/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize.argumentpropagation.codescanner;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexMethodSignature;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.MethodState;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.StateCloner;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.Timing;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;

abstract class MethodStateCollection<K> {
    private final Map<K, MethodState> methodStates;

    MethodStateCollection(Map<K, MethodState> methodStates) {
        assert (methodStates.values().stream().noneMatch(MethodState::isBottom));
        this.methodStates = methodStates;
    }

    private void addMethodState(AppView<AppInfoWithLiveness> appView, K method, MethodState methodState) {
        if (methodState.isUnknown()) {
            this.methodStates.put(method, methodState);
        } else {
            this.methodStates.compute(method, (ignore, existingMethodState) -> {
                MethodState newMethodState = existingMethodState == null ? methodState.mutableCopy() : existingMethodState.mutableJoin(appView, this.getSignature(method), methodState, StateCloner.getCloner());
                assert (!newMethodState.isBottom());
                return newMethodState;
            });
        }
    }

    private void set(K method, MethodState methodState) {
        if (methodState.isBottom()) {
            this.methodStates.remove(method);
        } else {
            this.methodStates.put(method, methodState);
        }
    }

    abstract K getKey(ProgramMethod var1);

    abstract DexMethodSignature getSignature(K var1);

    public void addMethodState(AppView<AppInfoWithLiveness> appView, ProgramMethod method, MethodState methodState) {
        this.addMethodState(appView, this.getKey(method), methodState);
    }

    public void addTemporaryMethodState(AppView<AppInfoWithLiveness> appView, K method, Function<MethodState, MethodState> methodStateSupplier, Timing timing) {
        this.methodStates.compute(method, (ignore, existingMethodState) -> {
            if (existingMethodState == null) {
                MethodState newMethodState = (MethodState)methodStateSupplier.apply(MethodState.bottom());
                assert (!newMethodState.isBottom());
                return newMethodState;
            }
            assert (!existingMethodState.isBottom());
            timing.begin("Join temporary method state");
            MethodState joinResult = existingMethodState.mutableJoin(appView, this.getSignature(method), methodStateSupplier, StateCloner.getIdentity());
            assert (!joinResult.isBottom());
            timing.end();
            return joinResult;
        });
    }

    public void addMethodStates(AppView<AppInfoWithLiveness> appView, MethodStateCollection<K> other) {
        other.methodStates.forEach((? super K method, ? super V methodState) -> this.addMethodState(appView, (K)method, (MethodState)methodState));
    }

    public void forEach(BiConsumer<K, MethodState> consumer) {
        this.methodStates.forEach(consumer);
    }

    public MethodState get(ProgramMethod method) {
        return this.get(this.getKey(method));
    }

    public MethodState get(K method) {
        return this.methodStates.getOrDefault(method, MethodState.bottom());
    }

    public boolean isEmpty() {
        return this.methodStates.isEmpty();
    }

    public MethodState remove(ProgramMethod method) {
        return this.removeOrElse(method, MethodState.bottom());
    }

    public MethodState removeOrElse(ProgramMethod method, MethodState defaultValue) {
        MethodState removed = this.methodStates.remove(this.getKey(method));
        return removed != null ? removed : defaultValue;
    }

    public void set(ProgramMethod method, MethodState methodState) {
        this.set(this.getKey(method), methodState);
    }
}

