/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize.argumentpropagation.propagation;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexMethodSignature;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ImmediateProgramSubtypingInfo;
import com.android.tools.r8.graph.MethodResolutionResult;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.type.ClassTypeElement;
import com.android.tools.r8.ir.analysis.type.DynamicType;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.ConcretePolymorphicMethodState;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.MethodState;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.MethodStateCollection;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.MethodStateCollectionByReference;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.MethodStateCollectionBySignature;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.StateCloner;
import com.android.tools.r8.optimize.argumentpropagation.propagation.MethodArgumentPropagator;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Consumer;

public class InterfaceMethodArgumentPropagator
extends MethodArgumentPropagator {
    final Map<DexProgramClass, MethodStateCollectionBySignature> methodStatesToPropagate = new IdentityHashMap<DexProgramClass, MethodStateCollectionBySignature>();
    final Consumer<DexMethodSignature> interfaceDispatchOutsideProgram;

    public InterfaceMethodArgumentPropagator(AppView<AppInfoWithLiveness> appView, ImmediateProgramSubtypingInfo immediateSubtypingInfo, MethodStateCollectionByReference methodStates, Consumer<DexMethodSignature> interfaceDispatchOutsideProgram) {
        super(appView, immediateSubtypingInfo, methodStates);
        this.interfaceDispatchOutsideProgram = interfaceDispatchOutsideProgram;
    }

    private MethodStateCollectionBySignature computeInterfaceState(DexProgramClass interfaceDefinition) {
        MethodStateCollectionBySignature interfaceState = MethodStateCollectionBySignature.create();
        this.immediateSubtypingInfo.forEachImmediateProgramSuperClass(interfaceDefinition, superclass -> {
            MethodStateCollectionBySignature implementedInterfaceState = this.methodStatesToPropagate.get(superclass);
            assert (implementedInterfaceState != null);
            interfaceState.addMethodStates(this.appView, (MethodStateCollection)implementedInterfaceState);
        });
        interfaceDefinition.forEachProgramVirtualMethod(method -> {
            MethodState methodState = this.methodStates.get((ProgramMethod)method);
            if (methodState.isBottom()) {
                return;
            }
            assert (methodState.isUnknown() || methodState.asConcrete().isPolymorphic());
            interfaceState.addMethodState(this.appView, (ProgramMethod)method, methodState);
        });
        this.methodStatesToPropagate.put(interfaceDefinition, interfaceState);
        return interfaceState;
    }

    private void propagateInterfaceStateToClassHierarchy(DexProgramClass interfaceDefinition, MethodStateCollectionBySignature interfaceState) {
        this.immediateSubtypingInfo.forEachImmediateSubClassMatching(interfaceDefinition, subclass -> !subclass.isInterface(), subclass -> interfaceState.forEach((interfaceMethod, interfaceMethodState) -> {
            MethodResolutionResult resolutionResult = ((AppInfoWithLiveness)this.appView.appInfo()).resolveMethodOnClass((DexMethodSignature)interfaceMethod, (DexClass)subclass);
            if (resolutionResult.isFailedResolution()) {
                assert (resolutionResult.asFailedResolution().hasMethodsCausingError());
                return;
            }
            assert (resolutionResult.isSingleResolution());
            if (!resolutionResult.getResolutionPair().isProgramMethod()) {
                this.interfaceDispatchOutsideProgram.accept((DexMethodSignature)interfaceMethod);
                return;
            }
            ProgramMethod resolvedMethod = resolutionResult.getResolvedProgramMethod();
            if (resolvedMethod == null || resolvedMethod.getHolder() == subclass) {
                return;
            }
            MethodState transformedInterfaceMethodState = this.transformInterfaceMethodStateForClassMethod((DexProgramClass)subclass, resolvedMethod, (MethodState)interfaceMethodState);
            if (!transformedInterfaceMethodState.isBottom()) {
                this.methodStates.addMethodState(this.appView, resolvedMethod, transformedInterfaceMethodState);
            }
        }));
    }

    private MethodState transformInterfaceMethodStateForClassMethod(DexProgramClass clazz, ProgramMethod resolvedMethod, MethodState methodState) {
        if (!methodState.isPolymorphic()) {
            return methodState.mutableCopy();
        }
        ConcretePolymorphicMethodState polymorphicMethodState = methodState.asPolymorphic();
        MethodState rewrittenMethodState = polymorphicMethodState.mutableCopyWithRewrittenBounds(this.appView, bounds -> {
            boolean shouldPropagateMethodStateForBounds;
            if (bounds.isUnknown()) {
                shouldPropagateMethodStateForBounds = true;
            } else {
                ClassTypeElement upperBound = bounds.getDynamicUpperBoundType().asClassType();
                shouldPropagateMethodStateForBounds = upperBound.getInterfaces().anyMatch((interfaceType, isKnown) -> ((AppInfoWithLiveness)this.appView.appInfo()).isSubtype(clazz.getType(), (DexType)interfaceType));
            }
            if (shouldPropagateMethodStateForBounds) {
                return DynamicType.createExact(TypeElement.fromDexType(resolvedMethod.getHolderType(), Nullability.maybeNull(), this.appView).asClassType());
            }
            return null;
        }, resolvedMethod.getMethodSignature(), StateCloner.getCloner());
        if (this.methodStates.get(resolvedMethod).isMonomorphic() && rewrittenMethodState.isPolymorphic()) {
            ConcretePolymorphicMethodState rewrittenPolymorphicMethodState = rewrittenMethodState.asPolymorphic();
            assert (rewrittenPolymorphicMethodState.values().size() == 1);
            return rewrittenPolymorphicMethodState.values().iterator().next();
        }
        return rewrittenMethodState;
    }

    private boolean verifyAllInterfacesFinished(Collection<DexProgramClass> stronglyConnectedComponent) {
        assert (stronglyConnectedComponent.stream().filter(DexClass::isInterface).allMatch(this::isClassFinished));
        return true;
    }

    @Override
    public void run(Collection<DexProgramClass> stronglyConnectedComponent) {
        super.run(stronglyConnectedComponent);
        assert (this.verifyAllInterfacesFinished(stronglyConnectedComponent));
    }

    @Override
    public void forEachSubClass(DexProgramClass clazz, Consumer<DexProgramClass> consumer) {
        for (DexProgramClass subclass : this.immediateSubtypingInfo.getSubclasses(clazz)) {
            if (!subclass.isInterface()) continue;
            consumer.accept(subclass);
        }
    }

    @Override
    public boolean isRoot(DexProgramClass clazz) {
        return clazz.isInterface() && super.isRoot(clazz);
    }

    @Override
    public void visit(DexProgramClass clazz) {
        assert (!this.methodStatesToPropagate.containsKey(clazz));
        MethodStateCollectionBySignature interfaceState = this.computeInterfaceState(clazz);
        this.propagateInterfaceStateToClassHierarchy(clazz, interfaceState);
    }

    @Override
    public void prune(DexProgramClass clazz) {
        this.methodStatesToPropagate.remove(clazz);
    }
}

