/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize.argumentpropagation.propagation;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethodSignature;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ImmediateProgramSubtypingInfo;
import com.android.tools.r8.graph.MethodResolutionResult;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.type.ClassTypeElement;
import com.android.tools.r8.ir.analysis.type.DynamicTypeWithUpperBound;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.ConcreteMethodState;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.ConcretePolymorphicMethodState;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.MethodState;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.MethodStateCollection;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.MethodStateCollectionByReference;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.MethodStateCollectionBySignature;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.StateCloner;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.UnknownMethodState;
import com.android.tools.r8.optimize.argumentpropagation.propagation.MethodArgumentPropagator;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.MapUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;

public class VirtualDispatchMethodArgumentPropagator
extends MethodArgumentPropagator {
    final Map<DexProgramClass, PropagationState> propagationStates = new IdentityHashMap<DexProgramClass, PropagationState>();

    public VirtualDispatchMethodArgumentPropagator(AppView<AppInfoWithLiveness> appView, ImmediateProgramSubtypingInfo immediateSubtypingInfo, MethodStateCollectionByReference methodStates) {
        super(appView, immediateSubtypingInfo, methodStates);
    }

    private void computePropagationState(DexProgramClass clazz) {
        PropagationState propagationState = new PropagationState(clazz);
        clazz.forEachProgramVirtualMethod(method -> {
            MethodState methodState = this.methodStates.get((ProgramMethod)method);
            if (methodState.isBottom()) {
                return;
            }
            if (methodState.isUnknown()) {
                propagationState.active.set((ProgramMethod)method, UnknownMethodState.get());
                return;
            }
            ConcreteMethodState concreteMethodState = methodState.asConcrete();
            if (concreteMethodState.isMonomorphic()) {
                return;
            }
            ConcretePolymorphicMethodState polymorphicMethodState = concreteMethodState.asPolymorphic();
            polymorphicMethodState.forEach((bounds, methodStateForBounds) -> {
                if (bounds.isUnknown()) {
                    propagationState.active.addMethodState(this.appView, (ProgramMethod)method, (MethodState)methodStateForBounds);
                } else {
                    ClassTypeElement upperBound = bounds.getDynamicUpperBoundType().asClassType();
                    if (this.isUpperBoundSatisfied(upperBound, clazz, propagationState)) {
                        if (bounds.hasDynamicLowerBoundType()) {
                            propagationState.activeUntilLowerBound.computeIfAbsent(bounds.getDynamicLowerBoundType().getClassType(), MapUtils.ignoreKey(MethodStateCollectionBySignature::create)).addMethodState(this.appView, (ProgramMethod)method, (MethodState)methodStateForBounds);
                        } else {
                            propagationState.active.addMethodState(this.appView, (ProgramMethod)method, (MethodState)methodStateForBounds);
                        }
                    } else {
                        assert (!clazz.getType().toTypeElement(this.appView).lessThanOrEqualUpToNullability(upperBound, this.appView));
                        propagationState.inactiveUntilUpperBound.computeIfAbsent((DynamicTypeWithUpperBound)bounds, MapUtils.ignoreKey(MethodStateCollectionBySignature::create)).addMethodState(this.appView, (ProgramMethod)method, (MethodState)methodStateForBounds);
                    }
                }
            });
        });
        this.propagationStates.put(clazz, propagationState);
    }

    private boolean isUpperBoundSatisfied(ClassTypeElement upperBound, DexProgramClass currentClass, PropagationState propagationState) {
        DexType upperBoundType = upperBound.getClassType() == this.appView.dexItemFactory().objectType && upperBound.getInterfaces().hasSingleKnownInterface() ? upperBound.getInterfaces().getSingleKnownInterface() : upperBound.getClassType();
        DexProgramClass upperBoundClass = DexProgramClass.asProgramClassOrNull(this.appView.definitionFor(upperBoundType));
        if (upperBoundClass == null) {
            return true;
        }
        return upperBoundClass == currentClass;
    }

    private void computeFinalMethodStates(DexProgramClass clazz, PropagationState propagationState) {
        clazz.forEachProgramVirtualMethod(method -> this.computeFinalMethodState((ProgramMethod)method, propagationState));
    }

    private void computeFinalMethodState(ProgramMethod method, PropagationState propagationState) {
        if (!((DexEncodedMethod)method.getDefinition()).hasCode()) {
            this.methodStates.remove(method);
            return;
        }
        MethodState methodState = this.methodStates.get(method);
        if (methodState.isMonomorphic() || methodState.isUnknown()) {
            return;
        }
        assert (methodState.isBottom() || methodState.isPolymorphic());
        methodState = propagationState.computeMethodStateForPolymorhicMethod(method);
        assert (!methodState.isConcrete() || methodState.asConcrete().isMonomorphic());
        this.methodStates.set(method, methodState);
    }

    private boolean verifyAllClassesFinished(Collection<DexProgramClass> stronglyConnectedComponent) {
        for (DexProgramClass clazz : stronglyConnectedComponent) {
            assert (this.isClassFinished(clazz));
        }
        return true;
    }

    private boolean verifyStatePruned() {
        assert (this.propagationStates.isEmpty());
        return true;
    }

    @Override
    public void run(Collection<DexProgramClass> stronglyConnectedComponent) {
        super.run(stronglyConnectedComponent);
        assert (this.verifyAllClassesFinished(stronglyConnectedComponent));
        assert (this.verifyStatePruned());
    }

    @Override
    public void visit(DexProgramClass clazz) {
        assert (!this.propagationStates.containsKey(clazz));
        this.computePropagationState(clazz);
    }

    @Override
    public void prune(DexProgramClass clazz) {
        PropagationState propagationState = this.propagationStates.remove(clazz);
        this.computeFinalMethodStates(clazz, propagationState);
    }

    class PropagationState {
        final MethodStateCollectionBySignature active = MethodStateCollectionBySignature.create();
        final Map<DexType, MethodStateCollectionBySignature> activeUntilLowerBound = new IdentityHashMap<DexType, MethodStateCollectionBySignature>();
        final Map<DynamicTypeWithUpperBound, MethodStateCollectionBySignature> inactiveUntilUpperBound = new HashMap<DynamicTypeWithUpperBound, MethodStateCollectionBySignature>();

        PropagationState(DexProgramClass clazz) {
            VirtualDispatchMethodArgumentPropagator.this.immediateSubtypingInfo.forEachImmediateProgramSuperClass(clazz, superclass -> this.addParentState(clazz, (DexProgramClass)superclass));
        }

        private void addParentState(DexProgramClass clazz, DexProgramClass superclass) {
            ClassTypeElement classType = TypeElement.fromDexType(clazz.getType(), Nullability.maybeNull(), VirtualDispatchMethodArgumentPropagator.this.appView).asClassType();
            PropagationState parentState = VirtualDispatchMethodArgumentPropagator.this.propagationStates.get(superclass.asProgramClass());
            assert (parentState != null);
            this.active.addMethodStates(VirtualDispatchMethodArgumentPropagator.this.appView, (MethodStateCollection)parentState.active);
            parentState.activeUntilLowerBound.forEach((lowerBound, activeMethodState) -> {
                if (lowerBound != superclass.getType()) {
                    this.activeUntilLowerBound.computeIfAbsent((DexType)lowerBound, MapUtils.ignoreKey(MethodStateCollectionBySignature::create)).addMethodStates(VirtualDispatchMethodArgumentPropagator.this.appView, (MethodStateCollection)activeMethodState);
                }
            });
            parentState.inactiveUntilUpperBound.forEach((bounds, inactiveMethodStates) -> {
                ClassTypeElement upperBound = bounds.getDynamicUpperBoundType().asClassType();
                if (upperBound.equalUpToNullability(classType)) {
                    if (bounds.hasDynamicLowerBoundType()) {
                        this.activeUntilLowerBound.computeIfAbsent(bounds.getDynamicLowerBoundType().getClassType(), MapUtils.ignoreKey(MethodStateCollectionBySignature::create)).addMethodStates(VirtualDispatchMethodArgumentPropagator.this.appView, (MethodStateCollection)inactiveMethodStates);
                    } else {
                        this.active.addMethodStates(VirtualDispatchMethodArgumentPropagator.this.appView, (MethodStateCollection)inactiveMethodStates);
                    }
                    inactiveMethodStates.forEach((signature, methodState) -> {
                        MethodResolutionResult.SingleResolutionResult resolutionResult = ((AppInfoWithLiveness)VirtualDispatchMethodArgumentPropagator.this.appView.appInfo()).resolveMethodOn((DexClass)clazz, (DexMethodSignature)signature).asSingleResolution();
                        while (resolutionResult != null && resolutionResult.getResolvedMethod().belongsToDirectPool()) {
                            resolutionResult = ((AppInfoWithLiveness)VirtualDispatchMethodArgumentPropagator.this.appView.appInfo()).resolveMethodOnClass((DexMethodSignature)signature, resolutionResult.getResolvedHolder().getSuperType()).asSingleResolution();
                        }
                        if (resolutionResult != null && resolutionResult.getResolvedHolder().isProgramClass() && resolutionResult.getResolvedHolder() != clazz && resolutionResult.getResolvedMethod().hasCode()) {
                            DexProgramClass resolvedHolder = resolutionResult.getResolvedHolder().asProgramClass();
                            VirtualDispatchMethodArgumentPropagator.this.propagationStates.get((Object)resolvedHolder).activeUntilLowerBound.computeIfAbsent(resolvedHolder.getType(), MapUtils.ignoreKey(MethodStateCollectionBySignature::create)).addMethodState(VirtualDispatchMethodArgumentPropagator.this.appView, resolutionResult.getResolvedProgramMethod(), (MethodState)methodState);
                        }
                    });
                } else {
                    this.inactiveUntilUpperBound.computeIfAbsent((DynamicTypeWithUpperBound)bounds, MapUtils.ignoreKey(MethodStateCollectionBySignature::create)).addMethodStates(VirtualDispatchMethodArgumentPropagator.this.appView, (MethodStateCollection)inactiveMethodStates);
                }
            });
        }

        private MethodState computeMethodStateForPolymorhicMethod(ProgramMethod method) {
            assert (((DexEncodedMethod)method.getDefinition()).isNonPrivateVirtualMethod());
            MethodState methodState = this.active.get(method).mutableCopy();
            if (!this.activeUntilLowerBound.isEmpty()) {
                DexMethodSignature methodSignature = method.getMethodSignature();
                for (MethodStateCollectionBySignature methodStates : this.activeUntilLowerBound.values()) {
                    methodState = methodState.mutableJoin((AppView<AppInfoWithLiveness>)VirtualDispatchMethodArgumentPropagator.this.appView, methodSignature, methodStates.get(method), StateCloner.getCloner());
                }
            }
            return methodState;
        }
    }
}

