/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize.argumentpropagation.reprocessingcriteria;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.optimize.info.CallSiteOptimizationInfo;
import com.android.tools.r8.ir.optimize.info.ConcreteCallSiteOptimizationInfo;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import com.android.tools.r8.optimize.argumentpropagation.reprocessingcriteria.ParameterReprocessingCriteria;
import com.android.tools.r8.shaking.AppInfoWithLiveness;

public class MethodReprocessingCriteria {
    public static final MethodReprocessingCriteria ALWAYS_REPROCESS = new MethodReprocessingCriteria();
    private final Int2ReferenceMap<ParameterReprocessingCriteria> reproccesingCriteria;

    private MethodReprocessingCriteria() {
        this.reproccesingCriteria = new Int2ReferenceOpenHashMap<ParameterReprocessingCriteria>();
    }

    public MethodReprocessingCriteria(Int2ReferenceMap<ParameterReprocessingCriteria> reproccesingCriteria) {
        assert (!reproccesingCriteria.isEmpty());
        this.reproccesingCriteria = reproccesingCriteria;
    }

    public static MethodReprocessingCriteria alwaysReprocess() {
        return ALWAYS_REPROCESS;
    }

    public ParameterReprocessingCriteria getParameterReprocessingCriteria(int parameterIndex) {
        return this.reproccesingCriteria.getOrDefault(parameterIndex, ParameterReprocessingCriteria.alwaysReprocess());
    }

    public boolean shouldReprocess(AppView<AppInfoWithLiveness> appView, ProgramMethod method, CallSiteOptimizationInfo methodState) {
        if (!methodState.isConcreteCallSiteOptimizationInfo()) {
            return false;
        }
        ConcreteCallSiteOptimizationInfo concreteMethodState = methodState.asConcreteCallSiteOptimizationInfo();
        for (int parameterIndex = 0; parameterIndex < ((DexEncodedMethod)method.getDefinition()).getNumberOfArguments(); ++parameterIndex) {
            DexType parameterType;
            if (methodState.getAbstractArgumentValue(parameterIndex).isSingleValue()) {
                return true;
            }
            ParameterReprocessingCriteria parameterReprocessingCriteria = this.getParameterReprocessingCriteria(parameterIndex);
            if (!parameterReprocessingCriteria.shouldReprocess(appView, method, concreteMethodState, parameterIndex, parameterType = method.getArgumentType(parameterIndex))) continue;
            return true;
        }
        return false;
    }
}

