/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize.argumentpropagation.reprocessingcriteria;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.type.DynamicType;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.optimize.info.ConcreteCallSiteOptimizationInfo;
import com.android.tools.r8.optimize.argumentpropagation.reprocessingcriteria.ParameterReprocessingCriteria;
import com.android.tools.r8.optimize.argumentpropagation.utils.WideningUtils;
import com.android.tools.r8.shaking.AppInfoWithLiveness;

public class NonTrivialParameterReprocessingCriteria
extends ParameterReprocessingCriteria {
    public NonTrivialParameterReprocessingCriteria(boolean reprocessDueToDynamicType) {
        assert (!reprocessDueToDynamicType);
    }

    private boolean shouldReprocessPrimitiveParameter(ConcreteCallSiteOptimizationInfo methodState, int parameterIndex) {
        return methodState.getAbstractArgumentValue(parameterIndex).isNonTrivial();
    }

    private boolean shouldReprocessReferenceParameter(AppView<AppInfoWithLiveness> appView, ProgramMethod method, ConcreteCallSiteOptimizationInfo methodState, int parameterIndex, DexType parameterType) {
        boolean isReceiverParameter;
        DynamicType widenedDynamicType;
        if (this.shouldReprocessDueToAbstractValue() && !methodState.getAbstractArgumentValue(parameterIndex).isUnknown()) {
            return true;
        }
        if (this.shouldReprocessDueToDynamicType() && !(widenedDynamicType = WideningUtils.widenDynamicNonReceiverType(appView, methodState.getDynamicType(parameterIndex).withNullability(Nullability.maybeNull()), parameterType)).isUnknown()) {
            return true;
        }
        boolean bl = isReceiverParameter = parameterIndex == 0 && ((DexEncodedMethod)method.getDefinition()).isInstance();
        return this.shouldReprocessDueToNullability() && !isReceiverParameter && !methodState.getNullability(parameterIndex).isUnknown();
    }

    @Override
    public boolean shouldReprocess(AppView<AppInfoWithLiveness> appView, ProgramMethod method, ConcreteCallSiteOptimizationInfo methodState, int parameterIndex, DexType parameterType) {
        if (parameterType.isReferenceType()) {
            return this.shouldReprocessReferenceParameter(appView, method, methodState, parameterIndex, parameterType);
        }
        assert (parameterType.isPrimitiveType());
        return this.shouldReprocessPrimitiveParameter(methodState, parameterIndex);
    }

    @Override
    public boolean shouldReprocessDueToAbstractValue() {
        return true;
    }

    @Override
    public boolean shouldReprocessDueToDynamicType() {
        return false;
    }

    @Override
    public boolean shouldReprocessDueToNullability() {
        return true;
    }
}

