/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize.argumentpropagation.reprocessingcriteria;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.type.ClassTypeElement;
import com.android.tools.r8.ir.analysis.type.DynamicType;
import com.android.tools.r8.ir.optimize.info.ConcreteCallSiteOptimizationInfo;
import com.android.tools.r8.optimize.argumentpropagation.reprocessingcriteria.AlwaysFalseParameterReprocessingCriteria;
import com.android.tools.r8.optimize.argumentpropagation.reprocessingcriteria.AlwaysTrueParameterReprocessingCriteria;
import com.android.tools.r8.optimize.argumentpropagation.reprocessingcriteria.NonTrivialParameterReprocessingCriteria;
import com.android.tools.r8.shaking.AppInfoWithLiveness;

public abstract class ParameterReprocessingCriteria {
    public static AlwaysTrueParameterReprocessingCriteria alwaysReprocess() {
        return AlwaysTrueParameterReprocessingCriteria.get();
    }

    public static AlwaysFalseParameterReprocessingCriteria neverReprocess() {
        return AlwaysFalseParameterReprocessingCriteria.get();
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isAlwaysReprocess() {
        return false;
    }

    public boolean isNeverReprocess() {
        return false;
    }

    public abstract boolean shouldReprocess(AppView<AppInfoWithLiveness> var1, ProgramMethod var2, ConcreteCallSiteOptimizationInfo var3, int var4, DexType var5);

    public abstract boolean shouldReprocessDueToAbstractValue();

    public abstract boolean shouldReprocessDueToDynamicType();

    public abstract boolean shouldReprocessDueToNullability();

    public final DynamicType widenDynamicClassType(AppView<AppInfoWithLiveness> appView, DynamicType dynamicType, ClassTypeElement staticType) {
        if (dynamicType.getNullability().isMaybeNull()) {
            return DynamicType.unknown();
        }
        return DynamicType.create(appView, staticType.getOrCreateVariant(dynamicType.getNullability()));
    }

    public static class Builder {
        private boolean reprocessDueToAbstractValue;
        private boolean reprocessDueToDynamicType;
        private boolean reprocessDueToNullability;

        Builder setReprocessDueToAbstractValue() {
            this.reprocessDueToAbstractValue = true;
            return this;
        }

        Builder setReprocessDueToDynamicType() {
            this.reprocessDueToDynamicType = true;
            return this;
        }

        Builder setReprocessDueToNullability() {
            this.reprocessDueToNullability = true;
            return this;
        }

        boolean shouldAlwaysReprocess() {
            return this.reprocessDueToAbstractValue && this.reprocessDueToDynamicType && this.reprocessDueToNullability;
        }

        boolean shouldNeverReprocess() {
            return !this.reprocessDueToAbstractValue && !this.reprocessDueToDynamicType && !this.reprocessDueToNullability;
        }

        public ParameterReprocessingCriteria build() {
            if (this.shouldAlwaysReprocess()) {
                return ParameterReprocessingCriteria.alwaysReprocess();
            }
            if (this.shouldNeverReprocess()) {
                return ParameterReprocessingCriteria.neverReprocess();
            }
            return new NonTrivialParameterReprocessingCriteria(this.reprocessDueToDynamicType);
        }
    }
}

