/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize.argumentpropagation.unusedarguments;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodSignature;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.code.Argument;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.MethodParameter;
import com.android.tools.r8.optimize.argumentpropagation.unusedarguments.EffectivelyUnusedArgumentsGraph;
import com.android.tools.r8.optimize.argumentpropagation.unusedarguments.EffectivelyUnusedArgumentsGraphNode;
import com.android.tools.r8.optimize.argumentpropagation.utils.ParameterRemovalUtils;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.ListUtils;
import com.android.tools.r8.utils.MapUtils;
import com.android.tools.r8.utils.WorkList;
import com.android.tools.r8.utils.collections.ProgramMethodSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class EffectivelyUnusedArgumentsAnalysis {
    private final AppView<AppInfoWithLiveness> appView;
    private final Map<MethodParameter, Set<MethodParameter>> constraints = new ConcurrentHashMap<MethodParameter, Set<MethodParameter>>();
    private final ProgramMethodSet optimizableVirtualMethods = ProgramMethodSet.createConcurrent();

    public EffectivelyUnusedArgumentsAnalysis(AppView<AppInfoWithLiveness> appView) {
        this.appView = appView;
    }

    private Set<MethodParameter> computeEffectivelyUnusedConstraints(ProgramMethod method, Argument argument, Value argumentValue) {
        if (((DexEncodedMethod)method.getDefinition()).isInstanceInitializer() && argumentValue.isThis()) {
            return null;
        }
        if (((DexEncodedMethod)method.getDefinition()).willBeInlinedIntoInstanceInitializer(this.appView.dexItemFactory())) {
            return null;
        }
        if (!ParameterRemovalUtils.canRemoveUnusedParameter(this.appView, method, argument.getIndex())) {
            return null;
        }
        if (!argumentValue.getType().isClassType() || argumentValue.hasDebugUsers() || argumentValue.hasPhiUsers()) {
            return null;
        }
        HashSet<MethodParameter> effectivelyUnusedConstraints = new HashSet<MethodParameter>();
        for (Instruction user : argumentValue.uniqueUsers()) {
            if (user.isInvokeMethod()) {
                InvokeMethod invoke = user.asInvokeMethod();
                ProgramMethod resolvedMethod = this.appView.appInfo().unsafeResolveMethodDueToDexFormat(invoke.getInvokedMethod()).getResolvedProgramMethod();
                if (resolvedMethod == null || this.isUnoptimizable(resolvedMethod)) {
                    return null;
                }
                int dependentArgumentIndex = ListUtils.uniqueIndexMatching(invoke.arguments(), value -> value == argumentValue);
                if (dependentArgumentIndex < 0 || !ParameterRemovalUtils.canRemoveUnusedParameter(this.appView, resolvedMethod, dependentArgumentIndex)) {
                    return null;
                }
                effectivelyUnusedConstraints.add(new MethodParameter((DexMethod)resolvedMethod.getReference(), dependentArgumentIndex));
                continue;
            }
            return null;
        }
        return effectivelyUnusedConstraints;
    }

    private boolean isUnoptimizable(ProgramMethod method) {
        if (((DexEncodedMethod)method.getDefinition()).belongsToDirectPool()) {
            return !ParameterRemovalUtils.canRemoveUnusedParametersFrom(this.appView, method);
        }
        if (this.optimizableVirtualMethods.contains(method)) {
            assert (ParameterRemovalUtils.canRemoveUnusedParametersFrom(this.appView, method));
            return false;
        }
        return true;
    }

    public void initializeOptimizableVirtualMethods(Set<DexProgramClass> stronglyConnectedComponent) {
        HashMap<DexMethodSignature, ProgramMethodSet> methodsBySignature = new HashMap<DexMethodSignature, ProgramMethodSet>();
        for (DexProgramClass clazz : stronglyConnectedComponent) {
            clazz.forEachProgramVirtualMethod(method -> {
                ProgramMethodSet methodsWithSameSignature = methodsBySignature.computeIfAbsent(method.getMethodSignature(), MapUtils.ignoreKey(ProgramMethodSet::create));
                methodsWithSameSignature.add(method);
            });
        }
        methodsBySignature.forEach((signature, methodsWithSignature) -> {
            ProgramMethod method;
            if (methodsWithSignature.size() == 1 && ParameterRemovalUtils.canRemoveUnusedParametersFrom(this.appView, method = (ProgramMethod)methodsWithSignature.getFirst())) {
                this.optimizableVirtualMethods.add(method);
            }
        });
    }

    public void scan(ProgramMethod method, IRCode code) {
        if (this.isUnoptimizable(method)) {
            return;
        }
        Iterator<Argument> argumentIterator = code.argumentIterator();
        while (argumentIterator.hasNext()) {
            Value argumentValue;
            Argument argument = argumentIterator.next();
            Set<MethodParameter> effectivelyUnusedConstraints = this.computeEffectivelyUnusedConstraints(method, argument, argumentValue = argument.outValue());
            if (effectivelyUnusedConstraints == null || effectivelyUnusedConstraints.isEmpty()) continue;
            MethodParameter methodParameter = new MethodParameter((DexMethod)method.getReference(), argument.getIndex());
            assert (!this.constraints.containsKey(methodParameter));
            this.constraints.put(methodParameter, effectivelyUnusedConstraints);
        }
    }

    public void computeEffectivelyUnusedArguments() {
        EffectivelyUnusedArgumentsGraph dependenceGraph = EffectivelyUnusedArgumentsGraph.create(this.appView, this.constraints);
        dependenceGraph.removeUnoptimizableNodes();
        WorkList<EffectivelyUnusedArgumentsGraphNode> worklist = WorkList.newIdentityWorkList(dependenceGraph.getNodes());
        while (!worklist.isEmpty()) {
            while (!worklist.isEmpty()) {
                EffectivelyUnusedArgumentsGraphNode node = worklist.removeSeen();
                assert (dependenceGraph.verifyContains(node));
                node.removeUnusedSuccessors();
                if (!node.getSuccessors().isEmpty()) continue;
                node.setUnused();
                node.getPredecessors().forEach(worklist::addIfNotSeen);
                node.cleanForRemoval();
                dependenceGraph.remove(node);
            }
            dependenceGraph.removeClosedCycles(worklist::addIfNotSeen);
        }
    }

    public void onMethodPruned(ProgramMethod method) {
        for (int argumentIndex = 0; argumentIndex < ((DexEncodedMethod)method.getDefinition()).getNumberOfArguments(); ++argumentIndex) {
            this.constraints.remove(new MethodParameter((DexMethod)method.getReference(), argumentIndex));
        }
    }
}

