/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize.argumentpropagation.unusedarguments;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.type.DynamicType;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedback;
import java.util.BitSet;
import java.util.Set;

class EffectivelyUnusedArgumentsGraphNode {
    private final ProgramMethod method;
    private final int argumentIndex;
    private final Set<EffectivelyUnusedArgumentsGraphNode> predecessors = Sets.newIdentityHashSet();
    private final Set<EffectivelyUnusedArgumentsGraphNode> successors = Sets.newIdentityHashSet();
    private boolean unoptimizable;

    EffectivelyUnusedArgumentsGraphNode(ProgramMethod method, int argumentIndex) {
        this.method = method;
        this.argumentIndex = argumentIndex;
    }

    void addSuccessor(EffectivelyUnusedArgumentsGraphNode node) {
        if (this.successors.add(node)) {
            node.predecessors.add(this);
        } else assert (node.predecessors.contains(this));
    }

    void cleanForRemoval() {
        this.clearSuccessors();
        this.clearPredecessors();
    }

    void clearSuccessors() {
        for (EffectivelyUnusedArgumentsGraphNode successor : this.successors) {
            boolean removed = successor.predecessors.remove(this);
            assert (removed);
        }
        this.successors.clear();
    }

    void clearPredecessors() {
        for (EffectivelyUnusedArgumentsGraphNode predecessor : this.predecessors) {
            boolean removed = predecessor.successors.remove(this);
            assert (removed);
        }
        this.predecessors.clear();
    }

    public int getArgumentIndex() {
        return this.argumentIndex;
    }

    public ProgramMethod getMethod() {
        return this.method;
    }

    Set<EffectivelyUnusedArgumentsGraphNode> getPredecessors() {
        return this.predecessors;
    }

    Set<EffectivelyUnusedArgumentsGraphNode> getSuccessors() {
        return this.successors;
    }

    boolean isNullable() {
        if (((DexEncodedMethod)this.method.getDefinition()).isInstance() && this.argumentIndex == 0) {
            return false;
        }
        DynamicType dynamicType = this.method.getOptimizationInfo().getArgumentInfos().getDynamicType(this.argumentIndex);
        return dynamicType.getNullability().isNullable();
    }

    boolean isUnoptimizable() {
        return this.unoptimizable;
    }

    boolean isUnused() {
        return this.method.getOptimizationInfo().hasUnusedArguments() && this.method.getOptimizationInfo().getUnusedArguments().get(this.argumentIndex);
    }

    void removeUnusedSuccessors() {
        this.successors.removeIf(successor -> {
            if (successor.isUnused()) {
                boolean removed = successor.predecessors.remove(this);
                assert (removed);
                return true;
            }
            return false;
        });
    }

    void setUnoptimizable() {
        this.unoptimizable = true;
    }

    void setUnused() {
        if (this.method.getOptimizationInfo().hasUnusedArguments()) {
            OptimizationFeedback.getSimpleFeedback().fixupUnusedArguments(this.method, unusedArguments -> unusedArguments.set(this.argumentIndex));
        } else {
            BitSet unusedArguments2 = new BitSet(((DexEncodedMethod)this.method.getDefinition()).getNumberOfArguments());
            unusedArguments2.set(this.argumentIndex);
            OptimizationFeedback.getSimpleFeedback().setUnusedArguments(this.method, unusedArguments2);
        }
    }
}

