/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize.argumentpropagation.utils;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ImmediateProgramSubtypingInfo;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public abstract class DepthFirstTopDownClassHierarchyTraversal {
    protected final AppView<AppInfoWithLiveness> appView;
    protected final ImmediateProgramSubtypingInfo immediateSubtypingInfo;
    private final Map<DexProgramClass, TraversalState> states = new IdentityHashMap<DexProgramClass, TraversalState>();
    private final List<DexProgramClass> newlySeenButNotFinishedRoots = new ArrayList<DexProgramClass>();

    public DepthFirstTopDownClassHierarchyTraversal(AppView<AppInfoWithLiveness> appView, ImmediateProgramSubtypingInfo immediateSubtypingInfo) {
        this.appView = appView;
        this.immediateSubtypingInfo = immediateSubtypingInfo;
    }

    private Deque<DexProgramClass> computeRoots(Collection<DexProgramClass> stronglyConnectedComponent) {
        ArrayDeque<DexProgramClass> roots = new ArrayDeque<DexProgramClass>();
        for (DexProgramClass clazz : stronglyConnectedComponent) {
            if (!this.isRoot(clazz)) continue;
            roots.add(clazz);
        }
        return roots;
    }

    private void prioritizeNewlySeenButNotFinishedRoots(Deque<DexProgramClass> roots) {
        assert (this.newlySeenButNotFinishedRoots.stream().allMatch(newlySeenButNotFinishedRoot -> {
            assert (this.isRoot((DexProgramClass)newlySeenButNotFinishedRoot));
            assert (this.isClassSeenButNotFinished((DexProgramClass)newlySeenButNotFinishedRoot));
            return true;
        }));
        roots.addAll(this.newlySeenButNotFinishedRoots);
        this.newlySeenButNotFinishedRoots.clear();
    }

    private void traverse(DexProgramClass clazz) {
        if (this.isClassFinished(clazz)) {
            return;
        }
        if (!this.isClassSeenButNotFinished(clazz)) {
            this.processSuperClasses(clazz);
            this.processClass(clazz);
        }
        this.processSubclasses(clazz);
        this.markFinished(clazz);
    }

    private void processSuperClasses(DexProgramClass clazz) {
        assert (!this.isClassSeenButNotFinished(clazz));
        assert (!this.isClassFinished(clazz));
        this.immediateSubtypingInfo.forEachImmediateProgramSuperClassMatching(clazz, superclass -> !this.isClassSeenButNotFinished((DexProgramClass)superclass), superclass -> {
            assert (this.isClassUnseen((DexProgramClass)superclass));
            this.processSuperClasses((DexProgramClass)superclass);
            this.processClass((DexProgramClass)superclass);
            if (this.isRoot((DexProgramClass)superclass)) {
                this.newlySeenButNotFinishedRoots.add((DexProgramClass)superclass);
            }
        });
    }

    private void processSubclasses(DexProgramClass clazz) {
        this.forEachSubClass(clazz, this::traverse);
    }

    private void processClass(DexProgramClass interfaceDefinition) {
        assert (!this.isClassSeenButNotFinished(interfaceDefinition));
        assert (!this.isClassFinished(interfaceDefinition));
        this.visit(interfaceDefinition);
        this.markSeenButNotFinished(interfaceDefinition);
    }

    private void markSeenButNotFinished(DexProgramClass clazz) {
        assert (this.isClassUnseen(clazz));
        this.states.put(clazz, TraversalState.SEEN);
    }

    private void markFinished(DexProgramClass clazz) {
        assert (this.isClassSeenButNotFinished(clazz));
        this.states.put(clazz, TraversalState.FINISHED);
        this.prune(clazz);
    }

    public abstract void visit(DexProgramClass var1);

    public abstract void prune(DexProgramClass var1);

    public void run(Collection<DexProgramClass> stronglyConnectedComponent) {
        Deque<DexProgramClass> roots = this.computeRoots(stronglyConnectedComponent);
        while (!roots.isEmpty()) {
            DexProgramClass root = roots.removeLast();
            this.traverse(root);
            this.prioritizeNewlySeenButNotFinishedRoots(roots);
        }
    }

    public boolean isRoot(DexProgramClass clazz) {
        if (clazz.getSuperType() == null) {
            return true;
        }
        DexProgramClass superclass = DexProgramClass.asProgramClassOrNull(this.appView.definitionFor(clazz.getSuperType()));
        if (superclass != null) {
            return false;
        }
        for (DexType implementedType : clazz.getInterfaces()) {
            DexProgramClass implementedClass = DexProgramClass.asProgramClassOrNull(this.appView.definitionFor(implementedType));
            if (implementedClass == null) continue;
            return false;
        }
        return true;
    }

    public void forEachSubClass(DexProgramClass clazz, Consumer<DexProgramClass> consumer) {
        this.immediateSubtypingInfo.getSubclasses(clazz).forEach(consumer);
    }

    protected boolean isClassUnseen(DexProgramClass clazz) {
        return !this.states.containsKey(clazz);
    }

    protected boolean isClassSeenButNotFinished(DexProgramClass clazz) {
        return this.states.get(clazz) == TraversalState.SEEN;
    }

    protected boolean isClassFinished(DexProgramClass clazz) {
        return this.states.get(clazz) == TraversalState.FINISHED;
    }

    private static enum TraversalState {
        SEEN,
        FINISHED;

    }
}

