/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize.bridgehoisting;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.proto.RewrittenPrototypeDescription;
import com.android.tools.r8.utils.collections.BidirectionalManyToOneMap;
import java.util.Set;

class BridgeHoistingLens
extends GraphLens.NonIdentityGraphLens {
    private final BidirectionalManyToOneMap<DexMethod, DexMethod> bridgeToHoistedBridgeMap;

    public BridgeHoistingLens(AppView<?> appView, BidirectionalManyToOneMap<DexMethod, DexMethod> bridgeToHoistedBridgeMap) {
        super(appView.dexItemFactory(), appView.graphLens());
        this.bridgeToHoistedBridgeMap = bridgeToHoistedBridgeMap;
    }

    @Override
    public DexMethod getRenamedMethodSignature(DexMethod originalMethod, GraphLens applied) {
        DexMethod renamedMethod = this.getPrevious().getRenamedMethodSignature(originalMethod, applied);
        return this.getNextMethodSignature(renamedMethod);
    }

    @Override
    public DexMethod getPreviousMethodSignature(DexMethod method) {
        Set bridges = this.bridgeToHoistedBridgeMap.getKeys(method);
        return bridges.isEmpty() ? method : (DexMethod)bridges.iterator().next();
    }

    @Override
    public DexMethod getNextMethodSignature(DexMethod method) {
        return this.bridgeToHoistedBridgeMap.getOrDefault(method, method);
    }

    @Override
    public DexType getOriginalType(DexType type) {
        return this.getPrevious().getOriginalType(type);
    }

    @Override
    public Iterable<DexType> getOriginalTypes(DexType type) {
        return this.getPrevious().getOriginalTypes(type);
    }

    @Override
    public DexField getOriginalFieldSignature(DexField field) {
        return this.getPrevious().getOriginalFieldSignature(field);
    }

    @Override
    public DexField getRenamedFieldSignature(DexField originalField, GraphLens codeLens) {
        if (this == codeLens) {
            return originalField;
        }
        return this.getPrevious().getRenamedFieldSignature(originalField);
    }

    @Override
    public RewrittenPrototypeDescription lookupPrototypeChangesForMethodDefinition(DexMethod method, GraphLens codeLens) {
        if (this == codeLens) {
            return BridgeHoistingLens.getIdentityLens().lookupPrototypeChangesForMethodDefinition(method, codeLens);
        }
        return this.getPrevious().lookupPrototypeChangesForMethodDefinition(method, codeLens);
    }

    @Override
    public boolean isContextFreeForMethods() {
        return this.getPrevious().isContextFreeForMethods();
    }

    @Override
    public boolean hasCodeRewritings() {
        return this.getPrevious().hasCodeRewritings();
    }

    @Override
    protected GraphLens.FieldLookupResult internalDescribeLookupField(GraphLens.FieldLookupResult previous) {
        return previous;
    }

    @Override
    protected GraphLens.MethodLookupResult internalDescribeLookupMethod(GraphLens.MethodLookupResult previous, DexMethod context) {
        return previous;
    }

    @Override
    protected DexType internalDescribeLookupClassType(DexType previous) {
        return previous;
    }
}

