/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize.proto;

import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodSignature;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.GenericSignature;
import com.android.tools.r8.graph.ObjectAllocationInfoCollection;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.proto.RewrittenPrototypeDescription;
import com.android.tools.r8.optimize.proto.ProtoNormalizerGraphLens;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.shaking.KeepMethodInfo;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.IterableUtils;
import com.android.tools.r8.utils.MapUtils;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.Timing;
import com.android.tools.r8.utils.WorkList;
import com.android.tools.r8.utils.collections.BidirectionalOneToOneHashMap;
import com.android.tools.r8.utils.collections.DexMethodSignatureSet;
import com.android.tools.r8.utils.collections.MutableBidirectionalOneToOneMap;
import com.android.tools.r8.utils.structural.StructuralItem;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

public class ProtoNormalizer {
    private final AppView<AppInfoWithLiveness> appView;
    private final DexItemFactory dexItemFactory;
    private final InternalOptions options;

    public ProtoNormalizer(AppView<AppInfoWithLiveness> appView) {
        this.appView = appView;
        this.dexItemFactory = appView.dexItemFactory();
        this.options = appView.options();
    }

    private void run(ExecutorService executorService) throws ExecutionException {
        GlobalReservationState globalReservationState = this.computeGlobalReservationState(executorService);
        LocalReservationState localReservationState = new LocalReservationState();
        ProtoNormalizerGraphLens.Builder lensBuilder = ProtoNormalizerGraphLens.builder(this.appView);
        for (DexProgramClass clazz : this.appView.appInfo().classesWithDeterministicOrder()) {
            Map<DexMethodSignature, DexMethodSignature> newInstanceInitializerSignatures = this.computeNewInstanceInitializerSignatures(clazz, localReservationState, globalReservationState);
            clazz.getMethodCollection().replaceMethods(method -> {
                DexMethodSignature newMethodSignature;
                DexMethodSignature methodSignature = method.getSignature();
                DexMethodSignature dexMethodSignature = newMethodSignature = method.isInstanceInitializer() ? (DexMethodSignature)newInstanceInitializerSignatures.get(methodSignature) : localReservationState.getAndReserveNewMethodSignature(methodSignature, this.dexItemFactory, globalReservationState);
                if (methodSignature.equals(newMethodSignature)) {
                    return method;
                }
                DexMethod newMethodReference = newMethodSignature.withHolder(clazz, this.dexItemFactory);
                RewrittenPrototypeDescription prototypeChanges = lensBuilder.recordNewMethodSignature((DexEncodedMethod)method, newMethodReference);
                return method.toTypeSubstitutedMethod(newMethodReference, builder -> {
                    if (!prototypeChanges.isEmpty()) {
                        builder.apply(prototypeChanges.createParameterAnnotationsRemover((DexEncodedMethod)method)).setGenericSignature(GenericSignature.MethodTypeSignature.noSignature());
                    }
                });
            });
        }
        if (!lensBuilder.isEmpty()) {
            this.appView.rewriteWithLens(lensBuilder.build());
        }
    }

    private GlobalReservationState computeGlobalReservationState(ExecutorService executorService) throws ExecutionException {
        ConcurrentHashMap<DexTypeList, Set> optimizableParameterLists = new ConcurrentHashMap<DexTypeList, Set>();
        ConcurrentHashMap<DexTypeList, Set<DexTypeList>> reservedParameterLists = new ConcurrentHashMap<DexTypeList, Set<DexTypeList>>();
        DexMethodSignatureSet unoptimizableSignatures = DexMethodSignatureSet.createConcurrent();
        ThreadUtils.processMethods(this.appView, method -> this.computeReservationsFromMethod((ProgramMethod)method, (Map<DexTypeList, Set<DexTypeList>>)optimizableParameterLists, (Map<DexTypeList, Set<DexTypeList>>)reservedParameterLists, unoptimizableSignatures), executorService);
        HashSet unoptimizableParameterLists = new HashSet();
        optimizableParameterLists.forEach((sortedParameters, parameterListsBeforeNormalization) -> {
            int size = parameterListsBeforeNormalization.size();
            if (size != 1) {
                assert (size > 1);
                return;
            }
            DexTypeList parameters = (DexTypeList)parameterListsBeforeNormalization.iterator().next();
            Set reservedParameters = reservedParameterLists.getOrDefault(sortedParameters, Collections.emptySet());
            if (!reservedParameters.isEmpty() && !reservedParameters.contains(parameters)) {
                return;
            }
            unoptimizableParameterLists.add(parameters);
        });
        ThreadUtils.processMethods(this.appView, method -> this.computeExtraReservationsFromMethod((ProgramMethod)method, unoptimizableParameterLists, unoptimizableSignatures), executorService);
        return new GlobalReservationState(reservedParameterLists, unoptimizableSignatures);
    }

    private void computeReservationsFromMethod(ProgramMethod method, Map<DexTypeList, Set<DexTypeList>> optimizableParameterLists, Map<DexTypeList, Set<DexTypeList>> reservedParameterLists, DexMethodSignatureSet unoptimizableSignatures) {
        if (this.isUnoptimizable(method)) {
            reservedParameterLists.computeIfAbsent(method.getParameters().getSorted(), MapUtils.ignoreKey(Sets::newConcurrentHashSet)).add(method.getParameters());
            unoptimizableSignatures.add(method);
        } else {
            optimizableParameterLists.computeIfAbsent(method.getParameters().getSorted(), MapUtils.ignoreKey(Sets::newConcurrentHashSet)).add(method.getParameters());
        }
    }

    private void computeExtraReservationsFromMethod(ProgramMethod method, Set<DexTypeList> unoptimizableParameterLists, DexMethodSignatureSet unoptimizableSignatures) {
        if (unoptimizableParameterLists.contains(method.getParameters())) {
            unoptimizableSignatures.add(method.getMethodSignature());
        }
    }

    private Map<DexMethodSignature, DexMethodSignatureSet> computeInstanceInitializerCollisions(DexProgramClass clazz, LocalReservationState localReservationState, GlobalReservationState globalReservationState) {
        HashMap<DexMethodSignature, DexMethodSignatureSet> instanceInitializerCollisions = new HashMap<DexMethodSignature, DexMethodSignatureSet>();
        clazz.forEachProgramInstanceInitializer(method -> {
            DexMethodSignature methodSignature = method.getMethodSignature();
            DexMethodSignature newMethodSignature = localReservationState.getNewMethodSignature(methodSignature, this.dexItemFactory, globalReservationState);
            instanceInitializerCollisions.computeIfAbsent(newMethodSignature, MapUtils.ignoreKey(DexMethodSignatureSet::create)).add(methodSignature);
        });
        return instanceInitializerCollisions;
    }

    private void resolveInstanceInitializerCollisions(Map<DexMethodSignature, DexMethodSignatureSet> instanceInitializerCollisions) {
        WorkList<DexMethodSignature> worklist = WorkList.newEqualityWorkList();
        instanceInitializerCollisions.forEach((newMethodSignature, methodSignatures) -> {
            if (methodSignatures.size() > 1) {
                worklist.addIfNotSeen((DexMethodSignature)newMethodSignature);
            }
        });
        while (worklist.hasNext()) {
            DexMethodSignature newMethodSignature2 = (DexMethodSignature)worklist.removeSeen();
            DexMethodSignatureSet methodSignatures2 = instanceInitializerCollisions.get(newMethodSignature2);
            assert (methodSignatures2.size() > 1);
            DexMethodSignature survivor = methodSignatures2.contains(newMethodSignature2) ? newMethodSignature2 : IterableUtils.min(methodSignatures2, StructuralItem::compareTo);
            for (DexMethodSignature methodSignature : methodSignatures2) {
                if (methodSignature.equals(survivor)) continue;
                DexMethodSignatureSet originalMethodSignaturesForMethodSignature = instanceInitializerCollisions.computeIfAbsent(methodSignature, MapUtils.ignoreKey(DexMethodSignatureSet::create));
                originalMethodSignaturesForMethodSignature.add(methodSignature);
                if (originalMethodSignaturesForMethodSignature.size() <= 1) continue;
                worklist.addIfNotSeen(methodSignature);
            }
            methodSignatures2.clear();
            methodSignatures2.add(survivor);
        }
    }

    private boolean isUnoptimizable(ProgramMethod method) {
        KeepMethodInfo keepInfo = this.appView.getKeepInfo(method);
        if (!keepInfo.isParameterReorderingAllowed(this.options) || ((DexEncodedMethod)method.getDefinition()).isLibraryMethodOverride().isPossiblyTrue()) {
            return true;
        }
        AppInfoWithLiveness appInfo = this.appView.appInfo();
        if (appInfo.isBootstrapMethod(method)) {
            return true;
        }
        ObjectAllocationInfoCollection objectAllocationInfoCollection = appInfo.getObjectAllocationInfoCollection();
        return method.getHolder().isInterface() && ((DexEncodedMethod)method.getDefinition()).isAbstract() && objectAllocationInfoCollection.isImmediateInterfaceOfInstantiatedLambda(method.getHolder());
    }

    public void run(ExecutorService executorService, Timing timing) throws ExecutionException {
        timing.time("Proto normalization", () -> this.run(executorService));
    }

    Map<DexMethodSignature, DexMethodSignature> computeNewInstanceInitializerSignatures(DexProgramClass clazz, LocalReservationState localReservationState, GlobalReservationState globalReservationState) {
        Map<DexMethodSignature, DexMethodSignatureSet> instanceInitializerCollisions = this.computeInstanceInitializerCollisions(clazz, localReservationState, globalReservationState);
        this.resolveInstanceInitializerCollisions(instanceInitializerCollisions);
        return MapUtils.transform(instanceInitializerCollisions, HashMap::new, (newMethodSignature, methodSignatures) -> Iterables.getFirst(methodSignatures, null), (newMethodSignature, methodSignatures) -> newMethodSignature, (newMethodSignature, methodSignature, otherMethodSignature) -> {
            throw new Unreachable();
        });
    }

    static class LocalReservationState {
        MutableBidirectionalOneToOneMap<DexMethodSignature, DexMethodSignature> newMethodSignatures = new BidirectionalOneToOneHashMap<DexMethodSignature, DexMethodSignature>();

        LocalReservationState() {
        }

        private DexMethodSignature internalGetAndReserveNewMethodSignature(DexMethodSignature methodSignature, DexItemFactory dexItemFactory, GlobalReservationState globalReservationState, boolean reserve) {
            if (globalReservationState.isUnoptimizable(methodSignature)) {
                assert (!this.newMethodSignatures.containsKey(methodSignature));
                return methodSignature;
            }
            DexMethodSignature reservedSignature = (DexMethodSignature)this.newMethodSignatures.get(methodSignature);
            if (reservedSignature != null) {
                assert (reservedSignature.getParameters().equals(globalReservationState.getReservedParameters(methodSignature)));
                return reservedSignature;
            }
            DexTypeList reservedParameters = globalReservationState.getReservedParameters(methodSignature);
            DexMethodSignature newMethodSignature = methodSignature.withParameters(reservedParameters, dexItemFactory);
            if (this.newMethodSignatures.containsValue(newMethodSignature)) {
                int index = 1;
                String newMethodBaseName = methodSignature.getName().toString();
                do {
                    DexString newMethodName = dexItemFactory.createString(newMethodBaseName + "$" + index);
                    newMethodSignature = newMethodSignature.withName(newMethodName);
                    ++index;
                } while (this.newMethodSignatures.containsValue(newMethodSignature));
            }
            if (reserve) {
                this.newMethodSignatures.put(methodSignature, newMethodSignature);
            }
            return newMethodSignature;
        }

        DexMethodSignature getNewMethodSignature(DexMethodSignature methodSignature, DexItemFactory dexItemFactory, GlobalReservationState globalReservationState) {
            return this.internalGetAndReserveNewMethodSignature(methodSignature, dexItemFactory, globalReservationState, false);
        }

        DexMethodSignature getAndReserveNewMethodSignature(DexMethodSignature methodSignature, DexItemFactory dexItemFactory, GlobalReservationState globalReservationState) {
            return this.internalGetAndReserveNewMethodSignature(methodSignature, dexItemFactory, globalReservationState, true);
        }
    }

    static class GlobalReservationState {
        Map<DexTypeList, DexTypeList> reservedParameters;
        DexMethodSignatureSet unoptimizableSignatures;

        GlobalReservationState(Map<DexTypeList, Set<DexTypeList>> reservedParameterLists, DexMethodSignatureSet unoptimizableSignatures) {
            this.reservedParameters = GlobalReservationState.selectDeterministicTarget(reservedParameterLists);
            this.unoptimizableSignatures = unoptimizableSignatures;
        }

        private static Map<DexTypeList, DexTypeList> selectDeterministicTarget(Map<DexTypeList, Set<DexTypeList>> reservedParameterLists) {
            HashMap<DexTypeList, DexTypeList> result = new HashMap<DexTypeList, DexTypeList>();
            reservedParameterLists.forEach((sortedParameters, candidates) -> {
                Iterator iterator2 = candidates.iterator();
                DexTypeList smallestCandidate = (DexTypeList)iterator2.next();
                while (iterator2.hasNext()) {
                    DexTypeList candidate = (DexTypeList)iterator2.next();
                    if (candidate.compareTo(smallestCandidate) >= 0) continue;
                    smallestCandidate = candidate;
                }
                result.put((DexTypeList)sortedParameters, smallestCandidate);
            });
            return result;
        }

        DexTypeList getReservedParameters(DexMethodSignature methodSignature) {
            DexTypeList sortedParameters = methodSignature.getParameters().getSorted();
            return this.reservedParameters.getOrDefault(sortedParameters, sortedParameters);
        }

        boolean isUnoptimizable(DexMethodSignature methodSignature) {
            return this.unoptimizableSignatures.contains(methodSignature);
        }
    }
}

