/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize.proto;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.proto.ArgumentInfoCollection;
import com.android.tools.r8.graph.proto.ArgumentPermutation;
import com.android.tools.r8.graph.proto.RewrittenPrototypeDescription;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.collections.BidirectionalOneToOneHashMap;
import com.android.tools.r8.utils.collections.BidirectionalOneToOneMap;
import com.android.tools.r8.utils.collections.MutableBidirectionalOneToOneMap;
import java.util.IdentityHashMap;
import java.util.Map;

public class ProtoNormalizerGraphLens
extends GraphLens.NonIdentityGraphLens {
    private final BidirectionalOneToOneMap<DexMethod, DexMethod> newMethodSignatures;
    private final Map<DexMethod, RewrittenPrototypeDescription> prototypeChanges;

    ProtoNormalizerGraphLens(AppView<?> appView, BidirectionalOneToOneMap<DexMethod, DexMethod> newMethodSignatures, Map<DexMethod, RewrittenPrototypeDescription> prototypeChanges) {
        super(appView);
        this.newMethodSignatures = newMethodSignatures;
        this.prototypeChanges = prototypeChanges;
    }

    public static Builder builder(AppView<AppInfoWithLiveness> appView) {
        return new Builder(appView);
    }

    @Override
    public DexType getOriginalType(DexType type) {
        return this.getPrevious().getOriginalType(type);
    }

    @Override
    public Iterable<DexType> getOriginalTypes(DexType type) {
        return this.getPrevious().getOriginalTypes(type);
    }

    @Override
    public DexField getOriginalFieldSignature(DexField field) {
        return this.getPrevious().getOriginalFieldSignature(field);
    }

    @Override
    public DexField getRenamedFieldSignature(DexField originalField, GraphLens applied) {
        if (this == applied) {
            return originalField;
        }
        return this.getPrevious().getRenamedFieldSignature(originalField);
    }

    @Override
    public DexMethod getRenamedMethodSignature(DexMethod originalMethod, GraphLens applied) {
        if (this == applied) {
            return originalMethod;
        }
        return this.getNextMethodSignature(this.getPrevious().getRenamedMethodSignature(originalMethod));
    }

    @Override
    public RewrittenPrototypeDescription lookupPrototypeChangesForMethodDefinition(DexMethod method, GraphLens codeLens) {
        if (this == codeLens) {
            return RewrittenPrototypeDescription.none();
        }
        DexMethod previousMethodSignature = this.getPreviousMethodSignature(method);
        RewrittenPrototypeDescription previousPrototypeChanges = this.getPrevious().lookupPrototypeChangesForMethodDefinition(previousMethodSignature);
        if (previousMethodSignature == method) {
            return previousPrototypeChanges;
        }
        return previousPrototypeChanges.combine(this.prototypeChanges.getOrDefault(method, RewrittenPrototypeDescription.none()));
    }

    @Override
    public boolean isContextFreeForMethods() {
        return this.getPrevious().isContextFreeForMethods();
    }

    @Override
    protected GraphLens.FieldLookupResult internalDescribeLookupField(GraphLens.FieldLookupResult previous) {
        return previous;
    }

    @Override
    protected GraphLens.MethodLookupResult internalDescribeLookupMethod(GraphLens.MethodLookupResult previous, DexMethod context) {
        DexMethod newMethodSignature;
        DexMethod methodSignature = (DexMethod)previous.getReference();
        if (methodSignature == (newMethodSignature = this.getNextMethodSignature(methodSignature))) {
            return previous;
        }
        assert (!previous.hasReboundReference());
        return ((GraphLens.MethodLookupResult.Builder)GraphLens.MethodLookupResult.builder(this).setPrototypeChanges(previous.getPrototypeChanges().combine(this.prototypeChanges.getOrDefault(newMethodSignature, RewrittenPrototypeDescription.none()))).setReference(newMethodSignature)).setType(previous.getType()).build();
    }

    @Override
    protected DexType internalDescribeLookupClassType(DexType previous) {
        return previous;
    }

    @Override
    public DexMethod getPreviousMethodSignature(DexMethod method) {
        return this.newMethodSignatures.getRepresentativeKeyOrDefault(method, method);
    }

    @Override
    public DexMethod getNextMethodSignature(DexMethod method) {
        return this.newMethodSignatures.getOrDefault(method, method);
    }

    public static class Builder {
        private final AppView<AppInfoWithLiveness> appView;
        private final MutableBidirectionalOneToOneMap<DexMethod, DexMethod> newMethodSignatures = new BidirectionalOneToOneHashMap<DexMethod, DexMethod>();
        private final Map<DexMethod, RewrittenPrototypeDescription> prototypeChanges = new IdentityHashMap<DexMethod, RewrittenPrototypeDescription>();

        private Builder(AppView<AppInfoWithLiveness> appView) {
            this.appView = appView;
        }

        private static RewrittenPrototypeDescription computePrototypeChanges(DexEncodedMethod method, DexMethod newMethodSignature) {
            int firstNonReceiverArgumentIndex = method.getFirstNonReceiverArgumentIndex();
            int numberOfArguments = method.getNumberOfArguments();
            ArgumentPermutation.Builder argumentPermutationBuilder = ArgumentPermutation.builder(numberOfArguments);
            boolean[] used = new boolean[numberOfArguments];
            block0: for (int argumentIndex = firstNonReceiverArgumentIndex; argumentIndex < numberOfArguments; ++argumentIndex) {
                DexType argumentType = method.getArgumentType(argumentIndex);
                for (int newArgumentIndex = firstNonReceiverArgumentIndex; newArgumentIndex < numberOfArguments; ++newArgumentIndex) {
                    DexType newArgumentType = newMethodSignature.getArgumentType(newArgumentIndex, method.getAccessFlags().isStatic());
                    if (argumentType != newArgumentType || used[newArgumentIndex]) continue;
                    argumentPermutationBuilder.setNewArgumentIndex(argumentIndex, newArgumentIndex);
                    used[newArgumentIndex] = true;
                    continue block0;
                }
            }
            ArgumentPermutation argumentPermutation = argumentPermutationBuilder.build();
            assert (!argumentPermutation.isDefault());
            ArgumentInfoCollection argumentInfoCollection = ArgumentInfoCollection.builder().setArgumentInfosSize(numberOfArguments).setArgumentPermutation(argumentPermutation).build();
            return RewrittenPrototypeDescription.create(ImmutableList.of(), null, argumentInfoCollection);
        }

        public RewrittenPrototypeDescription recordNewMethodSignature(DexEncodedMethod method, DexMethod newMethodSignature) {
            assert (method.getReference() != newMethodSignature);
            this.newMethodSignatures.put((DexMethod)method.getReference(), newMethodSignature);
            if (!method.getParameters().equals(newMethodSignature.getParameters())) {
                RewrittenPrototypeDescription prototypeChangesForMethod = Builder.computePrototypeChanges(method, newMethodSignature);
                this.prototypeChanges.put(newMethodSignature, prototypeChangesForMethod);
                return prototypeChangesForMethod;
            }
            return RewrittenPrototypeDescription.none();
        }

        public boolean isEmpty() {
            return this.newMethodSignatures.isEmpty();
        }

        public ProtoNormalizerGraphLens build() {
            return new ProtoNormalizerGraphLens(this.appView, this.newMethodSignatures, this.prototypeChanges);
        }
    }
}

