/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.org.checkerframework.checker.nullness;

import com.android.tools.r8.org.checkerframework.checker.nullness.qual.EnsuresNonNull;

public final class NullnessUtil {
    private NullnessUtil() {
        throw new AssertionError((Object)"shouldn't be instantiated");
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> T castNonNull(T ref) {
        assert (ref != null) : "Misuse of castNonNull: called with a null argument";
        return ref;
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> T castNonNull(T ref, String message) {
        assert (ref != null) : "Misuse of castNonNull: called with a null argument: " + message;
        return ref;
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> T[] castNonNullDeep(T[] arr) {
        return NullnessUtil.castNonNullArray(arr, null);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> T[] castNonNullDeep(T[] arr, String message) {
        return NullnessUtil.castNonNullArray(arr, message);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> T[][] castNonNullDeep(T[][] arr) {
        return (Object[][])NullnessUtil.castNonNullArray(arr, null);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> T[][] castNonNullDeep(T[][] arr, String message) {
        return (Object[][])NullnessUtil.castNonNullArray(arr, message);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> T[][][] castNonNullDeep(T[][][] arr) {
        return (Object[][][])NullnessUtil.castNonNullArray(arr, null);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> T[][][] castNonNullDeep(T[][][] arr, String message) {
        return (Object[][][])NullnessUtil.castNonNullArray(arr, message);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> T[][][][] castNonNullDeep(T[][][][] arr) {
        return (Object[][][][])NullnessUtil.castNonNullArray(arr, null);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> T[][][][] castNonNullDeep(T[][][][] arr, String message) {
        return (Object[][][][])NullnessUtil.castNonNullArray(arr, message);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> T[][][][][] castNonNullDeep(T[][][][][] arr) {
        return (Object[][][][][])NullnessUtil.castNonNullArray(arr, null);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> T[][][][][] castNonNullDeep(T[][][][][] arr, String message) {
        return (Object[][][][][])NullnessUtil.castNonNullArray(arr, message);
    }

    private static <T> T[] castNonNullArray(T[] arr, String message) {
        assert (arr != null) : "Misuse of castNonNullArray: called with a null array argument" + (message == null ? "" : ": " + message);
        for (int i = 0; i < arr.length; ++i) {
            assert (arr[i] != null) : "Misuse of castNonNull: called with a null array element" + (message == null ? "" : ": " + message);
            NullnessUtil.checkIfArray(arr[i], message);
        }
        return arr;
    }

    private static void checkIfArray(Object ref, String message) {
        assert (ref != null) : "Misuse of checkIfArray: called with a null argument" + (message == null ? "" : ": " + message);
        Class<?> comp = ref.getClass().getComponentType();
        if (comp != null && !comp.isPrimitive()) {
            NullnessUtil.castNonNullArray((Object[])ref, message);
        }
    }
}

