/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.references;

import com.android.tools.r8.Keep;
import com.android.tools.r8.KeepForRetraceApi;
import com.android.tools.r8.references.ClassReference;
import com.android.tools.r8.references.TypeReference;
import java.util.Objects;

@Keep
@KeepForRetraceApi
public final class FieldReference {
    private final ClassReference holderClass;
    private final String fieldName;
    private final TypeReference fieldType;

    FieldReference(ClassReference holderClass, String fieldName, TypeReference fieldType) {
        assert (holderClass != null);
        assert (fieldName != null);
        assert (fieldType != null);
        this.holderClass = holderClass;
        this.fieldName = fieldName;
        this.fieldType = fieldType;
    }

    public ClassReference getHolderClass() {
        return this.holderClass;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public TypeReference getFieldType() {
        return this.fieldType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FieldReference)) {
            return false;
        }
        FieldReference other = (FieldReference)o;
        return this.holderClass.equals(other.holderClass) && this.fieldName.equals(other.fieldName) && this.fieldType.equals(other.fieldType);
    }

    public int hashCode() {
        return Objects.hash(this.holderClass, this.fieldName, this.fieldType);
    }

    public String toString() {
        return this.getHolderClass().toString() + this.getFieldName() + ":" + this.getFieldType().getDescriptor();
    }
}

