/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.references;

import com.android.tools.r8.Keep;
import com.android.tools.r8.KeepForRetraceApi;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.references.ArrayReference;
import com.android.tools.r8.references.ClassReference;
import com.android.tools.r8.references.FieldReference;
import com.android.tools.r8.references.MethodReference;
import com.android.tools.r8.references.PackageReference;
import com.android.tools.r8.references.PrimitiveReference;
import com.android.tools.r8.references.TypeReference;
import com.android.tools.r8.utils.DescriptorUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;

@Keep
@KeepForRetraceApi
public final class Reference {
    public static PrimitiveReference BOOL = PrimitiveReference.BOOL;
    public static PrimitiveReference BYTE = PrimitiveReference.BYTE;
    public static PrimitiveReference CHAR = PrimitiveReference.CHAR;
    public static PrimitiveReference SHORT = PrimitiveReference.SHORT;
    public static PrimitiveReference INT = PrimitiveReference.INT;
    public static PrimitiveReference FLOAT = PrimitiveReference.FLOAT;
    public static PrimitiveReference LONG = PrimitiveReference.LONG;
    public static PrimitiveReference DOUBLE = PrimitiveReference.DOUBLE;

    private Reference() {
    }

    public static TypeReference returnTypeFromDescriptor(String descriptor) {
        return descriptor.equals("V") ? null : Reference.typeFromDescriptor(descriptor);
    }

    public static TypeReference returnTypeFromTypeName(String typename) {
        return typename.equals("void") ? null : Reference.typeFromTypeName(typename);
    }

    public static TypeReference typeFromDescriptor(String descriptor) {
        switch (descriptor.charAt(0)) {
            case 'L': {
                return Reference.classFromDescriptor(descriptor);
            }
            case '[': {
                return Reference.arrayFromDescriptor(descriptor);
            }
        }
        return Reference.primitiveFromDescriptor(descriptor);
    }

    public static TypeReference typeFromTypeName(String typeName) {
        return Reference.typeFromDescriptor(DescriptorUtils.javaTypeToDescriptor(typeName));
    }

    private static TypeReference typeFromClass(Class<?> clazz) {
        return Reference.typeFromDescriptor(DescriptorUtils.javaTypeToDescriptor(clazz.getTypeName()));
    }

    public static PrimitiveReference primitiveFromDescriptor(String descriptor) {
        return PrimitiveReference.fromDescriptor(descriptor);
    }

    public static ClassReference classFromDescriptor(String descriptor) {
        return ClassReference.fromDescriptor(descriptor);
    }

    public static ClassReference classFromBinaryName(String binaryName) {
        return Reference.classFromDescriptor(DescriptorUtils.getDescriptorFromClassBinaryName(binaryName));
    }

    public static ClassReference classFromTypeName(String typeName) {
        return Reference.classFromDescriptor(DescriptorUtils.javaTypeToDescriptor(typeName));
    }

    public static ClassReference classFromClass(Class<?> clazz) {
        return Reference.classFromTypeName(clazz.getTypeName());
    }

    public static ArrayReference arrayFromDescriptor(String descriptor) {
        return ArrayReference.fromDescriptor(descriptor);
    }

    public static ArrayReference array(TypeReference baseType, int dimensions) {
        return ArrayReference.fromBaseType(baseType, dimensions);
    }

    public static MethodReference method(ClassReference holderClass, String methodName, List<TypeReference> formalTypes, TypeReference returnType) {
        return new MethodReference(holderClass, methodName, ImmutableList.copyOf(formalTypes), returnType);
    }

    public static MethodReference methodFromMethod(Method method) {
        String methodName = method.getName();
        Class<?> holderClass = method.getDeclaringClass();
        Class<?>[] parameterTypes = method.getParameterTypes();
        Class<?> returnType = method.getReturnType();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Class<?> parameterType : parameterTypes) {
            builder.add(Reference.typeFromClass(parameterType));
        }
        return Reference.method(Reference.classFromClass(holderClass), methodName, (List<TypeReference>)((Object)builder.build()), returnType == Void.TYPE ? null : Reference.typeFromClass(returnType));
    }

    public static MethodReference methodFromMethod(Constructor<?> method) {
        Class<?> holderClass = method.getDeclaringClass();
        Class<?>[] parameterTypes = method.getParameterTypes();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Class<?> parameterType : parameterTypes) {
            builder.add(Reference.typeFromClass(parameterType));
        }
        return Reference.method(Reference.classFromClass(holderClass), "<init>", (List<TypeReference>)((Object)builder.build()), null);
    }

    public static MethodReference methodFromDescriptor(String classDescriptor, String methodName, String methodDescriptor) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String parameterTypeDescriptor : DescriptorUtils.getArgumentTypeDescriptors(methodDescriptor)) {
            builder.add(Reference.typeFromDescriptor(parameterTypeDescriptor));
        }
        String returnTypeDescriptor = DescriptorUtils.getReturnTypeDescriptor(methodDescriptor);
        return Reference.method(Reference.classFromDescriptor(classDescriptor), methodName, (List<TypeReference>)((Object)builder.build()), returnTypeDescriptor.equals("V") ? null : Reference.typeFromDescriptor(returnTypeDescriptor));
    }

    public static MethodReference methodFromDescriptor(ClassReference classReference, String methodName, String methodDescriptor) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String parameterTypeDescriptor : DescriptorUtils.getArgumentTypeDescriptors(methodDescriptor)) {
            builder.add(Reference.typeFromDescriptor(parameterTypeDescriptor));
        }
        String returnTypeDescriptor = DescriptorUtils.getReturnTypeDescriptor(methodDescriptor);
        return Reference.method(classReference, methodName, (List<TypeReference>)((Object)builder.build()), returnTypeDescriptor.equals("V") ? null : Reference.typeFromDescriptor(returnTypeDescriptor));
    }

    public static MethodReference classConstructor(ClassReference type) {
        return Reference.method(type, "<clinit>", Collections.emptyList(), null);
    }

    public static FieldReference field(ClassReference holderClass, String fieldName, TypeReference fieldType) {
        return new FieldReference(holderClass, fieldName, fieldType);
    }

    public static FieldReference fieldFromField(Field field) {
        Class<?> holderClass = field.getDeclaringClass();
        String fieldName = field.getName();
        Class<?> fieldType = field.getType();
        return Reference.field(Reference.classFromClass(holderClass), fieldName, Reference.typeFromClass(fieldType));
    }

    public static PackageReference packageFromString(String packageName) {
        return new PackageReference(packageName);
    }

    public static PackageReference packageFromPackage(Package pkg) {
        return new PackageReference(pkg.getName());
    }
}

