/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.relocator;

import com.android.tools.r8.BaseCompilerCommandParser;
import com.android.tools.r8.ClassFileConsumer;
import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.CompilationMode;
import com.android.tools.r8.Diagnostic;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.Keep;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.PathOrigin;
import com.android.tools.r8.references.PackageReference;
import com.android.tools.r8.references.Reference;
import com.android.tools.r8.shaking.ProguardConfiguration;
import com.android.tools.r8.shaking.ProguardPathList;
import com.android.tools.r8.utils.AbortException;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.Box;
import com.android.tools.r8.utils.ExceptionDiagnostic;
import com.android.tools.r8.utils.ExceptionUtils;
import com.android.tools.r8.utils.FlagFile;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.Reporter;
import com.android.tools.r8.utils.StringDiagnostic;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

@Keep
public class RelocatorCommand {
    private static final String THREAD_COUNT_FLAG = "--thread-count";
    private static final Set<String> OPTIONS_WITH_PARAMETER = ImmutableSet.of("--output", "--input", "--map", "--thread-count");
    static final String USAGE_MESSAGE = String.join((CharSequence)"\n", Iterables.concat(new Iterable[]{Arrays.asList("The Relocator CLI is EXPERIMENTAL and is subject to change", "Usage: relocator [options]", " where options are:", "  --input <file>          # Input file to remap, class, zip or jar.", "  --output <file>         # Output result in <outfile>.", "  --map <from->to>        # Registers a mapping.", "  --thread-count <number> # A specified number of threads to run with.", "  --version               # Print the version of d8.", "  --help                  # Print this message.")}));
    private final boolean printHelp;
    private final boolean printVersion;
    private final Reporter reporter;
    private final DexItemFactory factory;
    private final ClassFileConsumer consumer;
    private final AndroidApp app;
    private final ImmutableMap<PackageReference, PackageReference> mapping;
    private final int threadCount;

    private RelocatorCommand(boolean printHelp, boolean printVersion) {
        this.printHelp = printHelp;
        this.printVersion = printVersion;
        this.reporter = null;
        this.factory = null;
        this.consumer = null;
        this.app = null;
        this.mapping = null;
        this.threadCount = -1;
    }

    private RelocatorCommand(ImmutableMap<PackageReference, PackageReference> mapping, AndroidApp app, Reporter reporter, DexItemFactory factory, ClassFileConsumer consumer, int threadCount) {
        this.printHelp = false;
        this.printVersion = false;
        this.mapping = mapping;
        this.app = app;
        this.reporter = reporter;
        this.factory = factory;
        this.consumer = consumer;
        this.threadCount = threadCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder parse(String[] args2, Origin origin) {
        return Builder.parse(args2, origin);
    }

    public static Builder builder(DiagnosticsHandler diagnosticsHandler) {
        return new Builder(diagnosticsHandler);
    }

    public Reporter getReporter() {
        return this.reporter;
    }

    public DexItemFactory getFactory() {
        return this.factory;
    }

    public ClassFileConsumer getConsumer() {
        return this.consumer;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public AndroidApp getApp() {
        return this.app;
    }

    public boolean isPrintHelp() {
        return this.printHelp;
    }

    public boolean isPrintVersion() {
        return this.printVersion;
    }

    public InternalOptions getInternalOptions() {
        InternalOptions options = new InternalOptions(CompilationMode.DEBUG, ProguardConfiguration.builder(this.factory, this.getReporter()).disableShrinking().disableObfuscation().disableOptimization().addKeepAttributePatterns(ImmutableList.of("*")).addAdaptResourceFilenames(ProguardPathList.builder().addFileName("**").build()).build(), this.getReporter());
        options.relocatorCompilation = true;
        options.threadCount = this.getThreadCount();
        options.programConsumer = this.consumer;
        assert (this.consumer != null);
        options.dataResourceConsumer = this.consumer.getDataResourceConsumer();
        return options;
    }

    public Map<PackageReference, PackageReference> getMapping() {
        return this.mapping;
    }

    @Keep
    public static class Builder {
        private final AndroidApp.Builder app;
        private final Reporter reporter;
        private final ImmutableMap.Builder<PackageReference, PackageReference> mapping = ImmutableMap.builder();
        private ClassFileConsumer consumer = null;
        private int threadCount = -1;
        private boolean printVersion;
        private boolean printHelp;

        Builder() {
            this(AndroidApp.builder());
        }

        Builder(DiagnosticsHandler handler) {
            this(AndroidApp.builder(new Reporter(handler)));
        }

        Builder(AndroidApp.Builder builder) {
            this.app = builder;
            this.reporter = builder.getReporter();
        }

        private void validate() {
            if (this.consumer == null) {
                this.reporter.error(new StringDiagnostic("No output path or consumer has been specified"));
            }
        }

        public static Builder parse(String[] args2, Origin origin) {
            return Builder.parse(args2, origin, RelocatorCommand.builder());
        }

        public static Builder parse(String[] args2, Origin origin, DiagnosticsHandler handler) {
            return Builder.parse(args2, origin, RelocatorCommand.builder(handler));
        }

        private static Builder parse(String[] args2, Origin origin, Builder builder) {
            String[] expandedArgs = FlagFile.expandFlagFiles(args2, builder::error);
            Path outputPath = null;
            block16: for (int i = 0; i < expandedArgs.length; ++i) {
                String arg = expandedArgs[i].trim();
                String nextArg = null;
                if (OPTIONS_WITH_PARAMETER.contains(arg)) {
                    if (++i < expandedArgs.length) {
                        nextArg = expandedArgs[i];
                    } else {
                        builder.error(new StringDiagnostic("Missing parameter for " + expandedArgs[i - 1] + ".", origin));
                        break;
                    }
                }
                if (arg.length() == 0) continue;
                switch (arg) {
                    case "--help": {
                        builder.setPrintHelp(true);
                        continue block16;
                    }
                    case "--version": {
                        builder.setPrintVersion(true);
                        continue block16;
                    }
                    case "--output": {
                        assert (nextArg != null);
                        if (outputPath != null) {
                            builder.error(new StringDiagnostic("Cannot output both to '" + outputPath.toString() + "' and '" + nextArg + "'", origin));
                            continue block16;
                        }
                        outputPath = Paths.get(nextArg, new String[0]);
                        continue block16;
                    }
                    case "--input": {
                        assert (nextArg != null);
                        builder.addProgramFile(Paths.get(nextArg, new String[0]));
                        continue block16;
                    }
                    case "--thread-count": {
                        BaseCompilerCommandParser.parsePositiveIntArgument(builder::error, arg, nextArg, origin, builder::setThreadCount);
                        continue block16;
                    }
                    case "--map": {
                        assert (nextArg != null);
                        int separator = nextArg.indexOf("->");
                        if (separator < 0) {
                            builder.error(new StringDiagnostic("--map " + nextArg + " is not on the form from->to"));
                            continue block16;
                        }
                        builder.addPackageMapping(Reference.packageFromString(nextArg.substring(0, separator)), Reference.packageFromString(nextArg.substring(separator + 2)));
                        continue block16;
                    }
                    default: {
                        builder.error(new StringDiagnostic("Unknown argument: " + arg, origin));
                    }
                }
            }
            if (outputPath == null) {
                outputPath = Paths.get(".", new String[0]);
            }
            builder.setOutputPath(outputPath);
            return builder;
        }

        public Builder setOutputPath(Path outputPath) {
            if (outputPath == null) {
                this.consumer = null;
                return this;
            }
            this.consumer = new ClassFileConsumer.ArchiveConsumer(outputPath, true);
            return this;
        }

        public Builder setPrintHelp(boolean printHelp) {
            this.printHelp = printHelp;
            return this;
        }

        public Builder setPrintVersion(boolean printVersion) {
            this.printVersion = printVersion;
            return this;
        }

        public void error(Diagnostic diagnostic) {
            this.reporter.error(diagnostic);
        }

        public Builder setThreadCount(int threadCount) {
            if (threadCount <= 0) {
                this.reporter.error("Invalid threadCount: " + threadCount);
            } else {
                this.threadCount = threadCount;
            }
            return this;
        }

        public Builder addProgramFiles(Path ... files) {
            return this.addProgramFiles(Arrays.asList(files));
        }

        public Builder addProgramFiles(Collection<Path> files) {
            this.guard(() -> {
                for (Path path : files) {
                    try {
                        this.app.addProgramFile(path);
                    }
                    catch (CompilationError e) {
                        this.error(new PathOrigin(path), e);
                    }
                }
            });
            return this;
        }

        public Builder addProgramFile(Path file) {
            this.guard(() -> {
                try {
                    this.app.addProgramFile(file);
                }
                catch (CompilationError e) {
                    this.error(new PathOrigin(file), e);
                }
            });
            return this;
        }

        public Builder addPackageMapping(PackageReference source, PackageReference destination) {
            this.mapping.put(source, destination);
            return this;
        }

        public Builder setConsumer(ClassFileConsumer consumer) {
            this.consumer = consumer;
            return this;
        }

        public RelocatorCommand build() throws CompilationFailedException {
            Box result = new Box();
            ExceptionUtils.withCompilationHandler(this.reporter, () -> {
                if (this.printHelp || this.printVersion) {
                    result.set(new RelocatorCommand(this.printHelp, this.printVersion));
                    return;
                }
                this.reporter.failIfPendingErrors();
                this.validate();
                this.reporter.failIfPendingErrors();
                DexItemFactory factory = new DexItemFactory();
                result.set(new RelocatorCommand(this.mapping.build(), this.app.build(), this.reporter, factory, this.consumer, this.threadCount));
            });
            return (RelocatorCommand)result.get();
        }

        void error(Origin origin, Throwable throwable) {
            this.reporter.error(new ExceptionDiagnostic(throwable, origin));
        }

        void guard(Runnable action) {
            try {
                action.run();
            }
            catch (CompilationError e) {
                this.reporter.error(e.toStringDiagnostic());
            }
            catch (AbortException abortException) {
                // empty catch block
            }
        }
    }
}

