/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.repackaging;

import com.android.tools.r8.com.google.common.collect.BiMap;
import com.android.tools.r8.com.google.common.collect.HashBiMap;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMember;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DirectMappedDexApplication;
import com.android.tools.r8.graph.InnerClassAttribute;
import com.android.tools.r8.graph.NestedGraphLens;
import com.android.tools.r8.graph.ProgramPackage;
import com.android.tools.r8.graph.ProgramPackageCollection;
import com.android.tools.r8.graph.SortedProgramPackageCollection;
import com.android.tools.r8.graph.TreeFixerBase;
import com.android.tools.r8.naming.Minifier;
import com.android.tools.r8.repackaging.RepackagingConstraintGraph;
import com.android.tools.r8.repackaging.RepackagingLens;
import com.android.tools.r8.shaking.AnnotationFixer;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.shaking.ProguardConfiguration;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.Timing;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

public class Repackaging {
    private final AppView<AppInfoWithLiveness> appView;
    private final ProguardConfiguration proguardConfiguration;
    private final RepackagingConfiguration repackagingConfiguration;

    public Repackaging(AppView<AppInfoWithLiveness> appView) {
        this.appView = appView;
        this.proguardConfiguration = appView.options().getProguardConfiguration();
        this.repackagingConfiguration = appView.options().testing.repackagingConfigurationFactory.apply(appView);
    }

    public static boolean verifyIdentityRepackaging(AppView<AppInfoWithLiveness> appView) {
        List<DexProgramClass> newProgramClasses = new TreeFixerBase((AppView)appView){

            @Override
            public DexType mapClassType(DexType type) {
                return type;
            }

            @Override
            public void recordFieldChange(DexField from, DexField to) {
                assert (false);
            }

            @Override
            public void recordMethodChange(DexMethod from, DexMethod to) {
                assert (false);
            }

            @Override
            public void recordClassChange(DexType from, DexType to) {
                assert (false);
            }
        }.fixupClasses(appView.appInfo().classesWithDeterministicOrder());
        NestedGraphLens emptyRepackagingLens = new NestedGraphLens((AppView)appView){

            @Override
            protected boolean isLegitimateToHaveEmptyMappings() {
                return true;
            }
        };
        DirectMappedDexApplication newApplication = ((DirectMappedDexApplication.Builder)appView.appInfo().app().asDirect().builder().replaceProgramClasses(new ArrayList<DexProgramClass>(newProgramClasses))).build();
        appView.rewriteWithLensAndApplication(emptyRepackagingLens, newApplication);
        return true;
    }

    private RepackagingLens run(DirectMappedDexApplication.Builder appBuilder, ExecutorService executorService) throws ExecutionException {
        if (this.proguardConfiguration.getPackageObfuscationMode().isNone()) {
            return null;
        }
        HashBiMap<DexType, DexType> mappings = HashBiMap.create();
        HashMap<String, String> packageMappings = new HashMap<String, String>();
        HashSet<String> seenPackageDescriptors = new HashSet<String>();
        SortedProgramPackageCollection packages = SortedProgramPackageCollection.createWithAllProgramClasses(this.appView);
        this.processPackagesInDesiredLocation(packages, mappings, packageMappings, seenPackageDescriptors);
        this.processRemainingPackages(packages, mappings, packageMappings, seenPackageDescriptors, executorService);
        mappings.entrySet().removeIf(entry -> entry.getKey() == entry.getValue());
        if (mappings.isEmpty()) {
            return null;
        }
        RepackagingLens.Builder lensBuilder = new RepackagingLens.Builder();
        RepackagingTreeFixer repackagingTreeFixer = new RepackagingTreeFixer(this.appView, mappings, lensBuilder);
        ArrayList<DexProgramClass> newProgramClasses = new ArrayList<DexProgramClass>(repackagingTreeFixer.fixupClasses(this.appView.appInfo().classesWithDeterministicOrder()));
        appBuilder.replaceProgramClasses(newProgramClasses);
        RepackagingLens lens = lensBuilder.build(this.appView, packageMappings);
        new AnnotationFixer(lens).run(appBuilder.getProgramClasses());
        return lens;
    }

    private void processPackagesInDesiredLocation(ProgramPackageCollection packages, BiMap<DexType, DexType> mappings, Map<String, String> packageMappings, Set<String> seenPackageDescriptors) {
        Iterator<ProgramPackage> iterator2 = packages.iterator();
        while (iterator2.hasNext()) {
            ProgramPackage pkg = iterator2.next();
            if (!this.repackagingConfiguration.isPackageInTargetLocation(pkg)) continue;
            for (DexProgramClass alreadyRepackagedClass : pkg) {
                if (this.appView.appInfo().isRepackagingAllowed(alreadyRepackagedClass, this.appView)) continue;
                mappings.put(alreadyRepackagedClass.getType(), alreadyRepackagedClass.getType());
            }
            for (DexProgramClass alreadyRepackagedClass : pkg) {
                this.processClass(alreadyRepackagedClass, pkg, pkg.getPackageDescriptor(), mappings);
            }
            packageMappings.put(pkg.getPackageDescriptor(), pkg.getPackageDescriptor());
            seenPackageDescriptors.add(pkg.getPackageDescriptor());
            iterator2.remove();
        }
    }

    private void processRemainingPackages(ProgramPackageCollection packages, BiMap<DexType, DexType> mappings, Map<String, String> packageMappings, Set<String> seenPackageDescriptors, ExecutorService executorService) throws ExecutionException {
        Collection classesToRepackage;
        IdentityHashMap<ProgramPackage, Collection> packagesWithClassesToRepackage = new IdentityHashMap<ProgramPackage, Collection>();
        for (ProgramPackage pkg : packages) {
            classesToRepackage = this.computeClassesToRepackage(pkg, executorService);
            packagesWithClassesToRepackage.put(pkg, classesToRepackage);
            if (classesToRepackage.size() == pkg.classesInPackage().size()) continue;
            seenPackageDescriptors.add(pkg.getPackageDescriptor());
        }
        for (ProgramPackage pkg : packages) {
            classesToRepackage = (Collection)packagesWithClassesToRepackage.get(pkg);
            if (classesToRepackage.isEmpty()) continue;
            String newPackageDescriptor = this.repackagingConfiguration.getNewPackageDescriptor(pkg, seenPackageDescriptors);
            assert (!this.repackagingConfiguration.isPackageInTargetLocation(pkg));
            for (DexProgramClass classToRepackage : classesToRepackage) {
                this.processClass(classToRepackage, pkg, newPackageDescriptor, mappings);
            }
            seenPackageDescriptors.add(newPackageDescriptor);
            packageMappings.put(pkg.getPackageDescriptor(), classesToRepackage.size() == pkg.classesInPackage().size() ? newPackageDescriptor : pkg.getPackageDescriptor());
        }
    }

    private void processClass(DexProgramClass classToRepackage, ProgramPackage pkg, String newPackageDescriptor, BiMap<DexType, DexType> mappings) {
        InnerClassAttribute innerClassAttribute;
        DexType enclosingClass;
        if (mappings.containsKey(classToRepackage.getType())) {
            return;
        }
        DexProgramClass outerClass = null;
        if (classToRepackage.hasEnclosingMethodAttribute() && (enclosingClass = classToRepackage.getEnclosingMethodAttribute().getEnclosingClass()) != null) {
            outerClass = DexProgramClass.asProgramClassOrNull(this.appView.definitionFor(enclosingClass));
        }
        if (outerClass == null && (innerClassAttribute = classToRepackage.getInnerClassAttributeForThisClass()) != null && innerClassAttribute.getOuter() != null) {
            outerClass = DexProgramClass.asProgramClassOrNull(this.appView.definitionFor(innerClassAttribute.getOuter()));
        }
        if (outerClass != null) {
            if (pkg.contains(outerClass)) {
                this.processClass(outerClass, pkg, newPackageDescriptor, mappings);
            } else {
                outerClass = null;
            }
        }
        mappings.put(classToRepackage.getType(), this.repackagingConfiguration.getRepackagedType(classToRepackage, outerClass, newPackageDescriptor, mappings));
    }

    private Collection<DexProgramClass> computeClassesToRepackage(ProgramPackage pkg, ExecutorService executorService) throws ExecutionException {
        RepackagingConstraintGraph constraintGraph = new RepackagingConstraintGraph(this.appView, pkg);
        boolean canRepackageAllClasses = constraintGraph.initializeGraph();
        if (canRepackageAllClasses) {
            return pkg.classesInPackage();
        }
        constraintGraph.populateConstraints(executorService);
        return constraintGraph.computeClassesToRepackage();
    }

    public RepackagingLens run(DirectMappedDexApplication.Builder appBuilder, ExecutorService executorService, Timing timing) throws ExecutionException {
        timing.begin("Repackage classes");
        RepackagingLens lens = this.run(appBuilder, executorService);
        timing.end();
        return lens;
    }

    public static class SuffixRenamingRepackagingConfiguration
    implements RepackagingConfiguration {
        private final String classNameSuffix;
        private final DexItemFactory dexItemFactory;

        public SuffixRenamingRepackagingConfiguration(String classNameSuffix, DexItemFactory dexItemFactory) {
            this.classNameSuffix = classNameSuffix;
            this.dexItemFactory = dexItemFactory;
        }

        @Override
        public String getNewPackageDescriptor(ProgramPackage pkg, Set<String> seenPackageDescriptors) {
            return pkg.getPackageDescriptor();
        }

        @Override
        public boolean isPackageInTargetLocation(ProgramPackage pkg) {
            return true;
        }

        @Override
        public DexType getRepackagedType(DexProgramClass clazz, DexProgramClass outerClass, String newPackageDescriptor, BiMap<DexType, DexType> mappings) {
            String outerClassSimpleName;
            String simpleName;
            DexType repackagedDexType = clazz.getType();
            if (outerClass != null && (simpleName = clazz.getType().getSimpleName()).startsWith((outerClassSimpleName = outerClass.getType().getSimpleName()) + '$')) {
                String newSimpleName = ((DexType)mappings.get(outerClass.getType())).getSimpleName() + simpleName.substring(outerClassSimpleName.length());
                repackagedDexType = repackagedDexType.withSimpleName(newSimpleName, this.dexItemFactory);
            }
            DexType finalRepackagedDexType = repackagedDexType = repackagedDexType.addSuffix(this.classNameSuffix, this.dexItemFactory);
            int i = 1;
            while (mappings.inverse().containsKey(finalRepackagedDexType)) {
                finalRepackagedDexType = repackagedDexType.addSuffix(Character.toString('$') + i, this.dexItemFactory);
                ++i;
            }
            return finalRepackagedDexType;
        }
    }

    public static class DefaultRepackagingConfiguration
    implements RepackagingConfiguration {
        private final AppView<AppInfoWithLiveness> appView;
        private final DexItemFactory dexItemFactory;
        private final InternalOptions options;
        private final ProguardConfiguration proguardConfiguration;
        private final Minifier.MinificationPackageNamingStrategy packageMinificationStrategy;

        public DefaultRepackagingConfiguration(AppView<AppInfoWithLiveness> appView) {
            this.appView = appView;
            this.dexItemFactory = appView.dexItemFactory();
            this.options = appView.options();
            this.proguardConfiguration = appView.options().getProguardConfiguration();
            this.packageMinificationStrategy = new Minifier.MinificationPackageNamingStrategy(appView);
        }

        private boolean mayHavePinnedPackagePrivateOrProtectedItem(ProgramPackage pkg) {
            for (DexProgramClass clazz : pkg.classesInPackage()) {
                if (clazz.getAccessFlags().isPackagePrivateOrProtected() && !this.appView.getKeepInfo().getClassInfo(clazz).isShrinkingAllowed(this.options)) {
                    return true;
                }
                for (DexEncodedMember<?, ?> member : clazz.members()) {
                    if (member.isDexEncodedMethod() && member.asDexEncodedMethod().isClassInitializer() || !member.getAccessFlags().isPackagePrivateOrProtected() || this.appView.getKeepInfo().getMemberInfo(member, clazz).isShrinkingAllowed(this.options)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean isRepackageTypeUsed(DexType type, BiMap<DexType, DexType> mappings) {
            if (mappings.inverse().containsKey(type)) {
                return true;
            }
            return this.appView.appInfo().wasPruned(type) || this.appView.appInfo().getMissingClasses().contains(type);
        }

        @Override
        public String getNewPackageDescriptor(ProgramPackage pkg, Set<String> seenPackageDescriptors) {
            String newPackageDescriptor = DescriptorUtils.getBinaryNameFromJavaType(this.proguardConfiguration.getPackagePrefix());
            InternalOptions.PackageObfuscationMode packageObfuscationMode = this.proguardConfiguration.getPackageObfuscationMode();
            if (packageObfuscationMode.isRepackageClasses()) {
                return newPackageDescriptor;
            }
            if (packageObfuscationMode.isMinification()) {
                if (pkg.getPackageDescriptor().equals("") || this.proguardConfiguration.getKeepPackageNamesPatterns().matches(pkg) || this.mayHavePinnedPackagePrivateOrProtectedItem(pkg)) {
                    return pkg.getPackageDescriptor();
                }
                newPackageDescriptor = "";
            } else {
                assert (packageObfuscationMode.isFlattenPackageHierarchy());
                if (!newPackageDescriptor.isEmpty()) {
                    newPackageDescriptor = newPackageDescriptor + '/';
                }
            }
            return this.packageMinificationStrategy.next(newPackageDescriptor, seenPackageDescriptors::contains);
        }

        @Override
        public boolean isPackageInTargetLocation(ProgramPackage pkg) {
            String newPackageDescriptor = DescriptorUtils.getBinaryNameFromJavaType(this.proguardConfiguration.getPackagePrefix());
            InternalOptions.PackageObfuscationMode packageObfuscationMode = this.proguardConfiguration.getPackageObfuscationMode();
            if (packageObfuscationMode.isRepackageClasses()) {
                return pkg.getPackageDescriptor().equals(newPackageDescriptor);
            }
            if (packageObfuscationMode.isMinification()) {
                return pkg.getPackageDescriptor().equals("") || this.proguardConfiguration.getKeepPackageNamesPatterns().matches(pkg) || this.mayHavePinnedPackagePrivateOrProtectedItem(pkg);
            }
            assert (packageObfuscationMode.isFlattenPackageHierarchy());
            return false;
        }

        @Override
        public DexType getRepackagedType(DexProgramClass clazz, DexProgramClass outerClass, String newPackageDescriptor, BiMap<DexType, DexType> mappings) {
            DexType repackagedDexType = clazz.getType().replacePackage(newPackageDescriptor, this.dexItemFactory);
            if (outerClass != null) {
                String outerClassSimpleName;
                String simpleName = clazz.getType().getSimpleName();
                if (simpleName.startsWith((outerClassSimpleName = outerClass.getType().getSimpleName()) + '$')) {
                    String newSimpleName = ((DexType)mappings.get(outerClass.getType())).getSimpleName() + simpleName.substring(outerClassSimpleName.length());
                    repackagedDexType = repackagedDexType.withSimpleName(newSimpleName, this.dexItemFactory);
                } else assert (false) : "Unexpected name for inner class: " + clazz.getType().toSourceString() + " (outer class: " + outerClass.getType().toSourceString() + ")";
            }
            DexType finalRepackagedDexType = repackagedDexType;
            int i = 1;
            while (this.isRepackageTypeUsed(finalRepackagedDexType, mappings)) {
                finalRepackagedDexType = repackagedDexType.addSuffix(i + "", this.dexItemFactory);
                ++i;
            }
            return finalRepackagedDexType;
        }
    }

    public static interface RepackagingConfiguration {
        public String getNewPackageDescriptor(ProgramPackage var1, Set<String> var2);

        public boolean isPackageInTargetLocation(ProgramPackage var1);

        public DexType getRepackagedType(DexProgramClass var1, DexProgramClass var2, String var3, BiMap<DexType, DexType> var4);
    }

    private static class RepackagingTreeFixer
    extends TreeFixerBase {
        private final BiMap<DexType, DexType> mappings;
        private final RepackagingLens.Builder lensBuilder;

        public RepackagingTreeFixer(AppView<AppInfoWithLiveness> appView, BiMap<DexType, DexType> mappings, RepackagingLens.Builder lensBuilder) {
            super(appView);
            assert (mappings != null);
            this.mappings = mappings;
            this.lensBuilder = lensBuilder;
            this.recordFailedResolutionChanges();
        }

        @Override
        public DexType mapClassType(DexType type) {
            return this.mappings.getOrDefault(type, type);
        }

        @Override
        public void recordFieldChange(DexField from, DexField to) {
            this.lensBuilder.recordMove(from, to);
        }

        @Override
        public void recordMethodChange(DexMethod from, DexMethod to) {
            this.lensBuilder.recordMove(from, to);
        }

        @Override
        public void recordClassChange(DexType from, DexType to) {
            this.lensBuilder.recordMove(from, to);
        }
    }
}

