/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.retrace;

import com.android.tools.r8.Diagnostic;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.Keep;
import com.android.tools.r8.Version;
import com.android.tools.r8.com.google.common.base.Charsets;
import com.android.tools.r8.com.google.common.base.Equivalence;
import com.android.tools.r8.com.google.common.io.CharStreams;
import com.android.tools.r8.naming.ProguardMapSupplier;
import com.android.tools.r8.retrace.InvalidMappingFileException;
import com.android.tools.r8.retrace.MappingProvider;
import com.android.tools.r8.retrace.ProguardMapProducer;
import com.android.tools.r8.retrace.ProguardMappingProvider;
import com.android.tools.r8.retrace.RetraceCommand;
import com.android.tools.r8.retrace.RetraceFailedException;
import com.android.tools.r8.retrace.RetraceInvalidStackTraceLineDiagnostics;
import com.android.tools.r8.retrace.RetraceOptions;
import com.android.tools.r8.retrace.RetraceStackTraceContext;
import com.android.tools.r8.retrace.RetraceStackTraceElementProxy;
import com.android.tools.r8.retrace.RetraceStackTraceElementProxyResult;
import com.android.tools.r8.retrace.RetraceUnknownMapVersionDiagnostic;
import com.android.tools.r8.retrace.RetracedFieldReference;
import com.android.tools.r8.retrace.RetracedMethodReference;
import com.android.tools.r8.retrace.RetracedTypeReference;
import com.android.tools.r8.retrace.StackTraceElementProxy;
import com.android.tools.r8.retrace.StackTraceElementProxyRetracer;
import com.android.tools.r8.retrace.StackTraceLineParser;
import com.android.tools.r8.retrace.StringRetrace;
import com.android.tools.r8.retrace.internal.RetraceAbortException;
import com.android.tools.r8.retrace.internal.RetracerImpl;
import com.android.tools.r8.retrace.internal.StackTraceRegularExpressionParser;
import com.android.tools.r8.utils.Box;
import com.android.tools.r8.utils.ExceptionDiagnostic;
import com.android.tools.r8.utils.ExceptionUtils;
import com.android.tools.r8.utils.ListUtils;
import com.android.tools.r8.utils.OptionsParsing;
import com.android.tools.r8.utils.Pair;
import com.android.tools.r8.utils.StringDiagnostic;
import com.android.tools.r8.utils.StringUtils;
import com.android.tools.r8.utils.Timing;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import java.util.function.Function;
import java.util.stream.Collectors;

@Keep
public class Retrace<T, ST extends StackTraceElementProxy<T, ST>> {
    public static final String USAGE_MESSAGE = StringUtils.lines("Usage: retrace <proguard-map> [stack-trace-file] [--regex <regexp>, --verbose, --info, --quiet, --verify-mapping-file-hash]", "  where <proguard-map> is an r8 generated mapping file.");
    private final StackTraceLineParser<T, ST> stackTraceLineParser;
    private final StackTraceElementProxyRetracer<T, ST> proxyRetracer;
    private final DiagnosticsHandler diagnosticsHandler;
    protected final boolean isVerbose;

    private static RetraceCommand.Builder parseArguments(String[] args2, DiagnosticsHandler diagnosticsHandler) {
        OptionsParsing.ParseContext context = new OptionsParsing.ParseContext(args2);
        RetraceCommand.Builder builder = RetraceCommand.builder(diagnosticsHandler);
        boolean hasSetProguardMap = false;
        boolean hasSetStackTrace = false;
        boolean hasSetQuiet = false;
        while (context.head() != null) {
            Boolean help = OptionsParsing.tryParseBoolean(context, "--help");
            if (help != null) {
                return null;
            }
            Boolean version = OptionsParsing.tryParseBoolean(context, "--version");
            if (version != null) {
                return null;
            }
            Boolean info = OptionsParsing.tryParseBoolean(context, "--info");
            if (info != null) continue;
            Boolean verbose = OptionsParsing.tryParseBoolean(context, "--verbose");
            if (verbose != null) {
                builder.setVerbose(true);
                continue;
            }
            Boolean quiet = OptionsParsing.tryParseBoolean(context, "--quiet");
            if (quiet != null) {
                hasSetQuiet = true;
                continue;
            }
            String regex = OptionsParsing.tryParseSingle(context, "--regex", "r");
            if (regex != null && !regex.isEmpty()) {
                builder.setRegularExpression(regex);
                continue;
            }
            Boolean verify = OptionsParsing.tryParseBoolean(context, "--verify-mapping-file-hash");
            if (verify != null) {
                builder.setVerifyMappingFileHash(true);
                hasSetStackTrace = true;
                continue;
            }
            if (!hasSetProguardMap) {
                builder.setProguardMapProducer(Retrace.getMappingSupplier(context.head(), diagnosticsHandler));
                context.next();
                hasSetProguardMap = true;
                continue;
            }
            if (!hasSetStackTrace) {
                builder.setStackTrace(Retrace.getStackTraceFromFile(context.head(), diagnosticsHandler));
                context.next();
                hasSetStackTrace = true;
                continue;
            }
            diagnosticsHandler.error(new StringDiagnostic(String.format("Too many arguments specified for builder at '%s'", context.head())));
            diagnosticsHandler.error(new StringDiagnostic(USAGE_MESSAGE));
            throw new RetraceAbortException();
        }
        if (!hasSetProguardMap) {
            diagnosticsHandler.error(new StringDiagnostic("Mapping file not specified"));
            throw new RetraceAbortException();
        }
        if (!hasSetStackTrace) {
            builder.setStackTrace(Retrace.getStackTraceFromStandardInput(hasSetQuiet));
        }
        return builder;
    }

    private static ProguardMapProducer getMappingSupplier(String mappingPath, DiagnosticsHandler diagnosticsHandler) {
        Path path = Paths.get(mappingPath, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            diagnosticsHandler.error(new StringDiagnostic(String.format("Could not find mapping file '%s'.", mappingPath)));
            throw new RetraceAbortException();
        }
        return ProguardMapProducer.fromPath(Paths.get(mappingPath, new String[0]));
    }

    private static List<String> getStackTraceFromFile(String stackTracePath, DiagnosticsHandler diagnostics) {
        try {
            return Files.readAllLines(Paths.get(stackTracePath, new String[0]), Charsets.UTF_8);
        }
        catch (IOException e) {
            diagnostics.error(new ExceptionDiagnostic(e));
            throw new RetraceAbortException();
        }
    }

    Retrace(StackTraceLineParser<T, ST> stackTraceLineParser, StackTraceElementProxyRetracer<T, ST> proxyRetracer, DiagnosticsHandler diagnosticsHandler, boolean isVerbose) {
        this.stackTraceLineParser = stackTraceLineParser;
        this.proxyRetracer = proxyRetracer;
        this.diagnosticsHandler = diagnosticsHandler;
        this.isVerbose = isVerbose;
    }

    public static void run(RetraceCommand command) {
        boolean allowExperimentalMapVersion = System.getProperty("com.android.tools.r8.experimentalmapping") != null;
        Retrace.runForTesting(command, allowExperimentalMapVersion);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void runForTesting(RetraceCommand command, boolean allowExperimentalMapping) {
        try {
            Timing timing = Timing.create("R8 retrace", command.printMemory());
            RetraceOptions options = command.getOptions();
            if (command.getOptions().isVerifyMappingFileHash()) {
                try {
                    Reader reader = options.getProguardMapProducer().get();
                    Throwable throwable = null;
                    try {
                        ProguardMapSupplier.ProguardMapChecker.VerifyMappingFileHashResult checkResult = ProguardMapSupplier.ProguardMapChecker.validateProguardMapHash(CharStreams.toString(reader));
                        if (checkResult.isError()) {
                            command.getOptions().getDiagnosticsHandler().error(new StringDiagnostic(checkResult.getMessage()));
                            throw new RuntimeException(checkResult.getMessage());
                        }
                        if (!checkResult.isOk()) {
                            command.getOptions().getDiagnosticsHandler().warning(new StringDiagnostic(checkResult.getMessage()));
                        }
                        if (reader == null) return;
                    }
                    catch (Throwable checkResult) {
                        try {
                            throwable = checkResult;
                            throw checkResult;
                        }
                        catch (Throwable throwable2) {
                            if (reader == null) throw throwable2;
                            Retrace.$closeResource(throwable, reader);
                            throw throwable2;
                        }
                    }
                    Retrace.$closeResource(throwable, reader);
                    return;
                }
                catch (IOException e) {
                    command.getOptions().getDiagnosticsHandler().error(new ExceptionDiagnostic(e));
                    throw new RuntimeException(e);
                }
            }
            timing.begin("Read proguard map");
            DiagnosticsHandler diagnosticsHandler = options.getDiagnosticsHandler();
            Object mappingProvider = ((ProguardMappingProvider.Builder)((ProguardMappingProvider.Builder)ProguardMappingProvider.builder().setProguardMapProducer(options.getProguardMapProducer()).setDiagnosticsHandler(diagnosticsHandler)).setAllowExperimental(allowExperimentalMapping)).build();
            RetracerImpl retracer = RetracerImpl.builder().setMappingProvider((MappingProvider)mappingProvider).setDiagnosticsHandler(diagnosticsHandler).build();
            retracer.getMapVersions().forEach(mapVersionInfo -> {
                if (mapVersionInfo.getMapVersion().isUnknown()) {
                    diagnosticsHandler.warning(RetraceUnknownMapVersionDiagnostic.create(mapVersionInfo.getValue()));
                }
            });
            timing.end();
            timing.begin("Report result");
            StringRetrace stringRetrace = new StringRetrace(new StackTraceRegularExpressionParser(options.getRegularExpression()), StackTraceElementProxyRetracer.createDefault(retracer), diagnosticsHandler, options.isVerbose());
            command.getRetracedStackTraceConsumer().accept(stringRetrace.retrace(command.getStackTrace()));
            timing.end();
            if (!command.printTimes()) return;
            timing.report();
            return;
        }
        catch (InvalidMappingFileException e) {
            command.getOptions().getDiagnosticsHandler().error(new ExceptionDiagnostic(e));
            throw e;
        }
    }

    public static void run(String[] args2) throws RetraceFailedException {
        String[] mappedArgs = new String[args2.length];
        boolean printInfo = false;
        for (int i = 0; i < args2.length; ++i) {
            String arg = args2[i];
            if (arg == null || arg.length() < 2) {
                mappedArgs[i] = arg;
                continue;
            }
            mappedArgs[i] = arg.charAt(0) == '-' && arg.charAt(1) != '-' ? "-" + arg : arg;
            if (!mappedArgs[i].equals("--info")) continue;
            printInfo = true;
        }
        RetraceDiagnosticsHandler retraceDiagnosticsHandler = new RetraceDiagnosticsHandler(new DiagnosticsHandler(){}, printInfo);
        try {
            Retrace.run(mappedArgs, retraceDiagnosticsHandler);
        }
        catch (Throwable t) {
            throw ExceptionUtils.failWithFakeEntry(retraceDiagnosticsHandler, t, RetraceFailedException::new, RetraceAbortException.class);
        }
    }

    private static void run(String[] args2, DiagnosticsHandler diagnosticsHandler) {
        RetraceCommand.Builder builder = Retrace.parseArguments(args2, diagnosticsHandler);
        if (builder == null) {
            if (Arrays.asList(args2).contains("--version")) {
                System.out.println("Retrace " + Version.getVersionString());
                return;
            }
            assert (Arrays.asList(args2).contains("--help"));
            System.out.println("Retrace " + Version.getVersionString());
            System.out.print(USAGE_MESSAGE);
            return;
        }
        builder.setRetracedStackTraceConsumer(retraced -> {
            try {
                PrintStream printStream = new PrintStream((OutputStream)System.out, true, Charsets.UTF_8.name());
                Throwable throwable = null;
                try {
                    for (String line : retraced) {
                        printStream.println(line);
                    }
                }
                catch (Throwable throwable2) {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        Retrace.$closeResource(throwable, printStream);
                        throw throwable3;
                    }
                }
                Retrace.$closeResource(throwable, printStream);
            }
            catch (UnsupportedEncodingException e) {
                diagnosticsHandler.error(new StringDiagnostic(e.getMessage()));
            }
        });
        Retrace.run(builder.build());
    }

    public static void main(String ... args2) {
        Retrace.withMainProgramHandler(() -> Retrace.run(args2));
    }

    private static List<String> getStackTraceFromStandardInput(boolean printWaitingMessage) {
        if (!printWaitingMessage) {
            System.out.println("Waiting for stack-trace input...");
        }
        Scanner sc = new Scanner(new InputStreamReader(System.in, Charsets.UTF_8));
        ArrayList<String> readLines2 = new ArrayList<String>();
        while (sc.hasNext()) {
            readLines2.add(sc.nextLine());
        }
        return readLines2;
    }

    private static void withMainProgramHandler(MainAction action) {
        try {
            action.run();
        }
        catch (RetraceFailedException | RetraceAbortException e) {
            throw new RuntimeException("Retrace failed", e);
        }
        catch (Throwable t) {
            throw new RuntimeException("Retrace failed with an internal error.", t);
        }
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }

    public List<List<List<T>>> retraceStackTrace(List<T> stackTrace) {
        ListUtils.forEachWithIndex(stackTrace, (line, lineNumber) -> {
            if (line == null) {
                this.diagnosticsHandler.error(RetraceInvalidStackTraceLineDiagnostics.createNull(lineNumber));
                throw new RetraceAbortException();
            }
        });
        RetraceStackTraceElementProxyEquivalence equivalence = new RetraceStackTraceElementProxyEquivalence(this.isVerbose);
        ArrayList<List<List<T>>> finalResult = new ArrayList<List<List<T>>>();
        ListUtils.fold(stackTrace, RetraceStackTraceContext.empty(), (context, stackTraceLine) -> {
            ST parsedLine = this.stackTraceLineParser.parse(stackTraceLine);
            ArrayList<Pair> resultsForLine = new ArrayList<Pair>();
            Box currentList = new Box();
            HashSet seen = new HashSet();
            ArrayList contexts = new ArrayList();
            RetraceStackTraceElementProxyResult<T, ST> retraceResult = this.proxyRetracer.retrace(parsedLine, (RetraceStackTraceContext)context);
            retraceResult.stream().forEach(retracedElement -> {
                if (retracedElement.isTopFrame() || !retracedElement.hasRetracedClass()) {
                    if (seen.add(equivalence.wrap(retracedElement))) {
                        currentList.set(new ArrayList());
                        resultsForLine.add(Pair.create(retracedElement, (List)currentList.get()));
                        contexts.add(retracedElement.getContext());
                    } else {
                        currentList.empty();
                    }
                }
                if (currentList.isSet()) {
                    ((List)currentList.get()).add(parsedLine.toRetracedItem(retracedElement, this.isVerbose));
                }
            });
            resultsForLine.sort(Comparator.comparing(Pair::getFirst));
            finalResult.add(ListUtils.map(resultsForLine, Pair::getSecond));
            if (contexts.isEmpty()) {
                return retraceResult.getResultContext();
            }
            return contexts.size() == 1 ? (RetraceStackTraceContext)contexts.get(0) : RetraceStackTraceContext.empty();
        });
        return finalResult;
    }

    public List<List<T>> retraceFrame(T stackTraceFrame) {
        HashMap ambiguousBlocks = new HashMap();
        ArrayList ambiguousKeys = new ArrayList();
        ST parsedLine = this.stackTraceLineParser.parse(stackTraceFrame);
        this.proxyRetracer.retrace(parsedLine, RetraceStackTraceContext.empty()).stream().forEach(retracedElement -> {
            if (retracedElement.isTopFrame() || !retracedElement.hasRetracedClass()) {
                ambiguousKeys.add(retracedElement);
                ambiguousBlocks.put(retracedElement, new ArrayList());
            }
            ((List)ambiguousBlocks.get(ListUtils.last(ambiguousKeys))).add(parsedLine.toRetracedItem(retracedElement, this.isVerbose));
        });
        Collections.sort(ambiguousKeys);
        ArrayList retracedList = new ArrayList();
        ambiguousKeys.forEach(key -> retracedList.add((List)ambiguousBlocks.get(key)));
        return retracedList;
    }

    public List<T> retraceLine(T stackTraceLine) {
        ST parsedLine = this.stackTraceLineParser.parse(stackTraceLine);
        return this.proxyRetracer.retrace(parsedLine, RetraceStackTraceContext.empty()).stream().map(retraceFrame -> {
            ((StackTraceElementProxy)retraceFrame.getOriginalItem()).toRetracedItem(retraceFrame, this.isVerbose);
            return parsedLine.toRetracedItem(retraceFrame, this.isVerbose);
        }).collect(Collectors.toList());
    }

    private static class RetraceStackTraceElementProxyEquivalence<T, ST extends StackTraceElementProxy<T, ST>>
    extends Equivalence<RetraceStackTraceElementProxy<T, ST>> {
        private final boolean isVerbose;

        public RetraceStackTraceElementProxyEquivalence(boolean isVerbose) {
            this.isVerbose = isVerbose;
        }

        private boolean compareRetracedTypeReference(RetracedTypeReference one, RetracedTypeReference other) {
            return one.isVoid() == other.isVoid() && (one.isVoid() || one.getTypeName().equals(other.getTypeName()));
        }

        private <V extends Comparable<V>> boolean testNotEqualProperty(RetraceStackTraceElementProxy<T, ST> one, RetraceStackTraceElementProxy<T, ST> other, Function<RetraceStackTraceElementProxy<T, ST>, Boolean> predicate, Function<RetraceStackTraceElementProxy<T, ST>, V> getter) {
            return Comparator.comparing(predicate).thenComparing(getter, Comparator.nullsFirst(Comparable::compareTo)).compare(one, other) != 0;
        }

        public static <T, ST extends StackTraceElementProxy<T, ST>> RetraceStackTraceElementProxyEquivalence<T, ST> getInstance(boolean isVerbose) {
            return new RetraceStackTraceElementProxyEquivalence<T, ST>(isVerbose);
        }

        @Override
        protected boolean doEquivalent(RetraceStackTraceElementProxy<T, ST> one, RetraceStackTraceElementProxy<T, ST> other) {
            RetracedTypeReference otherFieldOrReturn;
            RetracedTypeReference oneFieldOrReturn;
            if (one == other) {
                return true;
            }
            if (this.testNotEqualProperty(one, other, RetraceStackTraceElementProxy::hasRetracedClass, r -> r.getRetracedClass().getTypeName()) || this.testNotEqualProperty(one, other, RetraceStackTraceElementProxy::hasSourceFile, RetraceStackTraceElementProxy::getSourceFile)) {
                return false;
            }
            assert (one.getOriginalItem() == other.getOriginalItem());
            if ((this.isVerbose || ((StackTraceElementProxy)one.getOriginalItem()).hasLineNumber() && ((StackTraceElementProxy)one.getOriginalItem()).getLineNumber() > 0) && this.testNotEqualProperty(one, other, RetraceStackTraceElementProxy::hasLineNumber, RetraceStackTraceElementProxy::getLineNumber)) {
                return false;
            }
            if (one.hasRetracedMethod() != other.hasRetracedMethod()) {
                return false;
            }
            if (one.hasRetracedMethod()) {
                RetracedMethodReference oneMethod = one.getRetracedMethod();
                RetracedMethodReference otherMethod = other.getRetracedMethod();
                if (oneMethod.isKnown() != otherMethod.isKnown()) {
                    return false;
                }
                if (!oneMethod.getMethodName().equals(otherMethod.getMethodName())) {
                    return false;
                }
                if (this.isVerbose && (oneMethod.isKnown() && !oneMethod.asKnown().getMethodReference().toString().equals(otherMethod.asKnown().getMethodReference().toString()) || !oneMethod.isKnown() && !oneMethod.getMethodName().equals(otherMethod.getMethodName()))) {
                    return false;
                }
            }
            if (one.hasRetracedField() != other.hasRetracedField()) {
                return false;
            }
            if (one.hasRetracedField()) {
                RetracedFieldReference oneField = one.getRetracedField();
                RetracedFieldReference otherField = other.getRetracedField();
                if (oneField.isKnown() != otherField.isKnown()) {
                    return false;
                }
                if (!oneField.getFieldName().equals(otherField.getFieldName())) {
                    return false;
                }
                if (this.isVerbose && (oneField.isKnown() && !oneField.asKnown().getFieldReference().toString().equals(otherField.asKnown().getFieldReference().toString()) || oneField.isUnknown() && !oneField.getFieldName().equals(otherField.getFieldName()))) {
                    return false;
                }
            }
            if (one.hasRetracedFieldOrReturnType() != other.hasRetracedFieldOrReturnType()) {
                return false;
            }
            if (one.hasRetracedFieldOrReturnType() && !this.compareRetracedTypeReference(oneFieldOrReturn = one.getRetracedFieldOrReturnType(), otherFieldOrReturn = other.getRetracedFieldOrReturnType())) {
                return false;
            }
            if (one.hasRetracedMethodArguments() != other.hasRetracedMethodArguments()) {
                return false;
            }
            if (one.hasRetracedMethodArguments()) {
                List<RetracedTypeReference> oneMethodArguments = one.getRetracedMethodArguments();
                List<RetracedTypeReference> otherMethodArguments = other.getRetracedMethodArguments();
                if (oneMethodArguments.size() != otherMethodArguments.size()) {
                    return false;
                }
                for (int i = 0; i < oneMethodArguments.size(); ++i) {
                    if (!this.compareRetracedTypeReference(oneMethodArguments.get(i), otherMethodArguments.get(i))) continue;
                    return false;
                }
            }
            return true;
        }

        @Override
        protected int doHash(RetraceStackTraceElementProxy<T, ST> proxy) {
            return 0;
        }
    }

    private static class RetraceDiagnosticsHandler
    implements DiagnosticsHandler {
        private final DiagnosticsHandler diagnosticsHandler;
        private final boolean printInfo;

        public RetraceDiagnosticsHandler(DiagnosticsHandler diagnosticsHandler, boolean printInfo) {
            this.diagnosticsHandler = diagnosticsHandler;
            this.printInfo = printInfo;
            assert (diagnosticsHandler != null);
        }

        @Override
        public void error(Diagnostic error) {
            this.diagnosticsHandler.error(error);
        }

        @Override
        public void warning(Diagnostic warning) {
            this.diagnosticsHandler.warning(warning);
        }

        @Override
        public void info(Diagnostic info) {
            if (this.printInfo) {
                this.diagnosticsHandler.info(info);
            }
        }
    }

    private static interface MainAction {
        public void run() throws RetraceFailedException;
    }
}

