/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.retrace;

import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.Keep;
import com.android.tools.r8.retrace.ProguardMapProducer;
import com.android.tools.r8.retrace.RetraceOptions;
import java.util.List;
import java.util.function.Consumer;

@Keep
public class RetraceCommand {
    private final List<String> stackTrace;
    private final Consumer<List<String>> retracedStackTraceConsumer;
    private final RetraceOptions options;

    private RetraceCommand(List<String> stackTrace, Consumer<List<String>> retracedStackTraceConsumer, RetraceOptions options) {
        this.stackTrace = stackTrace;
        this.retracedStackTraceConsumer = retracedStackTraceConsumer;
        this.options = options;
        assert (this.stackTrace != null || options.isVerifyMappingFileHash());
        assert (this.retracedStackTraceConsumer != null);
    }

    public static Builder builder(DiagnosticsHandler diagnosticsHandler) {
        return new Builder(diagnosticsHandler);
    }

    public static Builder builder() {
        return new Builder(new DiagnosticsHandler(){});
    }

    public boolean printTimes() {
        return System.getProperty("com.android.tools.r8.printtimes") != null;
    }

    public boolean printMemory() {
        return System.getProperty("com.android.tools.r8.printmemory") != null;
    }

    public List<String> getStackTrace() {
        return this.stackTrace;
    }

    public Consumer<List<String>> getRetracedStackTraceConsumer() {
        return this.retracedStackTraceConsumer;
    }

    public RetraceOptions getOptions() {
        return this.options;
    }

    @Keep
    public static class Builder {
        private boolean isVerbose;
        private final DiagnosticsHandler diagnosticsHandler;
        private ProguardMapProducer proguardMapProducer;
        private String regularExpression = "(?:.*?\\bat\\s+%c\\.%m\\s*\\(%S\\)\\s*(?:~\\[.*\\])?)|(?:(?:(?:%c|.*)?[:\"]\\s+)?%c(?::.*)?)";
        private List<String> stackTrace;
        private Consumer<List<String>> retracedStackTraceConsumer;
        private boolean verifyMappingFileHash = false;

        private Builder(DiagnosticsHandler diagnosticsHandler) {
            this.diagnosticsHandler = diagnosticsHandler;
        }

        public Builder setVerbose(boolean verbose) {
            this.isVerbose = verbose;
            return this;
        }

        public Builder setProguardMapProducer(ProguardMapProducer producer) {
            this.proguardMapProducer = producer;
            return this;
        }

        public Builder setRegularExpression(String regularExpression) {
            this.regularExpression = regularExpression;
            return this;
        }

        public Builder setStackTrace(List<String> stackTrace) {
            this.stackTrace = stackTrace;
            return this;
        }

        public Builder setVerifyMappingFileHash(boolean verifyMappingFileHash) {
            this.verifyMappingFileHash = verifyMappingFileHash;
            return this;
        }

        public Builder setRetracedStackTraceConsumer(Consumer<List<String>> consumer) {
            this.retracedStackTraceConsumer = consumer;
            return this;
        }

        public RetraceCommand build() {
            if (this.diagnosticsHandler == null) {
                throw new RuntimeException("DiagnosticsHandler not specified");
            }
            if (this.proguardMapProducer == null) {
                throw new RuntimeException("ProguardMapSupplier not specified");
            }
            if (this.stackTrace == null && !this.verifyMappingFileHash) {
                throw new RuntimeException("StackTrace not specified");
            }
            if (this.retracedStackTraceConsumer == null) {
                throw new RuntimeException("RetracedStackConsumer not specified");
            }
            RetraceOptions retraceOptions = RetraceOptions.builder(this.diagnosticsHandler).setRegularExpression(this.regularExpression).setProguardMapProducer(this.proguardMapProducer).setVerbose(this.isVerbose).setVerifyMappingFileHash(this.verifyMappingFileHash).build();
            return new RetraceCommand(this.stackTrace, this.retracedStackTraceConsumer, retraceOptions);
        }
    }
}

