/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.retrace.internal;

import com.android.tools.r8.references.ClassReference;
import com.android.tools.r8.references.MethodReference;
import com.android.tools.r8.references.Reference;
import com.android.tools.r8.retrace.internal.Definition;
import java.util.Objects;

abstract class MethodDefinition
implements Definition {
    MethodDefinition() {
    }

    static MethodDefinition create(ClassReference classReference, String methodName) {
        return new BaseMethodDefinition(classReference, methodName);
    }

    static MethodDefinition create(MethodReference methodReference) {
        return new FullMethodDefinition(methodReference);
    }

    boolean isFullMethodDefinition() {
        return false;
    }

    FullMethodDefinition asFullMethodDefinition() {
        return null;
    }

    abstract MethodDefinition substituteHolder(ClassReference var1);

    static class FullMethodDefinition
    extends MethodDefinition {
        private final MethodReference methodReference;

        private FullMethodDefinition(MethodReference methodReference) {
            this.methodReference = methodReference;
        }

        @Override
        public ClassReference getHolderClass() {
            return this.methodReference.getHolderClass();
        }

        @Override
        public String getName() {
            return this.methodReference.getMethodName();
        }

        @Override
        boolean isFullMethodDefinition() {
            return true;
        }

        @Override
        FullMethodDefinition asFullMethodDefinition() {
            return this;
        }

        @Override
        MethodDefinition substituteHolder(ClassReference newHolder) {
            return MethodDefinition.create(Reference.method(newHolder, this.methodReference.getMethodName(), this.methodReference.getFormalTypes(), this.methodReference.getReturnType()));
        }

        MethodReference getMethodReference() {
            return this.methodReference;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FullMethodDefinition that = (FullMethodDefinition)o;
            return this.methodReference.equals(that.methodReference);
        }

        public int hashCode() {
            return this.methodReference.hashCode();
        }
    }

    static class BaseMethodDefinition
    extends MethodDefinition {
        private final ClassReference classReference;
        private final String name;

        private BaseMethodDefinition(ClassReference classReference, String name) {
            this.classReference = classReference;
            this.name = name;
        }

        @Override
        public ClassReference getHolderClass() {
            return this.classReference;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        MethodDefinition substituteHolder(ClassReference newHolder) {
            return MethodDefinition.create(newHolder, this.name);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BaseMethodDefinition that = (BaseMethodDefinition)o;
            return this.classReference.equals(that.classReference) && this.name.equals(that.name);
        }

        public int hashCode() {
            return Objects.hash(this.classReference, this.name);
        }
    }
}

