/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.retrace.internal;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.naming.ClassNamingForNameMapper;
import com.android.tools.r8.naming.MemberNaming;
import com.android.tools.r8.naming.mappinginformation.MappingInformation;
import com.android.tools.r8.references.ClassReference;
import com.android.tools.r8.references.MethodReference;
import com.android.tools.r8.references.Reference;
import com.android.tools.r8.references.TypeReference;
import com.android.tools.r8.retrace.RetraceClassElement;
import com.android.tools.r8.retrace.RetraceClassResult;
import com.android.tools.r8.retrace.RetraceFrameResult;
import com.android.tools.r8.retrace.RetraceStackTraceContext;
import com.android.tools.r8.retrace.RetraceUnknownJsonMappingInformationResult;
import com.android.tools.r8.retrace.RetracedSourceFile;
import com.android.tools.r8.retrace.internal.Definition;
import com.android.tools.r8.retrace.internal.FieldDefinition;
import com.android.tools.r8.retrace.internal.MethodDefinition;
import com.android.tools.r8.retrace.internal.RetraceFieldResultImpl;
import com.android.tools.r8.retrace.internal.RetraceFrameResultImpl;
import com.android.tools.r8.retrace.internal.RetraceMethodResultImpl;
import com.android.tools.r8.retrace.internal.RetraceStackTraceContextImpl;
import com.android.tools.r8.retrace.internal.RetraceThrownExceptionResultImpl;
import com.android.tools.r8.retrace.internal.RetraceUnknownJsonMappingInformationResultImpl;
import com.android.tools.r8.retrace.internal.RetracedClassReferenceImpl;
import com.android.tools.r8.retrace.internal.RetracedSourceFileImpl;
import com.android.tools.r8.retrace.internal.RetracerImpl;
import com.android.tools.r8.utils.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.BiFunction;
import java.util.stream.Stream;

public class RetraceClassResultImpl
implements RetraceClassResult {
    private final ClassReference obfuscatedReference;
    private final ClassNamingForNameMapper mapper;
    private final RetracerImpl retracer;

    private RetraceClassResultImpl(ClassReference obfuscatedReference, ClassNamingForNameMapper mapper, RetracerImpl retracer) {
        this.obfuscatedReference = obfuscatedReference;
        this.mapper = mapper;
        this.retracer = retracer;
    }

    static RetraceClassResultImpl create(ClassReference obfuscatedReference, ClassNamingForNameMapper mapper, RetracerImpl retracer) {
        return new RetraceClassResultImpl(obfuscatedReference, mapper, retracer);
    }

    private RetraceFieldResultImpl lookupField(FieldDefinition fieldDefinition) {
        return this.lookup(fieldDefinition, (mapper, name) -> {
            List<MemberNaming> memberNamings = mapper.mappedFieldNamingsByName.get(name);
            if (memberNamings == null || memberNamings.isEmpty()) {
                return null;
            }
            return memberNamings;
        }, RetraceFieldResultImpl::new);
    }

    private RetraceMethodResultImpl lookupMethod(MethodDefinition methodDefinition) {
        return this.lookup(methodDefinition, (mapper, name) -> {
            ClassNamingForNameMapper.MappedRangesOfName mappedRanges = mapper.mappedRangesByRenamedName.get(name);
            if (mappedRanges == null || mappedRanges.getMappedRanges().isEmpty()) {
                return null;
            }
            return mappedRanges.getMappedRanges();
        }, RetraceMethodResultImpl::new);
    }

    private <T, R, D extends Definition> R lookup(D definition, BiFunction<ClassNamingForNameMapper, String, T> lookupFunction, ResultConstructor<T, R, D> constructor) {
        ArrayList mappings = new ArrayList();
        this.internalStream().forEach((? super T element) -> {
            if (this.mapper != null) {
                assert (((RetraceClassElementImpl)element).mapper != null);
                Object mappedElements = lookupFunction.apply(((RetraceClassElementImpl)element).mapper, definition.getName());
                if (mappedElements != null) {
                    mappings.add(new Pair((RetraceClassElementImpl)element, mappedElements));
                    return;
                }
            }
            mappings.add(new Pair<RetraceClassElementImpl, Object>((RetraceClassElementImpl)element, null));
        });
        return constructor.create(this, mappings, definition, this.retracer);
    }

    private RetraceFrameResultImpl lookupFrame(RetraceStackTraceContext context, OptionalInt position, MethodDefinition definition) {
        return this.lookupMethod(definition).narrowByPosition(context, position);
    }

    private Stream<RetraceClassElementImpl> internalStream() {
        return Stream.of(this.createElement());
    }

    private RetraceClassElementImpl createElement() {
        return new RetraceClassElementImpl(this, RetracedClassReferenceImpl.create(this.mapper == null ? this.obfuscatedReference : Reference.classFromTypeName(this.mapper.originalName)), this.mapper);
    }

    @Override
    public RetraceFieldResultImpl lookupField(String fieldName) {
        return this.lookupField(FieldDefinition.create(this.obfuscatedReference, fieldName));
    }

    @Override
    public RetraceFieldResultImpl lookupField(String fieldName, TypeReference fieldType) {
        return this.lookupField(FieldDefinition.create(Reference.field(this.obfuscatedReference, fieldName, fieldType)));
    }

    @Override
    public RetraceMethodResultImpl lookupMethod(String methodName) {
        return this.lookupMethod(MethodDefinition.create(this.obfuscatedReference, methodName));
    }

    @Override
    public RetraceMethodResultImpl lookupMethod(String methodName, List<TypeReference> formalTypes, TypeReference returnType) {
        return this.lookupMethod(MethodDefinition.create(Reference.method(this.obfuscatedReference, methodName, formalTypes, returnType)));
    }

    @Override
    public RetraceFrameResultImpl lookupFrame(RetraceStackTraceContext context, OptionalInt position, String methodName) {
        return this.lookupFrame(context, position, MethodDefinition.create(this.obfuscatedReference, methodName));
    }

    @Override
    public RetraceFrameResultImpl lookupFrame(RetraceStackTraceContext context, OptionalInt position, String methodName, List<TypeReference> formalTypes, TypeReference returnType) {
        return this.lookupFrame(context, position, MethodDefinition.create(Reference.method(this.obfuscatedReference, methodName, formalTypes, returnType)));
    }

    @Override
    public RetraceThrownExceptionResultImpl lookupThrownException(RetraceStackTraceContext context) {
        return new RetraceThrownExceptionResultImpl((RetraceStackTraceContextImpl)context, this.obfuscatedReference, this.mapper);
    }

    @Override
    public boolean isEmpty() {
        return this.mapper != null;
    }

    @Override
    public Stream<RetraceClassElement> stream() {
        return Stream.of(this.createElement());
    }

    public static class RetraceClassElementImpl
    implements RetraceClassElement {
        private final RetraceClassResultImpl classResult;
        private final RetracedClassReferenceImpl classReference;
        private final ClassNamingForNameMapper mapper;

        private RetraceClassElementImpl(RetraceClassResultImpl classResult, RetracedClassReferenceImpl classReference, ClassNamingForNameMapper mapper) {
            this.classResult = classResult;
            this.classReference = classReference;
            this.mapper = mapper;
        }

        private RetraceFieldResultImpl lookupField(FieldDefinition fieldDefinition) {
            return this.lookup(fieldDefinition, (mapper, name) -> {
                List<MemberNaming> memberNamings = mapper.mappedFieldNamingsByName.get(name);
                if (memberNamings == null || memberNamings.isEmpty()) {
                    return null;
                }
                return memberNamings;
            }, RetraceFieldResultImpl::new);
        }

        private RetraceMethodResultImpl lookupMethod(MethodDefinition methodDefinition) {
            return this.lookup(methodDefinition, (mapper, name) -> {
                ClassNamingForNameMapper.MappedRangesOfName mappedRanges = mapper.mappedRangesByRenamedName.get(name);
                if (mappedRanges == null || mappedRanges.getMappedRanges().isEmpty()) {
                    return null;
                }
                return mappedRanges.getMappedRanges();
            }, RetraceMethodResultImpl::new);
        }

        private <T, R, D extends Definition> R lookup(D definition, BiFunction<ClassNamingForNameMapper, String, T> lookupFunction, ResultConstructor<T, R, D> constructor) {
            T result;
            ImmutableList<Pair<RetraceClassElementImpl, Object>> mappings = ImmutableList.of();
            if (this.mapper != null && (result = lookupFunction.apply(this.mapper, definition.getName())) != null) {
                mappings = ImmutableList.of(new Pair<RetraceClassElementImpl, T>(this, result));
            }
            if (mappings.isEmpty()) {
                mappings = ImmutableList.of(new Pair<RetraceClassElementImpl, Object>(this, null));
            }
            return constructor.create(this.classResult, mappings, definition, this.classResult.retracer);
        }

        private RetraceFrameResultImpl lookupFrame(RetraceStackTraceContext context, OptionalInt position, MethodDefinition definition) {
            return this.classResult.lookupFrame(context, position, definition);
        }

        @Override
        public RetracedClassReferenceImpl getRetracedClass() {
            return this.classReference;
        }

        @Override
        public RetracedSourceFile getSourceFile() {
            String sourceFile = null;
            if (this.mapper != null) {
                for (MappingInformation info : this.mapper.getAdditionalMappingInfo()) {
                    if (!info.isFileNameInformation()) continue;
                    sourceFile = info.asFileNameInformation().getFileName();
                    break;
                }
            }
            return new RetracedSourceFileImpl(this.getRetracedClass().getClassReference(), sourceFile);
        }

        @Override
        public RetraceClassResultImpl getParentResult() {
            return this.classResult;
        }

        @Override
        public boolean isCompilerSynthesized() {
            if (this.classResult.mapper != null) {
                for (MappingInformation info : this.classResult.mapper.getAdditionalMappingInfo()) {
                    if (!info.isCompilerSynthesizedMappingInformation()) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public RetraceFieldResultImpl lookupField(String fieldName) {
            return this.lookupField(FieldDefinition.create(this.classReference.getClassReference(), fieldName));
        }

        @Override
        public RetraceMethodResultImpl lookupMethod(String methodName) {
            return this.lookupMethod(MethodDefinition.create(this.classReference.getClassReference(), methodName));
        }

        @Override
        public RetraceFrameResultImpl lookupFrame(RetraceStackTraceContext context, OptionalInt position, String methodName) {
            return this.lookupFrame(context, position, MethodDefinition.create(this.classReference.getClassReference(), methodName));
        }

        @Override
        public RetraceFrameResult lookupFrame(RetraceStackTraceContext context, OptionalInt position, String methodName, List<TypeReference> formalTypes, TypeReference returnType) {
            return this.lookupFrame(context, position, MethodDefinition.create(Reference.method(this.classReference.getClassReference(), methodName, formalTypes, returnType)));
        }

        @Override
        public RetraceFrameResult lookupFrame(RetraceStackTraceContext context, OptionalInt position, MethodReference methodReference) {
            return this.lookupFrame(context, position, MethodDefinition.create(methodReference));
        }

        @Override
        public RetraceUnknownJsonMappingInformationResult getUnknownJsonMappingInformation() {
            return RetraceUnknownJsonMappingInformationResultImpl.build(this.mapper.getAdditionalMappingInfo());
        }
    }

    private static interface ResultConstructor<T, R, D> {
        public R create(RetraceClassResultImpl var1, List<Pair<RetraceClassElementImpl, T>> var2, D var3, RetracerImpl var4);
    }
}

