/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.retrace.internal;

import com.android.tools.r8.references.MethodReference;
import com.android.tools.r8.references.TypeReference;
import com.android.tools.r8.retrace.RetracedMethodReference;
import com.android.tools.r8.retrace.internal.MethodDefinition;
import com.android.tools.r8.retrace.internal.RetracedClassReferenceImpl;
import com.android.tools.r8.utils.ComparatorUtils;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

public abstract class RetracedMethodReferenceImpl
implements RetracedMethodReference {
    private static final Comparator<RetracedMethodReference> comparator = Comparator.comparing(RetracedMethodReference::getMethodName).thenComparing(RetracedMethodReference::isKnown).thenComparing(RetracedMethodReference::asKnown, Comparator.nullsFirst(Comparator.comparing(m3 -> {
        if (m3 == null) {
            return null;
        }
        return m3.isVoid() ? "void" : m3.getReturnType().getTypeName();
    })).thenComparing(RetracedMethodReference.KnownRetracedMethodReference::getFormalTypes, ComparatorUtils.listComparator(Comparator.comparing(TypeReference::getTypeName))));
    protected final OptionalInt position;

    private RetracedMethodReferenceImpl(OptionalInt position) {
        this.position = position;
    }

    static RetracedMethodReferenceImpl create(MethodDefinition methodDefinition) {
        if (methodDefinition.isFullMethodDefinition()) {
            return RetracedMethodReferenceImpl.create(methodDefinition.asFullMethodDefinition().getMethodReference(), OptionalInt.empty());
        }
        return new UnknownRetracedMethodReferenceImpl(methodDefinition, OptionalInt.empty());
    }

    static RetracedMethodReferenceImpl create(MethodReference methodReference) {
        return RetracedMethodReferenceImpl.create(methodReference, OptionalInt.empty());
    }

    static RetracedMethodReferenceImpl create(MethodReference methodReference, OptionalInt position) {
        return new KnownRetracedMethodReferenceImpl(methodReference, position);
    }

    @Override
    public boolean hasPosition() {
        return this.position.isPresent();
    }

    @Override
    public int getOriginalPositionOrDefault(int defaultPosition) {
        return this.position.orElse(defaultPosition);
    }

    @Override
    public boolean isUnknown() {
        return true;
    }

    @Override
    public final boolean isKnown() {
        return !this.isUnknown();
    }

    @Override
    public KnownRetracedMethodReferenceImpl asKnown() {
        return null;
    }

    @Override
    public int compareTo(RetracedMethodReference other) {
        return comparator.compare(this, other);
    }

    public static final class UnknownRetracedMethodReferenceImpl
    extends RetracedMethodReferenceImpl {
        private final MethodDefinition methodDefinition;

        private UnknownRetracedMethodReferenceImpl(MethodDefinition methodDefinition, OptionalInt position) {
            super(position);
            this.methodDefinition = methodDefinition;
        }

        @Override
        public RetracedClassReferenceImpl getHolderClass() {
            return RetracedClassReferenceImpl.create(this.methodDefinition.getHolderClass());
        }

        @Override
        public String getMethodName() {
            return this.methodDefinition.getName();
        }

        public Optional<MethodReference> getMethodReference() {
            if (!this.methodDefinition.isFullMethodDefinition()) {
                return Optional.empty();
            }
            return Optional.of(this.methodDefinition.asFullMethodDefinition().getMethodReference());
        }
    }

    public static final class KnownRetracedMethodReferenceImpl
    extends RetracedMethodReferenceImpl
    implements RetracedMethodReference.KnownRetracedMethodReference {
        private final MethodReference methodReference;

        private KnownRetracedMethodReferenceImpl(MethodReference methodReference, OptionalInt position) {
            super(position);
            assert (methodReference != null);
            this.methodReference = methodReference;
        }

        @Override
        public boolean isUnknown() {
            return false;
        }

        @Override
        public boolean isVoid() {
            return this.methodReference.getReturnType() == null;
        }

        @Override
        public KnownRetracedMethodReferenceImpl asKnown() {
            return this;
        }

        @Override
        public RetracedClassReferenceImpl getHolderClass() {
            return RetracedClassReferenceImpl.create(this.methodReference.getHolderClass());
        }

        @Override
        public String getMethodName() {
            return this.methodReference.getMethodName();
        }

        @Override
        public TypeReference getReturnType() {
            assert (!this.isVoid());
            return this.methodReference.getReturnType();
        }

        @Override
        public List<TypeReference> getFormalTypes() {
            return this.methodReference.getFormalTypes();
        }

        @Override
        public MethodReference getMethodReference() {
            return this.methodReference;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KnownRetracedMethodReferenceImpl that = (KnownRetracedMethodReferenceImpl)o;
            return this.position == that.position && this.methodReference.equals(that.methodReference);
        }

        public int hashCode() {
            return Objects.hash(this.methodReference, this.position);
        }
    }
}

