/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.retrace.internal;

import com.android.tools.r8.references.ClassReference;
import com.android.tools.r8.retrace.RetracedSourceFile;
import com.android.tools.r8.retrace.internal.RetraceUtils;

public class RetracedSourceFileImpl
implements RetracedSourceFile {
    private final ClassReference classReference;
    private final String filename;

    RetracedSourceFileImpl(ClassReference classReference, String filename) {
        assert (classReference != null);
        this.classReference = classReference;
        this.filename = filename;
    }

    @Override
    public boolean hasRetraceResult() {
        return this.filename != null;
    }

    @Override
    public String getSourceFile() {
        return this.filename;
    }

    @Override
    public String getOrInferSourceFile() {
        String sourceFile = this.getSourceFile();
        return sourceFile != null ? sourceFile : RetraceUtils.inferSourceFile(this.classReference.getTypeName(), "", true);
    }
}

