/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.retrace.internal;

import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.retrace.StackTraceLineParser;
import com.android.tools.r8.retrace.internal.StackTraceElementStringProxy;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StackTraceRegularExpressionParser
implements StackTraceLineParser<String, StackTraceElementStringProxy> {
    public static final String DEFAULT_REGULAR_EXPRESSION = "(?:.*?\\bat\\s+%c\\.%m\\s*\\(%S\\)\\s*(?:~\\[.*\\])?)|(?:(?:(?:%c|.*)?[:\"]\\s+)?%c(?::.*)?)";
    private static final int NO_MATCH = -1;
    private static final String CAPTURE_GROUP_PREFIX = "captureGroup";
    private static final int FIRST_CAPTURE_GROUP_INDEX = 0;
    private static final String javaIdentifierSegment = "\\p{javaJavaIdentifierStart}(?:-|\\p{javaJavaIdentifierPart})*";
    private static final String METHOD_NAME_REGULAR_EXPRESSION = "(?:(\\p{javaJavaIdentifierStart}(?:-|\\p{javaJavaIdentifierPart})*|\\<init\\>|\\<clinit\\>))";
    private static final String JAVA_TYPE_REGULAR_EXPRESSION = "(\\p{javaJavaIdentifierStart}(?:-|\\p{javaJavaIdentifierPart})*\\.)*\\p{javaJavaIdentifierStart}(?:-|\\p{javaJavaIdentifierPart})*[\\[\\]]*";
    private final Pattern compiledPattern;
    private final SourceFileLineNumberGroup sourceFileLineNumberGroup = new SourceFileLineNumberGroup();
    private final List<RegularExpressionGroupHandler> handlers;
    private final TypeNameGroup typeNameGroup = new TypeNameGroup();
    private final BinaryNameGroup binaryNameGroup = new BinaryNameGroup();
    private final SourceFileGroup sourceFileGroup = new SourceFileGroup();
    private final LineNumberGroup lineNumberGroup = new LineNumberGroup();
    private final FieldOrReturnTypeGroup fieldOrReturnTypeGroup = new FieldOrReturnTypeGroup();
    private final MethodArgumentsGroup methodArgumentsGroup = new MethodArgumentsGroup();
    private final MethodNameGroup methodNameGroup = new MethodNameGroup();
    private final FieldNameGroup fieldNameGroup = new FieldNameGroup();

    public StackTraceRegularExpressionParser() {
        this(DEFAULT_REGULAR_EXPRESSION);
    }

    public StackTraceRegularExpressionParser(String regularExpression) {
        this.handlers = new ArrayList<RegularExpressionGroupHandler>();
        StringBuilder refinedRegularExpressionBuilder = new StringBuilder();
        this.registerGroups(regularExpression, refinedRegularExpressionBuilder, this.handlers, 0);
        this.compiledPattern = Pattern.compile(refinedRegularExpressionBuilder.toString());
    }

    private int registerGroups(String regularExpression, StringBuilder refinedRegularExpression, List<RegularExpressionGroupHandler> handlers, int captureGroupIndex) {
        int lastCommittedIndex = 0;
        boolean seenPercentage = false;
        boolean escaped = false;
        for (int i = 0; i < regularExpression.length(); ++i) {
            if (seenPercentage) {
                assert (!escaped);
                RegularExpressionGroup group = this.getGroupFromVariable(regularExpression.charAt(i));
                refinedRegularExpression.append(regularExpression, lastCommittedIndex, i - 1);
                if (group.isSynthetic()) {
                    captureGroupIndex = this.registerGroups(group.subExpression(), refinedRegularExpression, handlers, captureGroupIndex);
                } else {
                    String captureGroupName = CAPTURE_GROUP_PREFIX + captureGroupIndex++;
                    refinedRegularExpression.append("(?<").append(captureGroupName).append(">").append(group.subExpression()).append(")");
                    handlers.add(group.createHandler(captureGroupName));
                }
                lastCommittedIndex = i + 1;
                seenPercentage = false;
                continue;
            }
            seenPercentage = !escaped && regularExpression.charAt(i) == '%';
            escaped = !escaped && regularExpression.charAt(i) == '\\';
        }
        refinedRegularExpression.append(regularExpression, lastCommittedIndex, regularExpression.length());
        return captureGroupIndex;
    }

    private boolean isTypeOrBinarySeparator(String regularExpression, int startIndex, int endIndex) {
        assert (endIndex < regularExpression.length());
        if (startIndex + 1 != endIndex) {
            return false;
        }
        if (regularExpression.charAt(startIndex) != '\\') {
            return false;
        }
        return regularExpression.charAt(startIndex + 1) == '.' || regularExpression.charAt(startIndex + 1) == '/';
    }

    private RegularExpressionGroup getGroupFromVariable(char variable) {
        switch (variable) {
            case 'c': {
                return this.typeNameGroup;
            }
            case 'C': {
                return this.binaryNameGroup;
            }
            case 'm': {
                return this.methodNameGroup;
            }
            case 'f': {
                return this.fieldNameGroup;
            }
            case 's': {
                return this.sourceFileGroup;
            }
            case 'l': {
                return this.lineNumberGroup;
            }
            case 'S': {
                return this.sourceFileLineNumberGroup;
            }
            case 't': {
                return this.fieldOrReturnTypeGroup;
            }
            case 'a': {
                return this.methodArgumentsGroup;
            }
        }
        throw new Unreachable("Unexpected variable: " + variable);
    }

    @Override
    public StackTraceElementStringProxy parse(String stackTraceLine) {
        StackTraceElementStringProxy.StackTraceElementStringProxyBuilder proxyBuilder = StackTraceElementStringProxy.builder(stackTraceLine);
        Matcher matcher = this.compiledPattern.matcher(stackTraceLine);
        if (matcher.matches()) {
            boolean seenMatchedClassHandler = false;
            for (RegularExpressionGroupHandler handler : this.handlers) {
                if (seenMatchedClassHandler && handler.isClassHandler() || !handler.matchHandler(proxyBuilder, matcher)) continue;
                seenMatchedClassHandler |= handler.isClassHandler();
            }
        }
        return proxyBuilder.build();
    }

    private static class MethodArgumentsGroup
    extends RegularExpressionGroup {
        private MethodArgumentsGroup() {
        }

        @Override
        String subExpression() {
            return "(((\\p{javaJavaIdentifierStart}(?:-|\\p{javaJavaIdentifierPart})*\\.)*\\p{javaJavaIdentifierStart}(?:-|\\p{javaJavaIdentifierPart})*[\\[\\]]*\\,)*(\\p{javaJavaIdentifierStart}(?:-|\\p{javaJavaIdentifierPart})*\\.)*\\p{javaJavaIdentifierStart}(?:-|\\p{javaJavaIdentifierPart})*[\\[\\]]*)?";
        }

        @Override
        RegularExpressionGroupHandler createHandler(String captureGroup) {
            return (builder, matcher) -> {
                int startOfGroup = matcher.start(captureGroup);
                if (startOfGroup == -1) {
                    return false;
                }
                builder.registerMethodArguments(startOfGroup, matcher.end(captureGroup));
                return true;
            };
        }
    }

    private static class FieldOrReturnTypeGroup
    extends RegularExpressionGroup {
        private FieldOrReturnTypeGroup() {
        }

        @Override
        String subExpression() {
            return StackTraceRegularExpressionParser.JAVA_TYPE_REGULAR_EXPRESSION;
        }

        @Override
        RegularExpressionGroupHandler createHandler(String captureGroup) {
            return (builder, matcher) -> {
                int startOfGroup = matcher.start(captureGroup);
                if (startOfGroup == -1) {
                    return false;
                }
                builder.registerFieldOrReturnType(startOfGroup, matcher.end(captureGroup));
                return true;
            };
        }
    }

    private static class SourceFileLineNumberGroup
    extends RegularExpressionGroup {
        private SourceFileLineNumberGroup() {
        }

        private int findEndOfSourceFile(String group) {
            for (int index = group.length(); index > 0; --index) {
                char currentChar = group.charAt(index - 1);
                if (currentChar == ':' && index < group.length()) {
                    return index - 1;
                }
                if (Character.isDigit(currentChar)) continue;
                return group.length();
            }
            return group.length();
        }

        @Override
        String subExpression() {
            return SourceFileGroup.subExpressionInternal() + "(?::\\d*)?";
        }

        @Override
        RegularExpressionGroupHandler createHandler(String captureGroup) {
            return (builder, matcher) -> {
                int startOfGroup = matcher.start(captureGroup);
                if (startOfGroup == -1) {
                    return false;
                }
                int endOfSourceFineInGroup = this.findEndOfSourceFile(matcher.group(captureGroup));
                int sourceFileEnd = startOfGroup + endOfSourceFineInGroup;
                builder.registerSourceFile(startOfGroup, sourceFileEnd);
                int endOfMatch = matcher.end(captureGroup);
                int lineNumberStart = sourceFileEnd + 1;
                builder.registerLineNumber(Integer.min(lineNumberStart, endOfMatch), endOfMatch, lineNumberStart > endOfMatch);
                return true;
            };
        }
    }

    private static class LineNumberGroup
    extends RegularExpressionGroup {
        private LineNumberGroup() {
        }

        @Override
        String subExpression() {
            return "\\d*";
        }

        @Override
        RegularExpressionGroupHandler createHandler(String captureGroup) {
            return (builder, matcher) -> {
                int startOfGroup = matcher.start(captureGroup);
                if (startOfGroup == -1) {
                    return false;
                }
                builder.registerLineNumber(startOfGroup, matcher.end(captureGroup), false);
                return true;
            };
        }
    }

    private static class SourceFileGroup
    extends RegularExpressionGroup {
        private SourceFileGroup() {
        }

        static String subExpressionInternal() {
            String anyNonDigitNonColonChar = "^\\d:";
            String anyNonColonChar = "^:";
            String colonWithNonDigitSuffix = ":+[" + anyNonDigitNonColonChar + "]";
            return "((?:(?:(?:" + colonWithNonDigitSuffix + "))|(?:[" + anyNonColonChar + "]))+)?";
        }

        @Override
        String subExpression() {
            return SourceFileGroup.subExpressionInternal();
        }

        @Override
        RegularExpressionGroupHandler createHandler(String captureGroup) {
            return (builder, matcher) -> {
                int startOfGroup = matcher.start(captureGroup);
                if (startOfGroup == -1) {
                    return false;
                }
                builder.registerSourceFile(startOfGroup, matcher.end(captureGroup));
                return true;
            };
        }
    }

    private static class FieldNameGroup
    extends RegularExpressionGroup {
        private FieldNameGroup() {
        }

        @Override
        String subExpression() {
            return StackTraceRegularExpressionParser.javaIdentifierSegment;
        }

        @Override
        RegularExpressionGroupHandler createHandler(String captureGroup) {
            return (builder, matcher) -> {
                int startOfGroup = matcher.start(captureGroup);
                if (startOfGroup == -1) {
                    return false;
                }
                builder.registerFieldName(startOfGroup, matcher.end(captureGroup));
                return true;
            };
        }
    }

    private static class MethodNameGroup
    extends RegularExpressionGroup {
        private MethodNameGroup() {
        }

        @Override
        String subExpression() {
            return StackTraceRegularExpressionParser.METHOD_NAME_REGULAR_EXPRESSION;
        }

        @Override
        RegularExpressionGroupHandler createHandler(String captureGroup) {
            return (builder, matcher) -> {
                int startOfGroup = matcher.start(captureGroup);
                if (startOfGroup == -1) {
                    return false;
                }
                builder.registerMethodName(startOfGroup, matcher.end(captureGroup));
                return true;
            };
        }
    }

    private static class BinaryNameGroup
    extends ClassNameGroup {
        private BinaryNameGroup() {
        }

        @Override
        String subExpression() {
            return "(?:\\p{javaJavaIdentifierStart}(?:-|\\p{javaJavaIdentifierPart})*\\/)*\\p{javaJavaIdentifierStart}(?:-|\\p{javaJavaIdentifierPart})*";
        }

        @Override
        StackTraceElementStringProxy.ClassNameType getClassNameType() {
            return StackTraceElementStringProxy.ClassNameType.BINARY;
        }
    }

    private static class TypeNameGroup
    extends ClassNameGroup {
        private TypeNameGroup() {
        }

        @Override
        String subExpression() {
            return "(\\p{javaJavaIdentifierStart}(?:-|\\p{javaJavaIdentifierPart})*\\.)*\\p{javaJavaIdentifierStart}(?:-|\\p{javaJavaIdentifierPart})*";
        }

        @Override
        StackTraceElementStringProxy.ClassNameType getClassNameType() {
            return StackTraceElementStringProxy.ClassNameType.TYPENAME;
        }
    }

    static abstract class ClassNameGroup
    extends RegularExpressionGroup {
        ClassNameGroup() {
        }

        abstract StackTraceElementStringProxy.ClassNameType getClassNameType();

        @Override
        RegularExpressionGroupHandler createHandler(final String captureGroup) {
            return new RegularExpressionGroupHandler(){

                @Override
                public boolean matchHandler(StackTraceElementStringProxy.StackTraceElementStringProxyBuilder builder, Matcher matcher) {
                    int startOfGroup = matcher.start(captureGroup);
                    if (startOfGroup == -1) {
                        return false;
                    }
                    String typeName = matcher.group(captureGroup);
                    if (typeName.equals("Suppressed")) {
                        return false;
                    }
                    builder.registerClassName(startOfGroup, matcher.end(captureGroup), this.getClassNameType());
                    return true;
                }

                @Override
                public boolean isClassHandler() {
                    return true;
                }
            };
        }
    }

    private static abstract class RegularExpressionGroup {
        private RegularExpressionGroup() {
        }

        abstract String subExpression();

        abstract RegularExpressionGroupHandler createHandler(String var1);

        boolean isSynthetic() {
            return false;
        }
    }

    private static interface RegularExpressionGroupHandler {
        public boolean matchHandler(StackTraceElementStringProxy.StackTraceElementStringProxyBuilder var1, Matcher var2);

        default public boolean isClassHandler() {
            return false;
        }
    }
}

