/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.ProgramDefinition;
import java.util.List;
import java.util.Objects;

public abstract class AnnotationMatchResult {
    public boolean isConcreteAnnotationMatchResult() {
        return false;
    }

    public ConcreteAnnotationMatchResult asConcreteAnnotationMatchResult() {
        return null;
    }

    static class MatchedAnnotation {
        private final ProgramDefinition annotatedItem;
        private final DexAnnotation annotation;
        private final DexAnnotation.AnnotatedKind annotatedKind;

        MatchedAnnotation(ProgramDefinition annotatedItem, DexAnnotation annotation, DexAnnotation.AnnotatedKind annotatedKind) {
            this.annotatedItem = annotatedItem;
            this.annotation = annotation;
            this.annotatedKind = annotatedKind;
        }

        public ProgramDefinition getAnnotatedItem() {
            return this.annotatedItem;
        }

        public DexAnnotation getAnnotation() {
            return this.annotation;
        }

        public DexAnnotation.AnnotatedKind getAnnotatedKind() {
            return this.annotatedKind;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof MatchedAnnotation) {
                MatchedAnnotation annotationToRetain = (MatchedAnnotation)obj;
                return this.annotatedItem == annotationToRetain.annotatedItem && this.annotation == annotationToRetain.annotation && this.annotatedKind == annotationToRetain.annotatedKind;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.annotatedItem, this.annotation, this.annotatedKind});
        }
    }

    static class ConcreteAnnotationMatchResult
    extends AnnotationMatchResult {
        private final List<MatchedAnnotation> matchedAnnotations;

        public ConcreteAnnotationMatchResult(List<MatchedAnnotation> matchedAnnotations) {
            this.matchedAnnotations = matchedAnnotations;
        }

        public List<MatchedAnnotation> getMatchedAnnotations() {
            return this.matchedAnnotations;
        }

        @Override
        public boolean isConcreteAnnotationMatchResult() {
            return true;
        }

        @Override
        public ConcreteAnnotationMatchResult asConcreteAnnotationMatchResult() {
            return this;
        }
    }

    static class AnnotationsIgnoredMatchResult
    extends AnnotationMatchResult {
        private static final AnnotationsIgnoredMatchResult INSTANCE = new AnnotationsIgnoredMatchResult();

        private AnnotationsIgnoredMatchResult() {
        }

        public static AnnotationsIgnoredMatchResult getInstance() {
            return INSTANCE;
        }
    }
}

