/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.FieldAccessInfoCollectionImpl;
import com.android.tools.r8.graph.FieldAccessInfoImpl;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import java.util.Set;

public class AppInfoWithLivenessModifier {
    private final Set<DexProgramClass> noLongerInstantiatedClasses = Sets.newConcurrentHashSet();
    private final Set<DexField> noLongerWrittenFields = Sets.newConcurrentHashSet();

    AppInfoWithLivenessModifier() {
    }

    private void clear() {
        this.noLongerInstantiatedClasses.clear();
    }

    public boolean isEmpty() {
        return this.noLongerInstantiatedClasses.isEmpty();
    }

    public void removeInstantiatedType(DexProgramClass clazz) {
        this.noLongerInstantiatedClasses.add(clazz);
    }

    public void removeWrittenField(DexField field) {
        this.noLongerWrittenFields.add(field);
    }

    public void modify(AppInfoWithLiveness appInfo) {
        this.noLongerInstantiatedClasses.forEach(appInfo::removeFromSingleTargetLookupCache);
        appInfo.mutateObjectAllocationInfoCollection(mutator -> this.noLongerInstantiatedClasses.forEach(mutator::markNoLongerInstantiated));
        FieldAccessInfoCollectionImpl fieldAccessInfoCollection = appInfo.getMutableFieldAccessInfoCollection();
        this.noLongerWrittenFields.forEach(field -> {
            FieldAccessInfoImpl fieldAccessInfo = fieldAccessInfoCollection.get((DexField)field);
            if (fieldAccessInfo != null) {
                fieldAccessInfo.clearWrites();
            }
        });
        this.clear();
    }
}

