/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMember;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.FieldAccessFlags;
import com.android.tools.r8.graph.InitClassLens;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.Visibility;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

public class ClassInitFieldSynthesizer {
    private final AppView<AppInfoWithLiveness> appView;
    private final DexField clinitField;
    private final InitClassLens.Builder lensBuilder = InitClassLens.builder();

    public ClassInitFieldSynthesizer(AppView<AppInfoWithLiveness> appView) {
        this.appView = appView;
        this.clinitField = appView.dexItemFactory().objectMembers.clinitField;
    }

    private void synthesizeClassInitField(DexType type, Visibility minimumRequiredVisibility) {
        DexProgramClass clazz = DexProgramClass.asProgramClassOrNull(this.appView.definitionFor(type));
        if (clazz == null) {
            assert (false);
            return;
        }
        DexEncodedMember encodedClinitField = null;
        for (DexEncodedField staticField : clazz.staticFields()) {
            if (staticField.getOptimizationInfo().isDead() || !this.isMinimumRequiredVisibility(staticField, minimumRequiredVisibility) || ((DexField)staticField.getReference()).type.isWideType()) continue;
            if (encodedClinitField == null) {
                encodedClinitField = staticField;
            } else if (staticField.getAccessFlags().getVisibilityOrdinal() > ((DexEncodedField)encodedClinitField).getAccessFlags().getVisibilityOrdinal()) {
                encodedClinitField = staticField;
            }
            if (!((DexEncodedField)encodedClinitField).isPublic()) continue;
            break;
        }
        if (encodedClinitField == null) {
            FieldAccessFlags accessFlags = FieldAccessFlags.fromSharedAccessFlags(4121);
            encodedClinitField = DexEncodedField.syntheticBuilder().setField(this.appView.dexItemFactory().createField(clazz.type, this.clinitField.type, this.clinitField.name)).setAccessFlags(accessFlags).setApiLevel(this.appView.computedMinApiLevel()).build();
            clazz.appendStaticField((DexEncodedField)encodedClinitField);
        }
        this.lensBuilder.map(type, (DexField)encodedClinitField.getReference());
    }

    private boolean isMinimumRequiredVisibility(DexEncodedField field, Visibility minimumRequiredVisibility) {
        if (field.isPublic()) {
            return true;
        }
        switch (minimumRequiredVisibility) {
            case PROTECTED: {
                return field.isProtected();
            }
            case PACKAGE_PRIVATE: {
                return field.isPackagePrivate() || field.isProtected();
            }
            case PUBLIC: {
                return false;
            }
        }
        throw new Unreachable();
    }

    public void run(ExecutorService executorService) throws ExecutionException {
        ThreadUtils.processMap(this.appView.appInfo().initClassReferences, this::synthesizeClassInitField, executorService);
        this.appView.setInitClassLens(this.lensBuilder.build());
    }
}

