/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.ProgramField;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.EnqueuerEvent;
import com.android.tools.r8.shaking.KeepClassInfo;
import com.android.tools.r8.shaking.KeepFieldInfo;
import com.android.tools.r8.shaking.KeepInfo;
import com.android.tools.r8.shaking.KeepMethodInfo;
import com.android.tools.r8.shaking.MinimumKeepInfoCollection;
import com.android.tools.r8.utils.MapUtils;
import com.android.tools.r8.utils.TriConsumer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class DependentMinimumKeepInfoCollection {
    private final Map<EnqueuerEvent, MinimumKeepInfoCollection> dependentMinimumKeepInfo = new ConcurrentHashMap<EnqueuerEvent, MinimumKeepInfoCollection>();

    private <J extends KeepInfo.Joiner<?, ?, ?>> J internalRemove(EnqueuerEvent preconditionEvent, Function<MinimumKeepInfoCollection, J> fn) {
        MinimumKeepInfoCollection minimumKeepInfo = this.get(preconditionEvent);
        if (minimumKeepInfo == null) {
            return null;
        }
        KeepInfo.Joiner minimumKeepInfoForReference = (KeepInfo.Joiner)fn.apply(minimumKeepInfo);
        if (minimumKeepInfo.isEmpty()) {
            this.remove(preconditionEvent);
        }
        return (J)minimumKeepInfoForReference;
    }

    public void forEach(BiConsumer<EnqueuerEvent, MinimumKeepInfoCollection> consumer) {
        this.dependentMinimumKeepInfo.forEach(consumer);
    }

    public void forEach(DexDefinitionSupplier definitions, TriConsumer<EnqueuerEvent, DexProgramClass, KeepClassInfo.Joiner> classConsumer, TriConsumer<EnqueuerEvent, ProgramField, KeepFieldInfo.Joiner> fieldConsumer, TriConsumer<EnqueuerEvent, ProgramMethod, KeepMethodInfo.Joiner> methodConsumer) {
        this.dependentMinimumKeepInfo.forEach((? super K preconditionEvent, ? super V minimumKeepInfo) -> minimumKeepInfo.forEach(definitions, (DexProgramClass clazz, KeepClassInfo.Joiner minimumKeepInfoForClass) -> classConsumer.accept((EnqueuerEvent)preconditionEvent, (DexProgramClass)clazz, (KeepClassInfo.Joiner)minimumKeepInfoForClass), (ProgramField field, KeepFieldInfo.Joiner minimumKeepInfoForField) -> fieldConsumer.accept((EnqueuerEvent)preconditionEvent, (ProgramField)field, (KeepFieldInfo.Joiner)minimumKeepInfoForField), (ProgramMethod method, KeepMethodInfo.Joiner minimumKeepInfoForMethod) -> methodConsumer.accept((EnqueuerEvent)preconditionEvent, (ProgramMethod)method, (KeepMethodInfo.Joiner)minimumKeepInfoForMethod)));
    }

    public MinimumKeepInfoCollection get(EnqueuerEvent preconditionEvent) {
        return this.dependentMinimumKeepInfo.get(preconditionEvent);
    }

    public MinimumKeepInfoCollection getOrCreateMinimumKeepInfoFor(EnqueuerEvent preconditionEvent) {
        return this.dependentMinimumKeepInfo.computeIfAbsent(preconditionEvent, MapUtils.ignoreKey(MinimumKeepInfoCollection::new));
    }

    public KeepInfo.Joiner<?, ?, ?> getOrCreateMinimumKeepInfoFor(EnqueuerEvent preconditionEvent, DexReference reference) {
        return this.getOrCreateMinimumKeepInfoFor(preconditionEvent).getOrCreateMinimumKeepInfoFor(reference);
    }

    public MinimumKeepInfoCollection getOrCreateUnconditionalMinimumKeepInfo() {
        return this.getOrCreateMinimumKeepInfoFor(EnqueuerEvent.UnconditionalKeepInfoEvent.get());
    }

    public KeepInfo.Joiner<?, ?, ?> getOrCreateUnconditionalMinimumKeepInfoFor(DexReference reference) {
        return this.getOrCreateMinimumKeepInfoFor(EnqueuerEvent.UnconditionalKeepInfoEvent.get(), reference);
    }

    public MinimumKeepInfoCollection getOrDefault(EnqueuerEvent preconditionEvent, MinimumKeepInfoCollection defaultValue) {
        return this.dependentMinimumKeepInfo.getOrDefault(preconditionEvent, defaultValue);
    }

    public MinimumKeepInfoCollection getUnconditionalMinimumKeepInfoOrDefault(MinimumKeepInfoCollection defaultValue) {
        return this.getOrDefault(EnqueuerEvent.UnconditionalKeepInfoEvent.get(), defaultValue);
    }

    public void merge(DependentMinimumKeepInfoCollection otherDependentMinimumKeepInfo) {
        otherDependentMinimumKeepInfo.forEach((preconditionEvent, minimumKeepInfo) -> this.getOrCreateMinimumKeepInfoFor((EnqueuerEvent)preconditionEvent).merge((MinimumKeepInfoCollection)minimumKeepInfo));
    }

    public void pruneDeadItems(DexDefinitionSupplier definitions, Enqueuer enqueuer) {
        MapUtils.removeIf(this.dependentMinimumKeepInfo, (preconditionEvent, minimumKeepInfo) -> {
            if (preconditionEvent.isClassEvent()) {
                EnqueuerEvent.ClassEnqueuerEvent classPreconditionEvent = preconditionEvent.asClassEvent();
                DexClass clazz = definitions.definitionFor(classPreconditionEvent.getType());
                if (clazz == null || !enqueuer.isReachable(clazz)) {
                    return true;
                }
            } else assert (preconditionEvent.isUnconditionalKeepInfoEvent());
            assert (!minimumKeepInfo.isEmpty());
            minimumKeepInfo.pruneDeadItems(definitions, enqueuer);
            return minimumKeepInfo.isEmpty();
        });
    }

    public MinimumKeepInfoCollection remove(EnqueuerEvent preconditionEvent) {
        return this.dependentMinimumKeepInfo.remove(preconditionEvent);
    }

    public KeepClassInfo.Joiner remove(EnqueuerEvent preconditionEvent, DexType clazz) {
        return this.internalRemove(preconditionEvent, minimumKeepInfo -> minimumKeepInfo.remove(clazz));
    }

    public KeepFieldInfo.Joiner remove(EnqueuerEvent preconditionEvent, DexField field) {
        return this.internalRemove(preconditionEvent, minimumKeepInfo -> minimumKeepInfo.remove(field));
    }

    public KeepMethodInfo.Joiner remove(EnqueuerEvent preconditionEvent, DexMethod method) {
        return this.internalRemove(preconditionEvent, minimumKeepInfo -> minimumKeepInfo.remove(method));
    }

    public DependentMinimumKeepInfoCollection rewrittenWithLens(GraphLens graphLens) {
        DependentMinimumKeepInfoCollection rewrittenDependentMinimumKeepInfo = new DependentMinimumKeepInfoCollection();
        this.forEach((preconditionEvent, minimumKeepInfo) -> {
            EnqueuerEvent rewrittenPreconditionEvent = preconditionEvent.rewrittenWithLens(graphLens);
            if (!rewrittenPreconditionEvent.isNoSuchEvent()) {
                rewrittenDependentMinimumKeepInfo.getOrCreateMinimumKeepInfoFor(rewrittenPreconditionEvent).merge(minimumKeepInfo.rewrittenWithLens(graphLens));
            }
        });
        return rewrittenDependentMinimumKeepInfo;
    }
}

