/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.ProgramDefinition;
import com.android.tools.r8.shaking.KeepInfo;
import com.android.tools.r8.shaking.MinimumKeepInfoCollection;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.ThreadUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

public class DiscardedChecker {
    private final AppView<? extends AppInfoWithClassHierarchy> appView;
    private final InternalOptions options;
    private final List<ProgramDefinition> failed = new ArrayList<ProgramDefinition>();

    private DiscardedChecker(AppView<? extends AppInfoWithClassHierarchy> appView) {
        this.appView = appView;
        this.options = appView.options();
    }

    public static DiscardedChecker create(AppView<? extends AppInfoWithClassHierarchy> appView) {
        return new DiscardedChecker(appView);
    }

    public static DiscardedChecker createForMainDex(AppView<? extends AppInfoWithClassHierarchy> appView) {
        final MinimumKeepInfoCollection unconditionalKeepInfo = appView.getMainDexRootSet().getDependentMinimumKeepInfo().getOrCreateUnconditionalMinimumKeepInfo();
        return new DiscardedChecker(appView){

            @Override
            boolean isCheckDiscardedEnabled(ProgramDefinition definition) {
                return unconditionalKeepInfo.hasMinimumKeepInfoThatMatches(definition.getReference(), KeepInfo.Joiner::isCheckDiscardedEnabled);
            }
        };
    }

    private void checkClassAndMembers(DexProgramClass clazz) {
        if (this.check(clazz)) {
            clazz.forEachProgramMember(this::check);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean check(ProgramDefinition item) {
        if (this.isCheckDiscardedEnabled(item)) {
            List<ProgramDefinition> list = this.failed;
            synchronized (list) {
                this.failed.add(item);
            }
            return false;
        }
        return true;
    }

    public List<ProgramDefinition> run(Iterable<DexProgramClass> classes, ExecutorService executorService) throws ExecutionException {
        assert (this.failed.isEmpty());
        ThreadUtils.processItems(classes, this::checkClassAndMembers, executorService);
        this.failed.sort((item, other) -> item.getReference().compareTo(other.getReference()));
        return this.failed;
    }

    boolean isCheckDiscardedEnabled(ProgramDefinition definition) {
        return this.appView.getKeepInfo().getInfo(definition).isCheckDiscardedEnabled(this.options);
    }
}

