/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.position.Position;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;

public class FilteredClassPath {
    private final Path path;
    private final ImmutableList<String> pattern;
    private final Origin origin;
    private final Position position;

    public FilteredClassPath(Path path, List<String> pattern, Origin origin, Position position) {
        this.path = path;
        this.pattern = ImmutableList.copyOf(pattern);
        this.origin = origin;
        this.position = position;
    }

    private FilteredClassPath(Path path) {
        this(path, ImmutableList.of(), Origin.unknown(), Position.UNKNOWN);
    }

    public static FilteredClassPath unfiltered(Path path) {
        return new FilteredClassPath(path);
    }

    private boolean containsFileSeparator(String string) {
        return string.indexOf(47) != -1;
    }

    private boolean matchAgainstFileName(String fileName, int namePos, String pattern, int patternPos) {
        if (patternPos >= pattern.length()) {
            return namePos == fileName.length();
        }
        char currentPattern = pattern.charAt(patternPos);
        if (currentPattern == '*') {
            String remainingPattern;
            boolean includeFileSeparators;
            boolean bl = includeFileSeparators = pattern.length() > patternPos + 1 && pattern.charAt(patternPos + 1) == '*';
            if (includeFileSeparators) {
                ++patternPos;
            }
            if ((remainingPattern = pattern.substring(patternPos + 1)).indexOf(42) == -1) {
                int remaining = remainingPattern.length();
                if (namePos + remaining > fileName.length()) {
                    return false;
                }
                if (includeFileSeparators || !this.containsFileSeparator(fileName.substring(namePos, fileName.length() - remaining))) {
                    return this.matchAgainstFileName(fileName, fileName.length() - remaining, pattern, patternPos + 1);
                }
            } else {
                for (int i = namePos; i < fileName.length(); ++i) {
                    if (!includeFileSeparators && fileName.charAt(i) == '/') {
                        return false;
                    }
                    if (!this.matchAgainstFileName(fileName, i, pattern, patternPos + 1)) continue;
                    return true;
                }
            }
        } else {
            if (namePos >= fileName.length()) {
                return false;
            }
            if (currentPattern == '?' || currentPattern == fileName.charAt(namePos)) {
                return this.matchAgainstFileName(fileName, namePos + 1, pattern, patternPos + 1);
            }
        }
        return false;
    }

    public Path getPath() {
        return this.path;
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public Position getPosition() {
        return this.position;
    }

    public boolean matchesFile(String name) {
        if (this.isUnfiltered()) {
            return true;
        }
        boolean isNegated = false;
        Iterator iterator2 = this.pattern.iterator();
        while (iterator2.hasNext()) {
            String pattern;
            isNegated = (pattern = (String)iterator2.next()).charAt(0) == '!';
            boolean matches = this.matchAgainstFileName(name, 0, pattern, isNegated ? 1 : 0);
            if (!matches) continue;
            return !isNegated;
        }
        return isNegated;
    }

    public boolean isUnfiltered() {
        return this.pattern.isEmpty();
    }

    public String toString() {
        if (this.isUnfiltered()) {
            return this.path.toString();
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.path);
        builder.append('(');
        boolean first = true;
        for (String pattern : this.pattern) {
            if (!first) {
                builder.append(',');
            }
            builder.append(pattern);
            first = false;
        }
        builder.append(')');
        return builder.toString();
    }
}

