/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.base.Equivalence;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClassAndField;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexDefinition;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.SubtypingInfo;
import com.android.tools.r8.shaking.AnnotationMatchResult;
import com.android.tools.r8.shaking.ClassInlineRule;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.InlineRule;
import com.android.tools.r8.shaking.NoHorizontalClassMergingRule;
import com.android.tools.r8.shaking.ProguardIfRule;
import com.android.tools.r8.shaking.ProguardMemberRule;
import com.android.tools.r8.shaking.RootSetUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.ThreadUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

public class IfRuleEvaluator {
    private final AppView<? extends AppInfoWithClassHierarchy> appView;
    private final SubtypingInfo subtypingInfo;
    private final Enqueuer enqueuer;
    private final ExecutorService executorService;
    private final List<Future<?>> futures = new ArrayList();
    private final Map<Equivalence.Wrapper<ProguardIfRule>, Set<ProguardIfRule>> ifRules;
    private final RootSetUtils.ConsequentRootSetBuilder rootSetBuilder;

    IfRuleEvaluator(AppView<? extends AppInfoWithClassHierarchy> appView, SubtypingInfo subtypingInfo, Enqueuer enqueuer, ExecutorService executorService, Map<Equivalence.Wrapper<ProguardIfRule>, Set<ProguardIfRule>> ifRules, RootSetUtils.ConsequentRootSetBuilder rootSetBuilder) {
        this.appView = appView;
        this.subtypingInfo = subtypingInfo;
        this.enqueuer = enqueuer;
        this.executorService = executorService;
        this.ifRules = ifRules;
        this.rootSetBuilder = rootSetBuilder;
    }

    private boolean canRemoveSubsequentKeepRule(ProguardIfRule rule) {
        return Iterables.isEmpty(rule.subsequentRule.getWildcards());
    }

    private void registerClassCapture(ProguardIfRule memberRule, DexClass source, DexClass target) {
        boolean classNameResult = memberRule.getClassNames().matches(source.type);
        assert (classNameResult);
        if (memberRule.hasInheritanceClassName()) {
            boolean inheritanceResult = this.rootSetBuilder.satisfyInheritanceRule(target, memberRule);
            assert (inheritanceResult);
        }
    }

    private boolean isEffectivelyLive(DexProgramClass clazz) {
        if (this.enqueuer.isTypeLive(clazz)) {
            return true;
        }
        for (DexEncodedField field : clazz.fields()) {
            if (!field.getOptimizationInfo().valueHasBeenPropagated()) continue;
            return true;
        }
        for (DexEncodedMethod method : clazz.methods()) {
            if (!method.getOptimizationInfo().returnValueHasBeenPropagated()) continue;
            return true;
        }
        return false;
    }

    private boolean evaluateClassForIfRule(ProguardIfRule rule, DexProgramClass clazz) {
        if (!RootSetUtils.RootSetBuilder.satisfyClassType(rule, clazz)) {
            return false;
        }
        if (!RootSetUtils.RootSetBuilder.satisfyAccessFlag(rule, clazz)) {
            return false;
        }
        AnnotationMatchResult annotationMatchResult = RootSetUtils.RootSetBuilder.satisfyAnnotation(rule, clazz);
        if (annotationMatchResult == null) {
            return false;
        }
        this.rootSetBuilder.handleMatchedAnnotation(annotationMatchResult);
        if (!rule.getClassNames().matches(clazz.type)) {
            return false;
        }
        if (rule.hasInheritanceClassName()) {
            return this.rootSetBuilder.satisfyInheritanceRule(clazz, rule);
        }
        return true;
    }

    private boolean evaluateIfRuleMembersAndMaterialize(ProguardIfRule rule, DexClass sourceClass, DexClass targetClass) {
        List<ProguardMemberRule> memberKeepRules = rule.getMemberRules();
        if (memberKeepRules.isEmpty()) {
            this.materializeIfRule(rule, ImmutableSet.of(sourceClass.getReference()));
            return true;
        }
        ArrayList fieldsInlinedByJavaC = new ArrayList();
        Set filteredMembers = Sets.newIdentityHashSet();
        Iterables.addAll(filteredMembers, targetClass.fields(f -> {
            if (this.isFieldInlinedByJavaC((DexEncodedField)f)) {
                fieldsInlinedByJavaC.add(DexClassAndField.create(targetClass, f));
                return false;
            }
            return (this.enqueuer.isFieldLive((DexEncodedField)f) || this.enqueuer.isFieldReferenced((DexEncodedField)f) || f.getOptimizationInfo().valueHasBeenPropagated()) && this.appView.graphLens().getOriginalFieldSignature((DexField)((DexField)f.getReference())).holder == sourceClass.type;
        }));
        Iterables.addAll(filteredMembers, targetClass.methods(m3 -> (this.enqueuer.isMethodLive((DexEncodedMethod)m3) || this.enqueuer.isMethodTargeted((DexEncodedMethod)m3) || m3.getOptimizationInfo().returnValueHasBeenPropagated()) && this.appView.graphLens().getOriginalMethodSignature((DexMethod)((DexMethod)m3.getReference())).holder == sourceClass.type));
        if (!fieldsInlinedByJavaC.isEmpty()) {
            for (ProguardMemberRule proguardMemberRule : memberKeepRules) {
                if (!proguardMemberRule.getRuleType().includesFields()) continue;
                for (DexClassAndField field2 : fieldsInlinedByJavaC) {
                    if (!this.rootSetBuilder.sideEffectFreeIsRuleSatisfiedByField(proguardMemberRule, field2)) continue;
                    rule.addInlinableFieldMatchingPrecondition((DexField)field2.getReference());
                }
            }
        }
        if (filteredMembers.size() < memberKeepRules.size()) {
            return false;
        }
        for (Set set : Sets.combinations(filteredMembers, memberKeepRules.size())) {
            Collection fieldsInCombination = DexDefinition.filterDexEncodedField(set.stream(), field -> DexClassAndField.create(targetClass, field)).collect(Collectors.toList());
            Collection methodsInCombination = DexDefinition.filterDexEncodedMethod(set.stream(), method -> DexClassAndMethod.create(targetClass, method)).collect(Collectors.toList());
            boolean satisfied = memberKeepRules.stream().allMatch(memberRule -> this.rootSetBuilder.ruleSatisfiedByFields((ProguardMemberRule)memberRule, fieldsInCombination) || this.rootSetBuilder.ruleSatisfiedByMethods((ProguardMemberRule)memberRule, methodsInCombination));
            if (!satisfied) continue;
            this.materializeIfRule(rule, ImmutableSet.of(sourceClass.getReference()));
            if (!this.canRemoveSubsequentKeepRule(rule)) continue;
            return true;
        }
        return false;
    }

    private boolean isFieldInlinedByJavaC(DexEncodedField field) {
        if (this.enqueuer.getMode().isFinalTreeShaking()) {
            return field.getIsInlinableByJavaC();
        }
        return field.getOrComputeIsInlinableByJavaC(this.appView.dexItemFactory());
    }

    private void materializeIfRule(ProguardIfRule rule, Set<DexReference> preconditions) {
        DexItemFactory dexItemFactory = this.appView.dexItemFactory();
        ProguardIfRule materializedRule = rule.materialize(dexItemFactory, preconditions);
        if (this.enqueuer.getMode().isInitialTreeShaking() && !rule.isUsed()) {
            NoHorizontalClassMergingRule noHorizontalClassMergingRule;
            InlineRule neverInlineRuleForCondition;
            InlineRule neverInlineForClassInliningRuleForCondition;
            ClassInlineRule neverClassInlineRuleForCondition = materializedRule.neverClassInlineRuleForCondition(dexItemFactory);
            if (neverClassInlineRuleForCondition != null) {
                this.rootSetBuilder.runPerRule(this.executorService, this.futures, neverClassInlineRuleForCondition, null);
            }
            if ((neverInlineForClassInliningRuleForCondition = materializedRule.neverInlineRuleForCondition(dexItemFactory, InlineRule.Type.NEVER_CLASS_INLINE)) != null) {
                this.rootSetBuilder.runPerRule(this.executorService, this.futures, neverInlineForClassInliningRuleForCondition, null);
            }
            if ((neverInlineRuleForCondition = materializedRule.neverInlineRuleForCondition(dexItemFactory, InlineRule.Type.NEVER)) != null) {
                this.rootSetBuilder.runPerRule(this.executorService, this.futures, neverInlineRuleForCondition, null);
            }
            if ((noHorizontalClassMergingRule = materializedRule.noHorizontalClassMergingRuleForCondition(dexItemFactory)) != null) {
                this.rootSetBuilder.runPerRule(this.executorService, this.futures, noHorizontalClassMergingRule, null);
            }
        }
        this.rootSetBuilder.runPerRule(this.executorService, this.futures, materializedRule.subsequentRule, materializedRule);
        rule.markAsUsed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RootSetUtils.ConsequentRootSet run() throws ExecutionException {
        this.appView.appInfo().app().timing.begin("Find consequent items for -if rules...");
        try {
            if (this.ifRules != null && !this.ifRules.isEmpty()) {
                Iterator<Map.Entry<Equivalence.Wrapper<ProguardIfRule>, Set<ProguardIfRule>>> it = this.ifRules.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<Equivalence.Wrapper<ProguardIfRule>, Set<ProguardIfRule>> ifRuleEntry = it.next();
                    ProguardIfRule ifRuleKey = ifRuleEntry.getKey().get();
                    Set<ProguardIfRule> ifRulesInEquivalence = ifRuleEntry.getValue();
                    InternalOptions.TestingOptions.ProguardIfRuleEvaluationData ifRuleEvaluationData = this.appView.options().testing.proguardIfRuleEvaluationData;
                    ArrayList toRemove = new ArrayList();
                    for (DexProgramClass clazz : ifRuleKey.relevantCandidatesForRule(this.appView, this.subtypingInfo, this.appView.appInfo().classes())) {
                        if (!this.isEffectivelyLive(clazz)) continue;
                        if (this.appView.options().testing.measureProguardIfRuleEvaluations) {
                            ++ifRuleEvaluationData.numberOfProguardIfRuleClassEvaluations;
                        }
                        if (this.evaluateClassForIfRule(ifRuleKey, clazz)) {
                            ifRulesInEquivalence.forEach(ifRule -> {
                                boolean matched;
                                this.registerClassCapture((ProguardIfRule)ifRule, clazz, clazz);
                                if (this.appView.options().testing.measureProguardIfRuleEvaluations) {
                                    ++ifRuleEvaluationData.numberOfProguardIfRuleMemberEvaluations;
                                }
                                if ((matched = this.evaluateIfRuleMembersAndMaterialize((ProguardIfRule)ifRule, clazz, clazz)) && this.canRemoveSubsequentKeepRule((ProguardIfRule)ifRule)) {
                                    toRemove.add(ifRule);
                                }
                            });
                        }
                        if (this.appView.verticallyMergedClasses() == null) continue;
                        Collection<DexType> sources = this.appView.verticallyMergedClasses().getSourcesFor(clazz.type);
                        for (DexType sourceType : sources) {
                            DexProgramClass sourceClass = DexProgramClass.asProgramClassOrNull(this.appView.definitionFor(sourceType));
                            if (sourceClass == null) {
                                assert (false);
                                continue;
                            }
                            if (this.appView.options().testing.measureProguardIfRuleEvaluations) {
                                ++ifRuleEvaluationData.numberOfProguardIfRuleClassEvaluations;
                            }
                            if (!this.evaluateClassForIfRule(ifRuleKey, sourceClass)) continue;
                            ifRulesInEquivalence.forEach(ifRule -> {
                                this.registerClassCapture((ProguardIfRule)ifRule, sourceClass, clazz);
                                if (this.appView.options().testing.measureProguardIfRuleEvaluations) {
                                    ++ifRuleEvaluationData.numberOfProguardIfRuleMemberEvaluations;
                                }
                                if (this.evaluateIfRuleMembersAndMaterialize((ProguardIfRule)ifRule, sourceClass, clazz) && this.canRemoveSubsequentKeepRule((ProguardIfRule)ifRule)) {
                                    toRemove.add(ifRule);
                                }
                            });
                        }
                    }
                    if (ifRulesInEquivalence.size() == toRemove.size()) {
                        it.remove();
                        continue;
                    }
                    if (toRemove.isEmpty()) continue;
                    ifRulesInEquivalence.removeAll(toRemove);
                }
                ThreadUtils.awaitFutures(this.futures);
            }
        }
        finally {
            this.appView.appInfo().app().timing.end();
        }
        return this.rootSetBuilder.buildConsequentRootSet();
    }
}

