/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.ir.desugar.LambdaDescriptor;
import java.util.function.Consumer;

public abstract class InstantiatedObject {
    public static InstantiatedObject of(DexProgramClass clazz) {
        return new InstantiatedClass(clazz);
    }

    public static InstantiatedObject of(LambdaDescriptor lambda) {
        return new InstantiatedLambda(lambda);
    }

    public void apply(Consumer<DexProgramClass> classConsumer, Consumer<LambdaDescriptor> lambdaConsumer) {
        if (this.isClass()) {
            classConsumer.accept(this.asClass());
        } else {
            assert (this.isLambda());
            lambdaConsumer.accept(this.asLambda());
        }
    }

    public boolean isClass() {
        return false;
    }

    public DexProgramClass asClass() {
        return null;
    }

    public boolean isLambda() {
        return false;
    }

    public LambdaDescriptor asLambda() {
        return null;
    }

    private static class InstantiatedLambda
    extends InstantiatedObject {
        final LambdaDescriptor lambdaDescriptor;

        public InstantiatedLambda(LambdaDescriptor lambdaDescriptor) {
            this.lambdaDescriptor = lambdaDescriptor;
        }

        @Override
        public boolean isLambda() {
            return true;
        }

        @Override
        public LambdaDescriptor asLambda() {
            return this.lambdaDescriptor;
        }
    }

    private static class InstantiatedClass
    extends InstantiatedObject {
        final DexProgramClass clazz;

        InstantiatedClass(DexProgramClass clazz) {
            assert (!clazz.isInterface() || clazz.isAnnotation());
            this.clazz = clazz;
        }

        @Override
        public boolean isClass() {
            return true;
        }

        @Override
        public DexProgramClass asClass() {
            return this.clazz;
        }
    }
}

