/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramDefinition;
import com.android.tools.r8.shaking.GlobalKeepInfoConfiguration;
import com.android.tools.r8.shaking.KeepInfo;
import com.android.tools.r8.utils.InternalOptions;
import java.util.function.Function;

public final class KeepClassInfo
extends KeepInfo<Builder, KeepClassInfo> {
    private static final KeepClassInfo TOP = (KeepClassInfo)((Builder)new Builder().makeTop()).build();
    private static final KeepClassInfo BOTTOM = (KeepClassInfo)((Builder)new Builder().makeBottom()).build();

    public static KeepClassInfo top() {
        return TOP;
    }

    public static KeepClassInfo bottom() {
        return BOTTOM;
    }

    public static Joiner newEmptyJoiner() {
        return KeepClassInfo.bottom().joiner();
    }

    private KeepClassInfo(Builder builder) {
        super(builder);
    }

    public static boolean isKotlinMetadataClassKept(DexItemFactory factory, InternalOptions options, Function<DexType, DexClass> definitionForWithoutExistenceAssert, Function<DexProgramClass, KeepClassInfo> getClassInfo) {
        DexType kotlinMetadataType = factory.kotlinMetadataType;
        DexClass kotlinMetadataClass = definitionForWithoutExistenceAssert.apply(kotlinMetadataType);
        return kotlinMetadataClass == null || kotlinMetadataClass.isNotProgramClass() || !getClassInfo.apply(kotlinMetadataClass.asProgramClass()).isShrinkingAllowed(options);
    }

    @Override
    Builder builder() {
        return new Builder(this);
    }

    public Joiner joiner() {
        assert (!this.isTop());
        return new Joiner(this);
    }

    @Override
    public boolean isRepackagingAllowed(ProgramDefinition definition, GlobalKeepInfoConfiguration configuration) {
        return configuration.isRepackagingEnabled() && this.internalIsMinificationAllowed() && (definition.getAccessFlags().isPublic() || !this.internalIsAccessModificationRequiredForRepackaging());
    }

    public boolean isKotlinMetadataRemovalAllowed(GlobalKeepInfoConfiguration configuration, boolean kotlinMetadataKept) {
        return !kotlinMetadataKept || !this.isPinned(configuration) || !configuration.isKeepRuntimeVisibleAnnotationsEnabled() || this.isAnnotationRemovalAllowed(configuration);
    }

    @Override
    public boolean isTop() {
        return this.equals(KeepClassInfo.top());
    }

    @Override
    public boolean isBottom() {
        return this.equals(KeepClassInfo.bottom());
    }

    public static class Joiner
    extends KeepInfo.Joiner<Joiner, Builder, KeepClassInfo> {
        public Joiner(KeepClassInfo info) {
            super(info.builder());
        }

        @Override
        public Joiner asClassJoiner() {
            return this;
        }

        @Override
        public Joiner merge(Joiner joiner) {
            return super.merge(joiner);
        }

        @Override
        Joiner self() {
            return this;
        }
    }

    public static class Builder
    extends KeepInfo.Builder<Builder, KeepClassInfo> {
        private Builder() {
        }

        private Builder(KeepClassInfo original) {
            super(original);
        }

        @Override
        public KeepClassInfo getTopInfo() {
            return TOP;
        }

        @Override
        public KeepClassInfo getBottomInfo() {
            return BOTTOM;
        }

        @Override
        public Builder self() {
            return this;
        }

        @Override
        public boolean isEqualTo(KeepClassInfo other) {
            return this.internalIsEqualTo(other);
        }

        @Override
        public KeepClassInfo doBuild() {
            return new KeepClassInfo(this);
        }
    }
}

