/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.collect.Streams;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMember;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.ProgramDefinition;
import com.android.tools.r8.graph.ProgramField;
import com.android.tools.r8.graph.ProgramMember;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.PrunedItems;
import com.android.tools.r8.shaking.GlobalKeepInfoConfiguration;
import com.android.tools.r8.shaking.KeepClassInfo;
import com.android.tools.r8.shaking.KeepFieldInfo;
import com.android.tools.r8.shaking.KeepInfo;
import com.android.tools.r8.shaking.KeepMemberInfo;
import com.android.tools.r8.shaking.KeepMethodInfo;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.MapUtils;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class KeepInfoCollection {
    private static KeepClassInfo keepInfoForNonProgramClass() {
        return KeepClassInfo.bottom();
    }

    private static KeepMethodInfo keepInfoForNonProgramMethod() {
        return KeepMethodInfo.bottom();
    }

    private static KeepFieldInfo keepInfoForNonProgramField() {
        return KeepFieldInfo.bottom();
    }

    abstract void forEachRuleInstance(AppView<? extends AppInfoWithClassHierarchy> var1, BiConsumer<DexProgramClass, KeepClassInfo.Joiner> var2, BiConsumer<ProgramField, KeepFieldInfo.Joiner> var3, BiConsumer<ProgramMethod, KeepMethodInfo.Joiner> var4);

    public abstract KeepClassInfo getClassInfo(DexProgramClass var1);

    public abstract KeepMethodInfo getMethodInfo(DexEncodedMethod var1, DexProgramClass var2);

    public abstract KeepFieldInfo getFieldInfo(DexEncodedField var1, DexProgramClass var2);

    public KeepMemberInfo<?, ?> getMemberInfo(DexEncodedMember<?, ?> member, DexProgramClass holder) {
        if (member.isDexEncodedField()) {
            return this.getFieldInfo(member.asDexEncodedField(), holder);
        }
        assert (member.isDexEncodedMethod());
        return this.getMethodInfo(member.asDexEncodedMethod(), holder);
    }

    public final KeepClassInfo getClassInfo(DexType type, DexDefinitionSupplier definitions) {
        DexProgramClass clazz = DexProgramClass.asProgramClassOrNull(definitions.definitionFor(type));
        return clazz == null ? KeepInfoCollection.keepInfoForNonProgramClass() : this.getClassInfo(clazz);
    }

    public final KeepMemberInfo<?, ?> getMemberInfo(ProgramMember<?, ?> member) {
        return this.getMemberInfo((DexEncodedMember<?, ?>)member.getDefinition(), member.getHolder());
    }

    public final KeepMethodInfo getMethodInfo(ProgramMethod method) {
        return this.getMethodInfo((DexEncodedMethod)method.getDefinition(), method.getHolder());
    }

    public final KeepMethodInfo getMethodInfo(DexMethod method, DexDefinitionSupplier definitions) {
        DexProgramClass holder = DexProgramClass.asProgramClassOrNull(definitions.definitionFor(method.holder));
        if (holder == null) {
            return KeepInfoCollection.keepInfoForNonProgramMethod();
        }
        DexEncodedMethod definition = holder.lookupMethod(method);
        return definition == null ? KeepMethodInfo.bottom() : this.getMethodInfo(definition, holder);
    }

    public final KeepFieldInfo getFieldInfo(ProgramField field) {
        return this.getFieldInfo((DexEncodedField)field.getDefinition(), field.getHolder());
    }

    public final KeepFieldInfo getFieldInfo(DexField field, DexDefinitionSupplier definitions) {
        DexProgramClass holder = DexProgramClass.asProgramClassOrNull(definitions.definitionFor(field.holder));
        if (holder == null) {
            return KeepInfoCollection.keepInfoForNonProgramField();
        }
        DexEncodedField definition = holder.lookupField(field);
        return definition == null ? KeepFieldInfo.bottom() : this.getFieldInfo(definition, holder);
    }

    public final KeepInfo<?, ?> getInfo(DexReference reference, DexDefinitionSupplier definitions) {
        if (reference.isDexType()) {
            return this.getClassInfo(reference.asDexType(), definitions);
        }
        if (reference.isDexMethod()) {
            return this.getMethodInfo(reference.asDexMethod(), definitions);
        }
        if (reference.isDexField()) {
            return this.getFieldInfo(reference.asDexField(), definitions);
        }
        throw new Unreachable();
    }

    public final KeepInfo<?, ?> getInfo(ProgramDefinition definition) {
        if (definition.isProgramClass()) {
            return this.getClassInfo(definition.asProgramClass());
        }
        if (definition.isProgramMethod()) {
            return this.getMethodInfo(definition.asProgramMethod());
        }
        if (definition.isProgramField()) {
            return this.getFieldInfo(definition.asProgramField());
        }
        throw new Unreachable();
    }

    public final boolean isPinned(DexReference reference, DexDefinitionSupplier definitions, GlobalKeepInfoConfiguration configuration) {
        return this.getInfo(reference, definitions).isPinned(configuration);
    }

    public final boolean isPinned(DexType type, DexDefinitionSupplier definitions, GlobalKeepInfoConfiguration configuration) {
        return this.getClassInfo(type, definitions).isPinned(configuration);
    }

    public final boolean isPinned(DexMethod method, DexDefinitionSupplier definitions, GlobalKeepInfoConfiguration configuration) {
        return this.getMethodInfo(method, definitions).isPinned(configuration);
    }

    public final boolean isPinned(DexField field, DexDefinitionSupplier definitions, GlobalKeepInfoConfiguration configuration) {
        return this.getFieldInfo(field, definitions).isPinned(configuration);
    }

    public final boolean isMinificationAllowed(DexReference reference, DexDefinitionSupplier definitions, GlobalKeepInfoConfiguration configuration) {
        return configuration.isMinificationEnabled() && this.getInfo(reference, definitions).isMinificationAllowed(configuration);
    }

    public abstract boolean verifyPinnedTypesAreLive(Set<DexType> var1, InternalOptions var2);

    @Deprecated
    public abstract void forEachPinnedType(Consumer<DexType> var1, InternalOptions var2);

    @Deprecated
    public abstract void forEachPinnedMethod(Consumer<DexMethod> var1, InternalOptions var2);

    @Deprecated
    public abstract void forEachPinnedField(Consumer<DexField> var1, InternalOptions var2);

    public abstract KeepInfoCollection rewrite(DexDefinitionSupplier var1, GraphLens.NonIdentityGraphLens var2, InternalOptions var3);

    public abstract KeepInfoCollection mutate(Consumer<MutableKeepInfoCollection> var1);

    public static class MutableKeepInfoCollection
    extends KeepInfoCollection {
        private final Map<DexType, KeepClassInfo> keepClassInfo;
        private final Map<DexMethod, KeepMethodInfo> keepMethodInfo;
        private final Map<DexField, KeepFieldInfo> keepFieldInfo;
        private final Map<DexType, KeepClassInfo.Joiner> classRuleInstances;
        private final Map<DexField, KeepFieldInfo.Joiner> fieldRuleInstances;
        private final Map<DexMethod, KeepMethodInfo.Joiner> methodRuleInstances;

        MutableKeepInfoCollection() {
            this(new IdentityHashMap<DexType, KeepClassInfo>(), new IdentityHashMap<DexMethod, KeepMethodInfo>(), new IdentityHashMap<DexField, KeepFieldInfo>(), new IdentityHashMap<DexType, KeepClassInfo.Joiner>(), new IdentityHashMap<DexField, KeepFieldInfo.Joiner>(), new IdentityHashMap<DexMethod, KeepMethodInfo.Joiner>());
        }

        private MutableKeepInfoCollection(Map<DexType, KeepClassInfo> keepClassInfo, Map<DexMethod, KeepMethodInfo> keepMethodInfo, Map<DexField, KeepFieldInfo> keepFieldInfo, Map<DexType, KeepClassInfo.Joiner> classRuleInstances, Map<DexField, KeepFieldInfo.Joiner> fieldRuleInstances, Map<DexMethod, KeepMethodInfo.Joiner> methodRuleInstances) {
            this.keepClassInfo = keepClassInfo;
            this.keepMethodInfo = keepMethodInfo;
            this.keepFieldInfo = keepFieldInfo;
            this.classRuleInstances = classRuleInstances;
            this.fieldRuleInstances = fieldRuleInstances;
            this.methodRuleInstances = methodRuleInstances;
        }

        private static <R, J extends KeepInfo.Joiner<J, ?, ?>> Map<R, J> rewriteRuleInstances(Map<R, J> ruleInstances, Function<R, R> rewriter, Supplier<J> newEmptyJoiner) {
            return MapUtils.transform(ruleInstances, IdentityHashMap::new, rewriter, Function.identity(), (reference, joiner, otherJoiner) -> ((KeepInfo.Joiner)newEmptyJoiner.get()).merge(joiner).merge(otherJoiner));
        }

        public void removeKeepInfoForMergedClasses(PrunedItems prunedItems) {
            if (prunedItems.hasRemovedClasses()) {
                this.keepClassInfo.keySet().removeAll(prunedItems.getRemovedClasses());
            }
            if (prunedItems.hasRemovedFields()) {
                this.keepFieldInfo.keySet().removeAll(prunedItems.getRemovedFields());
            }
            if (prunedItems.hasRemovedMembers()) {
                this.keepMethodInfo.keySet().removeAll(prunedItems.getRemovedMethods());
            }
        }

        public void removeKeepInfoForPrunedItems(PrunedItems prunedItems) {
            block10: {
                block9: {
                    block8: {
                        block7: {
                            if (prunedItems.hasRemovedClasses()) {
                                this.keepClassInfo.keySet().removeAll(prunedItems.getRemovedClasses());
                            }
                            if (prunedItems.hasRemovedClasses()) break block7;
                            if (!prunedItems.hasRemovedFields()) break block8;
                        }
                        this.keepFieldInfo.keySet().removeIf(prunedItems::isRemoved);
                    }
                    if (prunedItems.hasRemovedClasses()) break block9;
                    if (!prunedItems.hasRemovedMembers()) break block10;
                }
                this.keepMethodInfo.keySet().removeIf(prunedItems::isRemoved);
            }
        }

        @Override
        public KeepInfoCollection rewrite(DexDefinitionSupplier definitions, GraphLens.NonIdentityGraphLens lens, InternalOptions options) {
            IdentityHashMap<DexType, KeepClassInfo> newClassInfo = new IdentityHashMap<DexType, KeepClassInfo>(this.keepClassInfo.size());
            this.keepClassInfo.forEach((type, info) -> {
                DexType newType = lens.lookupType((DexType)type);
                assert (newType == type || !info.isPinned(options) || info.isMinificationAllowed(options) || info.isRepackagingAllowed(definitions.definitionFor(newType).asProgramClass(), options));
                KeepClassInfo previous = newClassInfo.put(newType, (KeepClassInfo)info);
                assert (previous == null);
            });
            IdentityHashMap<DexMethod, KeepMethodInfo> newMethodInfo = new IdentityHashMap<DexMethod, KeepMethodInfo>(this.keepMethodInfo.size());
            this.keepMethodInfo.forEach((method, info) -> {
                DexMethod newMethod = lens.getRenamedMethodSignature((DexMethod)method);
                assert (!info.isPinned(options) || info.isMinificationAllowed(options) || newMethod.name == method.name);
                assert (!info.isPinned(options) || newMethod.getArity() == method.getArity());
                if (!$assertionsDisabled && info.isPinned(options)) {
                    if (!Streams.zip(newMethod.getParameters().stream(), method.getParameters().stream().map(lens::lookupType), Object::equals).allMatch(x -> x)) {
                        throw new AssertionError();
                    }
                }
                assert (!info.isPinned(options) || newMethod.getReturnType() == lens.lookupType(method.getReturnType()));
                KeepMethodInfo previous = newMethodInfo.put(newMethod, (KeepMethodInfo)info);
            });
            IdentityHashMap<DexField, KeepFieldInfo> newFieldInfo = new IdentityHashMap<DexField, KeepFieldInfo>(this.keepFieldInfo.size());
            this.keepFieldInfo.forEach((field, info) -> {
                DexField newField = lens.getRenamedFieldSignature((DexField)field);
                assert (newField.name == field.name || !info.isPinned(options) || info.isMinificationAllowed(options));
                KeepFieldInfo previous = newFieldInfo.put(newField, (KeepFieldInfo)info);
                assert (previous == null);
            });
            return new MutableKeepInfoCollection(newClassInfo, newMethodInfo, newFieldInfo, MutableKeepInfoCollection.rewriteRuleInstances(this.classRuleInstances, clazz -> {
                DexType rewritten = lens.lookupType((DexType)clazz);
                if (rewritten.isClassType()) {
                    return rewritten;
                }
                assert (rewritten.isIntType());
                return null;
            }, KeepClassInfo::newEmptyJoiner), MutableKeepInfoCollection.rewriteRuleInstances(this.fieldRuleInstances, lens::getRenamedFieldSignature, KeepFieldInfo::newEmptyJoiner), MutableKeepInfoCollection.rewriteRuleInstances(this.methodRuleInstances, lens::getRenamedMethodSignature, KeepMethodInfo::newEmptyJoiner));
        }

        @Override
        void forEachRuleInstance(AppView<? extends AppInfoWithClassHierarchy> appView, BiConsumer<DexProgramClass, KeepClassInfo.Joiner> classRuleInstanceConsumer, BiConsumer<ProgramField, KeepFieldInfo.Joiner> fieldRuleInstanceConsumer, BiConsumer<ProgramMethod, KeepMethodInfo.Joiner> methodRuleInstanceConsumer) {
            this.classRuleInstances.forEach((type, ruleInstance) -> {
                DexProgramClass clazz = DexProgramClass.asProgramClassOrNull(appView.definitionFor((DexType)type));
                if (clazz != null) {
                    classRuleInstanceConsumer.accept(clazz, (KeepClassInfo.Joiner)ruleInstance);
                }
            });
            this.fieldRuleInstances.forEach((fieldReference, ruleInstance) -> {
                DexProgramClass holder = DexProgramClass.asProgramClassOrNull(appView.definitionFor(fieldReference.getHolderType()));
                ProgramField field = holder.lookupProgramField((DexField)fieldReference);
                if (field != null) {
                    fieldRuleInstanceConsumer.accept(field, (KeepFieldInfo.Joiner)ruleInstance);
                }
            });
            this.methodRuleInstances.forEach((methodReference, ruleInstance) -> {
                DexProgramClass holder = DexProgramClass.asProgramClassOrNull(appView.definitionFor(methodReference.getHolderType()));
                ProgramMethod method = holder.lookupProgramMethod((DexMethod)methodReference);
                if (method != null) {
                    methodRuleInstanceConsumer.accept(method, (KeepMethodInfo.Joiner)ruleInstance);
                }
            });
        }

        void evaluateClassRule(DexProgramClass clazz, KeepClassInfo.Joiner minimumKeepInfo) {
            if (!minimumKeepInfo.isBottom()) {
                this.joinClass(clazz, joiner -> joiner.merge(minimumKeepInfo));
                this.classRuleInstances.computeIfAbsent(clazz.getType(), MapUtils.ignoreKey(KeepClassInfo::newEmptyJoiner)).merge(minimumKeepInfo);
            }
        }

        void evaluateFieldRule(ProgramField field, KeepFieldInfo.Joiner minimumKeepInfo) {
            if (!minimumKeepInfo.isBottom()) {
                this.joinField(field, joiner -> joiner.merge(minimumKeepInfo));
                this.fieldRuleInstances.computeIfAbsent((DexField)field.getReference(), MapUtils.ignoreKey(KeepFieldInfo::newEmptyJoiner)).merge(minimumKeepInfo);
            }
        }

        void evaluateMethodRule(ProgramMethod method, KeepMethodInfo.Joiner minimumKeepInfo) {
            if (!minimumKeepInfo.isBottom()) {
                this.joinMethod(method, joiner -> joiner.merge(minimumKeepInfo));
                this.methodRuleInstances.computeIfAbsent((DexMethod)method.getReference(), MapUtils.ignoreKey(KeepMethodInfo::newEmptyJoiner)).merge(minimumKeepInfo);
            }
        }

        @Override
        public KeepClassInfo getClassInfo(DexProgramClass clazz) {
            return this.keepClassInfo.getOrDefault(clazz.type, KeepClassInfo.bottom());
        }

        @Override
        public KeepMethodInfo getMethodInfo(DexEncodedMethod method, DexProgramClass holder) {
            assert (method.getHolderType() == holder.type);
            return this.keepMethodInfo.getOrDefault(method.getReference(), KeepMethodInfo.bottom());
        }

        @Override
        public KeepFieldInfo getFieldInfo(DexEncodedField field, DexProgramClass holder) {
            assert (field.getHolderType() == holder.type);
            return this.keepFieldInfo.getOrDefault(field.getReference(), KeepFieldInfo.bottom());
        }

        public void joinClass(DexProgramClass clazz, Consumer<? super KeepClassInfo.Joiner> fn) {
            KeepClassInfo info = this.getClassInfo(clazz);
            if (info.isTop()) {
                assert (info == KeepClassInfo.top());
                return;
            }
            KeepClassInfo.Joiner joiner = info.joiner();
            fn.accept(joiner);
            KeepClassInfo joined = (KeepClassInfo)joiner.join();
            if (!info.equals(joined)) {
                this.keepClassInfo.put(clazz.type, joined);
            }
        }

        public void keepClass(DexProgramClass clazz) {
            this.joinClass(clazz, KeepInfo.Joiner::top);
        }

        public void joinMethod(ProgramMethod method, Consumer<? super KeepMethodInfo.Joiner> fn) {
            KeepMethodInfo info = this.getMethodInfo(method);
            if (info.isTop()) {
                assert (info == KeepMethodInfo.top());
                return;
            }
            KeepMethodInfo.Joiner joiner = info.joiner();
            fn.accept(joiner);
            KeepMethodInfo joined = (KeepMethodInfo)joiner.join();
            if (!info.equals(joined)) {
                this.keepMethodInfo.put((DexMethod)method.getReference(), joined);
            }
        }

        public void keepMethod(ProgramMethod method) {
            this.joinMethod(method, KeepInfo.Joiner::top);
        }

        public void unsetRequireAllowAccessModificationForRepackaging(ProgramDefinition definition) {
            if (definition.isProgramClass()) {
                DexProgramClass clazz = definition.asProgramClass();
                KeepClassInfo info = this.getClassInfo(clazz);
                this.keepClassInfo.put(clazz.getType(), (KeepClassInfo)((KeepClassInfo.Builder)info.builder().unsetRequireAccessModificationForRepackaging()).build());
            } else if (definition.isProgramMethod()) {
                ProgramMethod method = definition.asProgramMethod();
                KeepMethodInfo info = this.getMethodInfo(method);
                this.keepMethodInfo.put((DexMethod)method.getReference(), (KeepMethodInfo)((KeepMethodInfo.Builder)info.builder().unsetRequireAccessModificationForRepackaging()).build());
            } else if (definition.isProgramField()) {
                ProgramField field = definition.asProgramField();
                KeepFieldInfo info = this.getFieldInfo(field);
                this.keepFieldInfo.put((DexField)field.getReference(), (KeepFieldInfo)((KeepFieldInfo.Builder)info.builder().unsetRequireAccessModificationForRepackaging()).build());
            } else {
                throw new Unreachable();
            }
        }

        public void joinField(ProgramField field, Consumer<? super KeepFieldInfo.Joiner> fn) {
            KeepFieldInfo info = this.getFieldInfo(field);
            if (info.isTop()) {
                assert (info == KeepFieldInfo.top());
                return;
            }
            KeepFieldInfo.Joiner joiner = info.joiner();
            fn.accept(joiner);
            KeepFieldInfo joined = (KeepFieldInfo)joiner.join();
            if (!info.equals(joined)) {
                this.keepFieldInfo.put((DexField)field.getReference(), joined);
            }
        }

        public void keepField(ProgramField field) {
            this.joinField(field, KeepInfo.Joiner::top);
        }

        @Override
        public KeepInfoCollection mutate(Consumer<MutableKeepInfoCollection> mutator) {
            mutator.accept(this);
            return this;
        }

        @Override
        public boolean verifyPinnedTypesAreLive(Set<DexType> liveTypes, InternalOptions options) {
            this.keepClassInfo.forEach((type, info) -> {
                assert (!info.isPinned(options) || liveTypes.contains(type));
            });
            return true;
        }

        @Override
        public void forEachPinnedType(Consumer<DexType> consumer, InternalOptions options) {
            this.keepClassInfo.forEach((type, info) -> {
                if (info.isPinned(options)) {
                    consumer.accept((DexType)type);
                }
            });
        }

        @Override
        public void forEachPinnedMethod(Consumer<DexMethod> consumer, InternalOptions options) {
            this.keepMethodInfo.forEach((method, info) -> {
                if (info.isPinned(options)) {
                    consumer.accept((DexMethod)method);
                }
            });
        }

        @Override
        public void forEachPinnedField(Consumer<DexField> consumer, InternalOptions options) {
            this.keepFieldInfo.forEach((field, info) -> {
                if (info.isPinned(options)) {
                    consumer.accept((DexField)field);
                }
            });
        }
    }
}

