/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.desugar.TypeRewriter;
import com.android.tools.r8.shaking.TreePruner;
import com.android.tools.r8.utils.InternalOptions;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;

public class L8TreePruner {
    private final InternalOptions options;
    private final Set<DexType> emulatedInterfaces = Sets.newIdentityHashSet();
    private final Set<DexType> backports = Sets.newIdentityHashSet();
    private final List<DexType> pruned = new ArrayList<DexType>();

    public L8TreePruner(InternalOptions options) {
        this.options = options;
        this.backports.addAll(options.machineDesugaredLibrarySpecification.getLegacyBackport().keySet());
        this.emulatedInterfaces.addAll(options.machineDesugaredLibrarySpecification.getEmulatedInterfaces().keySet());
    }

    public DexApplication prune(DexApplication app, TypeRewriter typeRewriter) {
        IdentityHashMap<DexType, DexProgramClass> typeMap = new IdentityHashMap<DexType, DexProgramClass>();
        ArrayList<DexProgramClass> toKeep = new ArrayList<DexProgramClass>();
        boolean pruneNestMember = false;
        for (DexProgramClass aClass : app.classes()) {
            typeMap.put(aClass.type, aClass);
            if (typeRewriter.hasRewrittenType(aClass.type, null) || this.emulatedInterfaces.contains(aClass.type)) {
                toKeep.add(aClass);
                continue;
            }
            pruneNestMember |= aClass.isInANest();
            this.pruned.add(aClass.type);
        }
        if (pruneNestMember) {
            for (DexProgramClass keptClass : toKeep) {
                TreePruner.rewriteNestAttributes(keptClass, type -> !this.pruned.contains(type), typeMap::get);
            }
        }
        typeMap.clear();
        return ((DexApplication.Builder)app.builder().replaceProgramClasses(toKeep)).build();
    }
}

