/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.utils.Box;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class MainDexDirectReferenceTracer {
    private final AnnotationDirectReferenceCollector annotationDirectReferenceCollector = new AnnotationDirectReferenceCollector();
    private final AppView<? extends AppInfoWithClassHierarchy> appView;
    private final Consumer<DexType> consumer;

    public MainDexDirectReferenceTracer(AppView<? extends AppInfoWithClassHierarchy> appView, Consumer<DexType> consumer) {
        this.appView = appView;
        this.consumer = consumer;
    }

    public static boolean hasReferencesOutsideMainDexClasses(AppView<? extends AppInfoWithClassHierarchy> appView, ProgramMethod method, Predicate<DexType> isOutside) {
        return MainDexDirectReferenceTracer.getFirstReferenceOutsideFromCode(appView, method, isOutside) != null;
    }

    public static DexProgramClass getFirstReferenceOutsideFromCode(AppView<? extends AppInfoWithClassHierarchy> appView, ProgramMethod method, Predicate<DexType> isOutside) {
        Box result = new Box();
        new MainDexDirectReferenceTracer(appView, type -> {
            DexClass cls;
            DexType baseType = type.toBaseType(appView.dexItemFactory());
            if (baseType.isClassType() && isOutside.test(baseType) && (cls = appView.definitionFor(baseType)) != null && cls.isProgramClass()) {
                result.set(cls.asProgramClass());
            }
        }).runOnCode(method);
        return (DexProgramClass)result.get();
    }

    private void traceAnnotationsDirectDependencies(DexAnnotationSet annotations) {
        annotations.collectIndexedItems(this.annotationDirectReferenceCollector);
    }

    private void traceMethodDirectDependencies(DexMethod method, Consumer<DexType> consumer) {
        DexProto proto = method.proto;
        consumer.accept(proto.returnType);
        for (DexType parameterType : proto.parameters.values) {
            consumer.accept(parameterType);
        }
    }

    public void run(Set<DexType> roots) {
        for (DexType type : roots) {
            DexProgramClass clazz = DexProgramClass.asProgramClassOrNull(this.appView.definitionFor(type));
            assert (clazz != null);
            this.consumer.accept(type);
            if (!DexAnnotation.hasSynthesizedClassAnnotation(clazz.annotations(), this.appView.dexItemFactory(), this.appView.getSyntheticItems())) {
                this.traceAnnotationsDirectDependencies(clazz.annotations());
            }
            clazz.forEachField(field -> this.consumer.accept(((DexField)field.getReference()).type));
            clazz.forEachProgramMethodMatching(definition -> {
                this.traceMethodDirectDependencies((DexMethod)definition.getReference(), this.consumer);
                return definition.hasCode();
            }, this::runOnCode);
        }
    }

    public void runOnCode(ProgramMethod method) {
        method.registerCodeReferences(new DirectReferencesCollector(method));
    }

    private class AnnotationDirectReferenceCollector
    implements IndexedItemCollection {
        private AnnotationDirectReferenceCollector() {
        }

        @Override
        public boolean addClass(DexProgramClass dexProgramClass) {
            MainDexDirectReferenceTracer.this.consumer.accept(dexProgramClass.type);
            return false;
        }

        @Override
        public boolean addField(DexField field) {
            MainDexDirectReferenceTracer.this.consumer.accept(field.holder);
            MainDexDirectReferenceTracer.this.consumer.accept(field.type);
            return false;
        }

        @Override
        public boolean addMethod(DexMethod method) {
            MainDexDirectReferenceTracer.this.consumer.accept(method.holder);
            this.addProto(method.proto);
            return false;
        }

        @Override
        public boolean addString(DexString string) {
            return false;
        }

        @Override
        public boolean addProto(DexProto proto) {
            MainDexDirectReferenceTracer.this.consumer.accept(proto.returnType);
            for (DexType parameterType : proto.parameters.values) {
                MainDexDirectReferenceTracer.this.consumer.accept(parameterType);
            }
            return false;
        }

        @Override
        public boolean addType(DexType type) {
            MainDexDirectReferenceTracer.this.consumer.accept(type);
            return false;
        }

        @Override
        public boolean addCallSite(DexCallSite callSite) {
            throw new AssertionError((Object)"CallSite are not supported when tracing for legacy multi dex");
        }

        @Override
        public boolean addMethodHandle(DexMethodHandle methodHandle) {
            throw new AssertionError((Object)"DexMethodHandle are not supported when tracing for legacy multi dex");
        }
    }

    private class DirectReferencesCollector
    extends UseRegistry<ProgramMethod> {
        private DirectReferencesCollector(ProgramMethod context) {
            super(MainDexDirectReferenceTracer.this.appView, context);
        }

        @Override
        public void registerInitClass(DexType clazz) {
            MainDexDirectReferenceTracer.this.consumer.accept(clazz);
        }

        @Override
        public void registerInvokeVirtual(DexMethod method) {
            this.registerInvoke(method);
        }

        @Override
        public void registerInvokeDirect(DexMethod method) {
            this.registerInvoke(method);
        }

        @Override
        public void registerInvokeStatic(DexMethod method) {
            this.registerInvoke(method);
        }

        @Override
        public void registerInvokeInterface(DexMethod method) {
            this.registerInvoke(method);
        }

        @Override
        public void registerInvokeSuper(DexMethod method) {
            this.registerInvoke(method);
        }

        protected void registerInvoke(DexMethod method) {
            MainDexDirectReferenceTracer.this.consumer.accept(method.holder);
            MainDexDirectReferenceTracer.this.traceMethodDirectDependencies(method, MainDexDirectReferenceTracer.this.consumer);
        }

        @Override
        public void registerInstanceFieldWrite(DexField field) {
            this.registerFieldAccess(field);
        }

        @Override
        public void registerInstanceFieldRead(DexField field) {
            this.registerFieldAccess(field);
        }

        @Override
        public void registerStaticFieldRead(DexField field) {
            this.registerFieldAccess(field);
        }

        @Override
        public void registerStaticFieldWrite(DexField field) {
            this.registerFieldAccess(field);
        }

        protected void registerFieldAccess(DexField field) {
            MainDexDirectReferenceTracer.this.consumer.accept(field.holder);
            MainDexDirectReferenceTracer.this.consumer.accept(field.type);
        }

        @Override
        public void registerNewInstance(DexType type) {
            MainDexDirectReferenceTracer.this.consumer.accept(type);
        }

        @Override
        public void registerTypeReference(DexType type) {
            MainDexDirectReferenceTracer.this.consumer.accept(type);
        }

        @Override
        public void registerInstanceOf(DexType type) {
            MainDexDirectReferenceTracer.this.consumer.accept(type);
        }
    }
}

