/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.ProgramDefinition;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.PrunedItems;
import com.android.tools.r8.shaking.MainDexDirectReferenceTracer;
import com.android.tools.r8.synthesis.SyntheticItems;
import com.android.tools.r8.utils.ConsumerUtils;
import com.android.tools.r8.utils.LensUtils;
import java.util.Collections;
import java.util.Set;
import java.util.function.Consumer;

public class MainDexInfo {
    private static final MainDexInfo NONE = new MainDexInfo(Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), false);
    private final Set<DexType> classList;
    private final Set<DexType> tracedRoots;
    private Set<DexMethod> tracedMethodRoots;
    private final Set<DexType> tracedDependencies;
    private boolean tracedMethodRootsCleared = false;

    private MainDexInfo(Set<DexType> classList) {
        this(classList, Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), false);
    }

    private MainDexInfo(Set<DexType> classList, Set<DexType> tracedRoots, Set<DexMethod> tracedMethodRoots, Set<DexType> tracedDependencies, boolean tracedMethodRootsCleared) {
        this.classList = classList;
        this.tracedRoots = tracedRoots;
        this.tracedMethodRoots = tracedMethodRoots;
        this.tracedDependencies = tracedDependencies;
        this.tracedMethodRootsCleared = tracedMethodRootsCleared;
        assert (tracedDependencies.stream().noneMatch(tracedRoots::contains));
    }

    private boolean isFromList(DexReference reference, SyntheticItems synthetics) {
        return this.isContainedOrHasContainedContext(reference, this.classList, synthetics);
    }

    private boolean isTracedRoot(DexReference reference, SyntheticItems synthetics) {
        return this.isContainedOrHasContainedContext(reference, this.tracedRoots, synthetics);
    }

    private boolean isContainedOrHasContainedContext(DexReference reference, Set<DexType> items, SyntheticItems synthetics) {
        if (items.isEmpty()) {
            return false;
        }
        DexType type = reference.getContextType();
        for (DexType context : synthetics.getSynthesizingContextTypes(type)) {
            if (!items.contains(context)) continue;
            return true;
        }
        return items.contains(type);
    }

    private boolean isDependency(ProgramDefinition definition) {
        return this.isDependency(definition.getContextType());
    }

    private boolean isDependency(DexReference reference) {
        return this.tracedDependencies.contains(reference.getContextType());
    }

    private boolean canMerge(DexReference source, DexReference target, SyntheticItems synthetics) {
        MainDexGroup targetGroup;
        MainDexGroup sourceGroup = this.getMainDexGroupInternal(source, synthetics);
        if (sourceGroup != (targetGroup = this.getMainDexGroupInternal(target, synthetics))) {
            return false;
        }
        return sourceGroup != MainDexGroup.MAIN_DEX_LIST;
    }

    private MainDexGroup getMainDexGroupInternal(ProgramDefinition definition, SyntheticItems synthetics) {
        return this.getMainDexGroupInternal(definition.getReference(), synthetics);
    }

    private MainDexGroup getMainDexGroupInternal(DexReference reference, SyntheticItems synthetics) {
        if (this.isFromList(reference, synthetics)) {
            return MainDexGroup.MAIN_DEX_LIST;
        }
        if (this.isTracedRoot(reference, synthetics)) {
            return MainDexGroup.MAIN_DEX_ROOT;
        }
        if (this.isDependency(reference)) {
            return MainDexGroup.MAIN_DEX_DEPENDENCY;
        }
        return MainDexGroup.NOT_IN_MAIN_DEX;
    }

    public static MainDexInfo none() {
        return NONE;
    }

    private void ifNotRemoved(DexType type, Set<DexType> removedClasses, Consumer<DexType> notRemoved) {
        if (!removedClasses.contains(type)) {
            notRemoved.accept(type);
        }
    }

    public boolean isSyntheticContextOnMainDexList(DexType syntheticContextType) {
        return this.classList.contains(syntheticContextType);
    }

    public boolean isNone() {
        assert (MainDexInfo.none() == NONE);
        return this == NONE;
    }

    public boolean isFromList(ProgramDefinition definition, SyntheticItems synthetics) {
        return this.isFromList(definition.getContextType(), synthetics);
    }

    public boolean isTracedRoot(ProgramDefinition definition, SyntheticItems synthetics) {
        return this.isTracedRoot(definition.getContextType(), synthetics);
    }

    public boolean isTracedMethodRoot(DexMethod method) {
        assert (!this.tracedMethodRootsCleared) : "Traced method roots are cleared after mergers has run";
        return this.tracedMethodRoots.contains(method);
    }

    public boolean isTracedMethodRootsCleared() {
        return this.tracedMethodRootsCleared;
    }

    public void clearTracedMethodRoots() {
        this.tracedMethodRootsCleared = true;
        this.tracedMethodRoots = Sets.newIdentityHashSet();
    }

    public boolean canRebindReference(ProgramMethod context, DexReference referenceToTarget, SyntheticItems synthetics) {
        MainDexGroup holderGroup = this.getMainDexGroupInternal(context, synthetics);
        if (holderGroup == MainDexGroup.NOT_IN_MAIN_DEX || holderGroup == MainDexGroup.MAIN_DEX_DEPENDENCY) {
            return true;
        }
        if (holderGroup == MainDexGroup.MAIN_DEX_LIST) {
            return false;
        }
        assert (holderGroup == MainDexGroup.MAIN_DEX_ROOT);
        return this.getMainDexGroupInternal(referenceToTarget, synthetics) == MainDexGroup.MAIN_DEX_ROOT;
    }

    public boolean canMerge(ProgramDefinition candidate, SyntheticItems synthetics) {
        return !this.isFromList(candidate, synthetics);
    }

    public boolean canMerge(ProgramDefinition source, ProgramDefinition target, SyntheticItems synthetics) {
        return this.canMerge(source.getContextType(), target.getContextType(), synthetics);
    }

    public MainDexGroup getMergeKey(ProgramDefinition mergeCandidate, SyntheticItems synthetics) {
        assert (this.canMerge(mergeCandidate, synthetics));
        MainDexGroup mainDexGroupInternal = this.getMainDexGroupInternal(mergeCandidate, synthetics);
        return mainDexGroupInternal == MainDexGroup.MAIN_DEX_LIST ? null : mainDexGroupInternal;
    }

    public boolean disallowInliningIntoContext(AppView<? extends AppInfoWithClassHierarchy> appView, ProgramDefinition context, ProgramMethod method, SyntheticItems synthetics) {
        if (context.getContextType() == method.getContextType()) {
            return false;
        }
        MainDexGroup mainDexGroupInternal = this.getMainDexGroupInternal(context, synthetics);
        if (mainDexGroupInternal == MainDexGroup.NOT_IN_MAIN_DEX || mainDexGroupInternal == MainDexGroup.MAIN_DEX_DEPENDENCY) {
            return false;
        }
        if (mainDexGroupInternal == MainDexGroup.MAIN_DEX_LIST) {
            return MainDexDirectReferenceTracer.hasReferencesOutsideMainDexClasses(appView, method, t -> !this.isFromList((DexReference)t, synthetics));
        }
        assert (mainDexGroupInternal == MainDexGroup.MAIN_DEX_ROOT);
        return MainDexDirectReferenceTracer.hasReferencesOutsideMainDexClasses(appView, method, t -> !this.isTracedRoot((DexReference)t, synthetics));
    }

    public boolean isEmpty() {
        assert (!this.tracedRoots.isEmpty() || this.tracedDependencies.isEmpty());
        return this.tracedRoots.isEmpty() && this.classList.isEmpty();
    }

    public int size() {
        return this.classList.size() + this.tracedRoots.size() + this.tracedDependencies.size();
    }

    public void forEachExcludingDependencies(Consumer<DexType> fn) {
        Set seen = Sets.newIdentityHashSet();
        this.classList.forEach(ConsumerUtils.acceptIfNotSeen(fn, seen));
        this.tracedRoots.forEach(ConsumerUtils.acceptIfNotSeen(fn, seen));
    }

    public void forEach(Consumer<DexType> fn) {
        Set seen = Sets.newIdentityHashSet();
        this.classList.forEach(ConsumerUtils.acceptIfNotSeen(fn, seen));
        this.tracedRoots.forEach(ConsumerUtils.acceptIfNotSeen(fn, seen));
        this.tracedDependencies.forEach(ConsumerUtils.acceptIfNotSeen(fn, seen));
    }

    public MainDexInfo withoutPrunedItems(PrunedItems prunedItems) {
        if (prunedItems.isEmpty()) {
            return this;
        }
        Set<DexType> removedClasses = prunedItems.getRemovedClasses();
        Set<DexType> modifiedClassList = Sets.newIdentityHashSet();
        this.classList.forEach((? super T type) -> this.ifNotRemoved((DexType)type, removedClasses, modifiedClassList::add));
        Builder builder = this.builder();
        this.tracedRoots.forEach((? super T type) -> this.ifNotRemoved((DexType)type, removedClasses, builder::addRoot));
        this.tracedMethodRoots.forEach((? super T method) -> this.ifNotRemoved(method.getHolderType(), removedClasses, ignored -> builder.addRoot((DexMethod)method)));
        this.tracedDependencies.forEach((? super T type) -> this.ifNotRemoved((DexType)type, removedClasses, builder::addDependency));
        return builder.build(modifiedClassList);
    }

    public MainDexInfo rewrittenWithLens(SyntheticItems syntheticItems, GraphLens lens) {
        Set<DexType> modifiedClassList = Sets.newIdentityHashSet();
        this.classList.forEach((? super T type) -> LensUtils.rewriteAndApplyIfNotPrimitiveType(lens, type, modifiedClassList::add));
        Builder builder = this.builder();
        this.tracedRoots.forEach((? super T type) -> LensUtils.rewriteAndApplyIfNotPrimitiveType(lens, type, builder::addRoot));
        this.tracedMethodRoots.forEach((? super T method) -> builder.addRoot(lens.getRenamedMethodSignature((DexMethod)method)));
        this.tracedDependencies.forEach((? super T type) -> {
            if (lens.isSyntheticFinalizationGraphLens()) {
                LensUtils.rewriteAndApplyIfNotPrimitiveType(lens, type, builder::addDependencyIfNotRoot);
            } else if (syntheticItems.isFinalized()) {
                LensUtils.rewriteAndApplyIfNotPrimitiveType(lens, type, builder.addDependencyAllowSyntheticRoot(syntheticItems));
            } else {
                LensUtils.rewriteAndApplyIfNotPrimitiveType(lens, type, builder::addDependency);
            }
        });
        return builder.build(modifiedClassList);
    }

    public Builder builder() {
        return new Builder(this.tracedMethodRootsCleared);
    }

    public Builder builderFromCopy() {
        Builder builder = new Builder(this.tracedMethodRootsCleared);
        builder.list.addAll(this.classList);
        builder.roots.addAll(this.tracedRoots);
        builder.methodRoots.addAll(this.tracedMethodRoots);
        builder.dependencies.addAll(this.tracedDependencies);
        return builder;
    }

    public static class Builder {
        private final Set<DexType> list = Sets.newIdentityHashSet();
        private final Set<DexType> roots = Sets.newIdentityHashSet();
        private final Set<DexMethod> methodRoots = Sets.newIdentityHashSet();
        private final Set<DexType> dependencies = Sets.newIdentityHashSet();
        private final boolean tracedMethodRootsCleared;

        private Builder(boolean tracedMethodRootsCleared) {
            this.tracedMethodRootsCleared = tracedMethodRootsCleared;
        }

        public void addList(DexProgramClass clazz) {
            this.addList(clazz.getType());
        }

        public void addList(DexType type) {
            this.list.add(type);
        }

        public void addRoot(DexProgramClass clazz) {
            this.addRoot(clazz.getType());
        }

        public void addRoot(DexType type) {
            assert (!this.dependencies.contains(type));
            this.roots.add(type);
        }

        public void addRoot(DexMethod method) {
            this.methodRoots.add(method);
        }

        public void addDependency(DexProgramClass clazz) {
            this.addDependency(clazz.getType());
        }

        public void addDependency(DexType type) {
            assert (!this.roots.contains(type));
            this.dependencies.add(type);
        }

        public Consumer<DexType> addDependencyAllowSyntheticRoot(SyntheticItems syntheticItems) {
            return type -> {
                assert (!this.roots.contains(type) || syntheticItems.isCommittedSynthetic((DexType)type));
                this.addDependencyIfNotRoot((DexType)type);
            };
        }

        public void addDependencyIfNotRoot(DexType type) {
            if (this.roots.contains(type)) {
                return;
            }
            this.addDependency(type);
        }

        public boolean isTracedRoot(DexProgramClass clazz) {
            return this.isTracedRoot(clazz.getType());
        }

        public boolean isTracedRoot(DexType type) {
            return this.roots.contains(type);
        }

        public boolean isDependency(DexProgramClass clazz) {
            return this.isDependency(clazz.getType());
        }

        public boolean isDependency(DexType type) {
            return this.dependencies.contains(type);
        }

        public boolean contains(DexProgramClass clazz) {
            return this.contains(clazz.type);
        }

        public boolean contains(DexType type) {
            return this.isTracedRoot(type) || this.isDependency(type);
        }

        public Set<DexType> getRoots() {
            return this.roots;
        }

        public MainDexInfo buildList() {
            assert (this.dependencies.isEmpty());
            assert (this.roots.isEmpty());
            return new MainDexInfo(this.list);
        }

        public MainDexInfo build(Set<DexType> classList) {
            assert (this.list.isEmpty());
            return new MainDexInfo(classList, this.roots, this.methodRoots, this.dependencies, this.tracedMethodRootsCleared);
        }

        public MainDexInfo build(MainDexInfo previous) {
            return this.build(previous.classList);
        }

        public MainDexInfo build() {
            return new MainDexInfo(this.list, this.roots, this.methodRoots, this.dependencies, this.tracedMethodRootsCleared);
        }
    }

    public static enum MainDexGroup {
        MAIN_DEX_LIST,
        MAIN_DEX_ROOT,
        MAIN_DEX_DEPENDENCY,
        NOT_IN_MAIN_DEX;

    }
}

