/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.ClassResolutionResult;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.SubtypingInfo;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.position.Position;
import com.android.tools.r8.shaking.ClassInlineRule;
import com.android.tools.r8.shaking.ProguardAccessFlags;
import com.android.tools.r8.shaking.ProguardCheckDiscardRule;
import com.android.tools.r8.shaking.ProguardClassNameList;
import com.android.tools.r8.shaking.ProguardClassSpecification;
import com.android.tools.r8.shaking.ProguardClassType;
import com.android.tools.r8.shaking.ProguardIfRule;
import com.android.tools.r8.shaking.ProguardKeepRule;
import com.android.tools.r8.shaking.ProguardMemberRule;
import com.android.tools.r8.shaking.ProguardTypeMatcher;
import com.android.tools.r8.shaking.ProguardWildcard;
import com.android.tools.r8.shaking.ReprocessClassInitializerRule;
import com.android.tools.r8.shaking.ReprocessMethodRule;
import com.android.tools.r8.utils.StringUtils;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.StreamSupport;

public abstract class ProguardConfigurationRule
extends ProguardClassSpecification {
    private boolean used = false;
    private boolean canReferenceDeadTypes = false;

    ProguardConfigurationRule(Origin origin, Position position, String source, List<ProguardTypeMatcher> classAnnotations, ProguardAccessFlags classAccessFlags, ProguardAccessFlags negatedClassAccessFlags, boolean classTypeNegated, ProguardClassType classType, ProguardClassNameList classNames, List<ProguardTypeMatcher> inheritanceAnnotations, ProguardTypeMatcher inheritanceClassName, boolean inheritanceIsExtends, List<ProguardMemberRule> memberRules) {
        super(origin, position, source, classAnnotations, classAccessFlags, negatedClassAccessFlags, classTypeNegated, classType, classNames, inheritanceAnnotations, inheritanceClassName, inheritanceIsExtends, memberRules);
    }

    public boolean isUsed() {
        return this.used;
    }

    public void markAsUsed() {
        this.used = true;
    }

    public boolean isProguardCheckDiscardRule() {
        return false;
    }

    public ProguardCheckDiscardRule asProguardCheckDiscardRule() {
        return null;
    }

    public boolean isProguardKeepRule() {
        return false;
    }

    public ProguardKeepRule asProguardKeepRule() {
        return null;
    }

    public boolean isProguardIfRule() {
        return false;
    }

    public ProguardIfRule asProguardIfRule() {
        return null;
    }

    public boolean isClassInlineRule() {
        return false;
    }

    public ClassInlineRule asClassInlineRule() {
        return null;
    }

    public boolean isReprocessClassInitializerRule() {
        return false;
    }

    public ReprocessClassInitializerRule asReprocessClassInitializerRule() {
        return null;
    }

    public boolean isReprocessMethodRule() {
        return false;
    }

    public ReprocessMethodRule asReprocessMethodRule() {
        return null;
    }

    public void canReferenceDeadTypes() {
        this.canReferenceDeadTypes = true;
    }

    Iterable<DexProgramClass> relevantCandidatesForRule(final AppView<? extends AppInfoWithClassHierarchy> appView, SubtypingInfo subtypingInfo, Iterable<DexProgramClass> defaultValue) {
        List<DexType> specificTypes = this.getClassNames().asSpecificDexTypes();
        if (specificTypes != null) {
            return DexProgramClass.asProgramClasses(specificTypes, new DexDefinitionSupplier(){

                @Override
                public ClassResolutionResult contextIndependentDefinitionForWithResolutionResult(DexType type) {
                    throw new Unreachable("Add support for multiple definitions with rule evaluation");
                }

                @Override
                public DexClass definitionFor(DexType type) {
                    if (ProguardConfigurationRule.this.canReferenceDeadTypes) {
                        return ((AppInfoWithClassHierarchy)appView.appInfo()).definitionForWithoutExistenceAssert(type);
                    }
                    return appView.definitionFor(type);
                }

                @Override
                public DexItemFactory dexItemFactory() {
                    return appView.dexItemFactory();
                }
            });
        }
        if (this.hasInheritanceClassName() && this.getInheritanceClassName().hasSpecificType()) {
            DexType type = this.getInheritanceClassName().getSpecificType();
            if (appView.verticallyMergedClasses() != null && appView.verticallyMergedClasses().hasBeenMergedIntoSubtype(type)) {
                DexType target = appView.verticallyMergedClasses().getTargetFor(type);
                DexClass clazz = appView.definitionFor(target);
                assert (clazz != null && clazz.isProgramClass());
                return Iterables.concat(ImmutableList.of(clazz.asProgramClass()), DexProgramClass.asProgramClasses(subtypingInfo.subtypes(type), appView));
            }
            return DexProgramClass.asProgramClasses(subtypingInfo.subtypes(type), appView);
        }
        return defaultValue;
    }

    abstract String typeString();

    String modifierString() {
        return null;
    }

    public boolean applyToNonProgramClasses() {
        return false;
    }

    protected Iterable<ProguardWildcard> getWildcards() {
        List<ProguardMemberRule> memberRules = this.getMemberRules();
        Iterable[] iterableArray = new Iterable[5];
        iterableArray[0] = ProguardTypeMatcher.getWildcardsOrEmpty(this.getClassAnnotations());
        iterableArray[1] = ProguardClassNameList.getWildcardsOrEmpty(this.getClassNames());
        iterableArray[2] = ProguardTypeMatcher.getWildcardsOrEmpty(this.getInheritanceAnnotations());
        iterableArray[3] = ProguardTypeMatcher.getWildcardsOrEmpty(this.getInheritanceClassName());
        iterableArray[4] = memberRules != null ? memberRules.stream().map(ProguardMemberRule::getWildcards).flatMap(it -> StreamSupport.stream(it.spliterator(), false))::iterator : Collections::emptyIterator;
        return Iterables.concat(iterableArray);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ProguardConfigurationRule)) {
            return false;
        }
        ProguardConfigurationRule that = (ProguardConfigurationRule)o;
        if (this.used != that.used) {
            return false;
        }
        if (!Objects.equals(this.typeString(), that.typeString())) {
            return false;
        }
        if (!Objects.equals(this.modifierString(), that.modifierString())) {
            return false;
        }
        return super.equals(that);
    }

    @Override
    public int hashCode() {
        int result = 3 * this.typeString().hashCode();
        result = 3 * result + (this.used ? 1 : 0);
        String modifier = this.modifierString();
        result = 3 * result + (modifier != null ? modifier.hashCode() : 0);
        return result + super.hashCode();
    }

    @Override
    protected StringBuilder append(StringBuilder builder, boolean includeMemberRules) {
        builder.append("-");
        builder.append(this.typeString());
        StringUtils.appendNonEmpty(builder, ",", this.modifierString(), null);
        builder.append(' ');
        super.append(builder, includeMemberRules);
        return builder;
    }
}

