/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.shaking.ProguardAccessFlags;
import com.android.tools.r8.shaking.ProguardAssumeNoSideEffectRule;
import com.android.tools.r8.shaking.ProguardAssumeValuesRule;
import com.android.tools.r8.shaking.ProguardClassNameList;
import com.android.tools.r8.shaking.ProguardClassType;
import com.android.tools.r8.shaking.ProguardConfigurationParser;
import com.android.tools.r8.shaking.ProguardConfigurationRule;
import com.android.tools.r8.shaking.ProguardKeepRule;
import com.android.tools.r8.shaking.ProguardKeepRuleType;
import com.android.tools.r8.shaking.ProguardMemberRule;
import com.android.tools.r8.shaking.ProguardMemberRuleReturnValue;
import com.android.tools.r8.shaking.ProguardMemberType;
import com.android.tools.r8.shaking.ProguardTypeMatcher;
import com.android.tools.r8.utils.AndroidApiLevel;
import com.android.tools.r8.utils.LongInterval;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class ProguardConfigurationUtils {
    private static Origin proguardCompatOrigin = new Origin(Origin.root()){

        @Override
        public String part() {
            return "<PROGUARD_COMPATIBILITY_RULE>";
        }
    };
    private static Origin synthesizedRecompilationOrigin = new Origin(Origin.root()){

        @Override
        public String part() {
            return "<SYNTHESIZED_RECOMPILATION_RULE>";
        }
    };

    public static ProguardKeepRule buildDefaultInitializerKeepRule(DexClass clazz) {
        ProguardKeepRule.Builder builder = ProguardKeepRule.builder();
        builder.setOrigin(proguardCompatOrigin);
        builder.setType(ProguardKeepRuleType.KEEP);
        builder.getModifiersBuilder().setAllowsObfuscation(true);
        builder.getModifiersBuilder().setAllowsOptimization(true);
        builder.getClassAccessFlags().setVisibility(clazz.accessFlags);
        builder.setClassType(ProguardClassType.CLASS);
        builder.setClassNames(ProguardClassNameList.singletonList(ProguardTypeMatcher.create(clazz.type)));
        if (clazz.hasDefaultInitializer()) {
            ProguardMemberRule.Builder memberRuleBuilder = ProguardMemberRule.builder();
            memberRuleBuilder.setRuleType(ProguardMemberType.INIT);
            memberRuleBuilder.setName(ProguardConfigurationParser.IdentifierPatternWithWildcards.withoutWildcards("<init>"));
            memberRuleBuilder.setArguments(ImmutableList.of());
            builder.getMemberRules().add(memberRuleBuilder.build());
        }
        return builder.build();
    }

    public static ProguardKeepRule buildMethodKeepRule(DexClass clazz, DexEncodedMethod method) {
        assert (clazz.type == method.getHolderType());
        ProguardKeepRule.Builder builder = ProguardKeepRule.builder();
        builder.setOrigin(proguardCompatOrigin);
        builder.setType(ProguardKeepRuleType.KEEP_CLASS_MEMBERS);
        builder.getModifiersBuilder().setAllowsObfuscation(true);
        builder.getModifiersBuilder().setAllowsOptimization(true);
        builder.getClassAccessFlags().setVisibility(clazz.accessFlags);
        if (clazz.isInterface()) {
            builder.setClassType(ProguardClassType.INTERFACE);
        } else {
            builder.setClassType(ProguardClassType.CLASS);
        }
        builder.setClassNames(ProguardClassNameList.singletonList(ProguardTypeMatcher.create(clazz.type)));
        ProguardMemberRule.Builder memberRuleBuilder = ProguardMemberRule.builder();
        memberRuleBuilder.setRuleType(ProguardMemberType.METHOD);
        memberRuleBuilder.getAccessFlags().setFlags(method.accessFlags);
        memberRuleBuilder.setName(ProguardConfigurationParser.IdentifierPatternWithWildcards.withoutWildcards(((DexMethod)method.getReference()).name.toString()));
        memberRuleBuilder.setTypeMatcher(ProguardTypeMatcher.create(((DexMethod)method.getReference()).proto.returnType));
        List<ProguardTypeMatcher> arguments = Arrays.stream(((DexMethod)method.getReference()).proto.parameters.values).map(ProguardTypeMatcher::create).collect(Collectors.toList());
        memberRuleBuilder.setArguments(arguments);
        builder.getMemberRules().add(memberRuleBuilder.build());
        return builder.build();
    }

    public static ProguardAssumeNoSideEffectRule buildAssumeNoSideEffectsRuleForApiLevel(DexItemFactory factory, final AndroidApiLevel apiLevel) {
        Origin synthesizedFromApiLevel = new Origin(Origin.root()){

            @Override
            public String part() {
                return "<SYNTHESIZED_FROM_API_LEVEL_" + apiLevel.getLevel() + ">";
            }
        };
        ProguardAccessFlags publicStaticFinalFlags = new ProguardAccessFlags();
        publicStaticFinalFlags.setPublic();
        publicStaticFinalFlags.setStatic();
        publicStaticFinalFlags.setFinal();
        return ((ProguardAssumeNoSideEffectRule.Builder)((ProguardAssumeNoSideEffectRule.Builder)((ProguardAssumeNoSideEffectRule.Builder)((ProguardAssumeNoSideEffectRule.Builder)ProguardAssumeNoSideEffectRule.builder().setOrigin(synthesizedFromApiLevel)).setClassType(ProguardClassType.CLASS)).setClassNames(ProguardClassNameList.singletonList(ProguardTypeMatcher.create(factory.androidOsBuildVersionType)))).setMemberRules(ImmutableList.of(ProguardMemberRule.builder().setAccessFlags(publicStaticFinalFlags).setRuleType(ProguardMemberType.FIELD).setTypeMatcher(ProguardTypeMatcher.create(factory.intType)).setName(ProguardConfigurationParser.IdentifierPatternWithWildcards.withoutWildcards("SDK_INT")).setReturnValue(new ProguardMemberRuleReturnValue(new LongInterval(apiLevel.getLevel(), Integer.MAX_VALUE))).build()))).build();
    }

    public static boolean hasExplicitAssumeValuesOrAssumeNoSideEffectsRuleForMinSdk(DexItemFactory factory, List<ProguardConfigurationRule> rules) {
        for (ProguardConfigurationRule rule : rules) {
            if (!(rule instanceof ProguardAssumeValuesRule) && !(rule instanceof ProguardAssumeNoSideEffectRule) || rule.getClassType() != ProguardClassType.CLASS || !rule.getClassAnnotations().isEmpty() || !rule.getInheritanceAnnotations().isEmpty() || rule.hasInheritanceClassName() && !rule.getInheritanceClassName().matches(factory.objectType) || rule.getClassNames().hasWildcards() || !rule.getClassNames().matches(factory.androidOsBuildVersionType)) continue;
            for (ProguardMemberRule memberRule : rule.getMemberRules()) {
                if (memberRule.getRuleType() == ProguardMemberType.ALL || memberRule.getRuleType() == ProguardMemberType.ALL_FIELDS) {
                    return true;
                }
                if (memberRule.getRuleType() != ProguardMemberType.FIELD || !memberRule.getAnnotations().isEmpty() || memberRule.getAccessFlags().isProtected() || memberRule.getAccessFlags().isPrivate() || memberRule.getAccessFlags().isAbstract() || memberRule.getAccessFlags().isTransient() || memberRule.getAccessFlags().isVolatile() || memberRule.getNegatedAccessFlags().isPublic() || memberRule.getNegatedAccessFlags().isStatic() || memberRule.getNegatedAccessFlags().isFinal() || !memberRule.getType().matches(factory.intType) || !memberRule.getName().matches("SDK_INT")) continue;
                return true;
            }
        }
        return false;
    }
}

