/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.base.Equivalence;
import com.android.tools.r8.com.google.common.base.Predicates;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Lists;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.com.google.common.collect.Streams;
import com.android.tools.r8.errors.AssumeNoSideEffectsRuleForObjectMembersDiagnostic;
import com.android.tools.r8.errors.InlinableStaticFinalFieldPreconditionDiagnostic;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.BottomUpClassHierarchyTraversal;
import com.android.tools.r8.graph.Definition;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClassAndField;
import com.android.tools.r8.graph.DexClassAndMember;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexDefinition;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMember;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexLibraryClass;
import com.android.tools.r8.graph.DexMember;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DirectMappedDexApplication;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.MethodResolutionResult;
import com.android.tools.r8.graph.ProgramDefinition;
import com.android.tools.r8.graph.ProgramField;
import com.android.tools.r8.graph.ProgramMember;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.PrunedItems;
import com.android.tools.r8.graph.SubtypingInfo;
import com.android.tools.r8.ir.analysis.proto.GeneratedMessageLiteBuilderShrinker;
import com.android.tools.r8.ir.desugar.itf.InterfaceDesugaringSyntheticHelper;
import com.android.tools.r8.ir.desugar.itf.InterfaceMethodDesugaringBaseEventConsumer;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedbackSimple;
import com.android.tools.r8.logging.Log;
import com.android.tools.r8.shaking.AnnotationMatchResult;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.shaking.ClassInlineRule;
import com.android.tools.r8.shaking.DelayedRootSetActionItem;
import com.android.tools.r8.shaking.DependentMinimumKeepInfoCollection;
import com.android.tools.r8.shaking.DexStringCache;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.EnqueuerEvent;
import com.android.tools.r8.shaking.InlineRule;
import com.android.tools.r8.shaking.KeepConstantArgumentRule;
import com.android.tools.r8.shaking.KeepInfo;
import com.android.tools.r8.shaking.KeepUnusedArgumentRule;
import com.android.tools.r8.shaking.KeepUnusedReturnValueRule;
import com.android.tools.r8.shaking.MemberValuePropagationRule;
import com.android.tools.r8.shaking.MinimumKeepInfoCollection;
import com.android.tools.r8.shaking.NoFieldTypeStrengtheningRule;
import com.android.tools.r8.shaking.NoHorizontalClassMergingRule;
import com.android.tools.r8.shaking.NoMethodStaticizingRule;
import com.android.tools.r8.shaking.NoParameterReorderingRule;
import com.android.tools.r8.shaking.NoParameterTypeStrengtheningRule;
import com.android.tools.r8.shaking.NoReturnTypeStrengtheningRule;
import com.android.tools.r8.shaking.NoUnusedInterfaceRemovalRule;
import com.android.tools.r8.shaking.NoVerticalClassMergingRule;
import com.android.tools.r8.shaking.ProguardAssumeMayHaveSideEffectsRule;
import com.android.tools.r8.shaking.ProguardAssumeNoSideEffectRule;
import com.android.tools.r8.shaking.ProguardAssumeValuesRule;
import com.android.tools.r8.shaking.ProguardCheckDiscardRule;
import com.android.tools.r8.shaking.ProguardConfigurationRule;
import com.android.tools.r8.shaking.ProguardIdentifierNameStringRule;
import com.android.tools.r8.shaking.ProguardIfRule;
import com.android.tools.r8.shaking.ProguardKeepRule;
import com.android.tools.r8.shaking.ProguardKeepRuleBase;
import com.android.tools.r8.shaking.ProguardKeepRuleModifiers;
import com.android.tools.r8.shaking.ProguardMemberRule;
import com.android.tools.r8.shaking.ProguardTypeMatcher;
import com.android.tools.r8.shaking.ProguardWhyAreYouKeepingRule;
import com.android.tools.r8.shaking.ReprocessClassInitializerRule;
import com.android.tools.r8.shaking.ReprocessMethodRule;
import com.android.tools.r8.shaking.WhyAreYouNotInliningRule;
import com.android.tools.r8.utils.ArrayUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.LensUtils;
import com.android.tools.r8.utils.MethodSignatureEquivalence;
import com.android.tools.r8.utils.OriginWithPosition;
import com.android.tools.r8.utils.PredicateSet;
import com.android.tools.r8.utils.Reporter;
import com.android.tools.r8.utils.StringDiagnostic;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.TraversalContinuation;
import com.android.tools.r8.utils.collections.ProgramMethodMap;
import com.android.tools.r8.utils.structural.StructuralItem;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class RootSetUtils {

    public static class MainDexRootSet
    extends RootSet {
        public MainDexRootSet(DependentMinimumKeepInfoCollection dependentMinimumKeepInfo, ImmutableList<DexReference> reasonAsked, Set<ProguardIfRule> ifRules, List<DelayedRootSetActionItem> delayedRootSetActionItems) {
            super(dependentMinimumKeepInfo, reasonAsked, Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), PredicateSet.empty(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptySet(), ifRules, delayedRootSetActionItems, ProgramMethodMap.empty());
        }

        public static MainDexRootSetBuilder builder(AppView<? extends AppInfoWithClassHierarchy> appView, SubtypingInfo subtypingInfo, Iterable<? extends ProguardConfigurationRule> rules) {
            return new MainDexRootSetBuilder(appView, subtypingInfo, rules);
        }

        @Override
        void shouldNotBeMinified(ProgramDefinition definition) {
        }

        @Override
        public MainDexRootSet rewrittenWithLens(GraphLens graphLens) {
            if (graphLens.isIdentityLens()) {
                return this;
            }
            ImmutableList.Builder rewrittenReasonAsked = ImmutableList.builder();
            this.reasonAsked.forEach(reference -> LensUtils.rewriteAndApplyIfNotPrimitiveType(graphLens, reference, rewrittenReasonAsked::add));
            this.ifRules.forEach(ProguardConfigurationRule::canReferenceDeadTypes);
            assert (this.delayedRootSetActionItems.isEmpty());
            return new MainDexRootSet(this.getDependentMinimumKeepInfo().rewrittenWithLens(graphLens), (ImmutableList<DexReference>)rewrittenReasonAsked.build(), this.ifRules, this.delayedRootSetActionItems);
        }

        public MainDexRootSet withoutPrunedItems(PrunedItems prunedItems) {
            if (prunedItems.isEmpty()) {
                return this;
            }
            this.ifRules.forEach(ProguardConfigurationRule::canReferenceDeadTypes);
            assert (this.delayedRootSetActionItems.isEmpty());
            return new MainDexRootSet(this.getDependentMinimumKeepInfo(), this.reasonAsked, this.ifRules, this.delayedRootSetActionItems);
        }
    }

    public static class MainDexRootSetBuilder
    extends RootSetBuilder {
        private MainDexRootSetBuilder(AppView<? extends AppInfoWithClassHierarchy> appView, SubtypingInfo subtypingInfo, Iterable<? extends ProguardConfigurationRule> rules) {
            super(appView, subtypingInfo, rules);
        }

        @Override
        boolean isMainDexRootSetBuilder() {
            return true;
        }

        @Override
        public MainDexRootSet build(ExecutorService executorService) throws ExecutionException {
            RootSet rootSet = super.build(executorService);
            return new MainDexRootSet(rootSet.getDependentMinimumKeepInfo(), rootSet.reasonAsked, rootSet.ifRules, rootSet.delayedRootSetActionItems);
        }
    }

    public static class ConsequentRootSet
    extends RootSetBase {
        ConsequentRootSet(Set<DexMethod> neverInlineDueToSingleCaller, Set<DexType> neverClassInline, DependentMinimumKeepInfoCollection dependentMinimumKeepInfo, Map<DexType, Set<ProguardKeepRuleBase>> dependentKeepClassCompatRule, List<DelayedRootSetActionItem> delayedRootSetActionItems, ProgramMethodMap<ProgramMethod> pendingMethodMoveInverse) {
            super(neverInlineDueToSingleCaller, neverClassInline, dependentMinimumKeepInfo, dependentKeepClassCompatRule, delayedRootSetActionItems, pendingMethodMoveInverse);
        }

        static ConsequentRootSetBuilder builder(AppView<? extends AppInfoWithClassHierarchy> appView, SubtypingInfo subtypingInfo, Enqueuer enqueuer) {
            return new ConsequentRootSetBuilder(appView, subtypingInfo, enqueuer);
        }
    }

    static class ConsequentRootSetBuilder
    extends RootSetBuilder {
        private final Enqueuer enqueuer;

        private ConsequentRootSetBuilder(AppView<? extends AppInfoWithClassHierarchy> appView, SubtypingInfo subtypingInfo, Enqueuer enqueuer) {
            super(appView, subtypingInfo, null);
            this.enqueuer = enqueuer;
        }

        @Override
        void handleMatchedAnnotation(AnnotationMatchResult annotationMatchResult) {
            if (this.enqueuer.getMode().isInitialTreeShaking() && annotationMatchResult.isConcreteAnnotationMatchResult()) {
                this.enqueuer.retainAnnotationForFinalTreeShaking(annotationMatchResult.asConcreteAnnotationMatchResult().getMatchedAnnotations());
            }
        }
    }

    public static class RootSet
    extends RootSetBase {
        public final ImmutableList<DexReference> reasonAsked;
        public final Set<DexMethod> alwaysInline;
        public final Set<DexMethod> bypassClinitForInlining;
        public final Set<DexMethod> whyAreYouNotInlining;
        public final Set<DexMethod> reprocess;
        public final Set<DexMethod> neverReprocess;
        public final PredicateSet<DexType> alwaysClassInline;
        public final Set<DexType> noUnusedInterfaceRemoval;
        public final Set<DexType> noVerticalClassMerging;
        public final Set<DexType> noHorizontalClassMerging;
        public final Set<DexMember<?, ?>> neverPropagateValue;
        public final Map<DexReference, ProguardMemberRule> mayHaveSideEffects;
        public final Map<DexMember<?, ?>, ProguardMemberRule> noSideEffects;
        public final Map<DexMember<?, ?>, ProguardMemberRule> assumedValues;
        public final Set<DexMember<?, ?>> identifierNameStrings;
        public final Set<ProguardIfRule> ifRules;

        private RootSet(DependentMinimumKeepInfoCollection dependentMinimumKeepInfo, ImmutableList<DexReference> reasonAsked, Set<DexMethod> alwaysInline, Set<DexMethod> neverInlineDueToSingleCaller, Set<DexMethod> bypassClinitForInlining, Set<DexMethod> whyAreYouNotInlining, Set<DexMethod> reprocess, Set<DexMethod> neverReprocess, PredicateSet<DexType> alwaysClassInline, Set<DexType> neverClassInline, Set<DexType> noUnusedInterfaceRemoval, Set<DexType> noVerticalClassMerging, Set<DexType> noHorizontalClassMerging, Set<DexMember<?, ?>> neverPropagateValue, Map<DexReference, ProguardMemberRule> mayHaveSideEffects, Map<DexMember<?, ?>, ProguardMemberRule> noSideEffects, Map<DexMember<?, ?>, ProguardMemberRule> assumedValues, Map<DexType, Set<ProguardKeepRuleBase>> dependentKeepClassCompatRule, Set<DexMember<?, ?>> identifierNameStrings, Set<ProguardIfRule> ifRules, List<DelayedRootSetActionItem> delayedRootSetActionItems, ProgramMethodMap<ProgramMethod> pendingMethodMoveInverse) {
            super(neverInlineDueToSingleCaller, neverClassInline, dependentMinimumKeepInfo, dependentKeepClassCompatRule, delayedRootSetActionItems, pendingMethodMoveInverse);
            this.reasonAsked = reasonAsked;
            this.alwaysInline = alwaysInline;
            this.bypassClinitForInlining = bypassClinitForInlining;
            this.whyAreYouNotInlining = whyAreYouNotInlining;
            this.reprocess = reprocess;
            this.neverReprocess = neverReprocess;
            this.alwaysClassInline = alwaysClassInline;
            this.noUnusedInterfaceRemoval = noUnusedInterfaceRemoval;
            this.noVerticalClassMerging = noVerticalClassMerging;
            this.noHorizontalClassMerging = noHorizontalClassMerging;
            this.neverPropagateValue = neverPropagateValue;
            this.mayHaveSideEffects = mayHaveSideEffects;
            this.noSideEffects = noSideEffects;
            this.assumedValues = assumedValues;
            this.identifierNameStrings = Collections.unmodifiableSet(identifierNameStrings);
            this.ifRules = Collections.unmodifiableSet(ifRules);
        }

        private static void pruneDeadReferences(Set<? extends DexReference> references, DexDefinitionSupplier definitions, Enqueuer enqueuer) {
            references.removeIf(reference -> {
                Definition definition = reference.apply(definitions::definitionFor, field -> field.lookupMemberOnClass(definitions.definitionFor(field.getHolderType())), method -> method.lookupMemberOnClass(definitions.definitionFor(method.getHolderType())));
                return definition == null || !enqueuer.isReachable(definition);
            });
        }

        private boolean isKeptDirectlyOrIndirectly(DexType type, AppView<AppInfoWithLiveness> appView) {
            DexProgramClass clazz = DexProgramClass.asProgramClassOrNull(appView.definitionFor(type));
            if (clazz == null) {
                return false;
            }
            if (this.isShrinkingDisallowedUnconditionally(clazz, appView.options())) {
                return true;
            }
            if (clazz.superType != null) {
                return this.isKeptDirectlyOrIndirectly(clazz.superType, appView);
            }
            return false;
        }

        public static RootSetBuilder builder(AppView<? extends AppInfoWithClassHierarchy> appView, SubtypingInfo subtypingInfo) {
            return new RootSetBuilder((AppView)appView, subtypingInfo);
        }

        public static RootSetBuilder builder(AppView<? extends AppInfoWithClassHierarchy> appView, SubtypingInfo subtypingInfo, Iterable<? extends ProguardConfigurationRule> rules) {
            return new RootSetBuilder(appView, subtypingInfo, rules);
        }

        public void checkAllRulesAreUsed(InternalOptions options) {
            List<ProguardConfigurationRule> rules = options.getProguardConfiguration().getRules();
            if (rules == null) {
                return;
            }
            for (ProguardConfigurationRule rule : rules) {
                ProguardIfRule ifRule;
                Set<DexField> unorderedFields;
                if (rule.isProguardIfRule() && !(unorderedFields = (ifRule = rule.asProguardIfRule()).getAndClearInlinableFieldsMatchingPrecondition()).isEmpty()) {
                    ArrayList<DexField> fields = new ArrayList<DexField>(unorderedFields);
                    fields.sort(StructuralItem::compareTo);
                    options.reporter.warning(new InlinableStaticFinalFieldPreconditionDiagnostic(ifRule, fields));
                    continue;
                }
                if (rule.isUsed() || !options.testing.reportUnusedProguardConfigurationRules) continue;
                String message = "Proguard configuration rule does not match anything: `" + rule + "`";
                StringDiagnostic diagnostic = new StringDiagnostic(message, rule.getOrigin());
                options.reporter.info(diagnostic);
            }
        }

        void addConsequentRootSet(ConsequentRootSet consequentRootSet) {
            this.neverInlineDueToSingleCaller.addAll(consequentRootSet.neverInlineDueToSingleCaller);
            this.neverClassInline.addAll(consequentRootSet.neverClassInline);
            consequentRootSet.dependentKeepClassCompatRule.forEach((type, rules) -> this.dependentKeepClassCompatRule.computeIfAbsent(type, k -> new HashSet()).addAll(rules));
            this.delayedRootSetActionItems.addAll(consequentRootSet.delayedRootSetActionItems);
        }

        public boolean isShrinkingDisallowedUnconditionally(ProgramDefinition definition, InternalOptions options) {
            if (!options.isShrinking()) {
                return true;
            }
            return this.getDependentMinimumKeepInfo().getOrDefault(EnqueuerEvent.UnconditionalKeepInfoEvent.get(), MinimumKeepInfoCollection.empty()).hasMinimumKeepInfoThatMatches(definition.getReference(), minimumKeepInfoForDefinition -> !minimumKeepInfoForDefinition.isShrinkingAllowed());
        }

        public void pruneDeadItems(DexDefinitionSupplier definitions, Enqueuer enqueuer) {
            this.getDependentMinimumKeepInfo().pruneDeadItems(definitions, enqueuer);
            RootSet.pruneDeadReferences(this.noUnusedInterfaceRemoval, definitions, enqueuer);
            RootSet.pruneDeadReferences(this.noVerticalClassMerging, definitions, enqueuer);
            RootSet.pruneDeadReferences(this.noHorizontalClassMerging, definitions, enqueuer);
            RootSet.pruneDeadReferences(this.alwaysInline, definitions, enqueuer);
            RootSet.pruneDeadReferences(this.noSideEffects.keySet(), definitions, enqueuer);
        }

        public void pruneItems(PrunedItems prunedItems) {
            MinimumKeepInfoCollection unconditionalMinimumKeepInfo = this.getDependentMinimumKeepInfo().getUnconditionalMinimumKeepInfoOrDefault(null);
            if (unconditionalMinimumKeepInfo != null) {
                unconditionalMinimumKeepInfo.pruneItems(prunedItems);
                if (unconditionalMinimumKeepInfo.isEmpty()) {
                    this.getDependentMinimumKeepInfo().remove(EnqueuerEvent.UnconditionalKeepInfoEvent.get());
                }
            }
        }

        public RootSet rewrittenWithLens(GraphLens graphLens) {
            if (graphLens.isIdentityLens()) {
                return this;
            }
            return new RootSet(this.getDependentMinimumKeepInfo().rewrittenWithLens(graphLens), this.reasonAsked, this.alwaysInline, this.neverInlineDueToSingleCaller, this.bypassClinitForInlining, this.whyAreYouNotInlining, this.reprocess, this.neverReprocess, this.alwaysClassInline, this.neverClassInline, this.noUnusedInterfaceRemoval, this.noVerticalClassMerging, this.noHorizontalClassMerging, this.neverPropagateValue, this.mayHaveSideEffects, this.noSideEffects, this.assumedValues, this.dependentKeepClassCompatRule, this.identifierNameStrings, this.ifRules, this.delayedRootSetActionItems, this.pendingMethodMoveInverse);
        }

        void shouldNotBeMinified(ProgramDefinition definition) {
            this.getDependentMinimumKeepInfo().getOrCreateUnconditionalMinimumKeepInfoFor(definition.getReference()).disallowMinification();
        }

        public boolean verifyKeptFieldsAreAccessedAndLive(AppView<AppInfoWithLiveness> appView) {
            this.getDependentMinimumKeepInfo().getUnconditionalMinimumKeepInfoOrDefault(MinimumKeepInfoCollection.empty()).forEachThatMatches((reference, minimumKeepInfo) -> reference.isDexField() && !minimumKeepInfo.isShrinkingAllowed(), (reference, minimumKeepInfo) -> {
                DexProgramClass holder;
                DexField fieldReference = reference.asDexField();
                ProgramField field = fieldReference.lookupOnProgramClass(holder = DexProgramClass.asProgramClassOrNull(appView.definitionForHolder(fieldReference)));
                if (field != null && (field.getAccessFlags().isStatic() || this.isKeptDirectlyOrIndirectly(field.getHolderType(), appView))) {
                    assert (((AppInfoWithLiveness)appView.appInfo()).isFieldRead((DexEncodedField)field.getDefinition())) : "Expected kept field `" + fieldReference.toSourceString() + "` to be read";
                    assert (((AppInfoWithLiveness)appView.appInfo()).isFieldWritten((DexEncodedField)field.getDefinition())) : "Expected kept field `" + fieldReference.toSourceString() + "` to be written";
                }
            });
            return true;
        }

        public boolean verifyKeptMethodsAreTargetedAndLive(AppView<AppInfoWithLiveness> appView) {
            this.getDependentMinimumKeepInfo().getUnconditionalMinimumKeepInfoOrDefault(MinimumKeepInfoCollection.empty()).forEachThatMatches((reference, minimumKeepInfo) -> reference.isDexMethod() && !minimumKeepInfo.isShrinkingAllowed(), (reference, minimumKeepInfo) -> {
                DexMethod methodReference = reference.asDexMethod();
                assert (((AppInfoWithLiveness)appView.appInfo()).isTargetedMethod(methodReference)) : "Expected kept method `" + reference.toSourceString() + "` to be targeted";
                DexEncodedMethod method = appView.definitionForHolder(methodReference).lookupMethod(methodReference);
                if (!method.isAbstract() && this.isKeptDirectlyOrIndirectly(methodReference.getHolderType(), appView)) assert (((AppInfoWithLiveness)appView.appInfo()).isLiveMethod(methodReference)) : "Expected non-abstract kept method `" + reference.toSourceString() + "` to be live";
            });
            return true;
        }

        public boolean verifyKeptTypesAreLive(AppView<AppInfoWithLiveness> appView) {
            this.getDependentMinimumKeepInfo().getUnconditionalMinimumKeepInfoOrDefault(MinimumKeepInfoCollection.empty()).forEachThatMatches((reference, minimumKeepInfo) -> reference.isDexType() && !minimumKeepInfo.isShrinkingAllowed(), (reference, minimumKeepInfo) -> {
                DexType type = reference.asDexType();
                assert (((AppInfoWithLiveness)appView.appInfo()).isLiveProgramType(type)) : "Expected kept type `" + type.toSourceString() + "` to be live";
            });
            return true;
        }

        public boolean verifyKeptItemsAreKept(AppView<? extends AppInfoWithClassHierarchy> appView) {
            AppInfoWithClassHierarchy appInfo = appView.appInfo();
            IdentityHashMap requiredMembersPerType = new IdentityHashMap();
            this.getDependentMinimumKeepInfo().getUnconditionalMinimumKeepInfoOrDefault(MinimumKeepInfoCollection.empty()).forEachThatMatches((reference, minimumKeepInfo) -> !minimumKeepInfo.isShrinkingAllowed(), (reference, minimumKeepInfo) -> {
                if (reference.isDexType()) {
                    DexType type = reference.asDexType();
                    assert (!appInfo.hasLiveness() || appInfo.withLiveness().isPinned(type)) : "Expected reference `" + type.toSourceString() + "` to be pinned";
                    requiredMembersPerType.computeIfAbsent(type, key -> Sets.newIdentityHashSet());
                } else {
                    DexMember<?, ?> member = reference.asDexMember();
                    assert (!appInfo.hasLiveness() || appInfo.withLiveness().isPinned(member)) : "Expected reference `" + member.toSourceString() + "` to be pinned";
                    requiredMembersPerType.computeIfAbsent(member.holder, key -> Sets.newIdentityHashSet()).add(member);
                }
            });
            for (DexProgramClass dexProgramClass : appView.appInfo().classes()) {
                Set requiredMembers = requiredMembersPerType.getOrDefault(dexProgramClass.type, ImmutableSet.of());
                Set fields = null;
                Set methods = null;
                for (DexMember requiredMember : requiredMembers) {
                    if (requiredMember.isDexField()) {
                        DexField requiredField = requiredMember.asDexField();
                        if (fields == null) {
                            fields = Streams.stream(dexProgramClass.fields()).map(DexEncodedMember::getReference).collect(Collectors.toSet());
                        }
                        assert (fields.contains(requiredField)) : "Expected field `" + requiredField.toSourceString() + "` from the root set to be present";
                        continue;
                    }
                    DexMethod requiredMethod = requiredMember.asDexMethod();
                    if (methods == null) {
                        methods = Streams.stream(dexProgramClass.methods()).map(DexEncodedMember::getReference).collect(Collectors.toSet());
                    }
                    assert (methods.contains(requiredMethod)) : "Expected method `" + requiredMethod.toSourceString() + "` from the root set to be present";
                }
                requiredMembersPerType.remove(dexProgramClass.type);
            }
            if (!requiredMembersPerType.isEmpty()) {
                DexType type = (DexType)requiredMembersPerType.keySet().iterator().next();
                DexClass dexClass = appView.definitionFor(type);
                assert (dexClass == null || dexClass.isProgramClass()) : "Unexpected library type in root set: `" + type + "`";
                assert (requiredMembersPerType.isEmpty()) : "Expected type `" + type.toSourceString() + "` to be present";
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("RootSet");
            builder.append("\nreasonAsked: " + this.reasonAsked.size());
            builder.append("\nnoSideEffects: " + this.noSideEffects.size());
            builder.append("\nassumedValues: " + this.assumedValues.size());
            builder.append("\nidentifierNameStrings: " + this.identifierNameStrings.size());
            builder.append("\nifRules: " + this.ifRules.size());
            return builder.toString();
        }
    }

    static abstract class RootSetBase {
        final Set<DexMethod> neverInlineDueToSingleCaller;
        final Set<DexType> neverClassInline;
        private final DependentMinimumKeepInfoCollection dependentMinimumKeepInfo;
        final Map<DexType, Set<ProguardKeepRuleBase>> dependentKeepClassCompatRule;
        final List<DelayedRootSetActionItem> delayedRootSetActionItems;
        public final ProgramMethodMap<ProgramMethod> pendingMethodMoveInverse;

        RootSetBase(Set<DexMethod> neverInlineDueToSingleCaller, Set<DexType> neverClassInline, DependentMinimumKeepInfoCollection dependentMinimumKeepInfo, Map<DexType, Set<ProguardKeepRuleBase>> dependentKeepClassCompatRule, List<DelayedRootSetActionItem> delayedRootSetActionItems, ProgramMethodMap<ProgramMethod> pendingMethodMoveInverse) {
            this.neverInlineDueToSingleCaller = neverInlineDueToSingleCaller;
            this.neverClassInline = neverClassInline;
            this.dependentMinimumKeepInfo = dependentMinimumKeepInfo;
            this.dependentKeepClassCompatRule = dependentKeepClassCompatRule;
            this.delayedRootSetActionItems = delayedRootSetActionItems;
            this.pendingMethodMoveInverse = pendingMethodMoveInverse;
        }

        Set<ProguardKeepRuleBase> getDependentKeepClassCompatRule(DexType type) {
            return this.dependentKeepClassCompatRule.get(type);
        }

        public DependentMinimumKeepInfoCollection getDependentMinimumKeepInfo() {
            return this.dependentMinimumKeepInfo;
        }
    }

    public static class RootSetBuilder {
        private final AppView<? extends AppInfoWithClassHierarchy> appView;
        private final SubtypingInfo subtypingInfo;
        private final DirectMappedDexApplication application;
        private final Iterable<? extends ProguardConfigurationRule> rules;
        private final DependentMinimumKeepInfoCollection dependentMinimumKeepInfo = new DependentMinimumKeepInfoCollection();
        private final LinkedHashMap<DexReference, DexReference> reasonAsked = new LinkedHashMap();
        private final Set<DexMethod> alwaysInline = Sets.newIdentityHashSet();
        private final Set<DexMethod> neverInlineDueToSingleCaller = Sets.newIdentityHashSet();
        private final Set<DexMethod> bypassClinitforInlining = Sets.newIdentityHashSet();
        private final Set<DexMethod> whyAreYouNotInlining = Sets.newIdentityHashSet();
        private final Set<DexMethod> reprocess = Sets.newIdentityHashSet();
        private final Set<DexMethod> neverReprocess = Sets.newIdentityHashSet();
        private final PredicateSet<DexType> alwaysClassInline = new PredicateSet();
        private final Set<DexType> neverClassInline = Sets.newIdentityHashSet();
        private final Set<DexType> noUnusedInterfaceRemoval = Sets.newIdentityHashSet();
        private final Set<DexType> noVerticalClassMerging = Sets.newIdentityHashSet();
        private final Set<DexType> noHorizontalClassMerging = Sets.newIdentityHashSet();
        private final Set<DexMember<?, ?>> neverPropagateValue = Sets.newIdentityHashSet();
        private final Map<DexType, Set<ProguardKeepRuleBase>> dependentKeepClassCompatRule = new IdentityHashMap<DexType, Set<ProguardKeepRuleBase>>();
        private final Map<DexReference, ProguardMemberRule> mayHaveSideEffects = new IdentityHashMap<DexReference, ProguardMemberRule>();
        private final Map<DexMember<?, ?>, ProguardMemberRule> noSideEffects = new IdentityHashMap();
        private final Map<DexMember<?, ?>, ProguardMemberRule> assumedValues = new IdentityHashMap();
        private final Set<DexMember<?, ?>> identifierNameStrings = Sets.newIdentityHashSet();
        private final Queue<DelayedRootSetActionItem> delayedRootSetActionItems = new ConcurrentLinkedQueue<DelayedRootSetActionItem>();
        private final InternalOptions options;
        private final DexStringCache dexStringCache = new DexStringCache();
        private final Set<ProguardIfRule> ifRules = Sets.newIdentityHashSet();
        private final Map<OriginWithPosition, Set<DexMethod>> assumeNoSideEffectsWarnings = new LinkedHashMap<OriginWithPosition, Set<DexMethod>>();
        private final Set<DexProgramClass> classesWithCheckDiscardedMembers = Sets.newIdentityHashSet();
        private final OptimizationFeedbackSimple feedback = OptimizationFeedbackSimple.getInstance();
        private final InterfaceDesugaringSyntheticHelper interfaceDesugaringSyntheticHelper;
        private final ProgramMethodMap<ProgramMethod> pendingMethodMoveInverse = ProgramMethodMap.create();

        private RootSetBuilder(AppView<? extends AppInfoWithClassHierarchy> appView, SubtypingInfo subtypingInfo, Iterable<? extends ProguardConfigurationRule> rules) {
            this.appView = appView;
            this.subtypingInfo = subtypingInfo;
            this.application = appView.appInfo().app().asDirect();
            this.rules = rules;
            this.options = appView.options();
            this.interfaceDesugaringSyntheticHelper = this.options.isInterfaceMethodDesugaringEnabled() ? new InterfaceDesugaringSyntheticHelper(appView) : null;
        }

        private RootSetBuilder(AppView<? extends AppInfoWithClassHierarchy> appView, SubtypingInfo subtypingInfo) {
            this(appView, subtypingInfo, null);
        }

        private void process(DexClass clazz, ProguardConfigurationRule rule, ProguardIfRule ifRule) {
            if (!RootSetBuilder.satisfyClassType(rule, clazz)) {
                return;
            }
            if (!RootSetBuilder.satisfyAccessFlag(rule, clazz)) {
                return;
            }
            AnnotationMatchResult annotationMatchResult = RootSetBuilder.satisfyAnnotation(rule, clazz);
            if (annotationMatchResult == null) {
                return;
            }
            this.handleMatchedAnnotation(annotationMatchResult);
            if (rule.hasInheritanceClassName() && !this.satisfyInheritanceRule(clazz, rule)) {
                return;
            }
            if (!rule.getClassNames().matches(clazz.type)) {
                return;
            }
            List<ProguardMemberRule> memberKeepRules = rule.getMemberRules();
            if (rule instanceof ProguardKeepRule) {
                if (clazz.isNotProgramClass()) {
                    return;
                }
                switch (((ProguardKeepRule)rule).getType()) {
                    case KEEP_CLASS_MEMBERS: {
                        ImmutableMap<Predicate<DexDefinition>, DexProgramClass> preconditionSupplier = ImmutableMap.of(definition -> true, clazz.asProgramClass());
                        this.markMatchingVisibleMethods(clazz, memberKeepRules, rule, preconditionSupplier, false, ifRule);
                        this.markMatchingVisibleFields(clazz, memberKeepRules, rule, preconditionSupplier, false, ifRule);
                        break;
                    }
                    case KEEP_CLASSES_WITH_MEMBERS: {
                        if (!this.allRulesSatisfied(memberKeepRules, clazz)) break;
                    }
                    case KEEP: {
                        this.markClass(clazz, rule, ifRule);
                        HashMap<Predicate<DexDefinition>, DexProgramClass> preconditionSupplier = new HashMap<Predicate<DexDefinition>, DexProgramClass>();
                        if (ifRule != null) {
                            preconditionSupplier.put(DexDefinition::isStaticMember, null);
                            preconditionSupplier.put(definition -> !definition.isStaticMember(), clazz.asProgramClass());
                        } else {
                            preconditionSupplier.put(Predicates.alwaysTrue(), null);
                        }
                        this.markMatchingVisibleMethods(clazz, memberKeepRules, rule, preconditionSupplier, false, ifRule);
                        this.markMatchingVisibleFields(clazz, memberKeepRules, rule, preconditionSupplier, false, ifRule);
                        break;
                    }
                    case CONDITIONAL: {
                        throw new Unreachable("-if rule will be evaluated separately, not here.");
                    }
                }
                return;
            }
            assert (ifRule == null);
            if (rule instanceof ProguardIfRule) {
                throw new Unreachable("-if rule will be evaluated separately, not here.");
            }
            if (rule.isProguardCheckDiscardRule()) {
                this.evaluateCheckDiscardRule(clazz, rule.asProguardCheckDiscardRule());
            } else if (rule instanceof ProguardWhyAreYouKeepingRule) {
                this.markClass(clazz, rule, ifRule);
                this.markMatchingVisibleMethods(clazz, memberKeepRules, rule, null, true, ifRule);
                this.markMatchingVisibleFields(clazz, memberKeepRules, rule, null, true, ifRule);
            } else if (rule instanceof ProguardAssumeMayHaveSideEffectsRule || rule instanceof ProguardAssumeNoSideEffectRule || rule instanceof ProguardAssumeValuesRule) {
                this.markMatchingVisibleMethods(clazz, memberKeepRules, rule, null, true, ifRule);
                this.markMatchingOverriddenMethods(this.appView.appInfo(), clazz, memberKeepRules, rule, null, true, ifRule);
                this.markMatchingVisibleFields(clazz, memberKeepRules, rule, null, true, ifRule);
            } else if (rule instanceof NoFieldTypeStrengtheningRule) {
                this.markMatchingFields(clazz, memberKeepRules, rule, null, ifRule);
            } else if (rule instanceof InlineRule || rule instanceof KeepConstantArgumentRule || rule instanceof KeepUnusedReturnValueRule || rule instanceof NoMethodStaticizingRule || rule instanceof NoParameterReorderingRule || rule instanceof NoParameterTypeStrengtheningRule || rule instanceof NoReturnTypeStrengtheningRule || rule instanceof KeepUnusedArgumentRule || rule instanceof ReprocessMethodRule || rule instanceof WhyAreYouNotInliningRule) {
                this.markMatchingMethods(clazz, memberKeepRules, rule, null, ifRule);
            } else if (rule instanceof ClassInlineRule || rule instanceof NoUnusedInterfaceRemovalRule || rule instanceof NoVerticalClassMergingRule || rule instanceof NoHorizontalClassMergingRule || rule instanceof ReprocessClassInitializerRule) {
                if (this.allRulesSatisfied(memberKeepRules, clazz)) {
                    this.markClass(clazz, rule, ifRule);
                }
            } else if (rule instanceof MemberValuePropagationRule) {
                this.markMatchingVisibleMethods(clazz, memberKeepRules, rule, null, true, ifRule);
                this.markMatchingVisibleFields(clazz, memberKeepRules, rule, null, true, ifRule);
            } else {
                assert (rule instanceof ProguardIdentifierNameStringRule);
                this.markMatchingFields(clazz, memberKeepRules, rule, null, ifRule);
                this.markMatchingMethods(clazz, memberKeepRules, rule, null, ifRule);
            }
        }

        private void propagateAssumeRules(DexClass clazz) {
            Set<DexType> subTypes = this.subtypingInfo.allImmediateSubtypes(clazz.type);
            if (subTypes.isEmpty()) {
                return;
            }
            for (DexEncodedMethod encodedMethod : clazz.virtualMethods()) {
                if (encodedMethod.hasCode()) {
                    assert (!encodedMethod.shouldNotHaveCode());
                    continue;
                }
                this.propagateAssumeRules(clazz.type, (DexMethod)encodedMethod.getReference(), subTypes, this.noSideEffects);
                this.propagateAssumeRules(clazz.type, (DexMethod)encodedMethod.getReference(), subTypes, this.assumedValues);
            }
        }

        private void propagateAssumeRules(DexType type, DexMethod reference, Set<DexType> subTypes, Map<DexMember<?, ?>, ProguardMemberRule> assumeRulePool) {
            ProguardMemberRule ruleToBePropagated = null;
            for (DexType subType : subTypes) {
                DexMethod referenceInSubType = this.appView.dexItemFactory().createMethod(subType, reference.proto, reference.name);
                DexEncodedMethod target = this.appView.appInfo().unsafeResolveMethodDueToDexFormat(referenceInSubType).getSingleTarget();
                if (target == null || target.getHolderType() == type) continue;
                ProguardMemberRule ruleInSubType = assumeRulePool.get(target.getReference());
                if (ruleInSubType == null) {
                    ruleToBePropagated = null;
                    break;
                }
                if (ruleToBePropagated == null) {
                    ruleToBePropagated = ruleInSubType;
                    continue;
                }
                if (ruleToBePropagated.equals(ruleInSubType)) continue;
                ruleToBePropagated = null;
                break;
            }
            if (ruleToBePropagated != null) {
                assumeRulePool.put(reference, ruleToBePropagated);
            }
        }

        private static DexProgramClass testAndGetPrecondition(DexDefinition definition, Map<Predicate<DexDefinition>, DexProgramClass> preconditionSupplier) {
            if (preconditionSupplier == null) {
                return null;
            }
            DexProgramClass precondition = null;
            boolean conditionEverMatched = false;
            for (Map.Entry<Predicate<DexDefinition>, DexProgramClass> entry : preconditionSupplier.entrySet()) {
                if (!entry.getKey().test(definition)) continue;
                precondition = entry.getValue();
                conditionEverMatched = true;
                break;
            }
            assert (conditionEverMatched);
            return precondition;
        }

        private void markMatchingVisibleMethods(DexClass clazz, Collection<ProguardMemberRule> memberKeepRules, ProguardConfigurationRule rule, Map<Predicate<DexDefinition>, DexProgramClass> preconditionSupplier, boolean includeLibraryClasses, ProguardIfRule ifRule) {
            HashSet methodsMarked = this.options.forceProguardCompatibility ? null : new HashSet();
            Stack<DexClass> worklist = new Stack<DexClass>();
            worklist.add(clazz);
            while (!worklist.isEmpty()) {
                DexClass dexClass;
                DexClass currentClass = (DexClass)worklist.pop();
                if (!includeLibraryClasses && currentClass.isNotProgramClass()) break;
                currentClass.forEachClassMethodMatching(method -> method.belongsToVirtualPool() || currentClass == clazz || method.isStatic() && !method.isPrivate() && !method.isInitializer() || this.options.forceProguardCompatibility, method -> {
                    DexProgramClass precondition = RootSetBuilder.testAndGetPrecondition(method.getDefinition(), preconditionSupplier);
                    this.markMethod((DexClassAndMethod)method, memberKeepRules, methodsMarked, rule, precondition, ifRule);
                });
                if (currentClass.superType == null || (dexClass = this.application.definitionFor(currentClass.superType)) == null) continue;
                worklist.add(dexClass);
            }
            if (clazz.isProgramClass() && rule.isProguardKeepRule() && !rule.asProguardKeepRule().getModifiers().allowsShrinking && !this.isMainDexRootSetBuilder()) {
                new SynthesizeMissingInterfaceMethodsForMemberRules(clazz.asProgramClass(), memberKeepRules, rule, preconditionSupplier, ifRule).run();
            }
        }

        private boolean canInsertForwardingMethod(DexClass holder, DexEncodedMethod target) {
            return this.appView.options().isGeneratingDex() || ArrayUtils.contains(holder.interfaces.values, target.getHolderType());
        }

        private void markMatchingOverriddenMethods(AppInfoWithClassHierarchy appInfoWithSubtyping, DexClass clazz, Collection<ProguardMemberRule> memberKeepRules, ProguardConfigurationRule rule, Map<Predicate<DexDefinition>, DexProgramClass> preconditionSupplier, boolean onlyIncludeProgramClasses, ProguardIfRule ifRule) {
            HashSet<DexType> visited = new HashSet<DexType>();
            ArrayDeque<DexType> worklist = new ArrayDeque<DexType>();
            worklist.addAll(this.subtypingInfo.allImmediateSubtypes(clazz.type));
            while (!worklist.isEmpty()) {
                DexClass currentClazz;
                DexType currentType = (DexType)worklist.poll();
                if (!visited.add(currentType) || (currentClazz = this.appView.definitionFor(currentType)) == null || !onlyIncludeProgramClasses && currentClazz.isNotProgramClass()) continue;
                currentClazz.forEachClassMethodMatching(DexEncodedMethod::belongsToVirtualPool, method -> {
                    DexProgramClass precondition = RootSetBuilder.testAndGetPrecondition(method.getDefinition(), preconditionSupplier);
                    this.markMethod((DexClassAndMethod)method, memberKeepRules, null, rule, precondition, ifRule);
                });
                worklist.addAll(this.subtypingInfo.allImmediateSubtypes(currentClazz.type));
            }
        }

        private void markMatchingMethods(DexClass clazz, Collection<ProguardMemberRule> memberKeepRules, ProguardConfigurationRule rule, Map<Predicate<DexDefinition>, DexProgramClass> preconditionSupplier, ProguardIfRule ifRule) {
            clazz.forEachClassMethod(method -> {
                DexProgramClass precondition = RootSetBuilder.testAndGetPrecondition(method.getDefinition(), preconditionSupplier);
                this.markMethod((DexClassAndMethod)method, memberKeepRules, null, rule, precondition, ifRule);
            });
        }

        private void markMatchingVisibleFields(DexClass clazz, Collection<ProguardMemberRule> memberKeepRules, ProguardConfigurationRule rule, Map<Predicate<DexDefinition>, DexProgramClass> preconditionSupplier, boolean includeLibraryClasses, ProguardIfRule ifRule) {
            while (clazz != null) {
                if (!includeLibraryClasses && clazz.isNotProgramClass()) {
                    return;
                }
                clazz.forEachClassField(field -> {
                    DexProgramClass precondition = RootSetBuilder.testAndGetPrecondition(field.getDefinition(), preconditionSupplier);
                    this.markField((DexClassAndField)field, memberKeepRules, rule, precondition, ifRule);
                });
                clazz = clazz.superType == null ? null : this.application.definitionFor(clazz.superType);
            }
        }

        private void markMatchingFields(DexClass clazz, Collection<ProguardMemberRule> memberKeepRules, ProguardConfigurationRule rule, Map<Predicate<DexDefinition>, DexProgramClass> preconditionSupplier, ProguardIfRule ifRule) {
            clazz.forEachClassField(field -> {
                DexProgramClass precondition = RootSetBuilder.testAndGetPrecondition(field.getDefinition(), preconditionSupplier);
                this.markField((DexClassAndField)field, memberKeepRules, rule, precondition, ifRule);
            });
        }

        public static void writeSeeds(AppInfoWithLiveness appInfo, PrintStream out, Predicate<DexType> include) {
            InternalOptions options = appInfo.app().options;
            appInfo.getKeepInfo().forEachPinnedType(type -> {
                if (include.test((DexType)type)) {
                    out.println(type.toSourceString());
                }
            }, options);
            appInfo.getKeepInfo().forEachPinnedField(field -> {
                if (include.test(field.holder)) {
                    out.println(field.holder.toSourceString() + ": " + field.type.toSourceString() + " " + field.name.toSourceString());
                }
            }, options);
            appInfo.getKeepInfo().forEachPinnedMethod(method -> {
                if (!include.test(method.holder)) {
                    return;
                }
                DexProgramClass holder = DexProgramClass.asProgramClassOrNull(appInfo.definitionForHolder(method));
                DexEncodedMethod definition = method.lookupOnClass(holder);
                if (definition == null) {
                    assert (method.match(appInfo.dexItemFactory().deserializeLambdaMethod));
                    return;
                }
                out.print(method.holder.toSourceString() + ": ");
                if (definition.isClassInitializer()) {
                    out.print("<clinit>");
                } else if (definition.isInstanceInitializer()) {
                    String holderName = method.holder.toSourceString();
                    String constrName = holderName.substring(holderName.lastIndexOf(46) + 1);
                    out.print(constrName);
                } else {
                    out.print(method.proto.returnType.toSourceString() + " " + method.name.toSourceString());
                }
                boolean first = true;
                out.print("(");
                for (DexType param : method.proto.parameters.values) {
                    if (!first) {
                        out.print(",");
                    }
                    first = false;
                    out.print(param.toSourceString());
                }
                out.println(")");
            }, options);
            out.close();
        }

        static boolean satisfyClassType(ProguardConfigurationRule rule, DexClass clazz) {
            return rule.getClassType().matches(clazz) != rule.getClassTypeNegated();
        }

        static boolean satisfyAccessFlag(ProguardConfigurationRule rule, DexClass clazz) {
            return rule.getClassAccessFlags().containsAll(clazz.accessFlags) && rule.getNegatedClassAccessFlags().containsNone(clazz.accessFlags);
        }

        static AnnotationMatchResult satisfyAnnotation(ProguardConfigurationRule rule, DexClass clazz) {
            return RootSetBuilder.containsAllAnnotations(rule.getClassAnnotations(), clazz);
        }

        private boolean anyImplementedInterfaceMatchesImplementsRule(DexClass clazz, ProguardConfigurationRule rule) {
            if (clazz == null) {
                return false;
            }
            for (DexType iface : clazz.interfaces.values) {
                AnnotationMatchResult annotationMatchResult;
                DexClass ifaceClass = this.application.definitionFor(iface);
                if (ifaceClass == null) {
                    return false;
                }
                if (rule.getInheritanceClassName().matches(iface, this.appView) && (annotationMatchResult = RootSetBuilder.containsAllAnnotations(rule.getInheritanceAnnotations(), ifaceClass)) != null) {
                    this.handleMatchedAnnotation(annotationMatchResult);
                    return true;
                }
                if (!this.anyImplementedInterfaceMatchesImplementsRule(ifaceClass, rule)) continue;
                return true;
            }
            if (clazz.superType == null) {
                return false;
            }
            DexClass superClass = this.application.definitionFor(clazz.superType);
            if (superClass == null) {
                return false;
            }
            return this.anyImplementedInterfaceMatchesImplementsRule(superClass, rule);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean anySourceMatchesInheritanceRuleDirectly(DexClass clazz, ProguardConfigurationRule rule, boolean isInterface) {
            if (this.appView.verticallyMergedClasses() == null) return false;
            if (!this.appView.verticallyMergedClasses().getSourcesFor(clazz.type).stream().filter(sourceType -> this.appView.definitionFor((DexType)sourceType).accessFlags.isInterface() == isInterface).anyMatch(rule.getInheritanceClassName()::matches)) return false;
            return true;
        }

        private boolean allRulesSatisfied(Collection<ProguardMemberRule> memberKeepRules, DexClass clazz) {
            for (ProguardMemberRule rule : memberKeepRules) {
                if (this.ruleSatisfied(rule, clazz)) continue;
                return false;
            }
            return true;
        }

        private boolean ruleSatisfied(ProguardMemberRule rule, DexClass clazz) {
            return this.ruleSatisfiedByMethods(rule, clazz.classMethods()) || this.ruleSatisfiedByFields(rule, clazz.classFields());
        }

        static AnnotationMatchResult containsAllAnnotations(List<ProguardTypeMatcher> annotationMatchers, DexClass clazz) {
            return RootSetBuilder.containsAllAnnotations(annotationMatchers, clazz, clazz.annotations(), DexAnnotation.AnnotatedKind.TYPE);
        }

        static <D extends DexEncodedMember<D, R>, R extends DexMember<D, R>> boolean containsAllAnnotations(List<ProguardTypeMatcher> annotationMatchers, DexClassAndMember<D, R> member, Consumer<AnnotationMatchResult> matchedAnnotationsConsumer) {
            AnnotationMatchResult annotationMatchResult = RootSetBuilder.containsAllAnnotations(annotationMatchers, member, member.getAnnotations(), member.isField() ? DexAnnotation.AnnotatedKind.FIELD : DexAnnotation.AnnotatedKind.METHOD);
            if (annotationMatchResult != null) {
                matchedAnnotationsConsumer.accept(annotationMatchResult);
                return true;
            }
            if (member.isMethod()) {
                DexClassAndMethod method = member.asMethod();
                for (int i = 0; i < method.getParameterAnnotations().size(); ++i) {
                    annotationMatchResult = RootSetBuilder.containsAllAnnotations(annotationMatchers, method, method.getParameterAnnotation(i), DexAnnotation.AnnotatedKind.PARAMETER);
                    if (annotationMatchResult == null) continue;
                    matchedAnnotationsConsumer.accept(annotationMatchResult);
                    return true;
                }
            }
            return false;
        }

        private static AnnotationMatchResult containsAllAnnotations(List<ProguardTypeMatcher> annotationMatchers, Definition annotatedItem, DexAnnotationSet annotations, DexAnnotation.AnnotatedKind annotatedKind) {
            if (annotationMatchers.isEmpty()) {
                return AnnotationMatchResult.AnnotationsIgnoredMatchResult.getInstance();
            }
            ArrayList<AnnotationMatchResult.MatchedAnnotation> matchedAnnotations = new ArrayList<AnnotationMatchResult.MatchedAnnotation>();
            for (ProguardTypeMatcher annotationMatcher : annotationMatchers) {
                DexAnnotation matchedAnnotation = RootSetBuilder.getFirstAnnotationThatMatches(annotationMatcher, annotations);
                if (matchedAnnotation == null) {
                    return null;
                }
                if (!annotatedItem.isProgramDefinition()) continue;
                matchedAnnotations.add(new AnnotationMatchResult.MatchedAnnotation(annotatedItem.asProgramDefinition(), matchedAnnotation, annotatedKind));
            }
            return new AnnotationMatchResult.ConcreteAnnotationMatchResult(matchedAnnotations);
        }

        private static DexAnnotation getFirstAnnotationThatMatches(ProguardTypeMatcher annotationMatcher, DexAnnotationSet annotations) {
            for (DexAnnotation annotation : annotations.annotations) {
                if (!annotationMatcher.matches(annotation.getAnnotationType())) continue;
                return annotation;
            }
            return null;
        }

        private void markMethod(DexClassAndMethod method, Collection<ProguardMemberRule> rules, Set<Equivalence.Wrapper<DexMethod>> methodsMarked, ProguardConfigurationRule context, DexProgramClass precondition, ProguardIfRule ifRule) {
            if (methodsMarked != null && methodsMarked.contains(MethodSignatureEquivalence.get().wrap((DexMethod)method.getReference()))) {
                return;
            }
            for (ProguardMemberRule rule : rules) {
                if (!rule.matches(method, this.appView, this::handleMatchedAnnotation, this.dexStringCache)) continue;
                if (Log.ENABLED) {
                    Log.verbose(this.getClass(), "Marking method `%s` due to `%s { %s }`.", method, context, rule);
                }
                if (methodsMarked != null) {
                    methodsMarked.add(MethodSignatureEquivalence.get().wrap((DexMethod)method.getReference()));
                }
                this.addItemToSets(method, context, rule, precondition, ifRule);
            }
        }

        private void markField(DexClassAndField field, Collection<ProguardMemberRule> rules, ProguardConfigurationRule context, DexProgramClass precondition, ProguardIfRule ifRule) {
            for (ProguardMemberRule rule : rules) {
                if (!rule.matches(field, this.appView, this::handleMatchedAnnotation, this.dexStringCache)) continue;
                if (Log.ENABLED) {
                    Log.verbose(this.getClass(), "Marking field `%s` due to `%s { %s }`.", field, context, rule);
                }
                this.addItemToSets(field, context, rule, precondition, ifRule);
            }
        }

        private void markClass(DexClass clazz, ProguardConfigurationRule rule, ProguardIfRule ifRule) {
            if (Log.ENABLED) {
                Log.verbose(this.getClass(), "Marking class `%s` due to `%s`.", clazz.type, rule);
            }
            this.addItemToSets(clazz, rule, null, null, ifRule);
        }

        private void includeDescriptor(DexType type, ProguardKeepRuleBase rule, EnqueuerEvent preconditionEvent) {
            if (type.isVoidType()) {
                return;
            }
            if (type.isArrayType()) {
                type = type.toBaseType(this.appView.dexItemFactory());
            }
            if (type.isPrimitiveType()) {
                return;
            }
            DexProgramClass clazz = DexProgramClass.asProgramClassOrNull(this.appView.definitionFor(type));
            if (clazz == null) {
                return;
            }
            ProguardKeepRuleModifiers modifiers = rule.getModifiers();
            if (this.appView.options().isShrinking() && !modifiers.allowsShrinking) {
                ((KeepInfo.Joiner)this.dependentMinimumKeepInfo.getOrCreateMinimumKeepInfoFor(preconditionEvent, clazz.getReference()).addRule(rule)).disallowShrinking();
            }
            if (this.appView.options().isMinificationEnabled() && !modifiers.allowsObfuscation) {
                this.dependentMinimumKeepInfo.getOrCreateMinimumKeepInfoFor(preconditionEvent, clazz.getReference()).disallowMinification();
            }
        }

        private void includeDescriptorClasses(ProgramDefinition item, ProguardKeepRuleBase rule, EnqueuerEvent preconditionEvent) {
            if (item.isMethod()) {
                ProgramMethod method = item.asProgramMethod();
                this.includeDescriptor(method.getReturnType(), rule, preconditionEvent);
                for (DexType value : method.getParameters()) {
                    this.includeDescriptor(value, rule, preconditionEvent);
                }
            } else if (item.isField()) {
                ProgramField field = item.asProgramField();
                this.includeDescriptor(field.getType(), rule, preconditionEvent);
            } else assert (item.isClass());
        }

        private synchronized void addItemToSets(Definition item, ProguardConfigurationRule context, ProguardMemberRule rule, DexProgramClass precondition, ProguardIfRule ifRule) {
            block59: {
                block76: {
                    block75: {
                        block74: {
                            block73: {
                                block72: {
                                    block71: {
                                        block70: {
                                            block69: {
                                                block68: {
                                                    block67: {
                                                        block66: {
                                                            block65: {
                                                                block64: {
                                                                    block63: {
                                                                        block62: {
                                                                            block61: {
                                                                                block60: {
                                                                                    block58: {
                                                                                        if (!context.isProguardKeepRule()) break block58;
                                                                                        if (!item.isProgramDefinition()) {
                                                                                            return;
                                                                                        }
                                                                                        this.evaluateKeepRule(item.asProgramDefinition(), context.asProguardKeepRule(), rule, precondition, ifRule);
                                                                                        break block59;
                                                                                    }
                                                                                    if (!(context instanceof ProguardAssumeMayHaveSideEffectsRule)) break block60;
                                                                                    this.mayHaveSideEffects.put(item.getReference(), rule);
                                                                                    context.markAsUsed();
                                                                                    break block59;
                                                                                }
                                                                                if (!(context instanceof ProguardAssumeNoSideEffectRule)) break block61;
                                                                                if (item.isMember()) {
                                                                                    DexClassAndMember<?, ?> member = item.asMember();
                                                                                    if (member.getHolderType() == this.appView.dexItemFactory().objectType) {
                                                                                        assert (member.isMethod());
                                                                                        this.reportAssumeNoSideEffectsWarningForJavaLangClassMethod(member.asMethod(), (ProguardAssumeNoSideEffectRule)context);
                                                                                    } else {
                                                                                        DexClassAndMethod method;
                                                                                        this.noSideEffects.put((DexMember<?, ?>)member.getReference(), rule);
                                                                                        if (member.isMethod() && ((DexEncodedMethod)(method = member.asMethod()).getDefinition()).isClassInitializer()) {
                                                                                            this.feedback.classInitializerMayBePostponed((DexEncodedMethod)method.getDefinition());
                                                                                        }
                                                                                    }
                                                                                    context.markAsUsed();
                                                                                }
                                                                                break block59;
                                                                            }
                                                                            if (!(context instanceof ProguardWhyAreYouKeepingRule)) break block62;
                                                                            this.reasonAsked.computeIfAbsent(item.getReference(), i -> i);
                                                                            context.markAsUsed();
                                                                            break block59;
                                                                        }
                                                                        if (!(context instanceof ProguardAssumeValuesRule)) break block63;
                                                                        if (item.isMember()) {
                                                                            this.assumedValues.put((DexMember<?, ?>)item.asMember().getReference(), rule);
                                                                            context.markAsUsed();
                                                                        }
                                                                        break block59;
                                                                    }
                                                                    if (!context.isProguardCheckDiscardRule()) break block64;
                                                                    assert (item.isProgramMember());
                                                                    this.evaluateCheckDiscardMemberRule(item.asProgramMember(), context.asProguardCheckDiscardRule());
                                                                    break block59;
                                                                }
                                                                if (!(context instanceof InlineRule)) break block65;
                                                                if (item.isMethod()) {
                                                                    DexMethod reference = (DexMethod)item.asMethod().getReference();
                                                                    switch (((InlineRule)context).getType()) {
                                                                        case ALWAYS: {
                                                                            this.alwaysInline.add(reference);
                                                                            break;
                                                                        }
                                                                        case NEVER: {
                                                                            this.dependentMinimumKeepInfo.getOrCreateUnconditionalMinimumKeepInfoFor(item.getReference()).asMethodJoiner().disallowInlining();
                                                                            break;
                                                                        }
                                                                        case NEVER_CLASS_INLINE: {
                                                                            this.dependentMinimumKeepInfo.getOrCreateUnconditionalMinimumKeepInfoFor(item.getReference()).asMethodJoiner().disallowClassInlining();
                                                                            break;
                                                                        }
                                                                        case NEVER_SINGLE_CALLER: {
                                                                            this.neverInlineDueToSingleCaller.add(reference);
                                                                            break;
                                                                        }
                                                                        default: {
                                                                            throw new Unreachable();
                                                                        }
                                                                    }
                                                                    context.markAsUsed();
                                                                }
                                                                break block59;
                                                            }
                                                            if (!(context instanceof WhyAreYouNotInliningRule)) break block66;
                                                            if (!item.isMethod()) {
                                                                throw new Unreachable();
                                                            }
                                                            this.whyAreYouNotInlining.add((DexMethod)item.asMethod().getReference());
                                                            context.markAsUsed();
                                                            break block59;
                                                        }
                                                        if (!context.isClassInlineRule()) break block67;
                                                        ClassInlineRule classInlineRule = context.asClassInlineRule();
                                                        DexClass clazz = item.asClass();
                                                        if (clazz == null) {
                                                            throw new IllegalStateException("Unexpected -" + classInlineRule.typeString() + " rule for a non-class type: `" + item.getReference().toSourceString() + "`");
                                                        }
                                                        switch (classInlineRule.getType()) {
                                                            case ALWAYS: {
                                                                this.alwaysClassInline.addElement(item.asClass().getType());
                                                                break;
                                                            }
                                                            case NEVER: {
                                                                this.neverClassInline.add(item.asClass().getType());
                                                                break;
                                                            }
                                                            default: {
                                                                throw new Unreachable();
                                                            }
                                                        }
                                                        context.markAsUsed();
                                                        break block59;
                                                    }
                                                    if (!(context instanceof NoFieldTypeStrengtheningRule)) break block68;
                                                    assert (item.isProgramField());
                                                    this.dependentMinimumKeepInfo.getOrCreateUnconditionalMinimumKeepInfoFor(item.getReference()).asFieldJoiner().disallowFieldTypeStrengthening();
                                                    context.markAsUsed();
                                                    break block59;
                                                }
                                                if (!(context instanceof NoUnusedInterfaceRemovalRule)) break block69;
                                                this.noUnusedInterfaceRemoval.add(item.asClass().type);
                                                context.markAsUsed();
                                                break block59;
                                            }
                                            if (!(context instanceof NoVerticalClassMergingRule)) break block70;
                                            this.noVerticalClassMerging.add(item.asClass().type);
                                            context.markAsUsed();
                                            break block59;
                                        }
                                        if (!(context instanceof NoHorizontalClassMergingRule)) break block71;
                                        this.noHorizontalClassMerging.add(item.asClass().type);
                                        context.markAsUsed();
                                        break block59;
                                    }
                                    if (!(context instanceof NoMethodStaticizingRule)) break block72;
                                    assert (item.isProgramMethod());
                                    this.dependentMinimumKeepInfo.getOrCreateUnconditionalMinimumKeepInfoFor(item.getReference()).asMethodJoiner().disallowMethodStaticizing();
                                    context.markAsUsed();
                                    break block59;
                                }
                                if (!(context instanceof NoParameterReorderingRule)) break block73;
                                assert (item.isProgramMethod());
                                this.dependentMinimumKeepInfo.getOrCreateUnconditionalMinimumKeepInfoFor(item.getReference()).asMethodJoiner().disallowParameterReordering();
                                context.markAsUsed();
                                break block59;
                            }
                            if (!(context instanceof NoParameterTypeStrengtheningRule)) break block74;
                            assert (item.isProgramMethod());
                            this.dependentMinimumKeepInfo.getOrCreateUnconditionalMinimumKeepInfoFor(item.getReference()).asMethodJoiner().disallowParameterTypeStrengthening();
                            context.markAsUsed();
                            break block59;
                        }
                        if (!(context instanceof NoReturnTypeStrengtheningRule)) break block75;
                        assert (item.isProgramMethod());
                        this.dependentMinimumKeepInfo.getOrCreateUnconditionalMinimumKeepInfoFor(item.getReference()).asMethodJoiner().disallowReturnTypeStrengthening();
                        context.markAsUsed();
                        break block59;
                    }
                    if (!(context instanceof MemberValuePropagationRule)) break block76;
                    switch (((MemberValuePropagationRule)context).getType()) {
                        case NEVER: {
                            DexClassAndMethod method;
                            if (item.isField()) {
                                DexClassAndField field = item.asField();
                                if (field.isProgramField()) {
                                    this.neverPropagateValue.add((DexMember<?, ?>)field.getReference());
                                    context.markAsUsed();
                                }
                            } else if (item.isMethod() && (method = item.asMethod()).isProgramMethod()) {
                                this.neverPropagateValue.add((DexMember<?, ?>)method.getReference());
                                context.markAsUsed();
                            }
                            break block59;
                        }
                        default: {
                            throw new Unreachable();
                        }
                    }
                }
                if (context instanceof ProguardIdentifierNameStringRule) {
                    this.evaluateIdentifierNameStringRule(item, context, ifRule);
                } else if (context instanceof ReprocessClassInitializerRule) {
                    DexProgramClass clazz = item.asProgramClass();
                    if (clazz != null && clazz.hasClassInitializer()) {
                        switch (context.asReprocessClassInitializerRule().getType()) {
                            case ALWAYS: {
                                this.reprocess.add((DexMethod)clazz.getClassInitializer().getReference());
                                break;
                            }
                            case NEVER: {
                                this.neverReprocess.add((DexMethod)clazz.getClassInitializer().getReference());
                                break;
                            }
                            default: {
                                throw new Unreachable();
                            }
                        }
                        context.markAsUsed();
                    }
                } else if (context.isReprocessMethodRule()) {
                    if (item.isMethod()) {
                        DexClassAndMethod method = item.asMethod();
                        switch (context.asReprocessMethodRule().getType()) {
                            case ALWAYS: {
                                this.reprocess.add((DexMethod)method.getReference());
                                break;
                            }
                            case NEVER: {
                                this.neverReprocess.add((DexMethod)method.getReference());
                                break;
                            }
                            default: {
                                throw new Unreachable();
                            }
                        }
                        context.markAsUsed();
                    }
                } else if (context instanceof KeepConstantArgumentRule) {
                    assert (item.isProgramMethod());
                    this.dependentMinimumKeepInfo.getOrCreateUnconditionalMinimumKeepInfoFor(item.getReference()).asMethodJoiner().disallowConstantArgumentOptimization();
                    context.markAsUsed();
                } else if (context instanceof KeepUnusedArgumentRule) {
                    assert (item.isProgramMethod());
                    this.dependentMinimumKeepInfo.getOrCreateUnconditionalMinimumKeepInfoFor(item.getReference()).asMethodJoiner().disallowUnusedArgumentOptimization();
                    context.markAsUsed();
                } else if (context instanceof KeepUnusedReturnValueRule) {
                    assert (item.isProgramMethod());
                    this.dependentMinimumKeepInfo.getOrCreateUnconditionalMinimumKeepInfoFor(item.getReference()).asMethodJoiner().disallowUnusedReturnValueOptimization();
                    context.markAsUsed();
                } else {
                    throw new Unreachable();
                }
            }
        }

        private void evaluateCheckDiscardRule(DexClass clazz, ProguardCheckDiscardRule rule) {
            if (clazz.isProgramClass()) {
                this.evaluateCheckDiscardRule(clazz.asProgramClass(), rule.asProguardCheckDiscardRule());
            } else {
                StringDiagnostic warning = new StringDiagnostic("The rule `" + rule + "` matches a class not in the program.");
                this.appView.reporter().warning(warning);
            }
        }

        private synchronized void evaluateCheckDiscardRule(DexProgramClass clazz, ProguardCheckDiscardRule rule) {
            if (rule.getMemberRules().isEmpty()) {
                this.evaluateCheckDiscardClassAndAllMembersRule(clazz, rule);
            } else if (clazz.hasFields() || clazz.hasMethods()) {
                this.markMatchingFields(clazz, rule.getMemberRules(), rule, null, null);
                this.markMatchingMethods(clazz, rule.getMemberRules(), rule, null, null);
                this.classesWithCheckDiscardedMembers.add(clazz);
            }
        }

        private void evaluateCheckDiscardClassAndAllMembersRule(DexProgramClass clazz, ProguardCheckDiscardRule rule) {
            this.setCheckDiscarded(clazz);
            clazz.forEachProgramMember(this::setCheckDiscarded);
            rule.markAsUsed();
        }

        private void evaluateCheckDiscardMemberRule(ProgramMember<?, ?> member, ProguardCheckDiscardRule rule) {
            this.setCheckDiscarded(member);
            rule.markAsUsed();
        }

        private void setCheckDiscarded(ProgramDefinition definition) {
            this.dependentMinimumKeepInfo.getOrCreateUnconditionalMinimumKeepInfo().getOrCreateMinimumKeepInfoFor(definition.getReference()).setCheckDiscarded();
        }

        private void finalizeCheckDiscardedInformation() {
            MinimumKeepInfoCollection unconditionalKeepInfo = this.dependentMinimumKeepInfo.getUnconditionalMinimumKeepInfoOrDefault(MinimumKeepInfoCollection.empty());
            for (DexProgramClass clazz : this.classesWithCheckDiscardedMembers) {
                TraversalContinuation<?> continueIfAllMembersMarkedAsCheckDiscarded = clazz.traverseProgramMembers(member -> TraversalContinuation.continueIf(unconditionalKeepInfo.hasMinimumKeepInfoThatMatches(member.getReference(), KeepInfo.Joiner::isCheckDiscardedEnabled)));
                if (!continueIfAllMembersMarkedAsCheckDiscarded.shouldContinue()) continue;
                this.setCheckDiscarded(clazz);
            }
        }

        private void evaluateKeepRule(ProgramDefinition item, ProguardKeepRule context, ProguardMemberRule rule, DexProgramClass precondition, ProguardIfRule ifRule) {
            if (item.isField()) {
                ProgramField field = item.asProgramField();
                if (field.getOptimizationInfo().cannotBeKept()) {
                    assert (ifRule != null);
                    return;
                }
            } else if (item.isMethod()) {
                ProgramMethod method = item.asProgramMethod();
                if (((DexEncodedMethod)method.getDefinition()).isClassInitializer() && !this.options.debug) {
                    return;
                }
                if (method.getOptimizationInfo().cannotBeKept()) {
                    assert (ifRule != null);
                    return;
                }
                if (this.options.isGeneratingDex() && ((DexMethod)method.getReference()).isLambdaDeserializeMethod(this.appView.dexItemFactory())) {
                    return;
                }
            }
            ProguardKeepRuleBase keepRule = ifRule != null ? ifRule : context;
            ProguardKeepRuleModifiers modifiers = context.getModifiers();
            if (modifiers.isBottom()) {
                return;
            }
            if (this.options.forceProguardCompatibility && !modifiers.allowsShrinking && precondition != null && precondition.isDexClass() && !item.isClass() && !item.getAccessFlags().isStatic()) {
                this.dependentKeepClassCompatRule.computeIfAbsent(precondition.asDexClass().getType(), i -> new HashSet()).add(keepRule);
                context.markAsUsed();
            }
            EnqueuerEvent preconditionEvent = precondition != null ? (item.getAccessFlags().isStatic() || item.isMethod() && ((DexEncodedMethod)item.asMethod().getDefinition()).isInstanceInitializer() ? new EnqueuerEvent.LiveClassEnqueuerEvent(precondition) : new EnqueuerEvent.InstantiatedClassEnqueuerEvent(precondition)) : EnqueuerEvent.UnconditionalKeepInfoEvent.get();
            if (this.isInterfaceMethodNeedingDesugaring(item)) {
                ProgramMethod method = item.asMethod();
                ProgramMethod companion = this.interfaceDesugaringSyntheticHelper.ensureMethodOfProgramCompanionClassStub(method, new InterfaceMethodDesugaringBaseEventConsumer(){

                    @Override
                    public void acceptCompanionClassClinit(ProgramMethod method) {
                    }

                    @Override
                    public void acceptCompanionMethod(ProgramMethod method, ProgramMethod companion) {
                    }
                });
                this.pendingMethodMoveInverse.put(companion, method);
                if (this.appView.options().isOptimizationEnabled() && !modifiers.allowsOptimization) {
                    this.dependentMinimumKeepInfo.getOrCreateMinimumKeepInfoFor(preconditionEvent, companion.getReference()).disallowOptimization();
                    context.markAsUsed();
                }
                if (this.appView.options().isShrinking() && !modifiers.allowsShrinking) {
                    ((KeepInfo.Joiner)this.dependentMinimumKeepInfo.getOrCreateMinimumKeepInfoFor(preconditionEvent, companion.getReference()).addRule(keepRule)).disallowShrinking();
                    context.markAsUsed();
                }
                if (!item.asMethod().isDefaultMethod()) {
                    return;
                }
            }
            if (this.appView.options().isAccessModificationEnabled() && !modifiers.allowsAccessModification) {
                this.dependentMinimumKeepInfo.getOrCreateMinimumKeepInfoFor(preconditionEvent, item.getReference()).disallowAccessModification();
                context.markAsUsed();
            }
            if (this.appView.options().isAnnotationRemovalEnabled() && !modifiers.allowsAnnotationRemoval) {
                this.dependentMinimumKeepInfo.getOrCreateMinimumKeepInfoFor(preconditionEvent, item.getReference()).disallowAnnotationRemoval();
                context.markAsUsed();
            }
            if (this.appView.options().isKeepAttributesSignatureEnabled()) {
                this.dependentMinimumKeepInfo.getOrCreateMinimumKeepInfoFor(preconditionEvent, item.getReference()).disallowSignatureRemoval();
                context.markAsUsed();
            }
            if (this.appView.options().isMinificationEnabled() && !modifiers.allowsObfuscation) {
                this.dependentMinimumKeepInfo.getOrCreateMinimumKeepInfoFor(preconditionEvent, item.getReference()).disallowMinification();
                context.markAsUsed();
            }
            if (this.appView.options().isOptimizationEnabled() && !modifiers.allowsOptimization) {
                this.dependentMinimumKeepInfo.getOrCreateMinimumKeepInfoFor(preconditionEvent, item.getReference()).disallowOptimization();
                context.markAsUsed();
            }
            if ((this.appView.options().isShrinking() || this.isMainDexRootSetBuilder()) && !modifiers.allowsShrinking) {
                Object minimumKeepInfoForItem = ((KeepInfo.Joiner)this.dependentMinimumKeepInfo.getOrCreateMinimumKeepInfoFor(preconditionEvent, item.getReference()).addRule(keepRule)).disallowShrinking();
                context.markAsUsed();
                if (item.getAccessFlags().isPackagePrivateOrProtected()) {
                    ((KeepInfo.Joiner)minimumKeepInfoForItem).requireAccessModificationForRepackaging();
                }
            }
            if (modifiers.includeDescriptorClasses) {
                this.includeDescriptorClasses(item, keepRule, preconditionEvent);
                context.markAsUsed();
            }
        }

        private void evaluateIdentifierNameStringRule(Definition item, ProguardConfigurationRule context, ProguardIfRule ifRule) {
            DexClassAndField field;
            assert (!this.isMainDexRootSetBuilder());
            assert (ifRule == null);
            if (item.isClass()) {
                return;
            }
            if (item.isField() && ((DexEncodedField)(field = item.asField()).getDefinition()).getOrComputeIsInlinableByJavaC(this.appView.dexItemFactory())) {
                Reporter reporter = this.appView.reporter();
                reporter.warning(new StringDiagnostic("Rule matches the static final field `" + field.toSourceString() + "`, which may have been inlined: " + context.toString(), context.getOrigin()));
            }
            this.identifierNameStrings.add((DexMember<?, ?>)item.asMember().getReference());
            context.markAsUsed();
        }

        private boolean isInterfaceMethodNeedingDesugaring(ProgramDefinition item) {
            return this.options.isInterfaceMethodDesugaringEnabled() && item.isMethod() && item.asMethod().getHolder().isInterface() && !((DexEncodedMethod)item.asMethod().getDefinition()).isClassInitializer() && ((DexEncodedMethod)item.asMethod().getDefinition()).hasCode();
        }

        private void reportAssumeNoSideEffectsWarningForJavaLangClassMethod(DexClassAndMethod method, ProguardAssumeNoSideEffectRule context) {
            assert (method.getHolderType() == this.options.dexItemFactory().objectType);
            OriginWithPosition key = new OriginWithPosition(context.getOrigin(), context.getPosition());
            this.assumeNoSideEffectsWarnings.computeIfAbsent(key, ignore -> new TreeSet(StructuralItem::compareTo)).add((DexMethod)method.getReference());
        }

        private boolean isWaitOrNotifyMethod(DexMethod method) {
            return method.name == this.options.itemFactory.waitMethodName || method.name == this.options.itemFactory.notifyMethodName || method.name == this.options.itemFactory.notifyAllMethodName;
        }

        private void generateAssumeNoSideEffectsWarnings() {
            if (this.appView.getDontWarnConfiguration().matches(this.options.itemFactory.objectType)) {
                return;
            }
            this.assumeNoSideEffectsWarnings.forEach((originWithPosition, methods) -> {
                boolean matchesWaitOrNotifyMethods = methods.stream().anyMatch(this::isWaitOrNotifyMethod);
                if (!matchesWaitOrNotifyMethods) {
                    return;
                }
                this.options.reporter.warning(new AssumeNoSideEffectsRuleForObjectMembersDiagnostic.Builder().addMatchedMethods((Set<DexMethod>)methods).setOrigin(originWithPosition.getOrigin()).setPosition(originWithPosition.getPosition()).build());
            });
        }

        boolean isMainDexRootSetBuilder() {
            return false;
        }

        void handleMatchedAnnotation(AnnotationMatchResult annotation) {
        }

        void runPerRule(ExecutorService executorService, List<Future<?>> futures, ProguardConfigurationRule rule, ProguardIfRule ifRule) {
            List<DexType> specifics = rule.getClassNames().asSpecificDexTypes();
            if (specifics != null) {
                for (DexType type : specifics) {
                    DexClass clazz = this.application.definitionFor(type);
                    if (clazz == null) continue;
                    this.process(clazz, rule, ifRule);
                }
                return;
            }
            futures.add(executorService.submit(() -> {
                for (DexProgramClass dexProgramClass : rule.relevantCandidatesForRule(this.appView, this.subtypingInfo, this.application.classes())) {
                    this.process(dexProgramClass, rule, ifRule);
                }
                if (rule.applyToNonProgramClasses()) {
                    for (DexLibraryClass dexLibraryClass : this.application.libraryClasses()) {
                        this.process(dexLibraryClass, rule, ifRule);
                    }
                }
            }));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RootSet build(ExecutorService executorService) throws ExecutionException {
            this.application.timing.begin("Build root set...");
            try {
                ArrayList futures = new ArrayList();
                if (this.rules != null) {
                    for (ProguardConfigurationRule proguardConfigurationRule : this.rules) {
                        if (proguardConfigurationRule instanceof ProguardIfRule) {
                            ProguardIfRule ifRule = (ProguardIfRule)proguardConfigurationRule;
                            this.ifRules.add(ifRule);
                            continue;
                        }
                        this.runPerRule(executorService, futures, proguardConfigurationRule, null);
                    }
                    ThreadUtils.awaitFutures(futures);
                }
            }
            finally {
                this.application.timing.end();
            }
            this.finalizeCheckDiscardedInformation();
            this.generateAssumeNoSideEffectsWarnings();
            if (!this.noSideEffects.isEmpty() || !this.assumedValues.isEmpty()) {
                BottomUpClassHierarchyTraversal.forAllClasses(this.appView, this.subtypingInfo).visit(this.appView.appInfo().classes(), this::propagateAssumeRules);
            }
            this.appView.withGeneratedMessageLiteShrinker(shrinker -> shrinker.extendRootSet(this.dependentMinimumKeepInfo));
            if (this.appView.options().protoShrinking().enableGeneratedMessageLiteBuilderShrinking) {
                GeneratedMessageLiteBuilderShrinker.addInliningHeuristicsForBuilderInlining(this.appView, this.subtypingInfo, this.alwaysClassInline, this.noVerticalClassMerging, this.noHorizontalClassMerging, this.alwaysInline, this.bypassClinitforInlining);
            }
            return new RootSet(this.dependentMinimumKeepInfo, ImmutableList.copyOf(this.reasonAsked.values()), this.alwaysInline, this.neverInlineDueToSingleCaller, this.bypassClinitforInlining, this.whyAreYouNotInlining, this.reprocess, this.neverReprocess, this.alwaysClassInline, this.neverClassInline, this.noUnusedInterfaceRemoval, this.noVerticalClassMerging, this.noHorizontalClassMerging, this.neverPropagateValue, this.mayHaveSideEffects, this.noSideEffects, this.assumedValues, this.dependentKeepClassCompatRule, this.identifierNameStrings, this.ifRules, Lists.newArrayList(this.delayedRootSetActionItems), this.pendingMethodMoveInverse);
        }

        ConsequentRootSet buildConsequentRootSet() {
            return new ConsequentRootSet(this.neverInlineDueToSingleCaller, this.neverClassInline, this.dependentMinimumKeepInfo, this.dependentKeepClassCompatRule, Lists.newArrayList(this.delayedRootSetActionItems), this.pendingMethodMoveInverse);
        }

        boolean satisfyInheritanceRule(DexClass clazz, ProguardConfigurationRule rule) {
            if (this.satisfyExtendsRule(clazz, rule)) {
                return true;
            }
            return this.satisfyImplementsRule(clazz, rule);
        }

        boolean satisfyExtendsRule(DexClass clazz, ProguardConfigurationRule rule) {
            if (this.anySuperTypeMatchesExtendsRule(clazz.superType, rule)) {
                return true;
            }
            return this.anySourceMatchesInheritanceRuleDirectly(clazz, rule, false);
        }

        boolean anySuperTypeMatchesExtendsRule(DexType type, ProguardConfigurationRule rule) {
            while (type != null) {
                AnnotationMatchResult annotationMatchResult;
                DexClass clazz = this.application.definitionFor(type);
                if (clazz == null) {
                    return false;
                }
                if (rule.getInheritanceClassName().matches(clazz.type, this.appView) && (annotationMatchResult = RootSetBuilder.containsAllAnnotations(rule.getInheritanceAnnotations(), clazz)) != null) {
                    this.handleMatchedAnnotation(annotationMatchResult);
                    return true;
                }
                type = clazz.superType;
            }
            return false;
        }

        boolean satisfyImplementsRule(DexClass clazz, ProguardConfigurationRule rule) {
            if (this.anyImplementedInterfaceMatchesImplementsRule(clazz, rule)) {
                return true;
            }
            return this.anySourceMatchesInheritanceRuleDirectly(clazz, rule, true);
        }

        boolean ruleSatisfiedByMethods(ProguardMemberRule rule, Iterable<DexClassAndMethod> methods) {
            if (rule.getRuleType().includesMethods()) {
                for (DexClassAndMethod method : methods) {
                    if (!rule.matches(method, this.appView, this::handleMatchedAnnotation, this.dexStringCache)) continue;
                    return true;
                }
            }
            return false;
        }

        boolean ruleSatisfiedByFields(ProguardMemberRule rule, Iterable<DexClassAndField> fields) {
            if (rule.getRuleType().includesFields()) {
                for (DexClassAndField field : fields) {
                    if (!rule.matches(field, this.appView, this::handleMatchedAnnotation, this.dexStringCache)) continue;
                    return true;
                }
            }
            return false;
        }

        boolean sideEffectFreeIsRuleSatisfiedByField(ProguardMemberRule rule, DexClassAndField field) {
            return rule.matches(field, this.appView, ignore -> {}, this.dexStringCache);
        }

        private class SynthesizeMissingInterfaceMethodsForMemberRules {
            private final DexProgramClass originalClazz;
            private final Collection<ProguardMemberRule> memberKeepRules;
            private final ProguardConfigurationRule context;
            private final Map<Predicate<DexDefinition>, DexProgramClass> preconditionSupplier;
            private final ProguardIfRule ifRule;
            private final Set<Equivalence.Wrapper<DexMethod>> seenMethods = Sets.newHashSet();
            private final Set<DexType> seenTypes = Sets.newIdentityHashSet();

            private SynthesizeMissingInterfaceMethodsForMemberRules(DexProgramClass originalClazz, Collection<ProguardMemberRule> memberKeepRules, ProguardConfigurationRule context, Map<Predicate<DexDefinition>, DexProgramClass> preconditionSupplier, ProguardIfRule ifRule) {
                assert (context.isProguardKeepRule());
                assert (!context.asProguardKeepRule().getModifiers().allowsShrinking);
                this.originalClazz = originalClazz;
                this.memberKeepRules = memberKeepRules;
                this.context = context;
                this.preconditionSupplier = preconditionSupplier;
                this.ifRule = ifRule;
            }

            private void visitAllSuperInterfaces(DexType type) {
                if (type == null) {
                    return;
                }
                DexClass clazz = RootSetBuilder.this.appView.definitionFor(type);
                if (clazz == null || clazz.isNotProgramClass() || !this.seenTypes.add(type)) {
                    return;
                }
                for (DexType iface : clazz.interfaces.values) {
                    this.visitAllSuperInterfaces(iface);
                }
                if (!clazz.isInterface()) {
                    this.visitAllSuperInterfaces(clazz.superType);
                    return;
                }
                if (this.originalClazz == clazz) {
                    return;
                }
                clazz.forEachClassMethodMatching(DexEncodedMethod::belongsToVirtualPool, method -> {
                    Equivalence.Wrapper<DexMethod> wrapped = MethodSignatureEquivalence.get().wrap((DexMethod)method.getReference());
                    if (!this.seenMethods.add(wrapped)) {
                        return;
                    }
                    for (ProguardMemberRule rule : this.memberKeepRules) {
                        if (!rule.matches((DexClassAndMethod)method, (AppView<?>)RootSetBuilder.this.appView, this::handleMatchedAnnotation, RootSetBuilder.this.dexStringCache)) continue;
                        this.tryAndKeepMethodOnClass((DexClassAndMethod)method, rule);
                    }
                });
            }

            private void tryAndKeepMethodOnClass(DexClassAndMethod method, ProguardMemberRule rule) {
                MethodResolutionResult.SingleResolutionResult resolutionResult = ((AppInfoWithClassHierarchy)RootSetBuilder.this.appView.appInfo()).resolveMethodOn((DexClass)this.originalClazz, (DexMethod)method.getReference()).asSingleResolution();
                if (resolutionResult == null || !resolutionResult.isVirtualTarget()) {
                    return;
                }
                if (resolutionResult.getResolvedHolder() == this.originalClazz || resolutionResult.getResolvedHolder().isNotProgramClass()) {
                    return;
                }
                if (!resolutionResult.getResolvedHolder().isInterface()) {
                    return;
                }
                ProgramMethod resolutionMethod = new ProgramMethod(resolutionResult.getResolvedHolder().asProgramClass(), resolutionResult.getResolvedMethod());
                ProgramMethod methodToKeep = RootSetBuilder.this.canInsertForwardingMethod(this.originalClazz, (DexEncodedMethod)resolutionMethod.getDefinition()) ? new ProgramMethod(this.originalClazz, ((DexEncodedMethod)resolutionMethod.getDefinition()).toForwardingMethod(this.originalClazz, RootSetBuilder.this.appView)) : resolutionMethod;
                RootSetBuilder.this.delayedRootSetActionItems.add(new DelayedRootSetActionItem.InterfaceMethodSyntheticBridgeAction(methodToKeep, resolutionMethod, rootSetBuilder -> {
                    if (Log.ENABLED) {
                        Log.verbose(this.getClass(), "Marking method `%s` due to `%s { %s }`.", methodToKeep, this.context, rule);
                    }
                    DexProgramClass precondition = RootSetBuilder.testAndGetPrecondition(methodToKeep.getDefinition(), this.preconditionSupplier);
                    ((RootSetBuilder)rootSetBuilder).addItemToSets(methodToKeep, this.context, rule, precondition, this.ifRule);
                }));
            }

            void handleMatchedAnnotation(AnnotationMatchResult annotationMatchResult) {
            }

            void run() {
                this.visitAllSuperInterfaces(this.originalClazz.type);
            }
        }
    }
}

