/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.analysis.EnqueuerCheckCastAnalysis;
import com.android.tools.r8.graph.analysis.EnqueuerExceptionGuardAnalysis;
import com.android.tools.r8.graph.analysis.EnqueuerInstanceOfAnalysis;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.utils.SetUtils;
import java.util.Set;

public class RuntimeTypeCheckInfo {
    private final Set<DexType> instanceOfTypes;
    private final Set<DexType> checkCastTypes;
    private final Set<DexType> exceptionGuardTypes;

    public RuntimeTypeCheckInfo(Set<DexType> instanceOfTypes, Set<DexType> checkCastTypes, Set<DexType> exceptionGuardTypes) {
        this.instanceOfTypes = instanceOfTypes;
        this.checkCastTypes = checkCastTypes;
        this.exceptionGuardTypes = exceptionGuardTypes;
    }

    public boolean isCheckCastType(DexProgramClass clazz) {
        return this.checkCastTypes.contains(clazz.type);
    }

    public boolean isInstanceOfType(DexProgramClass clazz) {
        return this.instanceOfTypes.contains(clazz.type);
    }

    public boolean isExceptionGuardType(DexProgramClass clazz) {
        return this.exceptionGuardTypes.contains(clazz.type);
    }

    public boolean isRuntimeCheckType(DexProgramClass clazz) {
        return this.isInstanceOfType(clazz) || this.isCheckCastType(clazz) || this.isExceptionGuardType(clazz);
    }

    public RuntimeTypeCheckInfo rewriteWithLens(GraphLens.NonIdentityGraphLens graphLens) {
        return new RuntimeTypeCheckInfo(SetUtils.mapIdentityHashSet(this.instanceOfTypes, graphLens::lookupType), SetUtils.mapIdentityHashSet(this.checkCastTypes, graphLens::lookupType), SetUtils.mapIdentityHashSet(this.exceptionGuardTypes, graphLens::lookupType));
    }

    public static class Builder
    implements EnqueuerInstanceOfAnalysis,
    EnqueuerCheckCastAnalysis,
    EnqueuerExceptionGuardAnalysis {
        private final GraphLens appliedGraphLens;
        private final DexItemFactory factory;
        private final Set<DexType> instanceOfTypes = Sets.newIdentityHashSet();
        private final Set<DexType> checkCastTypes = Sets.newIdentityHashSet();
        private final Set<DexType> exceptionGuardTypes = Sets.newIdentityHashSet();

        public Builder(AppView<?> appView) {
            this.appliedGraphLens = appView.graphLens();
            this.factory = appView.dexItemFactory();
        }

        private void add(DexType type, Set<DexType> set) {
            DexType baseType = type.toBaseType(this.factory);
            if (baseType.isClassType()) {
                set.add(baseType);
            }
        }

        public RuntimeTypeCheckInfo build(GraphLens graphLens) {
            RuntimeTypeCheckInfo runtimeTypeCheckInfo = new RuntimeTypeCheckInfo(this.instanceOfTypes, this.checkCastTypes, this.exceptionGuardTypes);
            return graphLens.isNonIdentityLens() && graphLens != this.appliedGraphLens ? runtimeTypeCheckInfo.rewriteWithLens(graphLens.asNonIdentityLens()) : runtimeTypeCheckInfo;
        }

        @Override
        public void traceCheckCast(DexType type, ProgramMethod context) {
            this.add(type, this.checkCastTypes);
        }

        @Override
        public void traceSafeCheckCast(DexType type, ProgramMethod context) {
        }

        @Override
        public void traceInstanceOf(DexType type, ProgramMethod context) {
            this.add(type, this.instanceOfTypes);
        }

        @Override
        public void traceExceptionGuard(DexType guard, ProgramMethod context) {
            this.add(guard, this.exceptionGuardTypes);
        }

        public void attach(Enqueuer enqueuer) {
            enqueuer.registerInstanceOfAnalysis(this).registerCheckCastAnalysis(this).registerExceptionGuardAnalysis(this);
        }
    }
}

