/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.base.Equivalence;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.utils.MethodSignatureEquivalence;
import java.util.HashMap;
import java.util.Map;

class ScopedDexMethodSet {
    private static final Equivalence<DexMethod> METHOD_EQUIVALENCE = MethodSignatureEquivalence.get();
    private ScopedDexMethodSet parent;
    private final Map<Equivalence.Wrapper<DexMethod>, DexEncodedMethod> items = new HashMap<Equivalence.Wrapper<DexMethod>, DexEncodedMethod>();

    public ScopedDexMethodSet() {
        this(null);
    }

    private ScopedDexMethodSet(ScopedDexMethodSet parent) {
        this.parent = parent;
    }

    private DexEncodedMethod lookup(Equivalence.Wrapper<DexMethod> item) {
        DexEncodedMethod ownMethod = this.items.get(item);
        return ownMethod != null ? ownMethod : (this.parent != null ? this.parent.lookup(item) : null);
    }

    private boolean contains(Equivalence.Wrapper<DexMethod> item) {
        return this.lookup(item) != null;
    }

    public ScopedDexMethodSet newNestedScope() {
        return new ScopedDexMethodSet(this);
    }

    public boolean addMethod(DexEncodedMethod method) {
        Equivalence.Wrapper<DexMethod> wrapped = METHOD_EQUIVALENCE.wrap((DexMethod)method.getReference());
        if (this.contains(wrapped)) {
            return false;
        }
        this.items.put(wrapped, method);
        return true;
    }

    public AddMethodIfMoreVisibleResult addMethodIfMoreVisible(DexEncodedMethod method) {
        Equivalence.Wrapper<DexMethod> wrapped = METHOD_EQUIVALENCE.wrap((DexMethod)method.getReference());
        DexEncodedMethod existing = this.lookup(wrapped);
        if (existing == null) {
            this.items.put(wrapped, method);
            return AddMethodIfMoreVisibleResult.ADDED_NOT_EXISTING;
        }
        if (method.accessFlags.isMoreVisibleThan(existing.accessFlags, method.getHolderType().getPackageName(), existing.getHolderType().getPackageName())) {
            this.items.put(wrapped, method);
            return AddMethodIfMoreVisibleResult.ADDED_MORE_VISIBLE;
        }
        return AddMethodIfMoreVisibleResult.NOT_ADDED;
    }

    public ScopedDexMethodSet getParent() {
        return this.parent;
    }

    public void setParent(ScopedDexMethodSet parent) {
        this.parent = parent;
    }

    public static enum AddMethodIfMoreVisibleResult {
        NOT_ADDED,
        ADDED_NOT_EXISTING,
        ADDED_MORE_VISIBLE;

    }
}

