/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.utils.Pair;
import com.android.tools.r8.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

class UnusedItemsPrinter {
    private static final String INDENT = "    ";
    static final UnusedItemsPrinter DONT_PRINT = new NopPrinter();
    private final Consumer<String> consumer;
    private DexType currentType = null;
    private Members currentMembers = new Members();
    private List<Pair<DexType, Members>> classes = new ArrayList<Pair<DexType, Members>>();

    UnusedItemsPrinter(Consumer<String> consumer) {
        this.consumer = consumer;
    }

    private void append(String string) {
        this.consumer.accept(string);
    }

    private void newline() {
        this.append(StringUtils.LINE_SEPARATOR);
    }

    private void printUnusedMethod(DexEncodedMethod method) {
        this.append(INDENT);
        String accessFlags = method.accessFlags.toString();
        if (!accessFlags.isEmpty()) {
            this.append(accessFlags);
            this.append(" ");
        }
        this.append(((DexMethod)method.getReference()).proto.returnType.toSourceString());
        this.append(" ");
        this.append(((DexMethod)method.getReference()).name.toSourceString());
        this.append("(");
        for (int i = 0; i < ((DexMethod)method.getReference()).proto.parameters.values.length; ++i) {
            if (i != 0) {
                this.append(",");
            }
            this.append(((DexMethod)method.getReference()).proto.parameters.values[i].toSourceString());
        }
        this.append(")");
        this.newline();
    }

    private void printUnusedField(DexEncodedField field) {
        this.append(INDENT);
        String accessFlags = field.accessFlags.toString();
        if (!accessFlags.isEmpty()) {
            this.append(accessFlags);
            this.append(" ");
        }
        this.append(((DexField)field.getReference()).type.toSourceString());
        this.append(" ");
        this.append(((DexField)field.getReference()).name.toSourceString());
        this.newline();
    }

    void registerUnusedClass(DexProgramClass clazz) {
        assert (this.currentType == null);
        this.classes.add(new Pair<DexType, Object>(clazz.type, null));
    }

    void visiting(DexProgramClass clazz) {
        assert (this.currentType == null);
        this.currentType = clazz.type;
    }

    void visited() {
        if (this.currentMembers.hasMembers()) {
            this.classes.add(new Pair<DexType, Members>(this.currentType, this.currentMembers));
            this.currentMembers = new Members();
        }
        this.currentType = null;
    }

    void registerUnusedMethod(DexEncodedMethod method) {
        this.currentMembers.methods.add(method);
    }

    void registerUnusedField(DexEncodedField field) {
        this.currentMembers.fields.add(field);
    }

    public void finished() {
        this.classes.sort((a, b) -> ((DexType)a.getFirst()).compareTo((DexType)b.getFirst()));
        for (Pair<DexType, Members> entry : this.classes) {
            DexType type = entry.getFirst();
            Members members = entry.getSecond();
            this.consumer.accept(type.toSourceString());
            if (members == null) {
                this.consumer.accept(StringUtils.LINE_SEPARATOR);
                continue;
            }
            this.consumer.accept(":" + StringUtils.LINE_SEPARATOR);
            members.sort();
            members.fields.forEach(this::printUnusedField);
            members.methods.forEach(this::printUnusedMethod);
        }
        this.classes = null;
    }

    private static class NopPrinter
    extends UnusedItemsPrinter {
        public NopPrinter() {
            super(null);
        }

        @Override
        void registerUnusedClass(DexProgramClass clazz) {
        }

        @Override
        void visiting(DexProgramClass clazz) {
        }

        @Override
        void visited() {
        }

        @Override
        void registerUnusedMethod(DexEncodedMethod method) {
        }

        @Override
        void registerUnusedField(DexEncodedField field) {
        }

        @Override
        public void finished() {
        }
    }

    private static class Members {
        final List<DexEncodedField> fields = new ArrayList<DexEncodedField>();
        final List<DexEncodedMethod> methods = new ArrayList<DexEncodedMethod>();

        private Members() {
        }

        boolean hasMembers() {
            return !this.fields.isEmpty() || !this.methods.isEmpty();
        }

        void sort() {
            this.fields.sort((a, b) -> ((DexField)a.getReference()).compareTo((DexField)b.getReference()));
            this.methods.sort((a, b) -> ((DexMethod)a.getReference()).compareTo((DexMethod)b.getReference()));
        }
    }
}

