/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.androidapi.AndroidApiLevelCompute;
import com.android.tools.r8.androidapi.ComputedApiLevel;
import com.android.tools.r8.cf.CfVersion;
import com.android.tools.r8.com.google.common.base.Equivalence;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.com.google.common.collect.Streams;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AccessControl;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DefaultInstanceInitializerCode;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMember;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMember;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.GenericSignature;
import com.android.tools.r8.graph.GenericSignatureContextBuilder;
import com.android.tools.r8.graph.GenericSignatureCorrectnessHelper;
import com.android.tools.r8.graph.GenericSignaturePartialTypeArgumentApplier;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.LookupResult;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.graph.MethodResolutionResult;
import com.android.tools.r8.graph.ObjectAllocationInfoCollection;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.PrunedItems;
import com.android.tools.r8.graph.SubtypingInfo;
import com.android.tools.r8.graph.TopDownClassHierarchyTraversal;
import com.android.tools.r8.graph.TreeFixerBase;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.graph.UseRegistryWithResult;
import com.android.tools.r8.graph.classmerging.VerticallyMergedClasses;
import com.android.tools.r8.graph.proto.RewrittenPrototypeDescription;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.MemberPoolCollection;
import com.android.tools.r8.ir.optimize.MethodPoolCollection;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedback;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedbackSimple;
import com.android.tools.r8.ir.synthetic.AbstractSynthesizedCode;
import com.android.tools.r8.ir.synthetic.ForwardMethodSourceCode;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2IntMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2BooleanOpenHashMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import com.android.tools.r8.logging.Log;
import com.android.tools.r8.shaking.AnnotationFixer;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.shaking.KeepInfoCollection;
import com.android.tools.r8.shaking.MainDexInfo;
import com.android.tools.r8.shaking.VerticalClassMergerGraphLens;
import com.android.tools.r8.utils.AndroidApiLevelUtils;
import com.android.tools.r8.utils.Box;
import com.android.tools.r8.utils.CollectionUtils;
import com.android.tools.r8.utils.FieldSignatureEquivalence;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.MethodSignatureEquivalence;
import com.android.tools.r8.utils.OptionalBool;
import com.android.tools.r8.utils.Timing;
import com.android.tools.r8.utils.TraversalContinuation;
import com.android.tools.r8.utils.collections.BidirectionalManyToOneHashMap;
import com.android.tools.r8.utils.collections.MutableBidirectionalManyToOneMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class VerticalClassMerger {
    private final DexApplication application;
    private final AppInfoWithLiveness appInfo;
    private final AppView<AppInfoWithLiveness> appView;
    private final InternalOptions options;
    private final SubtypingInfo subtypingInfo;
    private final ExecutorService executorService;
    private final MethodPoolCollection methodPoolCollection;
    private final Timing timing;
    private Collection<DexMethod> invokes;
    private final AndroidApiLevelCompute apiLevelCompute;
    private final OptimizationFeedback feedback = OptimizationFeedbackSimple.getInstance();
    private final Set<DexProgramClass> mergeCandidates = new LinkedHashSet<DexProgramClass>();
    private final MutableBidirectionalManyToOneMap<DexType, DexType> mergedClasses = BidirectionalManyToOneHashMap.newIdentityHashMap();
    private final MutableBidirectionalManyToOneMap<DexType, DexType> mergedInterfaces = BidirectionalManyToOneHashMap.newIdentityHashMap();
    private final Set<DexType> pinnedTypes = Sets.newIdentityHashSet();
    private final VerticalClassMergerGraphLens.Builder lensBuilder;
    private final List<SynthesizedBridgeCode> synthesizedBridges = new ArrayList<SynthesizedBridgeCode>();
    private final MainDexInfo mainDexInfo;

    public VerticalClassMerger(DexApplication application, AppView<AppInfoWithLiveness> appView, ExecutorService executorService, Timing timing) {
        this.application = application;
        this.appInfo = appView.appInfo();
        this.appView = appView;
        this.options = appView.options();
        this.mainDexInfo = this.appInfo.getMainDexInfo();
        this.subtypingInfo = this.appInfo.computeSubtypingInfo();
        this.executorService = executorService;
        this.methodPoolCollection = new MethodPoolCollection(appView, this.subtypingInfo);
        this.lensBuilder = new VerticalClassMergerGraphLens.Builder(appView.dexItemFactory());
        this.apiLevelCompute = appView.apiLevelCompute();
        this.timing = timing;
        Collection<DexProgramClass> classes = application.classesWithDeterministicOrder();
        this.initializePinnedTypes(classes);
        this.initializeMergeCandidates(classes);
    }

    private void initializeMergeCandidates(Iterable<DexProgramClass> classes) {
        for (DexProgramClass sourceClass : classes) {
            DexProgramClass targetClass;
            DexType singleSubtype = this.subtypingInfo.getSingleDirectSubtype(sourceClass.type);
            if (singleSubtype == null || (targetClass = DexProgramClass.asProgramClassOrNull(this.appView.definitionFor(singleSubtype))) == null || !this.isMergeCandidate(sourceClass, targetClass, this.pinnedTypes) || !this.isStillMergeCandidate(sourceClass, targetClass) || this.mergeMayLeadToIllegalAccesses(sourceClass, targetClass)) continue;
            this.mergeCandidates.add(sourceClass);
        }
    }

    private void initializePinnedTypes(Iterable<DexProgramClass> classes) {
        ArrayList pinnedItems = new ArrayList();
        this.appInfo.getKeepInfo().forEachPinnedType(pinnedItems::add, this.options);
        this.appInfo.getKeepInfo().forEachPinnedMethod(pinnedItems::add, this.options);
        this.appInfo.getKeepInfo().forEachPinnedField(pinnedItems::add, this.options);
        this.extractPinnedItems(pinnedItems, AbortReason.PINNED_SOURCE);
        for (DexProgramClass clazz : classes) {
            for (DexEncodedMethod method : clazz.methods()) {
                if (!method.accessFlags.isNative()) continue;
                this.markTypeAsPinned(clazz.type, AbortReason.NATIVE_METHOD);
            }
        }
        for (DexMethod signature : this.appInfo.getVirtualMethodsTargetedByInvokeDirect()) {
            this.markTypeAsPinned(signature.holder, AbortReason.UNHANDLED_INVOKE_DIRECT);
        }
        this.extractPinnedItems(this.appInfo.getFailedMethodResolutionTargets(), AbortReason.RESOLUTION_FOR_METHODS_MAY_CHANGE);
    }

    private <T extends DexReference> void extractPinnedItems(Iterable<T> items, AbortReason reason) {
        for (DexReference item : items) {
            if (item.isDexType()) {
                this.markTypeAsPinned(item.asDexType(), reason);
                continue;
            }
            if (item.isDexField()) {
                DexField field = item.asDexField();
                this.markTypeAsPinned(field.holder, reason);
                this.markTypeAsPinned(field.type, reason);
                continue;
            }
            assert (item.isDexMethod());
            DexMethod method = item.asDexMethod();
            this.markTypeAsPinned(method.holder, reason);
            this.markTypeAsPinned(method.proto.returnType, reason);
            for (DexType parameterType : method.proto.parameters.values) {
                this.markTypeAsPinned(parameterType, reason);
            }
        }
    }

    private void markTypeAsPinned(DexType type, AbortReason reason) {
        DexType baseType = type.toBaseType(this.appView.dexItemFactory());
        if (!baseType.isClassType() || this.appInfo.isPinned(baseType)) {
            return;
        }
        DexClass clazz = this.appInfo.definitionFor(baseType);
        if (clazz != null && clazz.isProgramClass()) {
            this.pinnedTypes.add(baseType);
        }
    }

    private boolean isMergeCandidate(DexProgramClass sourceClass, DexProgramClass targetClass, Set<DexType> pinnedTypes) {
        TraversalContinuation<?> result;
        assert (targetClass != null);
        ObjectAllocationInfoCollection allocationInfo = this.appInfo.getObjectAllocationInfoCollection();
        if (allocationInfo.isInstantiatedDirectly(sourceClass) || allocationInfo.isInterfaceWithUnknownSubtypeHierarchy(sourceClass) || allocationInfo.isImmediateInterfaceOfInstantiatedLambda(sourceClass) || this.appInfo.isPinned(sourceClass.type) || pinnedTypes.contains(sourceClass.type) || this.appInfo.isNoVerticalClassMergingOfType(sourceClass.type)) {
            return false;
        }
        assert (Streams.stream(Iterables.concat(sourceClass.fields(), sourceClass.methods())).map(DexEncodedMember::getReference).noneMatch(this.appInfo::isPinned));
        if (!this.appInfo.getClassToFeatureSplitMap().isInSameFeatureOrBothInSameBase(sourceClass, targetClass, this.appView.getSyntheticItems())) {
            return false;
        }
        if (this.appView.appServices().allServiceTypes().contains(sourceClass.type) && this.appInfo.isPinned(targetClass.type)) {
            if (Log.ENABLED) {
                AbortReason.SERVICE_LOADER.printLogMessageForClass(sourceClass);
            }
            return false;
        }
        if (sourceClass.isAnnotation()) {
            return false;
        }
        if (!sourceClass.isInterface() && targetClass.isSerializable(this.appView) && !this.appInfo.isSerializable(sourceClass.type)) {
            return false;
        }
        if (!Iterables.isEmpty(targetClass.programInstanceInitializers()) && (result = sourceClass.traverseProgramInstanceInitializers(method -> {
            AbortReason reason = this.disallowInlining((ProgramMethod)method, targetClass);
            if (reason != null) {
                if (Log.ENABLED) {
                    reason.printLogMessageForClass(sourceClass);
                }
                return TraversalContinuation.doBreak();
            }
            return TraversalContinuation.doContinue();
        })).shouldBreak()) {
            return false;
        }
        if (sourceClass.getEnclosingMethodAttribute() != null || !sourceClass.getInnerClasses().isEmpty()) {
            if (Log.ENABLED) {
                AbortReason.UNSUPPORTED_ATTRIBUTES.printLogMessageForClass(sourceClass);
            }
            return false;
        }
        if (targetClass.getNestHost() != sourceClass.getNestHost()) {
            if (Log.ENABLED) {
                AbortReason.MERGE_ACROSS_NESTS.printLogMessageForClass(sourceClass);
            }
            return false;
        }
        return !sourceClass.isInterface() || targetClass.isInterface() || !(result = sourceClass.traverseProgramMethods(method -> {
            boolean foundInvokeSpecialToDefaultLibraryMethod = method.registerCodeReferencesWithResult(new InvokeSpecialToDefaultLibraryMethodUseRegistry(this.appView, (ProgramMethod)method));
            return TraversalContinuation.breakIf(foundInvokeSpecialToDefaultLibraryMethod);
        })).shouldBreak();
    }

    private boolean isStillMergeCandidate(DexProgramClass sourceClass, DexProgramClass targetClass) {
        ComputedApiLevel targetApiLevel;
        ComputedApiLevel sourceApiLevel;
        boolean targetCanBeSynchronizedOn;
        assert (this.isMergeCandidate(sourceClass, targetClass, this.pinnedTypes));
        if (this.mergedClasses.containsValue(sourceClass.getType())) {
            if (Log.ENABLED) {
                AbortReason.ALREADY_MERGED.printLogMessageForClass(sourceClass);
            }
            return false;
        }
        if (sourceClass.hasClassInitializer() && targetClass.hasClassInitializer() || targetClass.classInitializationMayHaveSideEffects(this.appView, type -> type == sourceClass.type) || sourceClass.isInterface() && sourceClass.classInitializationMayHaveSideEffects(this.appView)) {
            if (Log.ENABLED) {
                AbortReason.STATIC_INITIALIZERS.printLogMessageForClass(sourceClass);
            }
            return false;
        }
        boolean sourceCanBeSynchronizedOn = this.appView.appInfo().isLockCandidate(sourceClass.type) || sourceClass.hasStaticSynchronizedMethods();
        boolean bl = targetCanBeSynchronizedOn = this.appView.appInfo().isLockCandidate(targetClass.type) || targetClass.hasStaticSynchronizedMethods();
        if (sourceCanBeSynchronizedOn && targetCanBeSynchronizedOn) {
            if (Log.ENABLED) {
                AbortReason.SOURCE_AND_TARGET_LOCK_CANDIDATES.printLogMessageForClass(sourceClass);
            }
            return false;
        }
        if (targetClass.getEnclosingMethodAttribute() != null || !targetClass.getInnerClasses().isEmpty()) {
            if (Log.ENABLED) {
                AbortReason.UNSUPPORTED_ATTRIBUTES.printLogMessageForClass(sourceClass);
            }
            return false;
        }
        if (this.methodResolutionMayChange(sourceClass, targetClass)) {
            if (Log.ENABLED) {
                AbortReason.RESOLUTION_FOR_METHODS_MAY_CHANGE.printLogMessageForClass(sourceClass);
            }
            return false;
        }
        if (this.fieldResolutionMayChange(sourceClass, targetClass)) {
            if (Log.ENABLED) {
                AbortReason.RESOLUTION_FOR_FIELDS_MAY_CHANGE.printLogMessageForClass(sourceClass);
            }
            return false;
        }
        if (this.appView.options().apiModelingOptions().enableApiCallerIdentification && !(sourceApiLevel = AndroidApiLevelUtils.getApiReferenceLevelForMerging(this.appView, this.apiLevelCompute, sourceClass)).equals(targetApiLevel = AndroidApiLevelUtils.getApiReferenceLevelForMerging(this.appView, this.apiLevelCompute, targetClass))) {
            if (Log.ENABLED) {
                AbortReason.API_REFERENCE_LEVEL.printLogMessageForClass(sourceClass);
            }
            return false;
        }
        return true;
    }

    private boolean mergeMayLeadToIllegalAccesses(DexProgramClass source, DexProgramClass target) {
        if (source.type.isSamePackage(target.type)) {
            int accessLevel;
            int n = source.isPrivate() ? 0 : (accessLevel = source.isPublic() ? 2 : 1);
            int otherAccessLevel = target.isPrivate() ? 0 : (target.isPublic() ? 2 : 1);
            return accessLevel > otherAccessLevel;
        }
        if (!target.isPublic()) {
            return true;
        }
        for (DexEncodedField field : source.fields()) {
            if (field.isPublic() || field.isPrivate()) continue;
            return true;
        }
        for (DexEncodedMethod method2 : source.methods()) {
            DexEncodedMethod targetOverride;
            if (!method2.isPublic() && !method2.isPrivate()) {
                return true;
            }
            if (!method2.isPublic() || (targetOverride = target.lookupVirtualMethod((DexMethod)method2.getReference())) == null || targetOverride.isPublic()) continue;
            return true;
        }
        TraversalContinuation<?> result = source.traverseProgramMethods(method -> {
            boolean foundIllegalAccess = method.registerCodeReferencesWithResult(new IllegalAccessDetector((AppView<? extends AppInfoWithClassHierarchy>)this.appView, (ProgramMethod)method));
            if (foundIllegalAccess) {
                return TraversalContinuation.doBreak();
            }
            return TraversalContinuation.doContinue();
        });
        return result.shouldBreak();
    }

    private Collection<DexMethod> getInvokes() {
        if (this.invokes == null) {
            this.invokes = new OverloadedMethodSignaturesRetriever().get();
        }
        return this.invokes;
    }

    private boolean verifyGraphLens(VerticalClassMergerGraphLens graphLens) {
        assert (graphLens.assertPinnedNotModified(this.appInfo.getKeepInfo(), this.options));
        for (DexProgramClass clazz : this.appInfo.classes()) {
            for (DexEncodedMethod encodedMethod : clazz.methods()) {
                DexMethod method = (DexMethod)encodedMethod.getReference();
                DexMethod originalMethod = graphLens.getOriginalMethodSignature(method);
                DexMethod renamedMethod = graphLens.getRenamedMethodSignature(originalMethod);
                if (encodedMethod.hasCode() && encodedMethod.getCode() instanceof SynthesizedBridgeCode) {
                    DexMethod implementationMethod = ((SynthesizedBridgeCode)encodedMethod.getCode()).invocationTarget;
                    DexMethod originalImplementationMethod = graphLens.getOriginalMethodSignature(implementationMethod);
                    assert (originalMethod == originalImplementationMethod);
                    assert (implementationMethod == renamedMethod);
                } else assert (method == renamedMethod);
                assert (!this.mergedClasses.containsKey(method.proto.returnType));
                if ($assertionsDisabled) continue;
                if (!Arrays.stream(method.proto.parameters.values).noneMatch(this.mergedClasses::containsKey)) {
                    throw new AssertionError();
                }
            }
        }
        return true;
    }

    private boolean methodResolutionMayChange(DexProgramClass source, DexProgramClass target) {
        for (DexEncodedMethod virtualSourceMethod : source.virtualMethods()) {
            DexEncodedMethod directTargetMethod = target.lookupDirectMethod((DexMethod)virtualSourceMethod.getReference());
            if (directTargetMethod == null) continue;
            return true;
        }
        if (source.isInterface() && !target.isInterface()) {
            ArrayList<DexEncodedMethod> defaultMethods = new ArrayList<DexEncodedMethod>();
            for (DexEncodedMethod virtualMethod : source.virtualMethods()) {
                if (virtualMethod.accessFlags.isAbstract()) continue;
                defaultMethods.add(virtualMethod);
            }
            for (DexEncodedMethod method : defaultMethods) {
                LookupResult.LookupResultSuccess lookupResult = this.appInfo.resolveMethodOnInterface(method.getHolderType(), (DexMethod)method.getReference()).lookupVirtualDispatchTargets(target, this.appInfo).asLookupResultSuccess();
                assert (lookupResult != null);
                if (lookupResult == null) {
                    return true;
                }
                if (!lookupResult.contains(method)) continue;
                Box<Boolean> found = new Box<Boolean>(false);
                lookupResult.forEach(interfaceTarget -> {
                    if (interfaceTarget.getDefinition() == method) {
                        return;
                    }
                    DexClass enclosingClass = interfaceTarget.getHolder();
                    if (enclosingClass != null && enclosingClass.isInterface()) {
                        found.set(true);
                    }
                }, lambdaTarget -> {
                    assert (false);
                });
                if (!found.get().booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    private void mergeClassIfPossible(DexProgramClass clazz) {
        boolean merged;
        boolean clazzOrTargetClassHasBeenMerged;
        if (!this.mergeCandidates.contains(clazz)) {
            return;
        }
        DexType singleSubtype = this.subtypingInfo.getSingleDirectSubtype(clazz.type);
        DexProgramClass targetClass = this.appView.definitionFor(singleSubtype).asProgramClass();
        assert (this.isMergeCandidate(clazz, targetClass, this.pinnedTypes));
        assert (!this.mergedClasses.containsKey(targetClass.type));
        boolean bl = clazzOrTargetClassHasBeenMerged = this.mergedClasses.containsValue(clazz.type) || this.mergedClasses.containsValue(targetClass.type);
        if (clazzOrTargetClassHasBeenMerged) {
            if (!this.isStillMergeCandidate(clazz, targetClass)) {
                return;
            }
        } else assert (this.isStillMergeCandidate(clazz, targetClass));
        if (new CollisionDetector(clazz.type, targetClass.type).mayCollide()) {
            if (Log.ENABLED) {
                AbortReason.CONFLICT.printLogMessageForClass(clazz);
            }
            return;
        }
        if (!this.mainDexInfo.canMerge(clazz, targetClass, this.appView.getSyntheticItems())) {
            return;
        }
        ClassMerger merger = new ClassMerger(clazz, targetClass);
        try {
            merged = merger.merge();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        if (merged) {
            this.lensBuilder.merge(merger.getRenamings());
            this.synthesizedBridges.addAll(merger.getSynthesizedBridges());
        }
        if (Log.ENABLED) {
            if (merged) {
                Log.info(this.getClass(), "Merged class %s into %s.", clazz.toSourceString(), targetClass.toSourceString());
            } else {
                Log.info(this.getClass(), "Aborted merge for class %s into %s.", clazz.toSourceString(), targetClass.toSourceString());
            }
        }
    }

    private boolean fieldResolutionMayChange(DexClass source, DexClass target) {
        if (source.type == target.superType) {
            FieldSignatureEquivalence equivalence = FieldSignatureEquivalence.get();
            HashSet<Equivalence.Wrapper<DexField>> staticFieldsInInterfacesOfTarget = new HashSet<Equivalence.Wrapper<DexField>>();
            for (DexType interfaceType : target.interfaces.values) {
                DexClass clazz = this.appInfo.definitionFor(interfaceType);
                for (DexEncodedField staticField : clazz.staticFields()) {
                    staticFieldsInInterfacesOfTarget.add(equivalence.wrap((DexField)staticField.getReference()));
                }
            }
            for (DexEncodedField instanceField : source.instanceFields()) {
                if (!staticFieldsInInterfacesOfTarget.contains(equivalence.wrap((DexField)instanceField.getReference()))) continue;
                return true;
            }
        }
        return false;
    }

    private static void makePrivate(DexEncodedMethod method) {
        assert (!method.accessFlags.isAbstract());
        method.accessFlags.unsetPublic();
        method.accessFlags.unsetProtected();
        method.accessFlags.setPrivate();
    }

    private static void makePublic(DexEncodedMethod method) {
        MethodAccessFlags accessFlags = method.getAccessFlags();
        assert (!accessFlags.isAbstract());
        accessFlags.unsetPrivate();
        accessFlags.unsetProtected();
        accessFlags.setPublic();
    }

    private AbortReason disallowInlining(ProgramMethod method, DexProgramClass context) {
        if (this.appView.options().inlinerOptions().enableInlining) {
            Code code = ((DexEncodedMethod)method.getDefinition()).getCode();
            if (code.isCfCode()) {
                CfCode cfCode = code.asCfCode();
                Inliner.ConstraintWithTarget constraint = cfCode.computeInliningConstraint(method, this.appView, new SingleTypeMapperGraphLens(method.getHolderType(), context), context.programInstanceInitializers().iterator().next());
                if (constraint == Inliner.ConstraintWithTarget.NEVER) {
                    return AbortReason.UNSAFE_INLINING;
                }
                if (this.mainDexInfo.disallowInliningIntoContext(this.appView, context, method, this.appView.getSyntheticItems())) {
                    return AbortReason.MAIN_DEX_ROOT_OUTSIDE_REFERENCE;
                }
                return null;
            }
            if (code.isDefaultInstanceInitializerCode()) {
                return null;
            }
        }
        return AbortReason.UNSAFE_INLINING;
    }

    static /* synthetic */ Collection access$1800(VerticalClassMerger x0) {
        return x0.getInvokes();
    }

    public VerticalClassMergerGraphLens run() {
        this.timing.begin("merge");
        TopDownClassHierarchyTraversal.forProgramClasses(this.appView).visit(this.mergeCandidates, this::mergeClassIfPossible);
        if (Log.ENABLED) {
            Log.debug(this.getClass(), "Merged %d classes.", this.mergedClasses.keySet().size());
        }
        this.timing.end();
        VerticallyMergedClasses verticallyMergedClasses = new VerticallyMergedClasses(this.mergedClasses, this.mergedInterfaces);
        this.appView.setVerticallyMergedClasses(verticallyMergedClasses);
        if (verticallyMergedClasses.isEmpty()) {
            return null;
        }
        this.timing.begin("fixup");
        VerticalClassMergerGraphLens lens = new VerticalClassMergerTreeFixer(this.appView, this.lensBuilder, verticallyMergedClasses, this.synthesizedBridges).fixupTypeReferences();
        KeepInfoCollection keepInfo = this.appView.getKeepInfo();
        keepInfo.mutate(mutator -> mutator.removeKeepInfoForMergedClasses(PrunedItems.builder().setRemovedClasses(this.mergedClasses.keySet()).build()));
        this.timing.end();
        assert (lens != null);
        assert (this.verifyGraphLens(lens));
        this.appView.rewriteWithLens(lens);
        keepInfo.mutate(mutator -> {
            for (SynthesizedBridgeCode synthesizedBridge : this.synthesizedBridges) {
                ProgramMethod bridge = DexClassAndMethod.asProgramMethodOrNull(this.appView.definitionFor(synthesizedBridge.method));
                ProgramMethod target = DexClassAndMethod.asProgramMethodOrNull(this.appView.definitionFor(synthesizedBridge.invocationTarget));
                if (bridge != null && target != null) {
                    mutator.joinMethod(bridge, info -> info.merge(this.appView.getKeepInfo(target).joiner()));
                    continue;
                }
                assert (false);
            }
        });
        return lens;
    }

    public Collection<DexType> getRemovedClasses() {
        return Collections.unmodifiableCollection(this.mergedClasses.keySet());
    }

    protected static class SynthesizedBridgeCode
    extends AbstractSynthesizedCode {
        private DexMethod method;
        private DexMethod originalMethod;
        private DexMethod invocationTarget;
        private Invoke.Type type;
        private final boolean isInterface;

        public SynthesizedBridgeCode(DexMethod method, DexMethod originalMethod, DexMethod invocationTarget, Invoke.Type type, boolean isInterface) {
            this.method = method;
            this.originalMethod = originalMethod;
            this.invocationTarget = invocationTarget;
            this.type = type;
            this.isInterface = isInterface;
        }

        public void updateMethodSignatures(Function<DexMethod, DexMethod> transformer) {
            this.method = transformer.apply(this.method);
            this.invocationTarget = transformer.apply(this.invocationTarget);
        }

        @Override
        public AbstractSynthesizedCode.SourceCodeProvider getSourceCodeProvider() {
            ForwardMethodSourceCode.Builder forwardSourceCodeBuilder = ForwardMethodSourceCode.builder(this.method);
            forwardSourceCodeBuilder.setReceiver(this.method.holder).setOriginalMethod(this.originalMethod).setTargetReceiver(this.type.isStatic() ? null : this.method.holder).setTarget(this.invocationTarget).setInvokeType(this.type).setIsInterface(this.isInterface);
            return forwardSourceCodeBuilder::build;
        }

        @Override
        public Consumer<UseRegistry> getRegistryCallback(DexClassAndMethod method) {
            return registry -> {
                assert (registry.getTraversalContinuation().shouldContinue());
                switch (this.type) {
                    case DIRECT: {
                        registry.registerInvokeDirect(this.invocationTarget);
                        break;
                    }
                    case STATIC: {
                        registry.registerInvokeStatic(this.invocationTarget);
                        break;
                    }
                    case VIRTUAL: {
                        registry.registerInvokeVirtual(this.invocationTarget);
                        break;
                    }
                    default: {
                        throw new Unreachable("Unexpected invocation type: " + (Object)((Object)this.type));
                    }
                }
            };
        }
    }

    public static class InvokeSpecialToDefaultLibraryMethodUseRegistry
    extends UseRegistryWithResult<Boolean, ProgramMethod> {
        InvokeSpecialToDefaultLibraryMethodUseRegistry(AppView<AppInfoWithLiveness> appView, ProgramMethod context) {
            super(appView, context, false);
            assert (context.getHolder().isInterface());
        }

        @Override
        public void registerInvokeSpecial(DexMethod method) {
            ProgramMethod context = (ProgramMethod)this.getContext();
            if (method.getHolderType() != context.getHolderType()) {
                return;
            }
            DexEncodedMethod definition = context.getHolder().lookupMethod(method);
            if (definition != null && definition.belongsToVirtualPool()) {
                this.setResult(true);
            }
        }

        @Override
        public void registerInitClass(DexType type) {
        }

        @Override
        public void registerInvokeDirect(DexMethod method) {
        }

        @Override
        public void registerInvokeInterface(DexMethod method) {
        }

        @Override
        public void registerInvokeStatic(DexMethod method) {
        }

        @Override
        public void registerInvokeSuper(DexMethod method) {
        }

        @Override
        public void registerInvokeVirtual(DexMethod method) {
        }

        @Override
        public void registerInstanceFieldRead(DexField field) {
        }

        @Override
        public void registerInstanceFieldWrite(DexField field) {
        }

        @Override
        public void registerStaticFieldRead(DexField field) {
        }

        @Override
        public void registerStaticFieldWrite(DexField field) {
        }

        @Override
        public void registerTypeReference(DexType type) {
        }
    }

    public static class IllegalAccessDetector
    extends UseRegistryWithResult<Boolean, ProgramMethod> {
        private final AppView<? extends AppInfoWithClassHierarchy> appView;

        public IllegalAccessDetector(AppView<? extends AppInfoWithClassHierarchy> appView, ProgramMethod context) {
            super(appView, context, false);
            this.appView = appView;
        }

        private boolean checkFieldReference(DexField field) {
            DexType baseType = this.appView.graphLens().lookupType(field.holder.toBaseType(this.appView.dexItemFactory()));
            if (baseType.isClassType() && baseType.isSamePackage(((ProgramMethod)this.getContext()).getHolderType())) {
                if (this.checkTypeReference(field.holder) || this.checkTypeReference(field.type)) {
                    return true;
                }
                DexEncodedField definition = this.appView.appInfo().resolveField(field).getResolvedField();
                if (definition == null || !definition.accessFlags.isPublic()) {
                    this.setResult(true);
                    return true;
                }
            }
            return false;
        }

        private boolean checkMethodReference(DexMethod method, OptionalBool isInterface) {
            DexType baseType = this.appView.graphLens().lookupType(method.holder.toBaseType(this.appView.dexItemFactory()));
            if (baseType.isClassType() && baseType.isSamePackage(((ProgramMethod)this.getContext()).getHolderType())) {
                MethodResolutionResult resolutionResult;
                if (this.checkTypeReference(method.holder) || this.checkTypeReference(method.proto.returnType) || Iterables.any(method.getParameters(), this::checkTypeReference)) {
                    return true;
                }
                MethodResolutionResult methodResolutionResult = resolutionResult = isInterface.isUnknown() ? this.appView.appInfo().unsafeResolveMethodDueToDexFormat(method) : this.appView.appInfo().resolveMethod(method, isInterface.isTrue());
                if (!resolutionResult.isSingleResolution() || !resolutionResult.asSingleResolution().getResolvedMethod().isPublic()) {
                    this.setResult(true);
                    return true;
                }
            }
            return false;
        }

        private boolean checkTypeReference(DexType type) {
            DexClass clazz;
            DexType baseType = this.appView.graphLens().lookupType(type.toBaseType(this.appView.dexItemFactory()));
            if (baseType.isClassType() && baseType.isSamePackage(((ProgramMethod)this.getContext()).getHolderType()) && ((clazz = this.appView.definitionFor(baseType)) == null || !clazz.accessFlags.isPublic())) {
                this.setResult(true);
                return true;
            }
            return false;
        }

        @Override
        public void registerInitClass(DexType clazz) {
            this.checkTypeReference(clazz);
        }

        @Override
        public void registerInvokeVirtual(DexMethod method) {
            GraphLens.MethodLookupResult lookup = this.appView.graphLens().lookupMethod(method, (DexMethod)((ProgramMethod)this.getContext()).getReference(), Invoke.Type.VIRTUAL);
            this.checkMethodReference((DexMethod)lookup.getReference(), OptionalBool.FALSE);
        }

        @Override
        public void registerInvokeDirect(DexMethod method) {
            GraphLens.MethodLookupResult lookup = this.appView.graphLens().lookupMethod(method, (DexMethod)((ProgramMethod)this.getContext()).getReference(), Invoke.Type.DIRECT);
            this.checkMethodReference((DexMethod)lookup.getReference(), OptionalBool.UNKNOWN);
        }

        @Override
        public void registerInvokeStatic(DexMethod method) {
            GraphLens.MethodLookupResult lookup = this.appView.graphLens().lookupMethod(method, (DexMethod)((ProgramMethod)this.getContext()).getReference(), Invoke.Type.STATIC);
            this.checkMethodReference((DexMethod)lookup.getReference(), OptionalBool.UNKNOWN);
        }

        @Override
        public void registerInvokeInterface(DexMethod method) {
            GraphLens.MethodLookupResult lookup = this.appView.graphLens().lookupMethod(method, (DexMethod)((ProgramMethod)this.getContext()).getReference(), Invoke.Type.INTERFACE);
            this.checkMethodReference((DexMethod)lookup.getReference(), OptionalBool.TRUE);
        }

        @Override
        public void registerInvokeSuper(DexMethod method) {
            GraphLens.MethodLookupResult lookup = this.appView.graphLens().lookupMethod(method, (DexMethod)((ProgramMethod)this.getContext()).getReference(), Invoke.Type.SUPER);
            this.checkMethodReference((DexMethod)lookup.getReference(), OptionalBool.UNKNOWN);
        }

        @Override
        public void registerInstanceFieldWrite(DexField field) {
            this.checkFieldReference(this.appView.graphLens().lookupField(field));
        }

        @Override
        public void registerInstanceFieldRead(DexField field) {
            this.checkFieldReference(this.appView.graphLens().lookupField(field));
        }

        @Override
        public void registerNewInstance(DexType type) {
            this.checkTypeReference(type);
        }

        @Override
        public void registerStaticFieldRead(DexField field) {
            this.checkFieldReference(this.appView.graphLens().lookupField(field));
        }

        @Override
        public void registerStaticFieldWrite(DexField field) {
            this.checkFieldReference(this.appView.graphLens().lookupField(field));
        }

        @Override
        public void registerTypeReference(DexType type) {
            this.checkTypeReference(type);
        }

        @Override
        public void registerInstanceOf(DexType type) {
            this.checkTypeReference(type);
        }
    }

    public class SingleTypeMapperGraphLens
    extends GraphLens.NonIdentityGraphLens {
        private final DexType source;
        private final DexProgramClass target;

        public SingleTypeMapperGraphLens(DexType source, DexProgramClass target) {
            super(VerticalClassMerger.this.appView.dexItemFactory(), GraphLens.getIdentityLens());
            this.source = source;
            this.target = target;
        }

        @Override
        public DexType getOriginalType(DexType type) {
            throw new Unreachable();
        }

        @Override
        public Iterable<DexType> getOriginalTypes(DexType type) {
            throw new Unreachable();
        }

        @Override
        public DexField getOriginalFieldSignature(DexField field) {
            throw new Unreachable();
        }

        @Override
        public DexField getRenamedFieldSignature(DexField originalField, GraphLens codeLens) {
            throw new Unreachable();
        }

        @Override
        public DexMethod getRenamedMethodSignature(DexMethod originalMethod, GraphLens applied) {
            throw new Unreachable();
        }

        @Override
        public final DexType internalDescribeLookupClassType(DexType previous) {
            return previous == this.source ? this.target.type : VerticalClassMerger.this.mergedClasses.getOrDefault(previous, previous);
        }

        @Override
        public DexMethod getPreviousMethodSignature(DexMethod method) {
            throw new Unreachable();
        }

        @Override
        public DexMethod getNextMethodSignature(DexMethod method) {
            throw new Unreachable();
        }

        @Override
        public GraphLens.MethodLookupResult lookupMethod(DexMethod method, DexMethod context, Invoke.Type type, GraphLens codeLens) {
            DexClass clazz;
            GraphLens.MethodLookupResult lookup = VerticalClassMerger.this.appView.graphLens().lookupMethod(method, context, type, codeLens);
            DexMethod newMethod = ((VerticalClassMerger)VerticalClassMerger.this).lensBuilder.methodMap.get(lookup.getReference());
            if (newMethod == null) {
                return lookup;
            }
            GraphLens.MethodLookupResult.Builder methodLookupResultBuilder = ((GraphLens.MethodLookupResult.Builder)GraphLens.MethodLookupResult.builder(this).setReference(newMethod)).setPrototypeChanges(lookup.getPrototypeChanges()).setType(lookup.getType());
            if (lookup.getType() == Invoke.Type.INTERFACE && (clazz = VerticalClassMerger.this.appInfo.definitionFor(newMethod.holder)) != null && !clazz.accessFlags.isInterface()) {
                assert (((VerticalClassMerger)VerticalClassMerger.this).appInfo.definitionFor((DexType)method.holder).accessFlags.isInterface());
                methodLookupResultBuilder.setType(Invoke.Type.VIRTUAL);
            }
            return methodLookupResultBuilder.build();
        }

        @Override
        protected GraphLens.MethodLookupResult internalDescribeLookupMethod(GraphLens.MethodLookupResult previous, DexMethod context) {
            throw new Unreachable();
        }

        @Override
        public RewrittenPrototypeDescription lookupPrototypeChangesForMethodDefinition(DexMethod method, GraphLens codeLens) {
            throw new Unreachable();
        }

        @Override
        public DexField lookupField(DexField field, GraphLens codeLens) {
            return ((VerticalClassMerger)VerticalClassMerger.this).lensBuilder.fieldMap.getOrDefault(field, field);
        }

        @Override
        protected GraphLens.FieldLookupResult internalDescribeLookupField(GraphLens.FieldLookupResult previous) {
            throw new Unreachable();
        }

        @Override
        public boolean isContextFreeForMethods() {
            return true;
        }
    }

    private class CollisionDetector {
        private static final int NOT_FOUND = Integer.MIN_VALUE;
        private final Map<DexString, Int2IntMap> seenPositions = new IdentityHashMap<DexString, Int2IntMap>();
        private final Reference2IntMap<DexProto> targetProtoCache;
        private final Reference2IntMap<DexProto> sourceProtoCache;
        private final DexType source;
        private final DexType target;
        private final Collection<DexMethod> invokes = VerticalClassMerger.access$1800(VerticalClassMerger.this);

        private CollisionDetector(DexType source, DexType target) {
            this.source = source;
            this.target = target;
            this.targetProtoCache = new Reference2IntOpenHashMap<DexProto>(this.invokes.size() / 2);
            this.targetProtoCache.defaultReturnValue(Integer.MIN_VALUE);
            this.sourceProtoCache = new Reference2IntOpenHashMap<DexProto>(this.invokes.size() / 2);
            this.sourceProtoCache.defaultReturnValue(Integer.MIN_VALUE);
        }

        private void fillSeenPositions() {
            for (DexMethod method : this.invokes) {
                DexType[] parameters = method.proto.parameters.values;
                int arity = parameters.length;
                int positions = this.computePositionsFor(method.proto, this.target, this.targetProtoCache);
                if (positions == 0) continue;
                Int2IntMap positionsMap = this.seenPositions.computeIfAbsent(method.name, k -> {
                    Int2IntOpenHashMap result = new Int2IntOpenHashMap();
                    result.defaultReturnValue(Integer.MIN_VALUE);
                    return result;
                });
                int value = 0;
                int previous = positionsMap.get(arity);
                if (previous != Integer.MIN_VALUE) {
                    value = previous;
                }
                positionsMap.put(arity, value |= positions);
            }
        }

        private int computePositionsFor(DexProto proto, DexType type, Reference2IntMap<DexProto> cache) {
            int result = cache.getInt(proto);
            if (result != Integer.MIN_VALUE) {
                return result;
            }
            result = 0;
            int bitsUsed = 0;
            int accumulator = 0;
            for (DexType parameterType : proto.parameters.values) {
                DexType parameterBaseType = parameterType.toBaseType(VerticalClassMerger.this.appView.dexItemFactory());
                DexType mappedType = VerticalClassMerger.this.mergedClasses.getOrDefault(parameterBaseType, parameterBaseType);
                accumulator <<= 1;
                ++bitsUsed;
                if (mappedType == type) {
                    accumulator |= 1;
                }
                if (bitsUsed != 31) continue;
                result |= accumulator;
                accumulator = 0;
                bitsUsed = 0;
            }
            DexType returnBaseType = proto.returnType.toBaseType(VerticalClassMerger.this.appView.dexItemFactory());
            DexType mappedReturnType = VerticalClassMerger.this.mergedClasses.getOrDefault(returnBaseType, returnBaseType);
            accumulator <<= 1;
            if (mappedReturnType == type) {
                accumulator |= 1;
            }
            cache.put(proto, result |= accumulator);
            return result;
        }

        boolean mayCollide() {
            VerticalClassMerger.this.timing.begin("collision detection");
            this.fillSeenPositions();
            boolean result = false;
            if (!this.seenPositions.isEmpty()) {
                for (DexMethod method : this.invokes) {
                    int arity;
                    int previous;
                    Int2IntMap positionsMap = this.seenPositions.get(method.name);
                    if (positionsMap == null || (previous = positionsMap.get(arity = method.getArity())) == Integer.MIN_VALUE) continue;
                    assert (previous != 0);
                    int positions = this.computePositionsFor(method.proto, this.source, this.sourceProtoCache);
                    if ((positions & previous) == 0) continue;
                    result = true;
                    break;
                }
            }
            VerticalClassMerger.this.timing.end();
            return result;
        }
    }

    private static class VerticalClassMergerTreeFixer
    extends TreeFixerBase {
        private final AppView<AppInfoWithLiveness> appView;
        private final VerticalClassMergerGraphLens.Builder lensBuilder;
        private final VerticallyMergedClasses mergedClasses;
        private final List<SynthesizedBridgeCode> synthesizedBridges;

        VerticalClassMergerTreeFixer(AppView<AppInfoWithLiveness> appView, VerticalClassMergerGraphLens.Builder lensBuilder, VerticallyMergedClasses mergedClasses, List<SynthesizedBridgeCode> synthesizedBridges) {
            super(appView);
            this.appView = appView;
            this.lensBuilder = VerticalClassMergerGraphLens.Builder.createBuilderForFixup(lensBuilder, mergedClasses);
            this.mergedClasses = mergedClasses;
            this.synthesizedBridges = synthesizedBridges;
        }

        private VerticalClassMergerGraphLens fixupTypeReferences() {
            for (DexProgramClass clazz : this.appView.appInfo().classes()) {
                clazz.getMethodCollection().replaceMethods(this::fixupMethod);
                clazz.setStaticFields(this.fixupFields(clazz.staticFields()));
                clazz.setInstanceFields(this.fixupFields(clazz.instanceFields()));
            }
            for (SynthesizedBridgeCode synthesizedBridge : this.synthesizedBridges) {
                synthesizedBridge.updateMethodSignatures(this::fixupMethodReference);
            }
            VerticalClassMergerGraphLens lens = this.lensBuilder.build(this.appView, this.mergedClasses);
            if (lens != null) {
                new AnnotationFixer(lens).run(this.appView.appInfo().classes());
            }
            return lens;
        }

        @Override
        public DexType mapClassType(DexType type) {
            while (this.mergedClasses.hasBeenMergedIntoSubtype(type)) {
                type = this.mergedClasses.getTargetFor(type);
            }
            return type;
        }

        @Override
        public void recordClassChange(DexType from, DexType to) {
            throw new Unreachable();
        }

        @Override
        public void recordFieldChange(DexField from, DexField to) {
            if (!this.lensBuilder.hasOriginalSignatureMappingFor(to)) {
                this.lensBuilder.map(from, to);
            }
        }

        @Override
        public void recordMethodChange(DexMethod from, DexMethod to) {
            if (!this.lensBuilder.hasOriginalSignatureMappingFor(to)) {
                this.lensBuilder.map(from, to).recordMove(from, to);
            }
        }

        @Override
        public DexEncodedMethod recordMethodChange(DexEncodedMethod method, DexEncodedMethod newMethod) {
            this.recordMethodChange((DexMethod)method.getReference(), (DexMethod)newMethod.getReference());
            if (newMethod.isNonPrivateVirtualMethod()) {
                assert (!method.isLibraryMethodOverride().isTrue());
                newMethod.setLibraryMethodOverride(OptionalBool.FALSE);
            }
            return newMethod;
        }
    }

    private class ClassMerger {
        private final DexProgramClass source;
        private final DexProgramClass target;
        private final VerticalClassMergerGraphLens.Builder deferredRenamings;
        private final List<SynthesizedBridgeCode> synthesizedBridges;
        private boolean abortMerge;

        private ClassMerger(DexProgramClass source, DexProgramClass target) {
            this.deferredRenamings = new VerticalClassMergerGraphLens.Builder(VerticalClassMerger.this.appView.dexItemFactory());
            this.synthesizedBridges = new ArrayList<SynthesizedBridgeCode>();
            this.abortMerge = false;
            this.source = source;
            this.target = target;
        }

        private void rewriteGenericSignatures(DexProgramClass target, DexProgramClass source, Collection<DexEncodedMethod> directMethods, Collection<DexEncodedMethod> virtualMethods) {
            GenericSignature.ClassSignature targetSignature = target.getClassSignature();
            if (targetSignature.hasNoSignature()) {
                directMethods.forEach(DexEncodedMethod::clearGenericSignature);
                virtualMethods.forEach(DexEncodedMethod::clearGenericSignature);
                source.fields().forEach(DexEncodedMember::clearGenericSignature);
                return;
            }
            GenericSignaturePartialTypeArgumentApplier classApplier = this.getGenericSignatureArgumentApplier(target, source);
            if (classApplier == null) {
                target.clearClassSignature();
                target.members().forEach(DexEncodedMember::clearGenericSignature);
                return;
            }
            GenericSignature.ClassSignature rewrittenSource = classApplier.visitClassSignature(source.getClassSignature());
            GenericSignature.ClassSignature.ClassSignatureBuilder builder = GenericSignature.ClassSignature.builder();
            builder.addFormalTypeParameters(targetSignature.getFormalTypeParameters());
            if (!source.isInterface()) {
                if (rewrittenSource.hasSignature()) {
                    builder.setSuperClassSignature(rewrittenSource.superClassSignature());
                } else {
                    builder.setSuperClassSignature(new GenericSignature.ClassTypeSignature(source.superType));
                }
            } else {
                builder.setSuperClassSignature(targetSignature.superClassSignature());
            }
            HashSet<DexType> seenInterfaces = new HashSet<DexType>();
            if (source.isInterface()) {
                seenInterfaces.add(source.type);
            }
            for (GenericSignature.ClassTypeSignature classTypeSignature : targetSignature.superInterfaceSignatures()) {
                if (!seenInterfaces.add(classTypeSignature.type())) continue;
                builder.addInterface(classTypeSignature);
            }
            if (rewrittenSource.hasSignature()) {
                for (GenericSignature.ClassTypeSignature classTypeSignature : rewrittenSource.superInterfaceSignatures()) {
                    if (seenInterfaces.contains(classTypeSignature.type())) continue;
                    builder.addInterface(classTypeSignature);
                }
            } else {
                for (DexType dexType : source.interfaces) {
                    if (seenInterfaces.contains(dexType)) continue;
                    builder.addInterface(new GenericSignature.ClassTypeSignature(dexType));
                }
            }
            target.setClassSignature(builder.build());
            CollectionUtils.forEach(method -> {
                GenericSignature.MethodTypeSignature methodSignature = method.getGenericSignature();
                if (methodSignature.hasNoSignature()) {
                    return;
                }
                method.setGenericSignature(classApplier.buildForMethod(methodSignature.getFormalTypeParameters()).visitMethodSignature(methodSignature));
            }, directMethods, virtualMethods);
            source.forEachField(field -> {
                if (field.getGenericSignature().hasNoSignature()) {
                    return;
                }
                field.setGenericSignature(classApplier.visitFieldTypeSignature(field.getGenericSignature()));
            });
        }

        private GenericSignaturePartialTypeArgumentApplier getGenericSignatureArgumentApplier(DexProgramClass target, DexProgramClass source) {
            assert (target.getClassSignature().hasSignature());
            List<GenericSignature.FieldTypeSignature> genericArgumentsToSuperType = target.getClassSignature().getGenericArgumentsToSuperType(source.type);
            if (genericArgumentsToSuperType == null) {
                assert (false) : "Type should be present in generic signature";
                return null;
            }
            HashMap<String, GenericSignature.FieldTypeSignature> substitutionMap = new HashMap<String, GenericSignature.FieldTypeSignature>();
            List<GenericSignature.FormalTypeParameter> formals = source.getClassSignature().getFormalTypeParameters();
            if (genericArgumentsToSuperType.size() != formals.size()) {
                if (!genericArgumentsToSuperType.isEmpty()) {
                    assert (false) : "Invalid argument count to formals";
                    return null;
                }
            } else {
                for (int i = 0; i < formals.size(); ++i) {
                    substitutionMap.put(formals.get(i).getName(), genericArgumentsToSuperType.get(i));
                }
            }
            return GenericSignaturePartialTypeArgumentApplier.build(VerticalClassMerger.this.appView, GenericSignatureContextBuilder.TypeParameterContext.empty().addPrunedSubstitutions(substitutionMap), (type1, type2) -> true, type -> true);
        }

        private boolean restoreDebuggingState(Stream<DexEncodedMethod> toBeDiscarded) {
            toBeDiscarded.forEach(method -> {
                assert (!method.isObsolete());
                method.setObsolete();
            });
            this.source.forEachMethod(method -> {
                if (method.isObsolete()) {
                    method.unsetObsolete();
                }
            });
            assert (Streams.concat(Streams.stream(this.source.methods()), Streams.stream(this.target.methods())).allMatch(method -> !method.isObsolete()));
            return true;
        }

        private void redirectSuperCallsInTarget(DexEncodedMethod oldTarget, DexEncodedMethod newTarget) {
            Invoke.Type newTargetType;
            DexMethod oldTargetReference = (DexMethod)oldTarget.getReference();
            DexMethod newTargetReference = (DexMethod)newTarget.getReference();
            Invoke.Type type = newTargetType = newTarget.isNonPrivateVirtualMethod() ? Invoke.Type.VIRTUAL : Invoke.Type.DIRECT;
            if (this.source.accessFlags.isInterface()) {
                this.deferredRenamings.mapVirtualMethodToDirectInType(oldTargetReference, prototypeChanges -> new GraphLens.MethodLookupResult(newTargetReference, null, Invoke.Type.STATIC, prototypeChanges), this.target.type);
            } else {
                DexProgramClass holder = this.target;
                while (holder != null && holder.isProgramClass()) {
                    boolean resolutionSucceeds;
                    DexMethod signatureInHolder = oldTargetReference.withHolder(holder, VerticalClassMerger.this.appView.dexItemFactory());
                    boolean bl = resolutionSucceeds = holder.lookupVirtualMethod(signatureInHolder) != null || VerticalClassMerger.this.appInfo.lookupSuperTarget(signatureInHolder, holder) != null;
                    if (!resolutionSucceeds) break;
                    this.deferredRenamings.mapVirtualMethodToDirectInType(signatureInHolder, prototypeChanges -> new GraphLens.MethodLookupResult(newTargetReference, null, newTargetType, prototypeChanges), this.target.type);
                    Set mergedTypes = VerticalClassMerger.this.mergedClasses.getKeys(holder.type);
                    for (DexType type2 : mergedTypes) {
                        DexMethod signatureInType = oldTargetReference.withHolder(type2, VerticalClassMerger.this.appView.dexItemFactory());
                        boolean resolutionSucceededBeforeMerge = VerticalClassMerger.this.lensBuilder.hasMappingForSignatureInContext(holder, signatureInType) || VerticalClassMerger.this.appInfo.lookupSuperTarget(signatureInHolder, holder) != null;
                        if (!resolutionSucceededBeforeMerge) continue;
                        this.deferredRenamings.mapVirtualMethodToDirectInType(signatureInType, prototypeChanges -> new GraphLens.MethodLookupResult(newTargetReference, null, newTargetType, prototypeChanges), this.target.type);
                    }
                    holder = holder.superType != null ? DexProgramClass.asProgramClassOrNull(VerticalClassMerger.this.appInfo.definitionFor(holder.superType)) : null;
                }
            }
        }

        private void blockRedirectionOfSuperCalls(DexMethod method) {
            this.deferredRenamings.markMethodAsMerged(method);
        }

        private DexEncodedMethod buildBridgeMethod(DexEncodedMethod method, DexEncodedMethod invocationTarget) {
            DexType holder = this.target.type;
            DexProto proto = ((DexMethod)method.getReference()).proto;
            DexString name = ((DexMethod)method.getReference()).name;
            DexMethod newMethod = ((VerticalClassMerger)VerticalClassMerger.this).application.dexItemFactory.createMethod(holder, proto, name);
            MethodAccessFlags accessFlags = method.accessFlags.copy();
            accessFlags.setBridge();
            accessFlags.setSynthetic();
            accessFlags.unsetAbstract();
            assert (invocationTarget.isStatic() || invocationTarget.isNonPrivateVirtualMethod() || invocationTarget.isNonStaticPrivateMethod());
            SynthesizedBridgeCode code = new SynthesizedBridgeCode(newMethod, VerticalClassMerger.this.appView.graphLens().getOriginalMethodSignature((DexMethod)method.getReference()), (DexMethod)invocationTarget.getReference(), invocationTarget.isStatic() ? Invoke.Type.STATIC : (invocationTarget.isNonPrivateVirtualMethod() ? Invoke.Type.VIRTUAL : Invoke.Type.DIRECT), this.target.isInterface());
            this.synthesizedBridges.add(code);
            CfVersion classFileVersion = method.hasClassFileVersion() ? method.getClassFileVersion() : null;
            DexEncodedMethod bridge = DexEncodedMethod.syntheticBuilder().setMethod(newMethod).setAccessFlags(accessFlags).setCode(code).setClassFileVersion(classFileVersion).setApiLevelForDefinition(method.getApiLevelForDefinition()).setApiLevelForCode(method.getApiLevelForDefinition()).setIsLibraryMethodOverride(method.isLibraryMethodOverride()).setGenericSignature(method.getGenericSignature()).build();
            if (method.accessFlags.isPromotedToPublic()) assert (bridge.accessFlags.isPromotedToPublic());
            return bridge;
        }

        private DexEncodedMethod findMethodInTarget(DexEncodedMethod method) {
            MethodResolutionResult resolutionResult = VerticalClassMerger.this.appInfo.resolveMethodOn((DexClass)this.target, (DexMethod)method.getReference());
            if (!resolutionResult.isSingleResolution()) {
                this.abortMerge = true;
                return null;
            }
            DexEncodedMethod actual = resolutionResult.getSingleTarget();
            if (actual != method) {
                assert (actual.isVirtualMethod() == method.isVirtualMethod());
                return actual;
            }
            if (Log.ENABLED && method.accessFlags.isAbstract() && !this.target.accessFlags.isAbstract()) {
                Log.warn(VerticalClassMerger.class, "The non-abstract type `" + this.target.type.toSourceString() + "` does not implement the method `" + ((DexMethod)method.getReference()).toSourceString() + "`.", new Object[0]);
            }
            return null;
        }

        private <D extends DexEncodedMember<D, R>, R extends DexMember<D, R>> void add(Map<Equivalence.Wrapper<R>, D> map, D item, Equivalence<R> equivalence) {
            map.put(equivalence.wrap(item.getReference()), item);
        }

        private <D extends DexEncodedMember<D, R>, R extends DexMember<D, R>> void addAll(Collection<Equivalence.Wrapper<R>> collection, Iterable<D> items, Equivalence<R> equivalence) {
            for (DexEncodedMember item : items) {
                collection.add(equivalence.wrap(item.getReference()));
            }
        }

        private <T> Set<T> mergeArrays(T[] one, T[] other) {
            LinkedHashSet merged = new LinkedHashSet();
            Collections.addAll(merged, one);
            Collections.addAll(merged, other);
            return merged;
        }

        private DexEncodedField[] mergeFields(Collection<DexEncodedField> sourceFields, Collection<DexEncodedField> targetFields, Predicate<DexField> availableFieldSignatures, Set<DexString> existingFieldNames) {
            DexEncodedField[] result = new DexEncodedField[sourceFields.size() + targetFields.size()];
            int i = 0;
            for (DexEncodedField field : sourceFields) {
                DexEncodedField resultingField = this.renameFieldIfNeeded(field, availableFieldSignatures);
                existingFieldNames.add(((DexField)resultingField.getReference()).name);
                this.deferredRenamings.map((DexField)field.getReference(), (DexField)resultingField.getReference());
                result[i] = resultingField;
                ++i;
            }
            Iterator<DexEncodedField> iterator2 = targetFields.iterator();
            while (iterator2.hasNext()) {
                DexEncodedField field;
                result[i] = field = iterator2.next();
                ++i;
            }
            return result;
        }

        private DexString getFreshName(String nameString, int index, DexType holder) {
            String freshName = nameString + "$" + holder.toSourceString().replace('.', '$');
            if (index > 1) {
                freshName = freshName + index;
            }
            return ((VerticalClassMerger)VerticalClassMerger.this).application.dexItemFactory.createString(freshName);
        }

        private DexEncodedMethod renameConstructor(DexEncodedMethod method, Predicate<DexMethod> availableMethodSignatures) {
            DexMethod newSignature;
            assert (method.isInstanceInitializer());
            DexType oldHolder = method.getHolderType();
            int count = 1;
            do {
                DexString newName = this.getFreshName("$r8$constructor", count, oldHolder);
                newSignature = ((VerticalClassMerger)VerticalClassMerger.this).application.dexItemFactory.createMethod(this.target.type, ((DexMethod)method.getReference()).proto, newName);
                ++count;
            } while (!availableMethodSignatures.test(newSignature));
            DexEncodedMethod result = method.toTypeSubstitutedMethod(newSignature);
            result.getMutableOptimizationInfo().markForceInline();
            this.deferredRenamings.map((DexMethod)method.getReference(), (DexMethod)result.getReference());
            this.deferredRenamings.recordMove((DexMethod)method.getReference(), (DexMethod)result.getReference());
            result.accessFlags.unsetConstructor();
            VerticalClassMerger.makePrivate(result);
            return result;
        }

        private DexEncodedMethod renameMethod(DexEncodedMethod method, Predicate<DexMethod> availableMethodSignatures, Rename strategy) {
            return this.renameMethod(method, availableMethodSignatures, strategy, ((DexMethod)method.getReference()).proto);
        }

        private DexEncodedMethod renameMethod(DexEncodedMethod method, Predicate<DexMethod> availableMethodSignatures, Rename strategy, DexProto newProto) {
            DexMethod newSignature;
            assert (!method.accessFlags.isConstructor() || strategy == Rename.NEVER);
            DexString oldName = ((DexMethod)method.getReference()).name;
            DexType oldHolder = method.getHolderType();
            switch (strategy) {
                case IF_NEEDED: {
                    newSignature = ((VerticalClassMerger)VerticalClassMerger.this).application.dexItemFactory.createMethod(this.target.type, newProto, oldName);
                    if (availableMethodSignatures.test(newSignature)) break;
                }
                case ALWAYS: {
                    int count = 1;
                    do {
                        DexString newName = this.getFreshName(oldName.toSourceString(), count, oldHolder);
                        newSignature = ((VerticalClassMerger)VerticalClassMerger.this).application.dexItemFactory.createMethod(this.target.type, newProto, newName);
                        ++count;
                    } while (!availableMethodSignatures.test(newSignature));
                    break;
                }
                case NEVER: {
                    newSignature = ((VerticalClassMerger)VerticalClassMerger.this).application.dexItemFactory.createMethod(this.target.type, newProto, oldName);
                    assert (availableMethodSignatures.test(newSignature));
                    break;
                }
                default: {
                    throw new Unreachable();
                }
            }
            return method.toTypeSubstitutedMethod(newSignature);
        }

        private DexEncodedField renameFieldIfNeeded(DexEncodedField field, Predicate<DexField> availableFieldSignatures) {
            DexString oldName = ((DexField)field.getReference()).name;
            DexType oldHolder = field.getHolderType();
            DexField newSignature = ((VerticalClassMerger)VerticalClassMerger.this).application.dexItemFactory.createField(this.target.type, ((DexField)field.getReference()).type, oldName);
            if (!availableFieldSignatures.test(newSignature)) {
                int count = 1;
                do {
                    DexString newName = this.getFreshName(oldName.toSourceString(), count, oldHolder);
                    newSignature = ((VerticalClassMerger)VerticalClassMerger.this).application.dexItemFactory.createField(this.target.type, ((DexField)field.getReference()).type, newName);
                    ++count;
                } while (!availableFieldSignatures.test(newSignature));
            }
            return field.toTypeSubstitutedField(VerticalClassMerger.this.appView, newSignature);
        }

        private void makeStatic(DexEncodedMethod method) {
            method.accessFlags.setStatic();
            if (!method.getCode().isCfCode()) {
                this.abortMerge = true;
            }
        }

        public boolean merge() throws ExecutionException {
            int i;
            HashSet existingMethods = new HashSet();
            this.addAll(existingMethods, this.target.methods(), MethodSignatureEquivalence.get());
            HashMap directMethods = new HashMap();
            HashMap virtualMethods = new HashMap();
            Predicate<DexMethod> availableMethodSignatures = method -> {
                Equivalence.Wrapper<DexMethod> wrapped = MethodSignatureEquivalence.get().wrap(method);
                return !existingMethods.contains(wrapped) && !directMethods.containsKey(wrapped) && !virtualMethods.containsKey(wrapped);
            };
            this.source.forEachProgramDirectMethod(directMethod -> {
                DexEncodedMethod definition = (DexEncodedMethod)directMethod.getDefinition();
                if (definition.isInstanceInitializer()) {
                    DexEncodedMethod resultingConstructor = this.renameConstructor(definition, availableMethodSignatures);
                    this.add(directMethods, resultingConstructor, MethodSignatureEquivalence.get());
                    this.blockRedirectionOfSuperCalls((DexMethod)resultingConstructor.getReference());
                } else {
                    DexEncodedMethod resultingDirectMethod = this.renameMethod(definition, availableMethodSignatures, definition.isClassInitializer() ? Rename.NEVER : Rename.IF_NEEDED);
                    this.add(directMethods, resultingDirectMethod, MethodSignatureEquivalence.get());
                    this.deferredRenamings.map((DexMethod)directMethod.getReference(), (DexMethod)resultingDirectMethod.getReference());
                    this.deferredRenamings.recordMove((DexMethod)directMethod.getReference(), (DexMethod)resultingDirectMethod.getReference());
                    this.blockRedirectionOfSuperCalls((DexMethod)resultingDirectMethod.getReference());
                    if (definition.isInstance() && definition.isPrivate() && AccessControl.isMemberAccessible(directMethod, (DexClass)this.source, this.target, VerticalClassMerger.this.appView).isTrue()) {
                        this.deferredRenamings.mapVirtualMethodToDirectInType((DexMethod)directMethod.getReference(), prototypeChanges -> new GraphLens.MethodLookupResult((DexMethod)resultingDirectMethod.getReference(), null, Invoke.Type.DIRECT, prototypeChanges), this.target.getType());
                    }
                }
            });
            for (DexEncodedMethod dexEncodedMethod : this.source.virtualMethods()) {
                DexEncodedMethod resultingMethod;
                DexEncodedMethod shadowedBy = this.findMethodInTarget(dexEncodedMethod);
                if (shadowedBy != null) {
                    if (dexEncodedMethod.isAbstract()) {
                        this.deferredRenamings.map((DexMethod)dexEncodedMethod.getReference(), (DexMethod)shadowedBy.getReference()).map((DexMethod)shadowedBy.getReference(), (DexMethod)shadowedBy.getReference()).recordMerge((DexMethod)dexEncodedMethod.getReference(), (DexMethod)shadowedBy.getReference());
                        if (dexEncodedMethod.isSyntheticMethod() || !shadowedBy.isSyntheticMethod()) continue;
                        shadowedBy.accessFlags.demoteFromSynthetic();
                        continue;
                    }
                } else {
                    if (this.abortMerge) {
                        assert (this.restoreDebuggingState(Streams.concat(directMethods.values().stream(), virtualMethods.values().stream())));
                        return false;
                    }
                    if (dexEncodedMethod.isAbstract()) {
                        if (!this.target.isAbstract()) {
                            assert (((VerticalClassMerger)VerticalClassMerger.this).appView.options().testing.allowNonAbstractClassesWithAbstractMethods);
                            this.abortMerge = true;
                            return false;
                        }
                        DexEncodedMethod resultingVirtualMethod = this.renameMethod(dexEncodedMethod, availableMethodSignatures, Rename.NEVER);
                        resultingVirtualMethod.setLibraryMethodOverride(dexEncodedMethod.isLibraryMethodOverride());
                        this.deferredRenamings.map((DexMethod)dexEncodedMethod.getReference(), (DexMethod)resultingVirtualMethod.getReference());
                        this.deferredRenamings.recordMove((DexMethod)dexEncodedMethod.getReference(), (DexMethod)resultingVirtualMethod.getReference());
                        this.add(virtualMethods, resultingVirtualMethod, MethodSignatureEquivalence.get());
                        continue;
                    }
                }
                if (this.source.accessFlags.isInterface()) {
                    MemberPoolCollection.MemberPool methodPoolForTarget = VerticalClassMerger.this.methodPoolCollection.buildForHierarchy(this.target, VerticalClassMerger.this.executorService, VerticalClassMerger.this.timing);
                    resultingMethod = this.renameMethod(dexEncodedMethod, method -> availableMethodSignatures.test((DexMethod)method) && !methodPoolForTarget.hasSeen(MethodSignatureEquivalence.get().wrap(method)), Rename.ALWAYS, VerticalClassMerger.this.appView.dexItemFactory().prependHolderToProto((DexMethod)dexEncodedMethod.getReference()));
                    this.makeStatic(resultingMethod);
                    methodPoolForTarget.seen((DexMethod)resultingMethod.getReference());
                } else {
                    resultingMethod = this.renameMethod(dexEncodedMethod, availableMethodSignatures, Rename.ALWAYS);
                    if (VerticalClassMerger.this.appView.options().getProguardConfiguration().isAccessModificationAllowed()) {
                        VerticalClassMerger.makePublic(resultingMethod);
                    } else {
                        VerticalClassMerger.makePrivate(resultingMethod);
                    }
                }
                this.add(resultingMethod.belongsToDirectPool() ? directMethods : virtualMethods, resultingMethod, MethodSignatureEquivalence.get());
                this.redirectSuperCallsInTarget(dexEncodedMethod, resultingMethod);
                this.blockRedirectionOfSuperCalls((DexMethod)resultingMethod.getReference());
                if (shadowedBy == null) {
                    shadowedBy = this.buildBridgeMethod(dexEncodedMethod, resultingMethod);
                    this.deferredRenamings.recordCreationOfBridgeMethod((DexMethod)dexEncodedMethod.getReference(), (DexMethod)shadowedBy.getReference());
                    this.add(virtualMethods, shadowedBy, MethodSignatureEquivalence.get());
                }
                this.deferredRenamings.map((DexMethod)dexEncodedMethod.getReference(), (DexMethod)shadowedBy.getReference());
                this.deferredRenamings.recordMove((DexMethod)dexEncodedMethod.getReference(), (DexMethod)resultingMethod.getReference(), resultingMethod.isStatic());
            }
            if (this.abortMerge) {
                assert (this.restoreDebuggingState(Streams.concat(directMethods.values().stream(), virtualMethods.values().stream())));
                return false;
            }
            this.rewriteGenericSignatures(this.target, this.source, directMethods.values(), virtualMethods.values());
            this.target.forEachProgramInstanceInitializerMatching(method -> method.getCode().isDefaultInstanceInitializerCode(), method -> DefaultInstanceInitializerCode.uncanonicalizeCode(VerticalClassMerger.this.appView, method));
            HashSet<DexString> existingFieldNames = new HashSet<DexString>();
            for (DexEncodedField field2 : this.target.fields()) {
                existingFieldNames.add(((DexField)field2.getReference()).name);
            }
            Predicate<DexField> predicate = field -> !existingFieldNames.contains(field.name);
            DexEncodedField[] mergedInstanceFields = this.mergeFields(this.source.instanceFields(), this.target.instanceFields(), predicate, existingFieldNames);
            DexEncodedField[] mergedStaticFields = this.mergeFields(this.source.staticFields(), this.target.staticFields(), predicate, existingFieldNames);
            Set<DexType> interfaces = this.mergeArrays(this.target.interfaces.values, this.source.interfaces.values);
            if (this.source.isInterface()) {
                interfaces.remove(this.source.type);
            } else {
                assert (!this.target.isInterface());
                this.target.superType = this.source.superType;
            }
            this.target.interfaces = interfaces.isEmpty() ? DexTypeList.empty() : new DexTypeList(interfaces.toArray(DexType.EMPTY_ARRAY));
            directMethods.values().forEach(VerticalClassMerger.this.feedback::markMethodCannotBeKept);
            virtualMethods.values().forEach(VerticalClassMerger.this.feedback::markMethodCannotBeKept);
            for (i = 0; i < this.source.instanceFields().size(); ++i) {
                VerticalClassMerger.this.feedback.markFieldCannotBeKept(mergedInstanceFields[i]);
            }
            for (i = 0; i < this.source.staticFields().size(); ++i) {
                VerticalClassMerger.this.feedback.markFieldCannotBeKept(mergedStaticFields[i]);
            }
            this.target.addDirectMethods(directMethods.values());
            this.target.addVirtualMethods(virtualMethods.values());
            this.target.setInstanceFields(mergedInstanceFields);
            this.target.setStaticFields(mergedStaticFields);
            this.source.getMethodCollection().clearDirectMethods();
            this.source.getMethodCollection().clearVirtualMethods();
            this.source.clearInstanceFields();
            this.source.clearStaticFields();
            VerticalClassMerger.this.mergedClasses.put(this.source.type, this.target.type);
            if (this.source.isInterface()) {
                VerticalClassMerger.this.mergedInterfaces.put(this.source.type, this.target.type);
            }
            assert (!this.abortMerge);
            assert (GenericSignatureCorrectnessHelper.createForVerification(VerticalClassMerger.this.appView, GenericSignatureContextBuilder.createForSingleClass(VerticalClassMerger.this.appView, this.target)).evaluateSignaturesForClass(this.target).isValid());
            return true;
        }

        public VerticalClassMergerGraphLens.Builder getRenamings() {
            return this.deferredRenamings;
        }

        public List<SynthesizedBridgeCode> getSynthesizedBridges() {
            return this.synthesizedBridges;
        }
    }

    private class OverloadedMethodSignaturesRetriever {
        private final Reference2BooleanOpenHashMap<DexProto> cache = new Reference2BooleanOpenHashMap();
        private final Equivalence<DexMethod> equivalence = MethodSignatureEquivalence.get();
        private final Set<DexType> mergeeCandidates = new HashSet<DexType>();

        public OverloadedMethodSignaturesRetriever() {
            for (DexProgramClass mergeCandidate : VerticalClassMerger.this.mergeCandidates) {
                DexType singleSubtype = VerticalClassMerger.this.subtypingInfo.getSingleDirectSubtype(mergeCandidate.type);
                this.mergeeCandidates.add(singleSubtype);
            }
        }

        private boolean protoMayReferenceMergedSourceOrTarget(DexProto proto) {
            boolean result;
            if (this.cache.containsKey(proto)) {
                result = this.cache.getBoolean(proto);
            } else {
                result = false;
                if (this.typeMayReferenceMergedSourceOrTarget(proto.returnType)) {
                    result = true;
                } else {
                    for (DexType type : proto.parameters.values) {
                        if (!this.typeMayReferenceMergedSourceOrTarget(type)) continue;
                        result = true;
                        break;
                    }
                }
                this.cache.put(proto, result);
            }
            return result;
        }

        private boolean typeMayReferenceMergedSourceOrTarget(DexType type) {
            if ((type = type.toBaseType(VerticalClassMerger.this.appView.dexItemFactory())).isClassType()) {
                if (this.mergeeCandidates.contains(type)) {
                    return true;
                }
                DexClass clazz = VerticalClassMerger.this.appInfo.definitionFor(type);
                if (clazz != null && clazz.isProgramClass()) {
                    return VerticalClassMerger.this.mergeCandidates.contains(clazz.asProgramClass());
                }
            }
            return false;
        }

        public Collection<DexMethod> get() {
            HashMap<DexString, DexProto> overloadingInfo = new HashMap<DexString, DexProto>();
            HashSet<Equivalence.Wrapper<DexMethod>> filteredSignatures = new HashSet<Equivalence.Wrapper<DexMethod>>();
            for (DexProgramClass clazz : VerticalClassMerger.this.appInfo.classes()) {
                for (DexEncodedMethod encodedMethod : clazz.methods()) {
                    DexMethod method = (DexMethod)encodedMethod.getReference();
                    DexClass definition = VerticalClassMerger.this.appInfo.definitionFor(method.holder);
                    if (definition == null || !definition.isProgramClass() || !this.protoMayReferenceMergedSourceOrTarget(method.proto)) continue;
                    filteredSignatures.add(this.equivalence.wrap(method));
                    DexProto existing = overloadingInfo.computeIfAbsent(method.name, key -> method.proto);
                    if (existing == DexProto.SENTINEL || existing.equals(method.proto)) continue;
                    overloadingInfo.put(method.name, DexProto.SENTINEL);
                }
            }
            ArrayList<DexMethod> result = new ArrayList<DexMethod>();
            for (Equivalence.Wrapper wrapper : filteredSignatures) {
                DexMethod signature = (DexMethod)wrapper.get();
                if (overloadingInfo.get(signature.name) != DexProto.SENTINEL) continue;
                result.add(signature);
            }
            return result;
        }
    }

    private static enum Rename {
        ALWAYS,
        IF_NEEDED,
        NEVER;

    }

    private static final class AbortReason
    extends Enum<AbortReason> {
        public static final /* enum */ AbortReason ALREADY_MERGED = new AbortReason();
        public static final /* enum */ AbortReason ALWAYS_INLINE = new AbortReason();
        public static final /* enum */ AbortReason CONFLICT = new AbortReason();
        public static final /* enum */ AbortReason ILLEGAL_ACCESS = new AbortReason();
        public static final /* enum */ AbortReason MAIN_DEX_ROOT_OUTSIDE_REFERENCE = new AbortReason();
        public static final /* enum */ AbortReason MERGE_ACROSS_NESTS = new AbortReason();
        public static final /* enum */ AbortReason NATIVE_METHOD = new AbortReason();
        public static final /* enum */ AbortReason NO_SIDE_EFFECTS = new AbortReason();
        public static final /* enum */ AbortReason PINNED_SOURCE = new AbortReason();
        public static final /* enum */ AbortReason RESOLUTION_FOR_FIELDS_MAY_CHANGE = new AbortReason();
        public static final /* enum */ AbortReason RESOLUTION_FOR_METHODS_MAY_CHANGE = new AbortReason();
        public static final /* enum */ AbortReason SERVICE_LOADER = new AbortReason();
        public static final /* enum */ AbortReason SOURCE_AND_TARGET_LOCK_CANDIDATES = new AbortReason();
        public static final /* enum */ AbortReason STATIC_INITIALIZERS = new AbortReason();
        public static final /* enum */ AbortReason UNHANDLED_INVOKE_DIRECT = new AbortReason();
        public static final /* enum */ AbortReason UNHANDLED_INVOKE_SUPER = new AbortReason();
        public static final /* enum */ AbortReason UNSAFE_INLINING = new AbortReason();
        public static final /* enum */ AbortReason UNSUPPORTED_ATTRIBUTES = new AbortReason();
        public static final /* enum */ AbortReason API_REFERENCE_LEVEL = new AbortReason();
        private static final /* synthetic */ AbortReason[] $VALUES;

        public static AbortReason[] values() {
            return (AbortReason[])$VALUES.clone();
        }

        public static AbortReason valueOf(String name) {
            return Enum.valueOf(AbortReason.class, name);
        }

        private String getMessageForClass(DexClass clazz) {
            String message = null;
            switch (this) {
                case ALREADY_MERGED: {
                    message = "it has already been merged with its superclass";
                    break;
                }
                case ALWAYS_INLINE: {
                    message = "it is mentioned in appInfo.alwaysInline";
                    break;
                }
                case CONFLICT: {
                    message = "it is conflicting with its subclass";
                    break;
                }
                case ILLEGAL_ACCESS: {
                    message = "it could lead to illegal accesses";
                    break;
                }
                case MAIN_DEX_ROOT_OUTSIDE_REFERENCE: {
                    message = "contains a constructor with a reference outside the main dex classes";
                    break;
                }
                case MERGE_ACROSS_NESTS: {
                    message = "cannot merge across nests, or from nest to non-nest";
                    break;
                }
                case NATIVE_METHOD: {
                    message = "it has a native method";
                    break;
                }
                case NO_SIDE_EFFECTS: {
                    message = "it is mentioned in appInfo.noSideEffects";
                    break;
                }
                case PINNED_SOURCE: {
                    message = "it should be kept";
                    break;
                }
                case RESOLUTION_FOR_FIELDS_MAY_CHANGE: {
                    message = "it could affect field resolution";
                    break;
                }
                case RESOLUTION_FOR_METHODS_MAY_CHANGE: {
                    message = "it could affect method resolution";
                    break;
                }
                case SERVICE_LOADER: {
                    message = "it is used by a service loader";
                    break;
                }
                case SOURCE_AND_TARGET_LOCK_CANDIDATES: {
                    message = "source and target are both lock-candidates";
                    break;
                }
                case STATIC_INITIALIZERS: {
                    message = "merging of static initializers are not supported";
                    break;
                }
                case UNHANDLED_INVOKE_DIRECT: {
                    message = "a virtual method is targeted by an invoke-direct instruction";
                    break;
                }
                case UNHANDLED_INVOKE_SUPER: {
                    message = "it may change the semantics of an invoke-super instruction";
                    break;
                }
                case UNSAFE_INLINING: {
                    message = "force-inlining might fail";
                    break;
                }
                case UNSUPPORTED_ATTRIBUTES: {
                    message = "since inner-class attributes are not supported";
                    break;
                }
                case API_REFERENCE_LEVEL: {
                    message = "since source class references a higher api-level than target";
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            return String.format("Cannot merge %s since %s.", clazz.toSourceString(), message);
        }

        static {
            $VALUES = new AbortReason[]{ALREADY_MERGED, ALWAYS_INLINE, CONFLICT, ILLEGAL_ACCESS, MAIN_DEX_ROOT_OUTSIDE_REFERENCE, MERGE_ACROSS_NESTS, NATIVE_METHOD, NO_SIDE_EFFECTS, PINNED_SOURCE, RESOLUTION_FOR_FIELDS_MAY_CHANGE, RESOLUTION_FOR_METHODS_MAY_CHANGE, SERVICE_LOADER, SOURCE_AND_TARGET_LOCK_CANDIDATES, STATIC_INITIALIZERS, UNHANDLED_INVOKE_DIRECT, UNHANDLED_INVOKE_SUPER, UNSAFE_INLINING, UNSUPPORTED_ATTRIBUTES, API_REFERENCE_LEVEL};
        }

        public void printLogMessageForClass(DexClass clazz) {
            Log.info(VerticalClassMerger.class, this.getMessageForClass(clazz), new Object[0]);
        }
    }
}

