/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.NestedGraphLens;
import com.android.tools.r8.graph.classmerging.VerticallyMergedClasses;
import com.android.tools.r8.graph.proto.ArgumentInfoCollection;
import com.android.tools.r8.graph.proto.RewrittenPrototypeDescription;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.utils.IterableUtils;
import com.android.tools.r8.utils.collections.BidirectionalManyToOneRepresentativeHashMap;
import com.android.tools.r8.utils.collections.BidirectionalManyToOneRepresentativeMap;
import com.android.tools.r8.utils.collections.BidirectionalOneToOneHashMap;
import com.android.tools.r8.utils.collections.MutableBidirectionalManyToOneRepresentativeMap;
import com.android.tools.r8.utils.collections.MutableBidirectionalOneToOneMap;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public class VerticalClassMergerGraphLens
extends NestedGraphLens {
    private final AppView<?> appView;
    private VerticallyMergedClasses mergedClasses;
    private final Map<DexType, Map<DexMethod, GraphLensLookupResultProvider>> contextualVirtualToDirectMethodMaps;
    private Set<DexMethod> mergedMethods;
    private final Map<DexMethod, DexMethod> originalMethodSignaturesForBridges;
    private final Map<DexMethod, RewrittenPrototypeDescription> prototypeChanges;

    private VerticalClassMergerGraphLens(AppView<?> appView, VerticallyMergedClasses mergedClasses, BidirectionalManyToOneRepresentativeMap<DexField, DexField> fieldMap, Map<DexMethod, DexMethod> methodMap, Set<DexMethod> mergedMethods, Map<DexType, Map<DexMethod, GraphLensLookupResultProvider>> contextualVirtualToDirectMethodMaps, BidirectionalManyToOneRepresentativeMap<DexMethod, DexMethod> newMethodSignatures, Map<DexMethod, DexMethod> originalMethodSignaturesForBridges, Map<DexMethod, RewrittenPrototypeDescription> prototypeChanges) {
        super(appView, fieldMap, methodMap, mergedClasses.getForwardMap(), newMethodSignatures);
        this.appView = appView;
        this.mergedClasses = mergedClasses;
        this.contextualVirtualToDirectMethodMaps = contextualVirtualToDirectMethodMaps;
        this.mergedMethods = mergedMethods;
        this.originalMethodSignaturesForBridges = originalMethodSignaturesForBridges;
        this.prototypeChanges = prototypeChanges;
    }

    @Override
    public boolean isVerticalClassMergerLens() {
        return true;
    }

    @Override
    protected Iterable<DexType> internalGetOriginalTypes(DexType previous) {
        Collection<DexType> originalTypes = this.mergedClasses.getSourcesFor(previous);
        Iterable<DexType> currentType = IterableUtils.singleton(previous);
        if (originalTypes == null) {
            return currentType;
        }
        return Iterables.concat(currentType, originalTypes);
    }

    @Override
    public GraphLens.MethodLookupResult internalDescribeLookupMethod(GraphLens.MethodLookupResult previous, DexMethod context) {
        GraphLensLookupResultProvider result;
        Map<DexMethod, GraphLensLookupResultProvider> virtualToDirectMethodMap;
        assert (context != null || this.verifyIsContextFreeForMethod((DexMethod)previous.getReference()));
        assert (context == null || previous.getType() != null);
        if (previous.getType() == Invoke.Type.SUPER && !this.mergedMethods.contains(context) && (virtualToDirectMethodMap = this.contextualVirtualToDirectMethodMaps.get(context.getHolderType())) != null && (result = virtualToDirectMethodMap.get(previous.getReference())) != null) {
            return result.get(previous.getPrototypeChanges());
        }
        DexMethod newMethod = (DexMethod)this.methodMap.apply((DexMethod)previous.getReference());
        if (newMethod == null) {
            return previous;
        }
        return ((GraphLens.MethodLookupResult.Builder)GraphLens.MethodLookupResult.builder(this).setReference(newMethod)).setPrototypeChanges(this.internalDescribePrototypeChanges(previous.getPrototypeChanges(), newMethod)).setType(this.mapInvocationType(newMethod, (DexMethod)previous.getReference(), previous.getType())).build();
    }

    @Override
    protected RewrittenPrototypeDescription internalDescribePrototypeChanges(RewrittenPrototypeDescription prototypeChanges, DexMethod method) {
        return prototypeChanges.combine(this.prototypeChanges.getOrDefault(method, RewrittenPrototypeDescription.none()));
    }

    @Override
    public DexMethod getPreviousMethodSignature(DexMethod method) {
        return super.getPreviousMethodSignature(this.originalMethodSignaturesForBridges.getOrDefault(method, method));
    }

    @Override
    protected Invoke.Type mapInvocationType(DexMethod newMethod, DexMethod originalMethod, Invoke.Type type) {
        return VerticalClassMergerGraphLens.mapVirtualInterfaceInvocationTypes(this.appView, newMethod, originalMethod, type);
    }

    @Override
    public boolean isContextFreeForMethods() {
        return this.contextualVirtualToDirectMethodMaps.isEmpty() && this.getPrevious().isContextFreeForMethods();
    }

    @Override
    public boolean verifyIsContextFreeForMethod(DexMethod method) {
        assert (this.getPrevious().verifyIsContextFreeForMethod(method));
        DexMethod previous = this.getPrevious().lookupMethod(method);
        assert (this.contextualVirtualToDirectMethodMaps.values().stream().noneMatch(virtualToDirectMethodMap -> virtualToDirectMethodMap.containsKey(previous)));
        return true;
    }

    public static class Builder {
        private final DexItemFactory dexItemFactory;
        protected final MutableBidirectionalOneToOneMap<DexField, DexField> fieldMap = new BidirectionalOneToOneHashMap<DexField, DexField>();
        protected final Map<DexMethod, DexMethod> methodMap = new IdentityHashMap<DexMethod, DexMethod>();
        private final ImmutableSet.Builder<DexMethod> mergedMethodsBuilder = ImmutableSet.builder();
        private final Map<DexType, Map<DexMethod, GraphLensLookupResultProvider>> contextualVirtualToDirectMethodMaps = new IdentityHashMap<DexType, Map<DexMethod, GraphLensLookupResultProvider>>();
        private final MutableBidirectionalManyToOneRepresentativeMap<DexMethod, DexMethod> newMethodSignatures = BidirectionalManyToOneRepresentativeHashMap.newIdentityHashMap();
        private final Map<DexMethod, DexMethod> originalMethodSignaturesForBridges = new IdentityHashMap<DexMethod, DexMethod>();
        private final Map<DexMethod, RewrittenPrototypeDescription> prototypeChanges = new IdentityHashMap<DexMethod, RewrittenPrototypeDescription>();
        private final Map<DexProto, DexProto> cache = new IdentityHashMap<DexProto, DexProto>();

        Builder(DexItemFactory dexItemFactory) {
            this.dexItemFactory = dexItemFactory;
        }

        static Builder createBuilderForFixup(Builder builder, VerticallyMergedClasses mergedClasses) {
            Builder newBuilder = new Builder(builder.dexItemFactory);
            builder.fieldMap.forEach((key, value) -> newBuilder.map((DexField)key, builder.getFieldSignatureAfterClassMerging((DexField)value, mergedClasses)));
            for (Map.Entry<DexMethod, DexMethod> entry : builder.methodMap.entrySet()) {
                newBuilder.map(entry.getKey(), builder.getMethodSignatureAfterClassMerging(entry.getValue(), mergedClasses));
            }
            for (DexMethod dexMethod : builder.mergedMethodsBuilder.build()) {
                newBuilder.markMethodAsMerged(builder.getMethodSignatureAfterClassMerging(dexMethod, mergedClasses));
            }
            for (Map.Entry<DexType, Map<DexMethod, GraphLensLookupResultProvider>> entry : builder.contextualVirtualToDirectMethodMaps.entrySet()) {
                DexType context = entry.getKey();
                assert (context == builder.getTypeAfterClassMerging(context, mergedClasses));
                for (Map.Entry<DexMethod, GraphLensLookupResultProvider> innerEntry : entry.getValue().entrySet()) {
                    DexMethod from = innerEntry.getKey();
                    GraphLens.MethodLookupResult rewriting = innerEntry.getValue().get(RewrittenPrototypeDescription.none());
                    DexMethod to = builder.getMethodSignatureAfterClassMerging((DexMethod)rewriting.getReference(), mergedClasses);
                    newBuilder.mapVirtualMethodToDirectInType(from, prototypeChanges -> new GraphLens.MethodLookupResult(to, null, rewriting.getType(), prototypeChanges), context);
                }
            }
            builder.newMethodSignatures.forEachManyToOneMapping((originalMethodSignatures, renamedMethodSignature, representative) -> {
                DexMethod methodSignatureAfterClassMerging = builder.getMethodSignatureAfterClassMerging((DexMethod)renamedMethodSignature, mergedClasses);
                newBuilder.newMethodSignatures.put((Iterable<DexMethod>)originalMethodSignatures, methodSignatureAfterClassMerging);
                if (originalMethodSignatures.size() > 1) {
                    newBuilder.newMethodSignatures.setRepresentative(methodSignatureAfterClassMerging, (DexMethod)representative);
                }
            });
            for (Map.Entry<DexReference, Object> entry : builder.originalMethodSignaturesForBridges.entrySet()) {
                newBuilder.recordCreationOfBridgeMethod((DexMethod)entry.getValue(), builder.getMethodSignatureAfterClassMerging((DexMethod)entry.getKey(), mergedClasses));
            }
            builder.prototypeChanges.forEach((method, prototypeChangesForMethod) -> newBuilder.prototypeChanges.put(builder.getMethodSignatureAfterClassMerging((DexMethod)method, mergedClasses), (RewrittenPrototypeDescription)prototypeChangesForMethod));
            return newBuilder;
        }

        private DexField getFieldSignatureAfterClassMerging(DexField field, VerticallyMergedClasses mergedClasses) {
            assert (!field.holder.isArrayType());
            DexType holder = field.holder;
            DexType newHolder = mergedClasses.getTargetForOrDefault(holder, holder);
            DexType type = field.type;
            DexType newType = this.getTypeAfterClassMerging(type, mergedClasses);
            if (holder == newHolder && type == newType) {
                return field;
            }
            return this.dexItemFactory.createField(newHolder, newType, field.name);
        }

        private DexMethod getMethodSignatureAfterClassMerging(DexMethod signature, VerticallyMergedClasses mergedClasses) {
            assert (!signature.holder.isArrayType());
            DexType holder = signature.holder;
            DexType newHolder = mergedClasses.getTargetForOrDefault(holder, holder);
            DexProto proto = signature.proto;
            DexProto newProto = this.dexItemFactory.applyClassMappingToProto(proto, type -> this.getTypeAfterClassMerging((DexType)type, mergedClasses), this.cache);
            if (holder == newHolder && proto == newProto) {
                return signature;
            }
            return this.dexItemFactory.createMethod(newHolder, newProto, signature.name);
        }

        private DexType getTypeAfterClassMerging(DexType type, VerticallyMergedClasses mergedClasses) {
            if (type.isArrayType()) {
                DexType baseType = type.toBaseType(this.dexItemFactory);
                DexType newBaseType = mergedClasses.getTargetForOrDefault(baseType, baseType);
                if (newBaseType != baseType) {
                    return type.replaceBaseType(newBaseType, this.dexItemFactory);
                }
                return type;
            }
            return mergedClasses.getTargetForOrDefault(type, type);
        }

        public VerticalClassMergerGraphLens build(AppView<?> appView, VerticallyMergedClasses mergedClasses) {
            if (mergedClasses.isEmpty()) {
                return null;
            }
            return new VerticalClassMergerGraphLens(appView, mergedClasses, this.fieldMap, this.methodMap, (Set)((Object)this.mergedMethodsBuilder.build()), this.contextualVirtualToDirectMethodMaps, this.newMethodSignatures, this.originalMethodSignaturesForBridges, this.prototypeChanges);
        }

        public boolean hasMappingForSignatureInContext(DexProgramClass context, DexMethod signature) {
            Map<DexMethod, GraphLensLookupResultProvider> virtualToDirectMethodMap = this.contextualVirtualToDirectMethodMaps.get(context.type);
            if (virtualToDirectMethodMap != null) {
                return virtualToDirectMethodMap.containsKey(signature);
            }
            return false;
        }

        public boolean hasOriginalSignatureMappingFor(DexField field) {
            return this.fieldMap.containsValue(field);
        }

        public boolean hasOriginalSignatureMappingFor(DexMethod method) {
            return this.newMethodSignatures.containsValue(method) || this.originalMethodSignaturesForBridges.containsKey(method);
        }

        public void markMethodAsMerged(DexMethod method) {
            this.mergedMethodsBuilder.add((Object)method);
        }

        public void map(DexField from, DexField to) {
            this.fieldMap.put(from, to);
        }

        public Builder map(DexMethod from, DexMethod to) {
            this.methodMap.put(from, to);
            return this;
        }

        public void recordMerge(DexMethod from, DexMethod to) {
            this.newMethodSignatures.put(from, to);
            this.newMethodSignatures.put(to, to);
            this.newMethodSignatures.setRepresentative(to, to);
        }

        public void recordMove(DexMethod from, DexMethod to) {
            this.recordMove(from, to, false);
        }

        public void recordMove(DexMethod from, DexMethod to, boolean isStaticized) {
            this.newMethodSignatures.put(from, to);
            if (isStaticized) {
                RewrittenPrototypeDescription prototypeChangesForMethod = RewrittenPrototypeDescription.create(ImmutableList.of(), null, ArgumentInfoCollection.builder().setArgumentInfosSize(to.getParameters().size()).setIsConvertedToStaticMethod().build());
                this.prototypeChanges.put(to, prototypeChangesForMethod);
            }
        }

        public void recordCreationOfBridgeMethod(DexMethod from, DexMethod to) {
            this.originalMethodSignaturesForBridges.put(to, from);
        }

        public void mapVirtualMethodToDirectInType(DexMethod from, GraphLensLookupResultProvider to, DexType type) {
            Map virtualToDirectMethodMap = this.contextualVirtualToDirectMethodMaps.computeIfAbsent(type, key -> new IdentityHashMap());
            virtualToDirectMethodMap.put(from, to);
        }

        public void merge(Builder builder) {
            this.fieldMap.putAll(builder.fieldMap);
            this.methodMap.putAll(builder.methodMap);
            this.mergedMethodsBuilder.addAll((Iterable)builder.mergedMethodsBuilder.build());
            builder.newMethodSignatures.forEachManyToOneMapping((keys2, value, representative) -> {
                boolean isRemapping = Iterables.any(keys2, key -> this.newMethodSignatures.containsValue((DexMethod)key) && key != value);
                if (isRemapping) {
                    assert (keys2.size() == 1);
                    DexMethod key2 = (DexMethod)keys2.iterator().next();
                    DexMethod originalRepresentative = (DexMethod)this.newMethodSignatures.getRepresentativeKey(key2);
                    Set originalKeys = this.newMethodSignatures.removeValue(key2);
                    assert (originalKeys.contains(key2));
                    this.newMethodSignatures.put(originalKeys, (DexMethod)value);
                    this.newMethodSignatures.setRepresentative((DexMethod)value, originalRepresentative);
                } else {
                    if (this.newMethodSignatures.containsValue((DexMethod)value) && !this.newMethodSignatures.hasExplicitRepresentativeKey((DexMethod)value)) {
                        this.newMethodSignatures.setRepresentative((DexMethod)value, (DexMethod)this.newMethodSignatures.getRepresentativeKey((DexMethod)value));
                    }
                    this.newMethodSignatures.put((Iterable<DexMethod>)keys2, (DexMethod)value);
                    if (keys2.size() > 1 && !this.newMethodSignatures.hasExplicitRepresentativeKey((DexMethod)value)) {
                        this.newMethodSignatures.setRepresentative((DexMethod)value, (DexMethod)representative);
                    }
                }
            });
            this.prototypeChanges.putAll(builder.prototypeChanges);
            this.originalMethodSignaturesForBridges.putAll(builder.originalMethodSignaturesForBridges);
            for (DexType context : builder.contextualVirtualToDirectMethodMaps.keySet()) {
                Map<DexMethod, GraphLensLookupResultProvider> current = this.contextualVirtualToDirectMethodMaps.get(context);
                Map<DexMethod, GraphLensLookupResultProvider> other = builder.contextualVirtualToDirectMethodMaps.get(context);
                if (current != null) {
                    current.putAll(other);
                    continue;
                }
                this.contextualVirtualToDirectMethodMaps.put(context, other);
            }
        }
    }

    static interface GraphLensLookupResultProvider {
        public GraphLens.MethodLookupResult get(RewrittenPrototypeDescription var1);
    }
}

