/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.synthesis;

import com.android.tools.r8.FeatureSplit;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.ClasspathOrLibraryClass;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.ProgramDefinition;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.shaking.MainDexInfo;
import com.android.tools.r8.utils.DescriptorUtils;
import java.util.Comparator;

class SynthesizingContext
implements Comparable<SynthesizingContext> {
    private final DexType synthesizingContextType;
    private final DexType inputContextType;
    private final Origin inputContextOrigin;
    private final FeatureSplit featureSplit;

    static SynthesizingContext fromNonSyntheticInputContext(ClasspathOrLibraryClass context) {
        return new SynthesizingContext(context.getContextType(), context.getContextType(), context.getOrigin(), FeatureSplit.BASE);
    }

    static SynthesizingContext fromType(DexType type) {
        return new SynthesizingContext(type, type, Origin.unknown(), FeatureSplit.BASE);
    }

    static SynthesizingContext fromNonSyntheticInputContext(ProgramDefinition context, FeatureSplit featureSplit) {
        return new SynthesizingContext(context.getContextType(), context.getContextType(), context.getOrigin(), featureSplit);
    }

    static SynthesizingContext fromSyntheticInputClass(DexProgramClass clazz, DexType synthesizingContextType, AppView<?> appView) {
        FeatureSplit featureSplit = appView.appInfoForDesugaring().getClassToFeatureSplitMap().getFeatureSplit(clazz, appView.getSyntheticItems());
        return new SynthesizingContext(synthesizingContextType, clazz.type, clazz.origin, featureSplit);
    }

    private SynthesizingContext(DexType synthesizingContextType, DexType inputContextType, Origin inputContextOrigin, FeatureSplit featureSplit) {
        this.synthesizingContextType = synthesizingContextType;
        this.inputContextType = inputContextType;
        this.inputContextOrigin = inputContextOrigin;
        this.featureSplit = featureSplit;
    }

    @Override
    public int compareTo(SynthesizingContext other) {
        return Comparator.comparing(SynthesizingContext::getSynthesizingContextType).thenComparing(c -> c.inputContextType).compare(this, other);
    }

    DexType getSynthesizingContextType() {
        return this.synthesizingContextType;
    }

    Origin getInputContextOrigin() {
        return this.inputContextOrigin;
    }

    FeatureSplit getFeatureSplit() {
        return this.featureSplit;
    }

    SynthesizingContext rewrite(GraphLens.NonIdentityGraphLens lens) {
        DexType rewrittenInputeContextType = lens.lookupType(this.inputContextType);
        DexType rewrittenSynthesizingContextType = lens.lookupType(this.synthesizingContextType);
        return rewrittenInputeContextType == this.inputContextType && rewrittenSynthesizingContextType == this.synthesizingContextType ? this : new SynthesizingContext(rewrittenSynthesizingContextType, rewrittenInputeContextType, this.inputContextOrigin, this.featureSplit);
    }

    void registerPrefixRewriting(DexType hygienicType, AppView<?> appView) {
        if (!appView.options().isDesugaredLibraryCompilation()) {
            return;
        }
        assert (hygienicType.toSourceString().startsWith(this.synthesizingContextType.toSourceString()));
        DexType rewrittenContext = appView.typeRewriter.rewrittenContextType(this.synthesizingContextType);
        if (rewrittenContext == null) {
            return;
        }
        String contextPrefix = DescriptorUtils.getBinaryNameFromDescriptor(this.synthesizingContextType.toDescriptorString());
        String rewrittenPrefix = DescriptorUtils.getBinaryNameFromDescriptor(rewrittenContext.toDescriptorString());
        String suffix = DescriptorUtils.getBinaryNameFromDescriptor(hygienicType.toDescriptorString()).substring(contextPrefix.length());
        DexType rewrittenType = appView.dexItemFactory().createType(DescriptorUtils.getDescriptorFromClassBinaryName(rewrittenPrefix + suffix));
        appView.typeRewriter.rewriteType(hygienicType, rewrittenType);
    }

    public String toString() {
        return "SynthesizingContext{" + this.getSynthesizingContextType() + (!this.featureSplit.isBase() ? ", feature:" + this.featureSplit : "") + "}";
    }

    boolean isDerivedFromMainDexList(MainDexInfo mainDexInfo) {
        return mainDexInfo.isSyntheticContextOnMainDexList(this.inputContextType);
    }
}

