/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.synthesis;

import com.android.tools.r8.androidapi.ComputedApiLevel;
import com.android.tools.r8.cf.CfVersion;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GenericSignature;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.graph.ParameterAnnotationsList;
import com.android.tools.r8.ir.optimize.info.DefaultMethodOptimizationInfo;
import com.android.tools.r8.ir.optimize.info.MethodOptimizationInfo;
import com.android.tools.r8.synthesis.SyntheticClassBuilder;
import com.android.tools.r8.synthesis.SyntheticNaming;

public class SyntheticMethodBuilder {
    private final DexItemFactory factory;
    private final DexType holderType;
    private final SyntheticNaming.SyntheticKind syntheticKind;
    private DexString name = null;
    private DexProto proto = null;
    private CfVersion classFileVersion;
    private SyntheticCodeGenerator codeGenerator = null;
    private MethodAccessFlags accessFlags = null;
    private GenericSignature.MethodTypeSignature genericSignature = GenericSignature.MethodTypeSignature.noSignature();
    private DexAnnotationSet annotations = DexAnnotationSet.empty();
    private ParameterAnnotationsList parameterAnnotationsList = ParameterAnnotationsList.empty();
    private ComputedApiLevel apiLevelForDefinition = ComputedApiLevel.notSet();
    private ComputedApiLevel apiLevelForCode = ComputedApiLevel.notSet();
    private MethodOptimizationInfo optimizationInfo = DefaultMethodOptimizationInfo.getInstance();
    private boolean checkAndroidApiLevels = true;

    SyntheticMethodBuilder(SyntheticClassBuilder<?, ?> parent) {
        this.factory = parent.getFactory();
        this.holderType = parent.getType();
        this.syntheticKind = parent.getSyntheticKind();
    }

    SyntheticMethodBuilder(DexItemFactory factory, DexType holderType, SyntheticNaming.SyntheticKind syntheticKind) {
        this.factory = factory;
        this.holderType = holderType;
        this.syntheticKind = syntheticKind;
    }

    public static boolean isValidSingleSyntheticMethod(DexEncodedMethod method, SyntheticNaming.SyntheticKind syntheticKind) {
        assert (syntheticKind.isSingleSyntheticMethod());
        return SyntheticMethodBuilder.isValidSingleSyntheticMethod(method);
    }

    public static boolean isValidSingleSyntheticMethod(DexEncodedMethod method) {
        return method.isStatic() && method.isNonAbstractNonNativeMethod() && method.isPublic() && method.annotations().isEmpty() && method.getParameterAnnotations().isEmpty();
    }

    private DexMethod getMethodSignature() {
        return this.factory.createMethod(this.holderType, this.proto, this.name);
    }

    private MethodAccessFlags getAccessFlags() {
        return this.accessFlags;
    }

    private Code getCodeObject(DexMethod methodSignature) {
        if (this.codeGenerator == null) {
            return null;
        }
        return this.codeGenerator.generate(methodSignature);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public SyntheticMethodBuilder setName(String name) {
        return this.setName(this.factory.createString(name));
    }

    public SyntheticMethodBuilder setName(DexString name) {
        assert (name != null);
        assert (this.name == null || this.name == name);
        this.name = name;
        return this;
    }

    public SyntheticMethodBuilder setOptimizationInfo(MethodOptimizationInfo optimizationInfo) {
        this.optimizationInfo = optimizationInfo;
        return this;
    }

    public SyntheticMethodBuilder setProto(DexProto proto) {
        this.proto = proto;
        return this;
    }

    public SyntheticMethodBuilder setClassFileVersion(CfVersion classFileVersion) {
        this.classFileVersion = classFileVersion;
        return this;
    }

    public SyntheticMethodBuilder setCode(SyntheticCodeGenerator codeGenerator) {
        this.codeGenerator = codeGenerator;
        return this;
    }

    public SyntheticMethodBuilder setAccessFlags(MethodAccessFlags accessFlags) {
        this.accessFlags = accessFlags;
        return this;
    }

    public SyntheticMethodBuilder setGenericSignature(GenericSignature.MethodTypeSignature genericSignature) {
        this.genericSignature = genericSignature;
        return this;
    }

    public SyntheticMethodBuilder setAnnotations(DexAnnotationSet annotations) {
        this.annotations = annotations;
        return this;
    }

    public SyntheticMethodBuilder setParameterAnnotationsList(ParameterAnnotationsList parameterAnnotationsList) {
        this.parameterAnnotationsList = parameterAnnotationsList;
        return this;
    }

    public SyntheticMethodBuilder setApiLevelForDefinition(ComputedApiLevel apiLevelForDefinition) {
        this.apiLevelForDefinition = apiLevelForDefinition;
        return this;
    }

    public SyntheticMethodBuilder setApiLevelForCode(ComputedApiLevel apiLevelForCode) {
        this.apiLevelForCode = apiLevelForCode;
        return this;
    }

    public SyntheticMethodBuilder disableAndroidApiLevelCheck() {
        this.checkAndroidApiLevels = false;
        return this;
    }

    DexEncodedMethod build() {
        assert (this.name != null);
        DexMethod methodSignature = this.getMethodSignature();
        MethodAccessFlags accessFlags = this.getAccessFlags();
        Code code = accessFlags.isAbstract() ? null : this.getCodeObject(methodSignature);
        DexEncodedMethod method = DexEncodedMethod.syntheticBuilder().setMethod(methodSignature).setAccessFlags(accessFlags).setGenericSignature(this.genericSignature).setAnnotations(this.annotations).setParameterAnnotations(this.parameterAnnotationsList).setCode(code).setClassFileVersion(this.classFileVersion).setApiLevelForDefinition(this.apiLevelForDefinition).setApiLevelForCode(this.apiLevelForCode).setOptimizationInfo(this.optimizationInfo).applyIf(!this.checkAndroidApiLevels, DexEncodedMethod.Builder::disableAndroidApiLevelCheck).build();
        assert (!this.syntheticKind.isSingleSyntheticMethod() || SyntheticMethodBuilder.isValidSingleSyntheticMethod(method, this.syntheticKind));
        return method;
    }

    public static interface SyntheticCodeGenerator {
        public Code generate(DexMethod var1);
    }
}

