/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.synthesis;

import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.references.ClassReference;
import com.android.tools.r8.references.Reference;
import com.android.tools.r8.synthesis.SynthesizingContext;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.structural.Equatable;
import com.android.tools.r8.utils.structural.Ordered;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SyntheticNaming {
    private static final String SYNTHETIC_CLASS_SEPARATOR = "$$";
    private static final String INTERNAL_SYNTHETIC_CLASS_SEPARATOR = "$$InternalSynthetic";
    private static final String EXTERNAL_SYNTHETIC_CLASS_SEPARATOR = "$$ExternalSynthetic";
    static final String INTERNAL_SYNTHETIC_METHOD_NAME = "m";
    private KindGenerator generator = new KindGenerator();
    public final SyntheticKind RECORD_TAG = this.generator.forGlobalClass();
    public final SyntheticKind API_MODEL_STUB = this.generator.forGlobalClass();
    public final SyntheticKind RETARGET_STUB = this.generator.forGlobalClasspathClass();
    public final SyntheticKind EMULATED_INTERFACE_MARKER_CLASS = this.generator.forGlobalClasspathClass();
    public final SyntheticKind ENUM_UNBOXING_LOCAL_UTILITY_CLASS = this.generator.forFixedClass("$EnumUnboxingLocalUtility");
    public final SyntheticKind ENUM_UNBOXING_SHARED_UTILITY_CLASS = this.generator.forFixedClass("$EnumUnboxingSharedUtility");
    public final SyntheticKind COMPANION_CLASS = this.generator.forFixedClass("$-CC");
    public final SyntheticKind EMULATED_INTERFACE_CLASS = this.generator.forFixedClass("$-EL");
    public final SyntheticKind RETARGET_CLASS = this.generator.forFixedClass("RetargetClass");
    public final SyntheticKind RETARGET_INTERFACE = this.generator.forFixedClass("RetargetInterface");
    public final SyntheticKind WRAPPER = this.generator.forFixedClass("$Wrapper");
    public final SyntheticKind VIVIFIED_WRAPPER = this.generator.forFixedClass("$VivifiedWrapper");
    public final SyntheticKind INIT_TYPE_ARGUMENT = this.generator.forFixedClass("-IA");
    public final SyntheticKind HORIZONTAL_INIT_TYPE_ARGUMENT_1 = this.generator.forFixedClass("$$IA$1");
    public final SyntheticKind HORIZONTAL_INIT_TYPE_ARGUMENT_2 = this.generator.forFixedClass("$$IA$2");
    public final SyntheticKind HORIZONTAL_INIT_TYPE_ARGUMENT_3 = this.generator.forFixedClass("$$IA$3");
    public final SyntheticKind ENUM_CONVERSION = this.generator.forFixedClass("$EnumConversion");
    public final SyntheticKind LAMBDA = this.generator.forInstanceClass("Lambda");
    public final SyntheticKind NON_FIXED_INIT_TYPE_ARGUMENT = this.generator.forNonSharableInstanceClass("$IA");
    public final SyntheticKind CONST_DYNAMIC = this.generator.forInstanceClass("$Condy");
    public final SyntheticKind ENUM_UNBOXING_CHECK_NOT_ZERO_METHOD = this.generator.forSingleMethod("CheckNotZero");
    public final SyntheticKind RECORD_HELPER = this.generator.forSingleMethod("Record");
    public final SyntheticKind BACKPORT = this.generator.forSingleMethod("Backport");
    public final SyntheticKind BACKPORT_WITH_FORWARDING = this.generator.forSingleMethod("BackportWithForwarding");
    public final SyntheticKind STATIC_INTERFACE_CALL = this.generator.forSingleMethod("StaticInterfaceCall");
    public final SyntheticKind TO_STRING_IF_NOT_NULL = this.generator.forSingleMethod("ToStringIfNotNull");
    public final SyntheticKind THROW_CCE_IF_NOT_NULL = this.generator.forSingleMethod("ThrowCCEIfNotNull");
    public final SyntheticKind THROW_IAE = this.generator.forSingleMethod("ThrowIAE");
    public final SyntheticKind THROW_ICCE = this.generator.forSingleMethod("ThrowICCE");
    public final SyntheticKind THROW_NSME = this.generator.forSingleMethod("ThrowNSME");
    public final SyntheticKind TWR_CLOSE_RESOURCE = this.generator.forSingleMethod("TwrCloseResource");
    public final SyntheticKind SERVICE_LOADER = this.generator.forSingleMethod("ServiceLoad");
    public final SyntheticKind OUTLINE = this.generator.forSingleMethod("Outline");
    public final SyntheticKind API_CONVERSION = this.generator.forSingleMethod("APIConversion");
    public final SyntheticKind API_CONVERSION_PARAMETERS = this.generator.forSingleMethod("APIConversionParameters");
    public final SyntheticKind ARRAY_CONVERSION = this.generator.forSingleMethod("$ArrayConversion");
    public final SyntheticKind API_MODEL_OUTLINE = this.generator.forSingleMethod("ApiModelOutline");
    private final List<SyntheticKind> ALL_KINDS = this.generator.getAllKinds();

    static String getPrefixForExternalSyntheticType(SyntheticKind kind, DexType type) {
        String binaryName = type.toBinaryName();
        int index = binaryName.lastIndexOf(kind.isFixedSuffixSynthetic() ? kind.descriptor : SYNTHETIC_CLASS_SEPARATOR);
        if (index < 0) {
            throw new Unreachable("Unexpected failure to compute an synthetic prefix");
        }
        return binaryName.substring(0, index);
    }

    static DexType createFixedType(SyntheticKind kind, SynthesizingContext context, DexItemFactory factory) {
        assert (kind.isFixedSuffixSynthetic());
        return SyntheticNaming.createType("", kind, context.getSynthesizingContextType(), "", factory);
    }

    static DexType createInternalType(SyntheticKind kind, SynthesizingContext context, String id, DexItemFactory factory) {
        assert (!kind.isFixedSuffixSynthetic());
        return SyntheticNaming.createType(INTERNAL_SYNTHETIC_CLASS_SEPARATOR, kind, context.getSynthesizingContextType(), id, factory);
    }

    static DexType createExternalType(SyntheticKind kind, String externalSyntheticTypePrefix, String id, DexItemFactory factory) {
        assert (kind.isFixedSuffixSynthetic() == id.isEmpty());
        return SyntheticNaming.createType(kind.isFixedSuffixSynthetic() ? "" : EXTERNAL_SYNTHETIC_CLASS_SEPARATOR, kind, externalSyntheticTypePrefix, id, factory);
    }

    private static DexType createType(String separator, SyntheticKind kind, DexType context, String id, DexItemFactory factory) {
        return factory.createType(SyntheticNaming.createDescriptor(separator, kind, context.getInternalName(), id));
    }

    private static DexType createType(String separator, SyntheticKind kind, String externalSyntheticTypePrefix, String id, DexItemFactory factory) {
        return factory.createType(SyntheticNaming.createDescriptor(separator, kind, externalSyntheticTypePrefix, id));
    }

    private static String createDescriptor(String separator, SyntheticKind kind, String externalSyntheticTypePrefix, String id) {
        return DescriptorUtils.getDescriptorFromClassBinaryName(externalSyntheticTypePrefix + separator + kind.descriptor + id);
    }

    public static boolean verifyNotInternalSynthetic(DexType type) {
        return SyntheticNaming.verifyNotInternalSynthetic(type.toDescriptorString());
    }

    public static boolean verifyNotInternalSynthetic(ClassReference reference) {
        return SyntheticNaming.verifyNotInternalSynthetic(reference.getDescriptor());
    }

    public static boolean verifyNotInternalSynthetic(String typeBinaryNameOrDescriptor) {
        assert (!typeBinaryNameOrDescriptor.contains(INTERNAL_SYNTHETIC_CLASS_SEPARATOR));
        return true;
    }

    static String getPhaseSeparator(Phase phase) {
        assert (phase != null);
        return phase == Phase.INTERNAL ? INTERNAL_SYNTHETIC_CLASS_SEPARATOR : EXTERNAL_SYNTHETIC_CLASS_SEPARATOR;
    }

    static ClassReference makeSyntheticReferenceForTest(ClassReference context, SyntheticKind kind, String id) {
        return Reference.classFromDescriptor(SyntheticNaming.createDescriptor(EXTERNAL_SYNTHETIC_CLASS_SEPARATOR, kind, context.getBinaryName(), id));
    }

    static boolean isSynthetic(ClassReference clazz, Phase phase, SyntheticKind kind) {
        String typeName = clazz.getTypeName();
        if (kind.isFixedSuffixSynthetic()) {
            assert (phase == null);
            return clazz.getBinaryName().endsWith(kind.descriptor);
        }
        String separator = SyntheticNaming.getPhaseSeparator(phase);
        int i = typeName.lastIndexOf(separator);
        return i >= 0 && SyntheticNaming.checkMatchFrom(kind, typeName, i, separator, phase == Phase.EXTERNAL);
    }

    private static boolean checkMatchFrom(SyntheticKind kind, String name, int i, String externalSyntheticClassSeparator, boolean checkIntSuffix) {
        int end = i + externalSyntheticClassSeparator.length() + kind.descriptor.length();
        if (end >= name.length()) {
            return false;
        }
        String prefix = name.substring(i, end);
        return prefix.equals(externalSyntheticClassSeparator + kind.descriptor) && (!checkIntSuffix || SyntheticNaming.isInt(name.substring(end)));
    }

    private static boolean isInt(String str) {
        if (str.isEmpty()) {
            return false;
        }
        if ('0' == str.charAt(0)) {
            return str.length() == 1;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public Collection<SyntheticKind> kinds() {
        return this.ALL_KINDS;
    }

    public SyntheticKind fromId(int id) {
        if (0 < id && id <= this.ALL_KINDS.size()) {
            return this.ALL_KINDS.get(id - 1);
        }
        return null;
    }

    static enum Phase {
        INTERNAL,
        EXTERNAL;

    }

    private static class SyntheticFixedClassKind
    extends SyntheticClassKind {
        private final boolean mayOverridesNonProgramType;
        private final boolean allowSyntheticContext;

        private SyntheticFixedClassKind(int id, String descriptor, boolean mayOverridesNonProgramType, boolean allowSyntheticContext) {
            super(id, descriptor, false);
            this.mayOverridesNonProgramType = mayOverridesNonProgramType;
            this.allowSyntheticContext = allowSyntheticContext;
        }

        @Override
        public boolean isShareable() {
            return false;
        }

        @Override
        public boolean isFixedSuffixSynthetic() {
            return true;
        }

        @Override
        public boolean isGlobal() {
            return this.getDescriptor().isEmpty();
        }

        @Override
        public boolean isMayOverridesNonProgramType() {
            return this.mayOverridesNonProgramType;
        }

        @Override
        public boolean allowSyntheticContext() {
            return this.allowSyntheticContext;
        }
    }

    private static class SyntheticClassKind
    extends SyntheticKind {
        private final boolean sharable;

        public SyntheticClassKind(int id, String descriptor, boolean sharable) {
            super(id, descriptor);
            this.sharable = sharable;
        }

        @Override
        public boolean isShareable() {
            return this.sharable;
        }

        @Override
        public final boolean isSingleSyntheticMethod() {
            return false;
        }

        @Override
        public boolean isFixedSuffixSynthetic() {
            return false;
        }

        @Override
        public boolean isGlobal() {
            return false;
        }

        @Override
        public boolean isMayOverridesNonProgramType() {
            return false;
        }

        @Override
        public boolean allowSyntheticContext() {
            return false;
        }
    }

    private static class SyntheticMethodKind
    extends SyntheticKind {
        public SyntheticMethodKind(int id, String descriptor) {
            super(id, descriptor);
        }

        @Override
        public boolean isShareable() {
            return true;
        }

        @Override
        public boolean isSingleSyntheticMethod() {
            return true;
        }

        @Override
        public boolean isFixedSuffixSynthetic() {
            return false;
        }

        @Override
        public boolean isGlobal() {
            return false;
        }

        @Override
        public boolean isMayOverridesNonProgramType() {
            return false;
        }

        @Override
        public boolean allowSyntheticContext() {
            return false;
        }
    }

    public static abstract class SyntheticKind
    implements Ordered<SyntheticKind> {
        private final int id;
        private final String descriptor;

        SyntheticKind(int id, String descriptor) {
            this.id = id;
            this.descriptor = descriptor;
        }

        @Override
        public int compareTo(SyntheticKind other) {
            return Integer.compare(this.id, other.getId());
        }

        @Override
        public int hashCode() {
            return this.id;
        }

        @Override
        public boolean equals(Object o) {
            return Equatable.equalsImpl(this, o);
        }

        public int getId() {
            return this.id;
        }

        public String getDescriptor() {
            return this.descriptor;
        }

        public abstract boolean isShareable();

        public abstract boolean isSingleSyntheticMethod();

        public abstract boolean isFixedSuffixSynthetic();

        public abstract boolean isGlobal();

        public abstract boolean isMayOverridesNonProgramType();

        public abstract boolean allowSyntheticContext();
    }

    private static class KindGenerator {
        private int nextId = 1;
        private List<SyntheticKind> kinds = new ArrayList<SyntheticKind>();

        private KindGenerator() {
        }

        private int getNextId() {
            return this.nextId++;
        }

        private SyntheticKind register(SyntheticKind kind) {
            this.kinds.add(kind);
            return kind;
        }

        SyntheticKind forSingleMethod(String descriptor) {
            return this.register(new SyntheticMethodKind(this.getNextId(), descriptor));
        }

        SyntheticKind forNonSharableInstanceClass(String descriptor) {
            return this.register(new SyntheticClassKind(this.getNextId(), descriptor, false));
        }

        SyntheticKind forInstanceClass(String descriptor) {
            return this.register(new SyntheticClassKind(this.getNextId(), descriptor, true));
        }

        SyntheticKind forFixedClass(String descriptor) {
            return this.register(new SyntheticFixedClassKind(this.getNextId(), descriptor, false, false));
        }

        SyntheticKind forGlobalClass() {
            return this.register(new SyntheticFixedClassKind(this.getNextId(), "", true, true));
        }

        SyntheticKind forGlobalClasspathClass() {
            return this.register(new SyntheticFixedClassKind(this.getNextId(), "", false, false));
        }

        List<SyntheticKind> getAllKinds() {
            List<SyntheticKind> kinds = this.kinds;
            this.kinds = null;
            return kinds;
        }
    }
}

