/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.tracereferences;

import com.android.tools.r8.references.ClassReference;
import com.android.tools.r8.references.FieldReference;
import com.android.tools.r8.references.MethodReference;
import com.android.tools.r8.references.PackageReference;
import com.android.tools.r8.references.TypeReference;
import com.android.tools.r8.tracereferences.TraceReferencesConsumer;
import com.android.tools.r8.tracereferences.internal.TraceReferencesResult;
import com.android.tools.r8.utils.ListUtils;
import com.android.tools.r8.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

abstract class Formatter {
    private final StringBuilder output = new StringBuilder();

    Formatter() {
    }

    private void print(Set<TraceReferencesConsumer.TracedClass> types, Set<PackageReference> keepPackageNames, Map<ClassReference, Set<TraceReferencesConsumer.TracedField>> fields, Map<ClassReference, Set<TraceReferencesConsumer.TracedMethod>> methods) {
        ArrayList<TraceReferencesConsumer.TracedClass> sortedTypes = new ArrayList<TraceReferencesConsumer.TracedClass>(types);
        sortedTypes.sort(Comparator.comparing(tracedClass -> ((ClassReference)tracedClass.getReference()).getTypeName()));
        for (TraceReferencesConsumer.TracedClass type : sortedTypes) {
            Set methodsForClass = methods.getOrDefault(type.getReference(), Collections.emptySet());
            Set fieldsForClass = fields.getOrDefault(type.getReference(), Collections.emptySet());
            if (type.isMissingDefinition()) continue;
            this.printTypeHeader(type);
            ArrayList<TraceReferencesConsumer.TracedMethod> sortedMethods = new ArrayList<TraceReferencesConsumer.TracedMethod>(methodsForClass.size());
            for (TraceReferencesConsumer.TracedMethod method : methodsForClass) {
                if (method.isMissingDefinition()) continue;
                assert (method.getAccessFlags() != null);
                sortedMethods.add(method);
            }
            sortedMethods.sort(Comparator.comparing(tracedMethod -> ((MethodReference)tracedMethod.getReference()).toString()));
            for (TraceReferencesConsumer.TracedMethod method : sortedMethods) {
                this.printMethod(method);
            }
            ArrayList sortedFields = new ArrayList(fieldsForClass);
            sortedFields.sort(Comparator.comparing(tracedField -> ((FieldReference)tracedField.getReference()).toString()));
            for (TraceReferencesConsumer.TracedField field : sortedFields) {
                if (field.isMissingDefinition()) continue;
                this.printField(field);
            }
            this.printTypeFooter();
        }
        List<String> packageNamesToKeep = keepPackageNames.stream().map(PackageReference::getPackageName).sorted().collect(Collectors.toList());
        this.printPackageNames(packageNamesToKeep);
    }

    String get() {
        return this.output.toString();
    }

    protected void append(String string) {
        this.output.append(string);
    }

    protected void appendLine(String string) {
        this.output.append(StringUtils.lines(string));
    }

    protected void printArguments(MethodReference method) {
        StringUtils.append(this.output, ListUtils.map(method.getFormalTypes(), TypeReference::getTypeName), ",", StringUtils.BraceType.PARENS);
    }

    protected abstract void printConstructorName(MethodReference var1);

    protected abstract void printField(TraceReferencesConsumer.TracedField var1);

    protected abstract void printMethod(TraceReferencesConsumer.TracedMethod var1);

    protected abstract void printPackageNames(List<String> var1);

    protected void printReturn(MethodReference method) {
        this.append(method.getReturnType() != null ? method.getReturnType().getTypeName() : "void");
    }

    protected void printNameAndReturn(MethodReference method) {
        if (method.getMethodName().equals("<init>")) {
            this.printConstructorName(method);
        } else {
            this.printReturn(method);
            this.append(" ");
            this.append(method.getMethodName());
        }
    }

    protected abstract void printTypeHeader(TraceReferencesConsumer.TracedClass var1);

    protected abstract void printTypeFooter();

    void format(TraceReferencesResult result) {
        this.print(result.getTracedClasses(), result.getTracedPackageNames(), result.getTracedFields(), result.getTracedMethods());
    }
}

