/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.tracereferences;

import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.Keep;
import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.ProgramResourceProvider;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.Version;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.dex.ApplicationReader;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.origin.CommandLineOrigin;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.tracereferences.TraceReferencesCommand;
import com.android.tools.r8.tracereferences.TraceReferencesCommandParser;
import com.android.tools.r8.tracereferences.Tracer;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.ExceptionUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.StringUtils;
import com.android.tools.r8.utils.Timing;
import java.io.IOException;
import java.util.HashSet;
import java.util.function.Consumer;

@Keep
public class TraceReferences {
    public static void run(TraceReferencesCommand command) throws CompilationFailedException {
        ExceptionUtils.withCompilationHandler(command.getReporter(), () -> TraceReferences.runInternal(command));
    }

    private static void forEachDescriptor(ProgramResourceProvider provider, Consumer<String> consumer) throws ResourceException, IOException {
        for (ProgramResource programResource : provider.getProgramResources()) {
            if (programResource.getKind() == ProgramResource.Kind.DEX) {
                assert (programResource.getClassDescriptors() == null);
                for (DexProgramClass clazz : new ApplicationReader(AndroidApp.builder().addDexProgramData(ImmutableList.of(programResource.getBytes())).build(), new InternalOptions(), Timing.empty()).read().classes()) {
                    consumer.accept(clazz.getType().toDescriptorString());
                }
                continue;
            }
            assert (programResource.getClassDescriptors() != null);
            programResource.getClassDescriptors().forEach(consumer);
        }
    }

    private static void runInternal(TraceReferencesCommand command) throws IOException, ResourceException {
        AndroidApp.Builder builder = AndroidApp.builder();
        command.getLibrary().forEach(builder::addLibraryResourceProvider);
        command.getTarget().forEach(builder::addClasspathResourceProvider);
        command.getSource().forEach(builder::addProgramResourceProvider);
        HashSet<String> targetDescriptors = new HashSet<String>();
        command.getTarget().forEach(provider -> targetDescriptors.addAll(provider.getClassDescriptors()));
        for (ProgramResourceProvider provider2 : command.getSource()) {
            TraceReferences.forEachDescriptor(provider2, targetDescriptors::remove);
        }
        InternalOptions options = new InternalOptions();
        options.loadAllClassDefinitions = true;
        Tracer tracer = new Tracer(targetDescriptors, builder.build(), command.getReporter(), options);
        tracer.run(command.getConsumer());
    }

    public static void run(String ... args2) throws CompilationFailedException {
        TraceReferencesCommand command = TraceReferencesCommand.parse(args2, (Origin)CommandLineOrigin.INSTANCE).build();
        if (command.isPrintHelp()) {
            System.out.println(TraceReferencesCommandParser.USAGE_MESSAGE);
            return;
        }
        if (command.isPrintVersion()) {
            System.out.println("tracereferences " + Version.getVersionString());
            return;
        }
        TraceReferences.run(command);
    }

    public static void main(String[] args2) {
        if (args2.length == 0) {
            throw new RuntimeException(StringUtils.joinLines("Invalid invocation.", TraceReferencesCommandParser.USAGE_MESSAGE));
        }
        ExceptionUtils.withMainProgramHandler(() -> TraceReferences.run(args2));
    }
}

